<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{Select, File, Text, Radio, Checkbox, Submit};


class AddPaymentGatewayForm extends Form {

    public function __construct($name = null) {

    parent::__construct('add-payment-gateway-form');
        
        /**
         * 
         * Gateway Name
         */
        $this->add([
            'name' => 'gateway_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'gateway-name',                
                'class' => 'form-control',
                 'placeholder' => 'Gateway name'
            ],
            'options' => [
                'label' => 'Gateway Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);
        
        /**
         * 
         * Status
         */
        $this->add([
            'name' => 'is_active',
            'type' => radio::class,
            'attributes' => [
                'id' => 'is-active', 
                'class' => 'form-control'
            ],
            'options' => [                
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);
        
        /**
         * 
         * User For Website...
         */
        $this->add([
            'name' => 'user_for_website',
            'type' => Checkbox::class,
            'attributes' => [
                'value' => 'Submit',
                'id' => 'user-for-website',
                'class' => ''
            ]
        ]); 
        
        /**
         * 
         * User For Mobile...
         */
        $this->add([
            'name' => 'user_for_mobile',
            'type' => Checkbox::class,
            'attributes' => [               
                'id' => 'user-for-mobile',
                'class' => ''
            ]
        ]); 
        
        /**
         * 
         * Upload Logo...
         */
        $this->add([
            'name' => 'upload_logo',
            'type' => File::class,
            'attributes' => [
                'id' => 'upload-logo',
                'class' => 'form-control'
            ],
            'options' => [          
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);
        
        /**
         * 
         * Save...
         */
        $this->add([
            'name' => 'save_payment_gateway',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'save_payment_gateway',
                'id' => 'save-payment-gateway'                
            ],
        ]);  
    }

}
