<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;

class AddNewVehicleForm extends Form {

    public function __construct($name = null) {

        parent::__construct('vehicle-detail-search-form');
        $this->setAttribute('method', 'post');
        
        /**
         * 
         * Cab Types
         */
        $this->add([
            'name' => 'vehicle_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vehicle-type',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Cab Types<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Ignition Type
         */
        $this->add([
            'name' => 'ignition_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'ignition-type',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Ignition Type<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * RC Proof
         */
        $this->add([
            'name' => 'rc_proof',
            'type' => File::class,
            'attributes' => [
                'id' => 'rc-proof',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'RC Proof<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);  
        
        /**
         * Permit Expiry Date
         */
        $this->add([
            'name' => 'permit_expiry_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'permit-expiry-date',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Permit Expiry Date<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);  
        
        /**
         * Vehicle No
         */
        $this->add([
            'name' => 'vehicle_number',
             'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-number',
                'placeholder' => 'DL-524',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Vehicle No.<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);  
        
        /**
         * Name Of Vehicle
         */
        $this->add([
            'name' => 'vehicle_name',
             'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-name',                
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Name Of Vehicle<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);  
        
        /**
         * 
         * Vehicle Color
         */
        $this->add([
            'name' => 'color',
             'type' => Text::class,
            'attributes' => [
                'id' => 'color',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Vehicle Color<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);  
        
        /**
         * 
         * Vehicle Owner
         */
        $this->add([
            'name' => 'vehicle_owner',
            'type' => Radio::class,
            'attributes' => [
                'id' => 'vehicle-owner',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Vehicle Owner<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);    
        
        /**
         * 
         * Model Year
         */
        $this->add([
            'name' => 'model_year',
           'type' => Text::class,
            'attributes' => [
                'id' => 'model-year',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Model Year<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);    
        
        /**
         * Fiture Information
         */
        /**
         * 
         * Passengers
         */
        $this->add([
            'name' => 'passengers',
            'type' => Text::class,
            'attributes' => [
                'id' => 'passengers',
                'placeholder' => '3+1',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Passengers<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);        
        
        /**
         * Large Suitcase
         */
        $this->add([
            'name' => 'large_suitcases',
            'type' => Text::class,
            'attributes' => [
                'id' => 'large-suitcases',
                'placeholder' => '1',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Large Suitcase<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * Small Suitcase
         */
        $this->add([
            'name' => 'small_suitcases',
            'type' => Text::class,
            'attributes' => [
                'id' => 'small-suitcases',
                'placeholder' => '3',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Small Suitcase<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);  
        
        /**
         * Amenities
         */
        $this->add([
            'name' => 'amenities',
           'type' => Radio::class,
            'attributes' => [
                'id' => 'amenities',
                'placeholder' => '3',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Amenities<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);  
        
        /**
         * Search
         */
        $this->add([
            'name' => 'search',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Reset',
                'id' => 'search',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);   
        
        /**
         * Clear
         */
        $this->add([
            'name' => 'clear',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'clear',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]); 
    }

}
