<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Application\Controller\RestAPIClientController;
use Dashboard\Form\TransferMasterForm;
use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Zend\Json\Json;
use Zend\Session\Container;
use Zend\Debug\Debug;
use Dashboard\Model\CommonModel;
use Dashboard\Model\User;

class TransferMasterController extends RestAPIClientController {

    public function __construct() {
        $this->CommonModel = new CommonModel();
        $this->userModel = new User();
    }

    /**
     * Index
     * @return ViewModel
     */
    public function indexAction() {
        $form = new TransferMasterForm();
        $data = [];
        $pStrtuctureList = $this->CommonModel->getTransferDetails($data);
        $viewModel = new ViewModel(['pStrtuctureList' => $pStrtuctureList]);
        return $viewModel;
    }

    public function addTransferMasterAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        TransferMasterForm::$country = $this->userModel->getCountryList();
        TransferMasterForm::$booking_type = $this->CommonModel->getTourTypeList();
        $form = new TransferMasterForm();
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();
                $data = [];
                if (isset($_FILES['thumb_image']['name']) && $_FILES['thumb_image']['name'] != '') {
                    $file = $_FILES['thumb_image']['tmp_name'];
                    $file    = file_get_contents($file);
                    $base64string    = base64_encode($file);
                    $uploaddir = $_SERVER['DOCUMENT_ROOT'];
                    $file = '/upload/transfer_master_image/';
                    $fileName= time() .'-'. $_FILES['thumb_image']['name'];
                    $filepath = $uploaddir . $file . $fileName;
                    $data1['base64image']= $base64string;
                    $data1['filepath']= $filepath;
                    $this->CommonModel->uploadimageapi($data1);
                }else{
                    $base64string = "";
                }
                $data = [
                    'country_id' => $post['country_id'],
                    'booking_type' => $post['booking_type'],
                    'title' => $post['title'],
                    'description' => $post['description'],
                    'image_path' => $fileName,
                    'status' => 1,
                    'created_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                $insertStatus = $this->CommonModel->addTransferDetails($data);
                if ($insertStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Details added successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'Somet thing Went Wrong'));
                }
                $this->redirect()->toRoute('transfer-master', ['action' => 'index']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function editTransferMasterAction() {
        $sessionUser = new Container('userlogin');
        $user_id = $sessionUser->userData['user_id'];

        TransferMasterForm::$country = $this->userModel->getCountryList();
        TransferMasterForm::$booking_type = $this->CommonModel->getTourTypeList();
        $form = new TransferMasterForm();
        $id = $this->params()->fromQuery('id');
        $data = [
            'auto_id' => $id
        ];
        $vehicleData = $this->CommonModel->getTransferDetails($data);
        $vehicleData = $vehicleData[0];
        $form->setData($vehicleData);
        $form->get('id')->setValue($vehicleData['id']);
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();
                $data = [];
                if (isset($_FILES['thumb_image']['name']) && $_FILES['thumb_image']['name'] != '') {
                    $file = $_FILES['thumb_image']['tmp_name'];
                    $file    = file_get_contents($file);
                    $base64string    = base64_encode($file);
                    $uploaddir = $_SERVER['DOCUMENT_ROOT'];
                    $file = '/upload/transfer_master_image/';
                    $fileName= time() .'-'. $_FILES['thumb_image']['name'];
                    $filepath = $uploaddir . $file . $fileName;
                    $data1['base64image']= $base64string;
                    $data1['filepath']= $filepath;
                    $this->CommonModel->uploadimageapi($data1);
                }else{
                    $base64string = "";
                    $fileName = $vehicleData1['image_path'];
                }
                $data = [
                    'country_id' => $post['country_id'],
                    'booking_type' => $post['booking_type'],
                    'title' => $post['title'],
                    'description' => $post['description'],
                    'image_path' => $fileName,
                    'modified_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'auto_id' => $post['id']
                ];
                $updateStatus = $this->CommonModel->updateTransferDetails($data);
                if($updateStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Details Updated successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'Somet thing Went Wrong'));
                }
                $this->redirect()->toRoute('transfer-master', ['action' => 'index']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }
    
      /** Function to change PAYMENT STRUCTURE STATUS */
    public function transferMasterStatusAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        $id = implode(',', $data['selected']);
        $status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'status' => $status];
        $this->CommonModel->updateTransferStatus($data);
        $val = [];
        $pStrtuctureList = $this->CommonModel->getTransferDetails($data);
        $viewModel = new ViewModel(['pStrtuctureList' => $pStrtuctureList]);
        $viewModel->setTemplate('/dashboard/transfer-master/transfer-master-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function changeRecordStatusAction() {
        $status=0;
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if($postData['status']==0 || $postData['status']==2){
                $status=1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->CommonModel->updateTransferStatus($data);
        }
        $val = [];
        $pStrtuctureList = $this->CommonModel->getTransferDetails($val);
        $viewModel = new ViewModel(['pStrtuctureList' => $pStrtuctureList]);
        $viewModel->setTemplate('/dashboard/transfer-master/transfer-master-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function deleteTransferMasterAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id'=>$userId, 'status'=>2];
        $this->CommonModel->updateTransferStatus($data);
        $this->redirect()->toRoute('transfer-master', ['action' => 'index']);
        $this->flashMessenger()->addMessage(array('success' => 'Details Delete Successfully'));
    }

}
