<?php

namespace Dashboard\Controller;

use Application\Controller\RestAPIClientController;
use Zend\View\Model\ViewModel;
use Zend\Session\Container;
use Zend\Json\Json;
use Zend\Config\Config;
use Zend\Config\Factory;
use Dashboard\Model\UserLicenseModel;
use Dashboard\Model\CommonModel;
use Dashboard\Model\User;
use Dashboard\Form\{
    AdUserLicenseForm
};

use User\Form\LoginForm;
use User\Form\ApiUserForm;
use User\Model\Registration;
 

class TrackingController extends RestAPIClientController {

    public function __construct() {
        $this->userModel = new User();
        $this->licenseModel = new UserLicenseModel();
        $this->commonModel = new CommonModel();
        $this->registrationModel = new Registration();
    }

    /**
     * index
     * @return ViewModel
     */
    public function vehicleStatusAction() {
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $user_id = $sessionContainer->user_id;
        $viewModel = new ViewModel();
        return $viewModel;
    }
    
    
    /**
     * 
     * @return ViewModel
     */
    public function monitoringMapAction() {
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $user_id = $sessionContainer->user_id;
        $viewModel = new ViewModel([ 
            'google_map_url' => $this->config()->getConfig()->google_map->url,
            'google_map_key' => $this->config()->getConfig()->google_map->key
        ]);
        return $viewModel;
    }
    
    /**
     * 
     * @return ViewModel
     */
    public function trackBookingAction() {
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $user_id = $sessionContainer->user_id;
        $viewModel = new ViewModel();
        return $viewModel;
    }


}
