<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Application\Controller\RestAPIClientController;
use Dashboard\Form\PackageAddForm;
use Dashboard\Form\PackageAddForm_1;
use Dashboard\Form\PackageFeatureAddForm;
use Dashboard\Form\PackageAvailabilityOthersForm;
use Dashboard\Form\PackageSearchForm;
use Dashboard\Form\TourInclusionAddForm;
use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Zend\Json\Json;
use Zend\Session\Container;
use Dashboard\Model\CommonModel;
use Dashboard\Model\User;

class TourPackageController extends RestAPIClientController {

    public function __construct() {
        $this->CommonModel = new CommonModel();
        $this->userModel = new User();
    }

    /**
     * Index
     * @return ViewModel
     */
    public function indexAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $form = new PackageAddForm();
        //Call API...
        $packageListing = [
            '0' => [
                'name' => 'Las Vegas',
                'price' => '300',
                'vendor_price' => '333',
                'discount_price' => '120',
                'child_price' => '100',
                'child_discount' => '30',
                'infant_price' => '60',
                'infant_discount' => '67.9',
                'start_date' => '02-06-2018',
                'end_date' => '25-8-2018'
            ],
            '1' => [
                'name' => 'New York',
                'price' => '300',
                'vendor_price' => '303',
                'discount_price' => '85',
                'child_price' => '43',
                'child_discount' => '43',
                'infant_price' => '45',
                'infant_discount' => '67.9',
                'start_date' => '02-06-2018',
                'end_date' => '25-8-2018'
            ],
            '2' => [
                'name' => 'Montana Hill',
                'price' => '300',
                'vendor_price' => '303',
                'discount_price' => '45',
                'child_price' => '34',
                'child_discount' => '34',
                'infant_price' => '54',
                'infant_discount' => '67.9',
                'start_date' => '02-06-2018',
                'end_date' => '25-8-2018'
            ]
        ];

        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getTourPackageDetails($data);
        //echo '<pre>';print_r($packageListing);die();
        $viewModel = new ViewModel(['packageListing' => $packageListing,
            'form' => $form]);
        return $viewModel;
    }

    public function addTourPackageAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        PackageAddForm::$country = $this->userModel->getCountryList();
        PackageAddForm::$tour_type = $this->CommonModel->getTourTypeList();
        PackageAddForm:: $tour_theme = $this->CommonModel->getSightseeingCategory();
        PackageAddForm:: $inclusion = $this->CommonModel->getInclusionList();
        PackageAddForm:: $tour_category = $this->CommonModel->getTourCategoryList();
        $form = new PackageAddForm();

        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            //echo '<pre>';print_r($postData);die();
            $form->setData($postData);
            if ($form->isValid()) {

                $departureDetails = [];
                if (isset($postData['tour_type']) && $postData['tour_type'] == 2) {
                    $departure_date = array_values($postData['departure_date']);
                    $departure_time = array_values($postData['departure_time']);
                    for ($i = 0; $i < count($departure_date); $i++) {
                        $departureDetails['departure_date'][$i] = date('Y-m-d', strtotime($departure_date[$i]));
                        $departureDetails['departure_time'][$i] = $departure_time[$i];
                    }
                }
                $finalData = [];
                $finalData = [
                    'company_id' => $this->config()->getConfig()->company->companyId,
                    'tours_type' => $postData['tours_type'],
                    'country_id' => $postData['destination_country'],
                    'city_id' => $postData['destination_city_id'],
                    'post_code' => $postData['destination_post_code'],
                    'tours_name' => $postData['tour_name'],
                    'tours_operator' => $postData['tours_operator'],
                    'starting_city' => str_replace(';', ',', rtrim($postData['start_city_id'], ';')),
                    'ending_city' => str_replace(';', ',', rtrim($postData['end_city_id'], ';')),
                    'destination_cover' => str_replace(';', ',', rtrim($postData['destination_covered_id'], ';')),
                    'no_of_traveller' => $postData['traveler'],
                    'package_validity_from' => date('Y-m-d', strtotime($postData['package_validity_from'])),
                    'package_validity_to' => date('Y-m-d', strtotime($postData['package_validity_to'])),
                    'booking_validity_from' => date('Y-m-d', strtotime($postData['booking_validity_from'])),
                    'booking_validity_to' => date('Y-m-d', strtotime($postData['booking_validity_to'])),
                    'tours_code' => $postData['tour_code'],
                    'rating' => $postData['rating'],
                    'num_of_nights' => $postData['number_of_nights'],
                    'num_of_days' => $postData['number_of_days'],
                    'tour_type' => $postData['tour_type'],
                    'package_specification' => $postData['specification'],
                    'short_desc' => $postData['short_desc'],
                    'created_date' => date('Y-m-d H:i:s'),
                    'user_id' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    "inclusion" => isset($postData['inclusion']) ? implode(",", $postData['inclusion']) : '',
                    "theme" => isset($postData['theme']) ? implode(",", $postData['theme']) : '',
                    "tour_category" => isset($postData['tour_category']) ? implode(",", $postData['tour_category']) : '',
                    "departure_details" => $departureDetails,
                ];
                //$get=array_filter($finalData);
                // $p=json_encode($get);
                //echo'<pre>';print_r($finalData);die();

                $responseData = $this->CommonModel->insertTourDetails($finalData);
                //echo '<pre>';print_r($responseData);die();           
                if ($responseData['response']['status'] == 'success') {
                    $msg = "Details Added Successfully!..";
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Details Could Not Added!..";
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
                $this->redirect()->toRoute('tour-package', ['action' => 'index']);
            }
//            else {
//                $msg = $form->getMessages();
//                echo '<pre>';
//                print_r($msg);
//                die();
//            }
        }

        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function packageDealAction() {
        $form = new PackageAddForm();


        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
        // $this->FormElement($form->get('tax_included'));
    }

    public function tourPackageListingAction() {
        $viewModel = new ViewModel();
        return $viewModel;
    }

    public function editTourPackageAction() {

        $form = new PackageAddForm();
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    // --------------packeges------------
    public function generalInformationAction() {

        $form = new PackageAddForm();
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    

    public function pricePaymentInformationAction() {

        $form = new PackageAddForm_1();

        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();

                return $this->redirect()->toRoute('tour-package', ['action' => 'feature-information']);
            }
        }

        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function pictureMetaInformationAction() {

        $form = new PackageAddForm_1();

        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();

                return $this->redirect()->toRoute('tour-package', ['action' => 'picture-meta-information']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function tourInclusionsAction() {

        $form1 = new PackageAddForm_1();
        $form = new TourInclusionAddForm();

        $request = $this->getRequest();

        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();

                return $this->redirect()->toRoute('tour-package', ['action' => 'tour-availability-others']);
            }
        }

        $viewModel = new ViewModel(['form1' => $form1, 'form' => $form]);
        return $viewModel;
    }

    public function tourAvailabilityOthersAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        PackageAvailabilityOthersForm::$tours = $this->CommonModel->getTourPackageList();
        PackageAvailabilityOthersForm::$country = $this->userModel->getCountryList();
        PackageAvailabilityOthersForm::$payment_structure = $this->CommonModel->getPaymentStructureList();
        PackageAvailabilityOthersForm::$documentation = $this->CommonModel->getDocumentationList();
        PackageAvailabilityOthersForm::$cancellation_policy = $this->CommonModel->getCancellationPolicyList();
        PackageAvailabilityOthersForm::$refund_policy = $this->CommonModel->getRefundPolicyList();
        PackageAvailabilityOthersForm::$term_policy = $this->CommonModel->getTermConditionsPolicyList();
        $form = new PackageAvailabilityOthersForm();
        $request = $this->getRequest();
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $postData = $request->getPost()->toArray();
                //echo '<pre>';print_r($post);die();                
                 $finalData = [];
                    $finalData = [
                    'tour_id' => $postData['tour_id'],
                    'tours_package_available_from' => date('Y-m-d', strtotime($postData['tours_package_available_from'])),
                    'tours_package_expire_date' => date('Y-m-d', strtotime($postData['tours_package_expire_date'])),
                    'google_map' => $postData['google_map'],
                    'tour_highlights' => $postData['tour_highlights'],
                    'availability_country' => $postData['availability_country'],
                    'availability_city' => $postData['destination_city_id'],       
                    'payment_structure_id' => $postData['payment_structure_id'],
                    'payment_structure_content' => $postData['payment_structure_content'],
                    'document_id' => $postData['document_id'],
                    'documentation_content' => $postData['documentation_content'],
                    'cancellation_policy' => $postData['cancellation_policy'],
                    'cancellation_policy_content' => $postData['cancellation_policy_content'],
                    'refund_policy' => $postData['refund_policy'],
                    'refund_policy_content' => $postData['refund_policy_content'],
                    'term_policy' => $postData['term_policy'],
                    'term_policy_content' => $postData['term_policy_content'],
                    'user_id' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR']
                 ];
                //$get=array_filter($finalData);
                // $p=json_encode($get);
                //echo'<pre>';print_r($finalData);die();

                $responseData = $this->CommonModel->updateTourAvailabiltyOtherDetails($finalData);
                //echo '<pre>';print_r($responseData);die();           
                if ($responseData['response']['status'] == 'success') {
                    $msg = "Details Added Successfully!..";
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Details Could Not Added!..";
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
                $this->redirect()->toRoute('tour-package', ['action' => 'index']);
              }
//            else{
//                $msg = $form->getMessages();
//                echo '<pre>';print_r($msg);die();
//            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function pricePaymentInformation2Action() {
        $form = new PackageAddForm();
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();

                return $this->redirect()->toRoute('tour-package', ['action' => 'feature-information']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function addQuickPackageAction() {
        $viewModel = new ViewModel();
        return $viewModel;
    }
    
    public function featureInformationAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        PackageFeatureAddForm::$tours = $this->CommonModel->getTourPackageList();
        PackageFeatureAddForm::$roomCategory = $this->CommonModel->getRoomCategoryList();
        PackageFeatureAddForm::$mealPlanType = $this->CommonModel->getMealPlanTypeList();
        $form = new PackageFeatureAddForm;
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();

                return $this->redirect()->toRoute('tour-package', ['action' => 'feature-information']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }
    
    
    public function getPaymentStructureDetailsAction() {
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $userId = $userData['user_id'];
        $postData = $this->getRequest()->getPost();
        //echo '<pre>';print_r($postData);die();
        if($postData['id']!=""){
        $val =['auto_id'=>$postData['id']];
        $data = $this->CommonModel->getPaymentStructureDetails($val);
        if(!empty($data[0]['description'])) {            
            $response = ["status" => true, "data" => $data[0]['description']];
        } else {
            $response = ["status" => false];
        }
        }else {
            $response = ["status" => false];
        }
        $view = new JsonModel($response);
        return $view;        
    }
    
    public function getDocumentationDetailsAction() {
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $userId = $userData['user_id'];
        $postData = $this->getRequest()->getPost();
        //echo '<pre>';print_r($postData);die();
        if($postData['id']!=""){
        $val =['auto_id'=>$postData['id']];
        $data = $this->CommonModel->getDocumentationDetails($val);
        if(!empty($data[0]['description'])) {            
            $response = ["status" => true, "data" => $data[0]['description']];
        } else {
            $response = ["status" => false];
        }
        }else {
            $response = ["status" => false];
        }
        $view = new JsonModel($response);
        return $view;        
    }
    
    public function getCancellationPolicyDetailsAction() {
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $userId = $userData['user_id'];
        $postData = $this->getRequest()->getPost();
        //echo '<pre>';print_r($postData);die();
        if($postData['id']!=""){
        $val =['auto_id'=>$postData['id']];
        $data = $this->CommonModel->getCancellationPolicyDetails($val);
        if(!empty($data[0]['description'])) {            
            $response = ["status" => true, "data" => $data[0]['description']];
        } else {
            $response = ["status" => false];
        }
        }else {
            $response = ["status" => false];
        }
        $view = new JsonModel($response);
        return $view;        
    }
    
    public function getRefundPolicyDetailsAction() {
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $userId = $userData['user_id'];
        $postData = $this->getRequest()->getPost();
        //echo '<pre>';print_r($postData);die();
        if($postData['id']!=""){
        $val =['auto_id'=>$postData['id']];
        $data = $this->CommonModel->getRefundPolicyDetails($val);
        if(!empty($data[0]['description'])) {            
            $response = ["status" => true, "data" => $data[0]['description']];
        } else {
            $response = ["status" => false];
        }
        }else {
            $response = ["status" => false];
        }
        $view = new JsonModel($response);
        return $view;        
    }
    
    public function getTermConditionPolicyDetailsAction() {
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $userId = $userData['user_id'];
        $postData = $this->getRequest()->getPost();
        //echo '<pre>';print_r($postData);die();
        if($postData['id']!=""){
        $val =['auto_id'=>$postData['id']];
        $data = $this->CommonModel->getTermConditionsDetails($val);
        if(!empty($data[0]['description'])) {            
            $response = ["status" => true, "data" => $data[0]['description']];
        } else {
            $response = ["status" => false];
        }
        }else {
            $response = ["status" => false];
        }
        $view = new JsonModel($response);
        return $view;        
    }
    
    
    public function cityItineraryAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $form = new PackageFeatureAddForm;
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
        }
        $viewModel = new ViewModel(['form'=>$form]);
        $viewModel->setTemplate('/dashboard/tour-package/itinerary-information');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
       
     public function itineraryInformationAction() {
		PackageFeatureAddForm::$tours = $this->CommonModel->getTourPackageList();
        PackageFeatureAddForm::$roomCategory = $this->CommonModel->getRoomCategoryList();
        PackageFeatureAddForm::$mealPlanType = $this->CommonModel->getMealPlanTypeList();
        $form = new PackageFeatureAddForm;
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }
    
    public function daywiseIteneraryAction() {
		PackageFeatureAddForm::$tours = $this->CommonModel->getTourPackageList();
        PackageFeatureAddForm::$roomCategory = $this->CommonModel->getRoomCategoryList();
        PackageFeatureAddForm::$mealPlanType = $this->CommonModel->getMealPlanTypeList();
        $form = new PackageFeatureAddForm;
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }
    

}
