<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Application\Controller\RestAPIClientController;
use Dashboard\Form\TourInclusionForm;
use Zend\View\Model\{
    ViewModel,
    JsonModel
};

use Zend\Session\Container;
use Zend\Debug\Debug;
use Zend\Json\Json;
use Dashboard\Model\CommonModel;
use Dashboard\Model\User;

class TourInclusionController extends RestAPIClientController {

    public function __construct() {
        $this->CommonModel = new CommonModel();
        $this->userModel = new User();
    }

    /**
     * Index
     * @return ViewModel
     */
    public function indexAction() {
        $form = new TourInclusionForm();
        $data = [];
        $pStrtuctureList = $this->CommonModel->getTourInclusionDetails($data);
        $viewModel = new ViewModel(['pStrtuctureList' => $pStrtuctureList]);
        return $viewModel;
    }

    public function addTourInclusionAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        TourInclusionForm::$country = $this->userModel->getCountryList();
        TourInclusionForm::$booking_type = $this->CommonModel->getTourTypeList();
        $form = new TourInclusionForm();
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();
                $data = [
                    'country_id' => $post['country_id'],
                    'booking_type' => $post['booking_type'],
                    'title' => $post['title'],
                    'description' => $post['description'],
                    'status' => 1,
                    'created_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                $insertStatus = $this->CommonModel->addTourInclusionDetails($data);
                if ($insertStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Details added successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'Somet thing Went Wrong'));
                }
                $this->redirect()->toRoute('tour-inclusion', ['action' => 'index']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function editTourInclusionAction() {
        $sessionUser = new Container('userlogin');
        $user_id = $sessionUser->userData['user_id'];

        TourInclusionForm::$country = $this->userModel->getCountryList();
        TourInclusionForm::$booking_type = $this->CommonModel->getTourTypeList();
        $form = new TourInclusionForm();
        $id = $this->params()->fromQuery('id');
        $data = [
            'auto_id' => $id
        ];
        $vehicleData = $this->CommonModel->getTourInclusionDetails($data);
        $vehicleData = $vehicleData[0];
        $form->setData($vehicleData);
        $form->get('id')->setValue($vehicleData['id']);
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();
                $data = [
                    'country_id' => $post['country_id'],
                    'booking_type' => $post['booking_type'],
                    'title' => $post['title'],
                    'description' => $post['description'],
                    'modified_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'auto_id' => $post['id']
                ];
                $updateStatus = $this->CommonModel->updateTourInclusionDetails($data);
                if($updateStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Details Updated successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'Somet thing Went Wrong'));
                }
                $this->redirect()->toRoute('tour-inclusion', ['action' => 'index']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }
    
      /** Function to change TOUR INCLUSION STATUS */
    public function tourInclusionStatusAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        $id = implode(',', $data['selected']);
        $status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'status' => $status];
        $this->CommonModel->updateTourInclusionStatus($data);
        $val = [];
        $pStrtuctureList = $this->CommonModel->getTourInclusionDetails($val);
        $viewModel = new ViewModel(['pStrtuctureList' => $pStrtuctureList]);
        $viewModel->setTemplate('/dashboard/tour-inclusion/tour-inclusion-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function changeRecordStatusAction() {
        $status=0;
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if($postData['status']==0 || $postData['status']==2){
                $status=1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->CommonModel->updateTourInclusionStatus($data);
        }
        $val = [];
        $pStrtuctureList = $this->CommonModel->getTourInclusionDetails($val);
        $viewModel = new ViewModel(['pStrtuctureList' => $pStrtuctureList]);
        $viewModel->setTemplate('/dashboard/tour-inclusion/tour-inclusion-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function deleteTourInclusionAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id'=>$userId, 'status'=>2];
        $this->CommonModel->updateTourInclusionStatus($data);
        $this->redirect()->toRoute('tour-inclusion', ['action' => 'index']);
        $this->flashMessenger()->addMessage(array('success' => 'Details Delete Successfully'));
    }

}
