<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Application\Controller\RestAPIClientController;
use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Zend\Json\Json;
use Zend\Session\Container;
use Dashboard\Form\{
    TestimonialForm
};
use Zend\Debug\Debug;
use Dashboard\Model\CommonModel;

class TestimonialController extends RestAPIClientController {

    public function __construct() {
        $this->commonModel = new CommonModel();
    }

    /**
     * Index
     * @return ViewModel
     */
    public function indexAction() {
        $data = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $companyId = $this->config()->getConfig()->company->companyId;

        $form = new TestimonialForm ();
        $responseData = $this->Testimoniallisting($companyId);
        if ($responseData['responsedata']['status'] == 'success') {
            $data = $responseData['responsedata']['data'];
        }

        $viewModel = new ViewModel(['form' => $form, 'datalist' => $data]);
        return $viewModel;
    }

    public function addTestimonialAction() {
        $data = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;

        $form = new TestimonialForm ();
        $request = $this->getRequest();

        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();

            $form->setData($postData);
            if ($form->isValid()) {

                $data = [
                    "user_id" => $userId,
                    "company_id" => $this->config()->getConfig()->company->companyId,
                    "description" => $postData['description'],
                    "status" => $postData['status'],
                    "created_by" => $userId,
                    "ip" => $_SERVER['REMOTE_ADDR']
                ];
                $insertResopnes = $this->addTestimonial($data);
                if ($insertResopnes['response']['status'] == 'success') {
                    $msg = "Added Successfully..";

                    $this->redirect()->toRoute('testimonial', ['action' => 'index']);
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Could Not Added !..";
                    $this->redirect()->toRoute('testimonial', ['action' => 'testimonial/add-testimonial']);
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
            }
        }



        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function editTestimonialAction() {

        $id = $this->params()->fromQuery('id');
        $data = [];
        $parameters = [];
        $responseData = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $companyId = $this->config()->getConfig()->company->companyId;

        $form = new TestimonialForm ();
        $request = $this->getRequest();
        if ($id != '') {
            $parameters = [
                'id' => $id,
                'company_id' => $companyId
            ];
            $getData = $this->getTestimonial($parameters);
            if ($getData['responsedata']['status'] = 'success') {
                $responseData = $getData['responsedata']['data'][0];
                $form->setData($responseData);
            }
        }

        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();

            $form->setData($postData);

            if ($form->isValid()) {

                $data = [
                    "id" => $postData['id'],
                    "user_id" => $userId,
                    "company_id" => $this->config()->getConfig()->company->companyId,
                    "description" => $postData['description'],
                    "status" => $postData['status'],
                    "modified_by" => $userId,
                ];

//echo'<pre>';print_r($data);die();
                $updateResopnes = $this->updateTestimonial($data);

                if ($updateResopnes['response']['status'] == 'success') {
                    $msg = "Updated Successfully..";

                    $this->redirect()->toRoute('testimonial', ['action' => 'index']);
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Could Not Updated !..";
                    $this->redirect()->toRoute('testimonial', ['action' => 'testimonial/edit-testimonial']);
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
            }
        }


        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function statusAction() {
        $form = new TestimonialForm ();

        $data = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $companyId = $this->config()->getConfig()->company->companyId;

        $postData = $this->getRequest()->getPost();
        $id = implode(',', $postData['selected']);
        $testimonialstatus = $postData['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'status' => $testimonialstatus];

        $this->testimonialStatus($data);

        $responseData = $this->Testimoniallisting($companyId);
        if ($responseData['responsedata']['status'] == 'success') {
            $data = $responseData['responsedata']['data'];
        }
        $viewModel = new ViewModel(['form' => $form, 'datalist' => $data]);
        $viewModel->setTemplate('dashboard/testimonial/testimonial-listing.phtml');
        $viewModel->setTerminal(true);

        return $viewModel;
    }

    public function deleteAction() {
        $id = $this->params()->fromQuery('id');

        $data = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $companyId = $this->config()->getConfig()->company->companyId;

        $data = ['user_id' => $user_id, 'id' => $id, 'status' => 2];

        $resopnes = $this->testimonialStatus($data);
        if ($resopnes['response']['status'] == 'success') {
            $msg = "Data Delete Successfully..";

            $this->redirect()->toRoute('testimonial', ['action' => 'index']);
            $this->flashMessenger()->addMessage(array('success' => $msg));
        } else {
            $msg = "Data Could Not Deleted !..";
            $this->redirect()->toRoute('testimonial', ['action' => 'index']);
            $this->flashMessenger()->addMessage(array('danger' => $msg));
        }


        return $viewModel;
    }

    public function addTestimonial($data) {

        $url = $this->apiUrl() . "/testimonial/addtestimonial";
        $val = $this->post($url, $data);
        $JsonData = $val->getBody();
        $responseJson = Json::decode($JsonData, true);
        return $responseJson;
    }

    public function Testimoniallisting($data) {

        $url = $this->apiUrl() . "/testimonial/gettestimonial?company_id=" . $data;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $responseJson = Json::decode($JsonData, true);
        return $responseJson;
    }

    public function getTestimonial($data) {
        $url = $this->apiUrl() . "/testimonial/gettestimonial?id=" . $data['id'] . "&company_id=" . $data['company_id'];
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $responseJson = Json::decode($JsonData, true);
        return $responseJson;
    }

    public function testimonialStatus($data) {

        $url = $this->apiUrl() . "/testimonial/testimonialStatus?id=" . $data['id'] . "&user_id=" . $data['user_id'] . "&status=" . $data['status'];
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

    public function updateTestimonial($data) {

        $url = $this->apiUrl() . "/testimonial/updateTestimonial";
        $resp = $this->post($url, $data);
        $response = Json::decode($resp->getBody(), true);
        return $response;
    }

}
