<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Application\Controller\RestAPIClientController;
use Zend\View\Model\ViewModel;
use Dashboard\Model\Template;
use Dashboard\Form\TemplateSettingsForm;
use Dashboard\Form\MailForm;
use Dashboard\Form\SmsForm;
use Zend\Session\Container;
use Zend\Json\Json;
use Zend\Debug\Debug;

class TemplateSettingsController extends RestAPIClientController {

    /**
     * 
     * @return ViewModel
     */
    public function __construct() {
        $this->temp = new Template();
    }

    public function indexAction() {
        //write code here...

        $form = new TemplateSettingsForm();
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    /* @Desc - Email Template Setting */

    public function mailTemplateAction() {
        $companyId = $this->config()->getConfig()->company->companyId;
        $mailList = $this->temp->getMailList($companyId);
        $viewModel = new ViewModel(['mailList' => $mailList['data']]);
        return $viewModel;
    }

    public function AddMailAction() {
        $form = new MailForm();
        $mailinfo = $this->temp->addMailInfo();
        $request = $this->getRequest();

        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();
                $addMailDeatils = $this->temp->insertMailDetails($post);

                if ((!empty($addMailDeatils)) && (!isset($addMailDeatils['error']))) {

                    $msg = "Mail Details Added Successfully";
                    $this->redirect()->toRoute('templatesettings', ['action' => 'mail-template']);
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Mail Details Could Not Added Successfully";

                    $this->redirect()->toRoute('templatesettings', ['action' => 'add-mail']);
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function EditMailAction() {
        $data = [];
        $is_active = '';
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $updateMailDeatils = '';
        $getid = $this->params()->fromQuery('id');
        $data['id'] = $getid;
        $content = $this->temp->getDesc($data);
        $form = new MailForm();
        $companyId = $this->config()->getConfig()->company->companyId;
        $compData = $this->getCompanySetupDetails($companyId);
        if ((!empty($content['data']))) {
            $form->setData($content['data']);
            $form->get('header_text')->setValue($content['data']['header_text']);
            $form->get('footer_text')->setValue($content['data']['footer_text']);
            $form->get('description')->setValue($content['data']['description']);
            $status = $content['data']['is_active'];
        }
        $request = $this->getRequest();
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();
                $updateMailDeatils = $this->temp->editMailDetails($post);

                if ((!empty($updateMailDeatils)) && (!isset($updateMailDeatils['error']))) {

                    $msg = "Mail Details Updated Successfully";
                    $this->redirect()->toRoute('templatesettings', ['action' => 'mail-template']);
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Mail Details Could Not Updated Successfully";

                    $this->redirect()->toRoute('templatesettings', ['action' => 'edit-mail']);
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
            }
        }
        $viewModel = new ViewModel(['form' => $form, 'status' => $status]);
        return $viewModel;
    }
    
     public function MailStatusAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $data = $this->getRequest()->getPost();
        $id = implode(',', $data['selected']);
        $user_status = $data['status'];
        $data = ['id' => $id, 'email_status' => $user_status, 'user_id'=>$userId];
        $this->temp->updateMailStatus($data); 
        $companyId = $this->config()->getConfig()->company->companyId;
        $mailList = $this->temp->getMailList($companyId);
        $viewModel = new ViewModel(['mailList' => $mailList['data']]);
        $viewModel->setTemplate('dashboard/template-settings/mail-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function descViewAction() {
        $desc = '';
        $val = $this->getRequest()->getPost();
        $content = $this->temp->getDesc($val);
        if (!empty($content)) {
            $data = $content['data'];
        }
        $viewModel = new ViewModel(['data' => $data,'type'=>$val['type']]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function SmsTemplateAction() {
        $companyId = $this->config()->getConfig()->company->companyId;
        $smslist = $this->temp->getSmsList($companyId);
        $viewModel = new ViewModel(['smslist' => $smslist['data']]);
        return $viewModel;
    }

    public function AddSmsAction() {
        $form = new SmsForm();
        $request = $this->getRequest();

        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();
                $post['company_id']= $this->config()->getConfig()->company->companyId;
                $insertdata=$this->temp->insertSmsDetails($post);                
                if($insertdata['responsedata']['status']=="success"){
                    $msg = "New Sms Details Created Successfully";
                    $this->redirect()->toRoute('templatesettings', ['action' => 'sms-template']);
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Sms Details Could Not create Successfully";
                    $this->redirect()->toRoute('templatesettings', ['action' => 'add-sms']);
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }                
            }
        }

        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function EditSmsAction() {
        $form = new SmsForm();
        $is_active='';
        $request = $this->getRequest();
        $getid = $this->params()->fromQuery('id');
        
        if(!empty($getid)){
         $getdata=$this->temp->getsmsdetail($getid);
         $is_active=$getdata['data']['is_active'];
         //echo $is_active; die;
         $form->setData($getdata['data']);
        }
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray(); 
                $getresult=$this->temp->editSmsDetails($post);             
                if ((!empty($getresult)) && (!isset($getresult['error']))) {

                    $msg = "Sms Details Updated Successfully";
                    $this->redirect()->toRoute('templatesettings', ['action' => 'sms-template']);
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Sms Details Could Not Update Successfully";
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
                
            }
        }

        $viewModel = new ViewModel(['form' => $form,'is_active'=>$is_active]);
        return $viewModel;
    }
    
    public function SmsStatusAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $data = $this->getRequest()->getPost();
        $id = implode(',', $data['selected']);
        $user_status = $data['status'];
        $data = ['id' => $id, 'sms_status' => $user_status, 'user_id'=>$userId];
        $this->temp->updateSmsStatus($data);
        $companyId = $this->config()->getConfig()->company->companyId;
        $smslist = $this->temp->getSmsList($companyId);
        $viewModel = new ViewModel(['smslist' => $smslist['data']]);
        $viewModel->setTemplate('dashboard/template-settings/sms-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function deleteMailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'email_status' => 2, 'user_id'=>$userId];
        $this->temp->updateMailStatus($data); 
        $this->redirect()->toRoute('templatesettings', ['action' => 'mail-template']);
    }
    
    public function deleteSmsAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'sms_status' => 2, 'user_id'=>$userId];
        $this->temp->updateSmsStatus($data);
        $this->redirect()->toRoute('templatesettings', ['action' => 'sms-template']);
    }
    
    public function changeRecordStatusAction() {
        $status=0;
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if($postData['status']==0){
                $status=1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'email_status' => $status];
            $this->temp->updateMailStatus($data);
        }
        $data = [];
        $companyId = $this->config()->getConfig()->company->companyId;
        $mailList = $this->temp->getMailList($companyId);
        $viewModel = new ViewModel(['mailList' => $mailList['data']]);
        $viewModel->setTemplate('dashboard/template-settings/mail-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function changeSmsRecordStatusAction() {
        $status=0;
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if($postData['status']==0 || $postData['status']==2){
                $status=1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'sms_status' => $status];
            $this->temp->updateSmsStatus($data);
        }
        $data = [];
        $companyId = $this->config()->getConfig()->company->companyId;
        $smslist = $this->temp->getSmsList($companyId);
        $viewModel = new ViewModel(['smslist' => $smslist['data']]);
        $viewModel->setTemplate('dashboard/template-settings/sms-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

}
