<?php

namespace Dashboard\Controller;

use Application\Controller\RestAPIClientController;
use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Dashboard\Form\{
    StatementOfAccountForm
};
use Zend\Json\Json;
use Zend\Session\Container;
use Zend\Debug\Debug;
use Dashboard\Model\Vehicle;

class StatementOfAccountController extends RestAPIClientController {

    public function __construct() {
        $this->vehicleModel = new Vehicle();
    }

    /**
     * Account Home
     * @return ViewModel
     */
    public function indexAction() {
        $data=[];
        $statusData = $this->getRequest()->getQuery()->toArray();
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $user_type_id = $loginData['user_type_id'];
        //Call API...
        StatementOfAccountForm::$bookingStatus = $this->getCabStatusList($user_type_id);
        StatementOfAccountForm:: $bookingType = $this->getPackageTypeList();
        StatementOfAccountForm:: $vehicletype = $this->vehicleModel->getVehicleTypeList();
        $form = new StatementOfAccountForm();
        if (!empty($statusData)) {
            if($statusData['type']=='current'){
            $data = ['multi_status' => '222','booking_pickup_date'=> date('Y-m-d')];
            }if($statusData['type']=='future'){
            $data = ['multi_status' => '111','booking_pickup_date'=> date('Y-m-d')];
            }if($statusData['type']=='complete'){
            $data = ['status' => '8'];
            }if($statusData['type']=='pending'){
            $data = ['status' => '1'];
            }if($statusData['type']=='cancel'){
            $data = ['status' => '10,20'];
            }
            if($user_type_id!=10){
            $data['user_id'] = $user_id;
            }
            $accountListing = $this->getStatementAccountData($data);
        } else {
            if($user_type_id!=10){
            $data = ['user_id' => $user_id];
            }
            $accountListing = $this->getStatementAccountData($data);
        }
        $accountListing = $this->getStatementAccountData($data);
      //  echo'<pre>';print_r($accountListing);die();
        $viewModel = new ViewModel(['form' => $form, 'accountListing' => $accountListing,]);
        return $viewModel;
    }

    /*
     * Search Cancellation Record
     * @return ViewModel
     */

    public function searchStatementRecordAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $user_type_id = $loginData['user_type_id'];
        $val = $this->getRequest()->getPost();
        //echo '<pre>';print_r($val);die();
        //echo $val['booking_reference'];die;
        //Call API...
        if($user_type_id!=10){
        $userId = $user_id;
        }else{
        $userId = "";
        }
        $data = [
            'booking_id' => $val['booking_reference'],
            'multi_status' => $val['booking_status'],
            'agent_reference'=>$val['agent_reference'],
            'multi_city_name'=>rtrim(str_replace(';',',',$val['city_search_id']),","),
            'client_first_name' => $val['passenger_first_name'],
            'client_last_name' => $val['passenger_last_name'],
            'multi_booking_type' => isset($val['booking_type'])?implode(',',$val['booking_type']):'',
            'multi_vehicle_type' => isset($val['vehicle_type'])?implode(',',$val['vehicle_type']):'',
            'from_date' => $val['from_date'],
            'to_date' => $val['to_date'],
            'user_id' => $userId,
            'booking_pickup_date'=> date('Y-m-d')
        ];
        $data = array_filter($data);
        //Call API...
        //echo '<pre>';print_r($data);die();
        $accountListing = $this->getStatementAccountData($data);
        $viewModel = new ViewModel(['accountListing' => $accountListing]);
        $viewModel->setTemplate('/dashboard/statement-of-account/statement-of-account-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    /**
     *
     * Mark Paid...
     */
    public function markPaidAction() {

        $data = $this->getRequest()->getPost();
        $response = $this->getResponse();
        $response->getHeaders()->addHeaderLine('Content-Type', 'application/json');
        $msg = ['resp' => 0, 'error' => '', 'status' => 'fail', 'message' => 'error occurred Try Again'];

        $res = 1; //call api

        if ($res) {
            $msg = ['resp' => 1, 'error' => '', 'status' => 'success', 'message' => 'Selected Data Marked'];
        }

        $response->setContent(json_encode($msg));
        return $response;
    }

    /**
     *
     * Mark Unpaid...
     */
    public function markUnpaidAction() {

        $data = $this->getRequest()->getPost();
        $response = $this->getResponse();
        $response->getHeaders()->addHeaderLine('Content-Type', 'application/json');
        $msg = ['resp' => 0, 'error' => '', 'status' => 'fail', 'message' => 'error occurred Try Again'];

        $res = 1; //call api

        if (isset($res)) {
            $msg = ['resp' => 1, 'error' => '', 'status' => 'success', 'message' => 'Selected Data Unmark'];
        }

        $response->setContent(json_encode($msg));
        return $response;
    }

    /**
     *
     * Mark Cancle...
     */
    public function markCancleAction() {

        $data = $this->getRequest()->getPost();
        $response = $this->getResponse();
        $response->getHeaders()->addHeaderLine('Content-Type', 'application/json');
        $msg = ['resp' => 0, 'error' => '', 'status' => 'fail', 'message' => 'error occurred Try Again'];

        $res = 1; //call api

        if ($res) {
            $msg = ['resp' => 1, 'error' => '', 'status' => 'success', 'message' => 'Selected Data Cancled'];
        }

        $response->setContent(json_encode($msg));
        return $response;
    }

    /**
     *
     * Mark Overdue...
     */
    public function markOverdueAction() {

        $data = $this->getRequest()->getPost();
        $response = $this->getResponse();
        $response->getHeaders()->addHeaderLine('Content-Type', 'application/json');
        $msg = ['resp' => 0, 'error' => '', 'status' => 'fail', 'message' => 'error occurred Try Again'];

        $res = 1; //call api

        if ($res) {
            $msg = ['resp' => 1, 'error' => '', 'status' => 'success', 'message' => 'Selected Data Markoverdue'];
        }

        $response->setContent(json_encode($msg));
        return $response;
    }

    /**
     *
     * Mark Collection...
     */
    public function markCollectionAction() {

        $data = $this->getRequest()->getPost();
        $response = $this->getResponse();
        $response->getHeaders()->addHeaderLine('Content-Type', 'application/json');
        $msg = ['resp' => 0, 'error' => '', 'status' => 'fail', 'message' => 'error occurred Try Again'];

        $res = 1; //call api

        if ($res) {
            $msg = ['resp' => 1, 'error' => '', 'status' => 'success', 'message' => 'Selected Data Markcollection'];
        }

        $response->setContent(json_encode($msg));
        return $response;
    }

    public function getCabStatusList($userTypeId) {
        if($userTypeId==3){
        $statusJsonDataArray = ['8'=> 'Completed', '111'=> 'Future', '10'=> 'Driver Cancel','222'=>'Current'];
        }else if($userTypeId==4){
        $statusJsonDataArray = ['8'=> 'Completed', '111' => 'Future', '21'=> 'Vendor Cancel','222'=>'Current'];
        }else if($userTypeId==10){
        $statusJsonDataArray = ['8'=> 'Completed', '111' => 'Future', '20'=> 'User Cancel', '10'=> 'Driver Cancel', '21'=> 'Vendor Cancel', '222'=>'Current'];
        }else{
        $statusJsonDataArray = ['8'=> 'Completed', '111' => 'Future', '20'=> 'User Cancel','222'=>'Current'];
        }
        return $statusJsonDataArray;
    }

    public function getPackageTypeList() {
        $packageTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/package";
        $resp = $this->get($url);
        $packageTypeJsonData = Json::decode($resp->getBody(), true);
        foreach ($packageTypeJsonData['data'] as $res) {
            $packageTypeJsonDataArray[$res['id']] = $res['name'];
        }
        return $packageTypeJsonDataArray;
    }

    public function getVehicleTypeList($data = null) {
        $vehicleTypeJsonDataArray = [];
        $val = '{"where": {"status": {"neq": 2}}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/vehicle-type?&filter=" . $val;
        $resp = $this->get($url);
        $vehicleTypeJsonData = Json::decode($resp->getBody(), true);
        if($vehicleTypeJsonData['status']=="success"){
        foreach ($vehicleTypeJsonData['data'] as $res) {
            $vehicleTypeJsonDataArray[$res['id']] = $res['vehicle_type'];
        }
        }
        return $vehicleTypeJsonDataArray;
    }

    public function getStatementAccountData($data) {
        $url = $this->apiUrl() . "/booking/bookingListSearch";
        $resp = $this->post($url, $data);
        $bookingList = Json::decode($resp->getBody(), true);
        $result = [];
        if ($bookingList['responsedata']['status'] == 'success') {
            $result = $bookingList['responsedata']['data'];
        }
        return $result;
    }

    public function makePaymentAction() {
        $val = $this->getRequest()->getPost();
        $apiParams = ['booking_id' => $val['ref']];
        $url = $this->apiUrl() . "/booking/bookingListSearch";
        $resp = $this->post($url, $apiParams);
        $bookingList = Json::decode($resp->getBody(), true);
        $bookinginfo = $bookingList['responsedata']['data'];
        if ($bookingList['responsedata']['status'] == 'success') {
            $bookinginfo = $bookingList['responsedata']['data'];
            $makePaymentContainer = new Container('make_payment');
            $makePaymentContainer->booking_detail = $bookinginfo[0];
            $result = ['status' => 'success'];
        }
        $view = new JsonModel($result);
        return $view;
    }

}
