<?php

namespace Dashboard\Controller;

use Application\Controller\RestAPIClientController;
use Dashboard\Form\{
    UserAddBasicForm,
    UserAddCancellationFeesForm,
    UserAddPricePremiumForm,
    UserAddPriceFixedRoutesForm,
    UserAddShareForm,
    BookingMappingForm,
    PointConversionForm,
    ProfileCompanyDetailForm
};
use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Zend\Json\Json;
use Zend\Session\Container;
use Zend\Debug\Debug;
use Dashboard\Model\CommonModel;
use Dashboard\Model\User;

class SettingController extends RestAPIClientController {

    public function __construct() {
        $this->CommonModel = new CommonModel();
        $this->userModel = new User();
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : ADD THE CAB BASIC TAX FARE
     * @param $data
     * @returns $responsedata
     */

    public function indexAction() {
        $taxFare = "";
        $taxFareDetails = "";
        $bookingModule = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        //$user_id = 6;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->cab;
        //UserAddBasicForm::$booking_module = $this->CommonModel->getBookingModuleList();     
       UserAddBasicForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddBasicForm();
        //$login_id = '1111';
        if (!empty($id)) {
            $taxFare = $this->CommonModel->getUserTaxDetail($login_id, $masterBookType, $id);
            $taxFare = $taxFare[0];
            $bookingModule = $this->fetchBookingModule($taxFare['booking_type']);
            
            $stateList = $this->getPackageListArray($bookingModule);
            if (!empty($stateList['data'])) {
                foreach ($stateList['data'] as $val) {
                    $list[$val['id']] = $val['name'];
                }
                $form->get('booking_type')->setValueOptions($list);
                $form->get('booking_type')->setValue($taxFare['booking_type']);
            }
            //echo "<pre>";            print_r($taxFare); die;
        }
        $taxFareDetails = $this->CommonModel->getUserTaxDetail($login_id, $masterBookType, '');
        //$taxFareDetails
        //echo '<pre>';print_r($taxFareDetails);die();
        //echo '<pre>';print_r($taxFare[0]);die();
        if (!empty($taxFare)) {
            $form->setData($taxFare);
            $taxFareId = $taxFare['id'];
        } else {
            $taxFareId = 0;
        }

        $fareSetting = $this->CommonModel->getFareSettingDetail($login_id);
        //echo '<pre>';print_r($fareSetting);die();
        if (!empty($fareSetting)) {
            $fareSettingId = $fareSetting['id'];
        } else {
            $fareSettingId = 0;
        }

        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            $form->setData($postdata);
            if ($postdata['tax_save'] == 'Save & Next') {
                $form->getInputFilter()->get('booking_type')->setRequired(false);
                $form->getInputFilter()->get('sgst')->setRequired(false);
                $form->getInputFilter()->get('cgst')->setRequired(false);
                $form->getInputFilter()->get('igst')->setRequired(false);
                $form->getInputFilter()->get('tax_date_from')->setRequired(false);
                $form->getInputFilter()->get('tax_date_to')->setRequired(false);
            }
            if ($form->isValid()) {

                if ($postdata['tax_save'] == 'Save') {
                    $addBasicFare = [
                        'user_id' => $login_id,
                        'master_booking_type_id' => $masterBookType,
                        'booking_type' => $postdata['booking_type'],
                        'from_date' => date('Y-m-d', strtotime($postdata['tax_date_from'])),
                        'to_date' => date('Y-m-d', strtotime($postdata['tax_date_to'])),
                        'tax_type' => '%',
                        'sgst' => $postdata['sgst'],
                        'cgst' => $postdata['cgst'],
                        'igst' => $postdata['igst'],
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'status' => 1,
                        //'auto_id' => $taxFareId
                        'auto_id' => $postdata['tax_fare_id']
                    ];
                    //echo '<pre>';print_r($addBasicFare);die();

                    if ($postdata['tax_fare_id'] > 0) {
                        $addBasicFare['modified_by'] = $login_id;
                        $resp = $this->CommonModel->updatetUserTaxDetail($addBasicFare);
                        $msg = $resp['message'];
                    } else if (isset($postdata['tax_save']) && ($postdata['tax_save'] == 'Save')) {
                        $addBasicFare['created_by'] = $login_id;
                        $resp = $this->CommonModel->addUserTaxDetail($addBasicFare);
                        $msg = "Data Insert Successfully";
                    }
                    $this->redirect()->toRoute('setting', ['action' => 'index']);
                } else {

                    $basicfareSettings = [
                        'user_id' => $login_id,
                        'rounding' => $postdata['rounding'],
                        'level' => $postdata['level'],
                        'direction' => $postdata['direction'],
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'status' => 1,
                        'auto_id' => $fareSettingId
                    ];
                    //echo '<pre>';print_r($basicfareSettings);die();
                    if ($fareSettingId > 0) {
                        $basicfareSettings['modified_by'] = $login_id;
                        $resp = $this->CommonModel->updateUserFareSettingDetail($basicfareSettings);
                        $msg = $resp['message'];
                    } else {
                        $basicfareSettings['created_by'] = $login_id;
                        $resp = $this->CommonModel->addUserFareSettingDetail($basicfareSettings);
                        $msg = "Data Insert Successfully";
                    }
                    //$this->redirect()->toRoute('setting', ['action' => 'add-fees-fare']);
                    $this->redirect()->toRoute('setting', ['action' => 'index']);
                }
                //echo '<pre>';print_r($resp);die();
                //$this->redirect()->toRoute('setting', ['action' => 'index']);
                $this->flashMessenger()->addMessage(array('success' => $msg));
            } else {
                //$sm = $form->getMessages();
                //echo '<pre>';print_r($sm);die();
            }
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'tax-detail', 'taxFare' => $taxFare, 'taxFareDetails' => $taxFareDetails, 'fareSetting' => $fareSetting, 'bookingModule'=>$bookingModule]);
        return $viewModel;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : ADD THE PACKAGE BASIC TAX FARE
     * @param $data
     * @returns $responsedata
     */
    
    
    public function packagetaxAction() {
        $taxFare = "";
        $taxFareDetails = "";
        $bookingModule = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        //$user_id = 6;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->package;
        //UserAddBasicForm::$booking_module = $this->CommonModel->getBookingModuleList();     
       UserAddBasicForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddBasicForm();
        //$login_id = '1111';
        if (!empty($id)) {
            $taxFare = $this->CommonModel->getUserTaxDetail($login_id, $masterBookType, $id);
            $taxFare = $taxFare[0];
            $bookingModule = $this->fetchBookingModule($taxFare['booking_type']);
            
            $stateList = $this->getPackageListArray($bookingModule);
            if (!empty($stateList['data'])) {
                foreach ($stateList['data'] as $val) {
                    $list[$val['id']] = $val['name'];
                }
                $form->get('booking_type')->setValueOptions($list);
                $form->get('booking_type')->setValue($taxFare['booking_type']);
            }
            //echo "<pre>";            print_r($taxFare); die;
        }
        $taxFareDetails = $this->CommonModel->getUserTaxDetail($login_id, $masterBookType, '');
        //$taxFareDetails
        //echo '<pre>';print_r($taxFareDetails);die();
        //echo '<pre>';print_r($taxFare[0]);die();
        if (!empty($taxFare)) {
            $form->setData($taxFare);
            $taxFareId = $taxFare['id'];
        } else {
            $taxFareId = 0;
        }

        $fareSetting = $this->CommonModel->getFareSettingDetail($login_id);
        //echo '<pre>';print_r($fareSetting);die();
        if (!empty($fareSetting)) {
            $fareSettingId = $fareSetting['id'];
        } else {
            $fareSettingId = 0;
        }

        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            $form->setData($postdata);
            if ($postdata['tax_save'] == 'Save & Next') {
                $form->getInputFilter()->get('booking_type')->setRequired(false);
                $form->getInputFilter()->get('sgst')->setRequired(false);
                $form->getInputFilter()->get('cgst')->setRequired(false);
                $form->getInputFilter()->get('igst')->setRequired(false);
                $form->getInputFilter()->get('tax_date_from')->setRequired(false);
                $form->getInputFilter()->get('tax_date_to')->setRequired(false);
            }
            if ($form->isValid()) {

                if ($postdata['tax_save'] == 'Save') {
                    $addBasicFare = [
                        'user_id' => $login_id,
                        'master_booking_type_id' => $masterBookType,
                        'booking_type' => $postdata['booking_type'],
                        'from_date' => date('Y-m-d', strtotime($postdata['tax_date_from'])),
                        'to_date' => date('Y-m-d', strtotime($postdata['tax_date_to'])),
                        'tax_type' => '%',
                        'sgst' => $postdata['sgst'],
                        'cgst' => $postdata['cgst'],
                        'igst' => $postdata['igst'],
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'status' => 1,
                        //'auto_id' => $taxFareId
                        'auto_id' => $postdata['tax_fare_id']
                    ];
                    //echo '<pre>';print_r($addBasicFare);die();

                    if ($postdata['tax_fare_id'] > 0) {
                        $addBasicFare['modified_by'] = $login_id;
                        $resp = $this->CommonModel->updatetUserTaxDetail($addBasicFare);
                        $msg = $resp['message'];
                    } else if (isset($postdata['tax_save']) && ($postdata['tax_save'] == 'Save')) {
                        $addBasicFare['created_by'] = $login_id;
                        $resp = $this->CommonModel->addUserTaxDetail($addBasicFare);
                        $msg = "Data Insert Successfully";
                    }
                    $this->redirect()->toRoute('setting', ['action' => 'packagetax']);
                } else {

                    $basicfareSettings = [
                        'user_id' => $login_id,
                        'rounding' => $postdata['rounding'],
                        'level' => $postdata['level'],
                        'direction' => $postdata['direction'],
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'status' => 1,
                        'auto_id' => $fareSettingId
                    ];
                    //echo '<pre>';print_r($basicfareSettings);die();
                    if ($fareSettingId > 0) {
                        $basicfareSettings['modified_by'] = $login_id;
                        $resp = $this->CommonModel->updateUserFareSettingDetail($basicfareSettings);
                        $msg = $resp['message'];
                    } else {
                        $basicfareSettings['created_by'] = $login_id;
                        $resp = $this->CommonModel->addUserFareSettingDetail($basicfareSettings);
                        $msg = "Data Insert Successfully";
                    }
                    //$this->redirect()->toRoute('setting', ['action' => 'add-fees-fare']);
                    $this->redirect()->toRoute('setting', ['action' => 'packagetax']);
                }
                //echo '<pre>';print_r($resp);die();
                //$this->redirect()->toRoute('setting', ['action' => 'index']);
                $this->flashMessenger()->addMessage(array('success' => $msg));
            } else {
                //$sm = $form->getMessages();
                //echo '<pre>';print_r($sm);die();
            }
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'tax-detail', 'taxFare' => $taxFare, 'taxFareDetails' => $taxFareDetails, 'fareSetting' => $fareSetting, 'bookingModule'=>$bookingModule]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : ADD THE HOTEL BASIC TAX FARE
     * @param $data
     * @returns $responsedata
     */
    
    public function hoteltaxAction() {
        $taxFare = "";
        $taxFareDetails = "";
        $bookingModule = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        //$user_id = 6;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->hotel;
        //UserAddBasicForm::$booking_module = $this->CommonModel->getBookingModuleList();     
       UserAddBasicForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddBasicForm();
        //$login_id = '1111';
        if (!empty($id)) {
            $taxFare = $this->CommonModel->getUserTaxDetail($login_id, $masterBookType, $id);
            $taxFare = $taxFare[0];
            $bookingModule = $this->fetchBookingModule($taxFare['booking_type']);
            
            $stateList = $this->getPackageListArray($bookingModule);
            if (!empty($stateList['data'])) {
                foreach ($stateList['data'] as $val) {
                    $list[$val['id']] = $val['name'];
                }
                $form->get('booking_type')->setValueOptions($list);
                $form->get('booking_type')->setValue($taxFare['booking_type']);
            }
            //echo "<pre>";            print_r($taxFare); die;
        }
        $taxFareDetails = $this->CommonModel->getUserTaxDetail($login_id, $masterBookType, '');
        //$taxFareDetails
        //echo '<pre>';print_r($taxFareDetails);die();
        //echo '<pre>';print_r($taxFare[0]);die();
        if (!empty($taxFare)) {
            $form->setData($taxFare);
            $taxFareId = $taxFare['id'];
        } else {
            $taxFareId = 0;
        }

        $fareSetting = $this->CommonModel->getFareSettingDetail($login_id);
        //echo '<pre>';print_r($fareSetting);die();
        if (!empty($fareSetting)) {
            $fareSettingId = $fareSetting['id'];
        } else {
            $fareSettingId = 0;
        }

        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            $form->setData($postdata);
            if ($postdata['tax_save'] == 'Save & Next') {
                $form->getInputFilter()->get('booking_type')->setRequired(false);
                $form->getInputFilter()->get('sgst')->setRequired(false);
                $form->getInputFilter()->get('cgst')->setRequired(false);
                $form->getInputFilter()->get('igst')->setRequired(false);
                $form->getInputFilter()->get('tax_date_from')->setRequired(false);
                $form->getInputFilter()->get('tax_date_to')->setRequired(false);
            }
            if ($form->isValid()) {

                if ($postdata['tax_save'] == 'Save') {
                    $addBasicFare = [
                        'user_id' => $login_id,
                        'master_booking_type_id' => $masterBookType,
                        'booking_type' => $postdata['booking_type'],
                        'from_date' => date('Y-m-d', strtotime($postdata['tax_date_from'])),
                        'to_date' => date('Y-m-d', strtotime($postdata['tax_date_to'])),
                        'tax_type' => '%',
                        'sgst' => $postdata['sgst'],
                        'cgst' => $postdata['cgst'],
                        'igst' => $postdata['igst'],
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'status' => 1,
                        //'auto_id' => $taxFareId
                        'auto_id' => $postdata['tax_fare_id']
                    ];
                    //echo '<pre>';print_r($addBasicFare);die();

                    if ($postdata['tax_fare_id'] > 0) {
                        $addBasicFare['modified_by'] = $login_id;
                        $resp = $this->CommonModel->updatetUserTaxDetail($addBasicFare);
                        $msg = $resp['message'];
                    } else if (isset($postdata['tax_save']) && ($postdata['tax_save'] == 'Save')) {
                        $addBasicFare['created_by'] = $login_id;
                        $resp = $this->CommonModel->addUserTaxDetail($addBasicFare);
                        $msg = "Data Insert Successfully";
                    }
                    $this->redirect()->toRoute('setting', ['action' => 'hoteltax']);
                } else {

                    $basicfareSettings = [
                        'user_id' => $login_id,
                        'rounding' => $postdata['rounding'],
                        'level' => $postdata['level'],
                        'direction' => $postdata['direction'],
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'status' => 1,
                        'auto_id' => $fareSettingId
                    ];
                    //echo '<pre>';print_r($basicfareSettings);die();
                    if ($fareSettingId > 0) {
                        $basicfareSettings['modified_by'] = $login_id;
                        $resp = $this->CommonModel->updateUserFareSettingDetail($basicfareSettings);
                        $msg = $resp['message'];
                    } else {
                        $basicfareSettings['created_by'] = $login_id;
                        $resp = $this->CommonModel->addUserFareSettingDetail($basicfareSettings);
                        $msg = "Data Insert Successfully";
                    }
                    //$this->redirect()->toRoute('setting', ['action' => 'add-fees-fare']);
                    $this->redirect()->toRoute('setting', ['action' => 'hoteltax']);
                }
                //echo '<pre>';print_r($resp);die();
                //$this->redirect()->toRoute('setting', ['action' => 'index']);
                $this->flashMessenger()->addMessage(array('success' => $msg));
            } else {
                //$sm = $form->getMessages();
                //echo '<pre>';print_r($sm);die();
            }
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'tax-detail', 'taxFare' => $taxFare, 'taxFareDetails' => $taxFareDetails, 'fareSetting' => $fareSetting, 'bookingModule'=>$bookingModule]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : ADD THE CRUISE BASIC TAX FARE
     * @param $data
     * @returns $responsedata
     */
    
    public function cruisetaxAction() {
        $taxFare = "";
        $taxFareDetails = "";
        $bookingModule = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        //$user_id = 6;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->cruise;
        //UserAddBasicForm::$booking_module = $this->CommonModel->getBookingModuleList();     
       UserAddBasicForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddBasicForm();
        //$login_id = '1111';
        if (!empty($id)) {
            $taxFare = $this->CommonModel->getUserTaxDetail($login_id, $masterBookType, $id);
            $taxFare = $taxFare[0];
            $bookingModule = $this->fetchBookingModule($taxFare['booking_type']);
            
            $stateList = $this->getPackageListArray($bookingModule);
            if (!empty($stateList['data'])) {
                foreach ($stateList['data'] as $val) {
                    $list[$val['id']] = $val['name'];
                }
                $form->get('booking_type')->setValueOptions($list);
                $form->get('booking_type')->setValue($taxFare['booking_type']);
            }
            //echo "<pre>";            print_r($taxFare); die;
        }
        $taxFareDetails = $this->CommonModel->getUserTaxDetail($login_id, $masterBookType, '');
        //$taxFareDetails
        //echo '<pre>';print_r($taxFareDetails);die();
        //echo '<pre>';print_r($taxFare[0]);die();
        if (!empty($taxFare)) {
            $form->setData($taxFare);
            $taxFareId = $taxFare['id'];
        } else {
            $taxFareId = 0;
        }

        $fareSetting = $this->CommonModel->getFareSettingDetail($login_id);
        //echo '<pre>';print_r($fareSetting);die();
        if (!empty($fareSetting)) {
            $fareSettingId = $fareSetting['id'];
        } else {
            $fareSettingId = 0;
        }

        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            $form->setData($postdata);
            if ($postdata['tax_save'] == 'Save & Next') {
                $form->getInputFilter()->get('booking_type')->setRequired(false);
                $form->getInputFilter()->get('sgst')->setRequired(false);
                $form->getInputFilter()->get('cgst')->setRequired(false);
                $form->getInputFilter()->get('igst')->setRequired(false);
                $form->getInputFilter()->get('tax_date_from')->setRequired(false);
                $form->getInputFilter()->get('tax_date_to')->setRequired(false);
            }
            if ($form->isValid()) {

                if ($postdata['tax_save'] == 'Save') {
                    $addBasicFare = [
                        'user_id' => $login_id,
                        'master_booking_type_id' => $masterBookType,
                        'booking_type' => $postdata['booking_type'],
                        'from_date' => date('Y-m-d', strtotime($postdata['tax_date_from'])),
                        'to_date' => date('Y-m-d', strtotime($postdata['tax_date_to'])),
                        'tax_type' => '%',
                        'sgst' => $postdata['sgst'],
                        'cgst' => $postdata['cgst'],
                        'igst' => $postdata['igst'],
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'status' => 1,
                        //'auto_id' => $taxFareId
                        'auto_id' => $postdata['tax_fare_id']
                    ];
                    //echo '<pre>';print_r($addBasicFare);die();

                    if ($postdata['tax_fare_id'] > 0) {
                        $addBasicFare['modified_by'] = $login_id;
                        $resp = $this->CommonModel->updatetUserTaxDetail($addBasicFare);
                        $msg = $resp['message'];
                    } else if (isset($postdata['tax_save']) && ($postdata['tax_save'] == 'Save')) {
                        $addBasicFare['created_by'] = $login_id;
                        $resp = $this->CommonModel->addUserTaxDetail($addBasicFare);
                        $msg = "Data Insert Successfully";
                    }
                    $this->redirect()->toRoute('setting', ['action' => 'cruisetax']);
                } else {

                    $basicfareSettings = [
                        'user_id' => $login_id,
                        'rounding' => $postdata['rounding'],
                        'level' => $postdata['level'],
                        'direction' => $postdata['direction'],
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'status' => 1,
                        'auto_id' => $fareSettingId
                    ];
                    //echo '<pre>';print_r($basicfareSettings);die();
                    if ($fareSettingId > 0) {
                        $basicfareSettings['modified_by'] = $login_id;
                        $resp = $this->CommonModel->updateUserFareSettingDetail($basicfareSettings);
                        $msg = $resp['message'];
                    } else {
                        $basicfareSettings['created_by'] = $login_id;
                        $resp = $this->CommonModel->addUserFareSettingDetail($basicfareSettings);
                        $msg = "Data Insert Successfully";
                    }
                    //$this->redirect()->toRoute('setting', ['action' => 'add-fees-fare']);
                    $this->redirect()->toRoute('setting', ['action' => 'cruisetax']);
                }
                //echo '<pre>';print_r($resp);die();
                //$this->redirect()->toRoute('setting', ['action' => 'index']);
                $this->flashMessenger()->addMessage(array('success' => $msg));
            } else {
                //$sm = $form->getMessages();
                //echo '<pre>';print_r($sm);die();
            }
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'tax-detail', 'taxFare' => $taxFare, 'taxFareDetails' => $taxFareDetails, 'fareSetting' => $fareSetting, 'bookingModule'=>$bookingModule]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : ADD THE FLIGHT BASIC TAX FARE
     * @param $data
     * @returns $responsedata
     */
    
    public function flighttaxAction() {
        $taxFare = "";
        $taxFareDetails = "";
        $bookingModule = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        //$user_id = 6;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->flight;
        //UserAddBasicForm::$booking_module = $this->CommonModel->getBookingModuleList();     
       UserAddBasicForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddBasicForm();
        //$login_id = '1111';
        if (!empty($id)) {
            $taxFare = $this->CommonModel->getUserTaxDetail($login_id, $masterBookType, $id);
            $taxFare = $taxFare[0];
            $bookingModule = $this->fetchBookingModule($taxFare['booking_type']);
            
            $stateList = $this->getPackageListArray($bookingModule);
            if (!empty($stateList['data'])) {
                foreach ($stateList['data'] as $val) {
                    $list[$val['id']] = $val['name'];
                }
                $form->get('booking_type')->setValueOptions($list);
                $form->get('booking_type')->setValue($taxFare['booking_type']);
            }
            //echo "<pre>";            print_r($taxFare); die;
        }
        $taxFareDetails = $this->CommonModel->getUserTaxDetail($login_id, $masterBookType, '');
        //$taxFareDetails
        //echo '<pre>';print_r($taxFareDetails);die();
        //echo '<pre>';print_r($taxFare[0]);die();
        if (!empty($taxFare)) {
            $form->setData($taxFare);
            $taxFareId = $taxFare['id'];
        } else {
            $taxFareId = 0;
        }

        $fareSetting = $this->CommonModel->getFareSettingDetail($login_id);
        //echo '<pre>';print_r($fareSetting);die();
        if (!empty($fareSetting)) {
            $fareSettingId = $fareSetting['id'];
        } else {
            $fareSettingId = 0;
        }

        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            $form->setData($postdata);
            if ($postdata['tax_save'] == 'Save & Next') {
                $form->getInputFilter()->get('booking_type')->setRequired(false);
                $form->getInputFilter()->get('sgst')->setRequired(false);
                $form->getInputFilter()->get('cgst')->setRequired(false);
                $form->getInputFilter()->get('igst')->setRequired(false);
                $form->getInputFilter()->get('tax_date_from')->setRequired(false);
                $form->getInputFilter()->get('tax_date_to')->setRequired(false);
            }
            if ($form->isValid()) {

                if ($postdata['tax_save'] == 'Save') {
                    $addBasicFare = [
                        'user_id' => $login_id,
                        'master_booking_type_id' => $masterBookType,
                        'booking_type' => $postdata['booking_type'],
                        'from_date' => date('Y-m-d', strtotime($postdata['tax_date_from'])),
                        'to_date' => date('Y-m-d', strtotime($postdata['tax_date_to'])),
                        'tax_type' => '%',
                        'sgst' => $postdata['sgst'],
                        'cgst' => $postdata['cgst'],
                        'igst' => $postdata['igst'],
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'status' => 1,
                        //'auto_id' => $taxFareId
                        'auto_id' => $postdata['tax_fare_id']
                    ];
                    //echo '<pre>';print_r($addBasicFare);die();

                    if ($postdata['tax_fare_id'] > 0) {
                        $addBasicFare['modified_by'] = $login_id;
                        $resp = $this->CommonModel->updatetUserTaxDetail($addBasicFare);
                        $msg = $resp['message'];
                    } else if (isset($postdata['tax_save']) && ($postdata['tax_save'] == 'Save')) {
                        $addBasicFare['created_by'] = $login_id;
                        $resp = $this->CommonModel->addUserTaxDetail($addBasicFare);
                        $msg = "Data Insert Successfully";
                    }
                    $this->redirect()->toRoute('setting', ['action' => 'flighttax']);
                } else {

                    $basicfareSettings = [
                        'user_id' => $login_id,
                        'rounding' => $postdata['rounding'],
                        'level' => $postdata['level'],
                        'direction' => $postdata['direction'],
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'status' => 1,
                        'auto_id' => $fareSettingId
                    ];
                    //echo '<pre>';print_r($basicfareSettings);die();
                    if ($fareSettingId > 0) {
                        $basicfareSettings['modified_by'] = $login_id;
                        $resp = $this->CommonModel->updateUserFareSettingDetail($basicfareSettings);
                        $msg = $resp['message'];
                    } else {
                        $basicfareSettings['created_by'] = $login_id;
                        $resp = $this->CommonModel->addUserFareSettingDetail($basicfareSettings);
                        $msg = "Data Insert Successfully";
                    }
                    //$this->redirect()->toRoute('setting', ['action' => 'add-fees-fare']);
                    $this->redirect()->toRoute('setting', ['action' => 'flighttax']);
                }
                //echo '<pre>';print_r($resp);die();
                //$this->redirect()->toRoute('setting', ['action' => 'index']);
                $this->flashMessenger()->addMessage(array('success' => $msg));
            } else {
                //$sm = $form->getMessages();
                //echo '<pre>';print_r($sm);die();
            }
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'tax-detail', 'taxFare' => $taxFare, 'taxFareDetails' => $taxFareDetails, 'fareSetting' => $fareSetting, 'bookingModule'=>$bookingModule]);
        return $viewModel;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : ADD THE BUS BASIC TAX FARE
     * @param $data
     * @returns $responsedata
     */
    
    public function bustaxAction() {
        $taxFare = "";
        $taxFareDetails = "";
        $bookingModule = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        //$user_id = 6;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->bus;
        //UserAddBasicForm::$booking_module = $this->CommonModel->getBookingModuleList();     
       UserAddBasicForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddBasicForm();
        //$login_id = '1111';
        if (!empty($id)) {
            $taxFare = $this->CommonModel->getUserTaxDetail($login_id, $masterBookType, $id);
            $taxFare = $taxFare[0];
            $bookingModule = $this->fetchBookingModule($taxFare['booking_type']);
            
            $stateList = $this->getPackageListArray($bookingModule);
            if (!empty($stateList['data'])) {
                foreach ($stateList['data'] as $val) {
                    $list[$val['id']] = $val['name'];
                }
                $form->get('booking_type')->setValueOptions($list);
                $form->get('booking_type')->setValue($taxFare['booking_type']);
            }
            //echo "<pre>";            print_r($taxFare); die;
        }
        $taxFareDetails = $this->CommonModel->getUserTaxDetail($login_id, $masterBookType, '');
        //$taxFareDetails
        //echo '<pre>';print_r($taxFareDetails);die();
        //echo '<pre>';print_r($taxFare[0]);die();
        if (!empty($taxFare)) {
            $form->setData($taxFare);
            $taxFareId = $taxFare['id'];
        } else {
            $taxFareId = 0;
        }

        $fareSetting = $this->CommonModel->getFareSettingDetail($login_id);
        //echo '<pre>';print_r($fareSetting);die();
        if (!empty($fareSetting)) {
            $fareSettingId = $fareSetting['id'];
        } else {
            $fareSettingId = 0;
        }

        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            $form->setData($postdata);
            if ($postdata['tax_save'] == 'Save & Next') {
                $form->getInputFilter()->get('booking_type')->setRequired(false);
                $form->getInputFilter()->get('sgst')->setRequired(false);
                $form->getInputFilter()->get('cgst')->setRequired(false);
                $form->getInputFilter()->get('igst')->setRequired(false);
                $form->getInputFilter()->get('tax_date_from')->setRequired(false);
                $form->getInputFilter()->get('tax_date_to')->setRequired(false);
            }
            if ($form->isValid()) {

                if ($postdata['tax_save'] == 'Save') {
                    $addBasicFare = [
                        'user_id' => $login_id,
                        'master_booking_type_id' => $masterBookType,
                        'booking_type' => $postdata['booking_type'],
                        'from_date' => date('Y-m-d', strtotime($postdata['tax_date_from'])),
                        'to_date' => date('Y-m-d', strtotime($postdata['tax_date_to'])),
                        'tax_type' => '%',
                        'sgst' => $postdata['sgst'],
                        'cgst' => $postdata['cgst'],
                        'igst' => $postdata['igst'],
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'status' => 1,
                        //'auto_id' => $taxFareId
                        'auto_id' => $postdata['tax_fare_id']
                    ];
                    //echo '<pre>';print_r($addBasicFare);die();

                    if ($postdata['tax_fare_id'] > 0) {
                        $addBasicFare['modified_by'] = $login_id;
                        $resp = $this->CommonModel->updatetUserTaxDetail($addBasicFare);
                        $msg = $resp['message'];
                    } else if (isset($postdata['tax_save']) && ($postdata['tax_save'] == 'Save')) {
                        $addBasicFare['created_by'] = $login_id;
                        $resp = $this->CommonModel->addUserTaxDetail($addBasicFare);
                        $msg = "Data Insert Successfully";
                    }
                    $this->redirect()->toRoute('setting', ['action' => 'bustax']);
                } else {

                    $basicfareSettings = [
                        'user_id' => $login_id,
                        'rounding' => $postdata['rounding'],
                        'level' => $postdata['level'],
                        'direction' => $postdata['direction'],
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'status' => 1,
                        'auto_id' => $fareSettingId
                    ];
                    //echo '<pre>';print_r($basicfareSettings);die();
                    if ($fareSettingId > 0) {
                        $basicfareSettings['modified_by'] = $login_id;
                        $resp = $this->CommonModel->updateUserFareSettingDetail($basicfareSettings);
                        $msg = $resp['message'];
                    } else {
                        $basicfareSettings['created_by'] = $login_id;
                        $resp = $this->CommonModel->addUserFareSettingDetail($basicfareSettings);
                        $msg = "Data Insert Successfully";
                    }
                    //$this->redirect()->toRoute('setting', ['action' => 'add-fees-fare']);
                    $this->redirect()->toRoute('setting', ['action' => 'bustax']);
                }
                //echo '<pre>';print_r($resp);die();
                //$this->redirect()->toRoute('setting', ['action' => 'index']);
                $this->flashMessenger()->addMessage(array('success' => $msg));
            } else {
                //$sm = $form->getMessages();
                //echo '<pre>';print_r($sm);die();
            }
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'tax-detail', 'taxFare' => $taxFare, 'taxFareDetails' => $taxFareDetails, 'fareSetting' => $fareSetting, 'bookingModule'=>$bookingModule]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : ADD THE ATTRACTION BASIC TAX FARE
     * @param $data
     * @returns $responsedata
     */
    
    public function attractiontaxAction() {
        $taxFare = "";
        $taxFareDetails = "";
        $bookingModule = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        //$user_id = 6;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->attractions;
        //UserAddBasicForm::$booking_module = $this->CommonModel->getBookingModuleList();     
       UserAddBasicForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddBasicForm();
        //$login_id = '1111';
        if (!empty($id)) {
            $taxFare = $this->CommonModel->getUserTaxDetail($login_id, $masterBookType, $id);
            $taxFare = $taxFare[0];
            $bookingModule = $this->fetchBookingModule($taxFare['booking_type']);
            
            $stateList = $this->getPackageListArray($bookingModule);
            if (!empty($stateList['data'])) {
                foreach ($stateList['data'] as $val) {
                    $list[$val['id']] = $val['name'];
                }
                $form->get('booking_type')->setValueOptions($list);
                $form->get('booking_type')->setValue($taxFare['booking_type']);
            }
            //echo "<pre>";            print_r($taxFare); die;
        }
        $taxFareDetails = $this->CommonModel->getUserTaxDetail($login_id, $masterBookType, '');
        //$taxFareDetails
        //echo '<pre>';print_r($taxFareDetails);die();
        //echo '<pre>';print_r($taxFare[0]);die();
        if (!empty($taxFare)) {
            $form->setData($taxFare);
            $taxFareId = $taxFare['id'];
        } else {
            $taxFareId = 0;
        }

        $fareSetting = $this->CommonModel->getFareSettingDetail($login_id);
        //echo '<pre>';print_r($fareSetting);die();
        if (!empty($fareSetting)) {
            $fareSettingId = $fareSetting['id'];
        } else {
            $fareSettingId = 0;
        }

        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            $form->setData($postdata);
            if ($postdata['tax_save'] == 'Save & Next') {
                $form->getInputFilter()->get('booking_type')->setRequired(false);
                $form->getInputFilter()->get('sgst')->setRequired(false);
                $form->getInputFilter()->get('cgst')->setRequired(false);
                $form->getInputFilter()->get('igst')->setRequired(false);
                $form->getInputFilter()->get('tax_date_from')->setRequired(false);
                $form->getInputFilter()->get('tax_date_to')->setRequired(false);
            }
            if ($form->isValid()) {

                if ($postdata['tax_save'] == 'Save') {
                    $addBasicFare = [
                        'user_id' => $login_id,
                        'master_booking_type_id' => $masterBookType,
                        'booking_type' => $postdata['booking_type'],
                        'from_date' => date('Y-m-d', strtotime($postdata['tax_date_from'])),
                        'to_date' => date('Y-m-d', strtotime($postdata['tax_date_to'])),
                        'tax_type' => '%',
                        'sgst' => $postdata['sgst'],
                        'cgst' => $postdata['cgst'],
                        'igst' => $postdata['igst'],
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'status' => 1,
                        //'auto_id' => $taxFareId
                        'auto_id' => $postdata['tax_fare_id']
                    ];
                    //echo '<pre>';print_r($addBasicFare);die();

                    if ($postdata['tax_fare_id'] > 0) {
                        $addBasicFare['modified_by'] = $login_id;
                        $resp = $this->CommonModel->updatetUserTaxDetail($addBasicFare);
                        $msg = $resp['message'];
                    } else if (isset($postdata['tax_save']) && ($postdata['tax_save'] == 'Save')) {
                        $addBasicFare['created_by'] = $login_id;
                        $resp = $this->CommonModel->addUserTaxDetail($addBasicFare);
                        $msg = "Data Insert Successfully";
                    }
                    $this->redirect()->toRoute('setting', ['action' => 'attractiontax']);
                } else {

                    $basicfareSettings = [
                        'user_id' => $login_id,
                        'rounding' => $postdata['rounding'],
                        'level' => $postdata['level'],
                        'direction' => $postdata['direction'],
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'status' => 1,
                        'auto_id' => $fareSettingId
                    ];
                    //echo '<pre>';print_r($basicfareSettings);die();
                    if ($fareSettingId > 0) {
                        $basicfareSettings['modified_by'] = $login_id;
                        $resp = $this->CommonModel->updateUserFareSettingDetail($basicfareSettings);
                        $msg = $resp['message'];
                    } else {
                        $basicfareSettings['created_by'] = $login_id;
                        $resp = $this->CommonModel->addUserFareSettingDetail($basicfareSettings);
                        $msg = "Data Insert Successfully";
                    }
                    //$this->redirect()->toRoute('setting', ['action' => 'add-fees-fare']);
                    $this->redirect()->toRoute('setting', ['action' => 'attractiontax']);
                }
                //echo '<pre>';print_r($resp);die();
                //$this->redirect()->toRoute('setting', ['action' => 'index']);
                $this->flashMessenger()->addMessage(array('success' => $msg));
            } else {
                //$sm = $form->getMessages();
                //echo '<pre>';print_r($sm);die();
            }
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'tax-detail', 'taxFare' => $taxFare, 'taxFareDetails' => $taxFareDetails, 'fareSetting' => $fareSetting, 'bookingModule'=>$bookingModule]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : ADD THE GUIDE BASIC TAX FARE
     * @param $data
     * @returns $responsedata
     */
    
     public function guidetaxAction() {
        $taxFare = "";
        $taxFareDetails = "";
        $bookingModule = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        //$user_id = 6;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->guide;
        //UserAddBasicForm::$booking_module = $this->CommonModel->getBookingModuleList();     
       UserAddBasicForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddBasicForm();
        //$login_id = '1111';
        if (!empty($id)) {
            $taxFare = $this->CommonModel->getUserTaxDetail($login_id, $masterBookType, $id);
            $taxFare = $taxFare[0];
            $bookingModule = $this->fetchBookingModule($taxFare['booking_type']);
            
            $stateList = $this->getPackageListArray($bookingModule);
            if (!empty($stateList['data'])) {
                foreach ($stateList['data'] as $val) {
                    $list[$val['id']] = $val['name'];
                }
                $form->get('booking_type')->setValueOptions($list);
                $form->get('booking_type')->setValue($taxFare['booking_type']);
            }
            //echo "<pre>";            print_r($taxFare); die;
        }
        $taxFareDetails = $this->CommonModel->getUserTaxDetail($login_id, $masterBookType, '');
        //$taxFareDetails
        //echo '<pre>';print_r($taxFareDetails);die();
        //echo '<pre>';print_r($taxFare[0]);die();
        if (!empty($taxFare)) {
            $form->setData($taxFare);
            $taxFareId = $taxFare['id'];
        } else {
            $taxFareId = 0;
        }

        $fareSetting = $this->CommonModel->getFareSettingDetail($login_id);
        //echo '<pre>';print_r($fareSetting);die();
        if (!empty($fareSetting)) {
            $fareSettingId = $fareSetting['id'];
        } else {
            $fareSettingId = 0;
        }

        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            $form->setData($postdata);
            if ($postdata['tax_save'] == 'Save & Next') {
                $form->getInputFilter()->get('booking_type')->setRequired(false);
                $form->getInputFilter()->get('sgst')->setRequired(false);
                $form->getInputFilter()->get('cgst')->setRequired(false);
                $form->getInputFilter()->get('igst')->setRequired(false);
                $form->getInputFilter()->get('tax_date_from')->setRequired(false);
                $form->getInputFilter()->get('tax_date_to')->setRequired(false);
            }
            if ($form->isValid()) {

                if ($postdata['tax_save'] == 'Save') {
                    $addBasicFare = [
                        'user_id' => $login_id,
                        'master_booking_type_id' => $masterBookType,
                        'booking_type' => $postdata['booking_type'],
                        'from_date' => date('Y-m-d', strtotime($postdata['tax_date_from'])),
                        'to_date' => date('Y-m-d', strtotime($postdata['tax_date_to'])),
                        'tax_type' => '%',
                        'sgst' => $postdata['sgst'],
                        'cgst' => $postdata['cgst'],
                        'igst' => $postdata['igst'],
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'status' => 1,
                        //'auto_id' => $taxFareId
                        'auto_id' => $postdata['tax_fare_id']
                    ];
                    //echo '<pre>';print_r($addBasicFare);die();

                    if ($postdata['tax_fare_id'] > 0) {
                        $addBasicFare['modified_by'] = $login_id;
                        $resp = $this->CommonModel->updatetUserTaxDetail($addBasicFare);
                        $msg = $resp['message'];
                    } else if (isset($postdata['tax_save']) && ($postdata['tax_save'] == 'Save')) {
                        $addBasicFare['created_by'] = $login_id;
                        $resp = $this->CommonModel->addUserTaxDetail($addBasicFare);
                        $msg = "Data Insert Successfully";
                    }
                    $this->redirect()->toRoute('setting', ['action' => 'guidetax']);
                } else {

                    $basicfareSettings = [
                        'user_id' => $login_id,
                        'rounding' => $postdata['rounding'],
                        'level' => $postdata['level'],
                        'direction' => $postdata['direction'],
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'status' => 1,
                        'auto_id' => $fareSettingId
                    ];
                    //echo '<pre>';print_r($basicfareSettings);die();
                    if ($fareSettingId > 0) {
                        $basicfareSettings['modified_by'] = $login_id;
                        $resp = $this->CommonModel->updateUserFareSettingDetail($basicfareSettings);
                        $msg = $resp['message'];
                    } else {
                        $basicfareSettings['created_by'] = $login_id;
                        $resp = $this->CommonModel->addUserFareSettingDetail($basicfareSettings);
                        $msg = "Data Insert Successfully";
                    }
                    //$this->redirect()->toRoute('setting', ['action' => 'add-fees-fare']);
                    $this->redirect()->toRoute('setting', ['action' => 'guidetax']);
                }
                //echo '<pre>';print_r($resp);die();
                //$this->redirect()->toRoute('setting', ['action' => 'index']);
                $this->flashMessenger()->addMessage(array('success' => $msg));
            } else {
                //$sm = $form->getMessages();
                //echo '<pre>';print_r($sm);die();
            }
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'tax-detail', 'taxFare' => $taxFare, 'taxFareDetails' => $taxFareDetails, 'fareSetting' => $fareSetting, 'bookingModule'=>$bookingModule]);
        return $viewModel;
    }
    
    
    
     public function addPricePremiumAction() {
        $night_charge ="";
        $nightFareDetails= "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        //$user_id = 6;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->cab;
        UserAddPricePremiumForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddPricePremiumForm();
        
        if(!empty($id)) {
            $night_charge = $this->CommonModel->getUserNightFare($login_id, $id);
            $night_charge = $night_charge[0];
        }
        $nightFareDetails = $this->CommonModel->getUserNightFare($login_id, '');
        //$night_charge = $this->CommonModel->getUserNightFare($login_id);
        $premiums_charge = $this->CommonModel->getUserPremiumsFare($login_id);
        $peak_time_fare = $this->CommonModel->getUserPeakTimeCharge($login_id);
        $extras_fare = $this->CommonModel->getUserExtraCharge($login_id);
        $fareDetails = [
            'night_charge' => $night_charge,
            'premiums_charge' => $premiums_charge,
            'peak_time_fare' => $peak_time_fare,
            'extras_fare' => $extras_fare
        ];

        if ($request->isPost()) {
            $postdata = $request->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            $form->setData($postdata);
            $nightFareId = $postdata['night_premium_id'];
            $premiumsFareId = $postdata['premiums_id'];

            /// Night Fare STARTS HERE ///////////
            
            if($postdata['premium_fare_btn'] == 'Save') {
            $nightFare = [
                'user_id' => $login_id,
                'from_date' => date('Y-m-d', strtotime($postdata['night_fare_date_from'])),
                'to_date' => date('Y-m-d', strtotime($postdata['night_fare_date_to'])),
                'night_rate_begins' => $postdata['night_rate_begins'],
                'night_rate_ends' => $postdata['night_rate_ends'],
                'night_rate_type' => $postdata['night_rate_type'],
                'night_rate_value' => $postdata['night_rate_value'],
                'ip' => $_SERVER['REMOTE_ADDR'],
                'status' => 1,
                'auto_id' => $nightFareId,
                'booking_type' => $postdata['booking_type']
            ];

            if ($nightFareId > 0) {
                $nightFare['modified_by'] = $login_id;
                $resp = $this->CommonModel->updateUserNightFareDetail($nightFare);
                $msg = $resp['message'];
            } else if (isset($postdata['premium_fare_btn']) && ($postdata['premium_fare_btn'] == 'Save') && ($postdata['booking_type']!="")) {
                $nightFare['created_by'] = $login_id;
                $resp = $this->CommonModel->addUserNightFareDetail($nightFare);
                $msg = "Data Insert Successfully";
            }
            
            $this->redirect()->toRoute('setting', ['action' => 'add-price-premium']);
            
            }else{
            /// Premiums Fare STARTS HERE ///////////

            $premiumsFare = [
                'user_id' => $login_id,
                'from_date' => date('Y-m-d', strtotime($postdata['premium_fare_date_from'])),
                'to_date' => date('Y-m-d', strtotime($postdata['premium_fare_date_to'])),
                'premiums_type' => $postdata['premiums_type'],
                'premiums_value' => $postdata['premiums_value'],
                'ip' => $_SERVER['REMOTE_ADDR'],
                'status' => 1,
                'auto_id' => $premiumsFareId,
                'booking_type' => $postdata['booking_type']
            ];

            if ($premiumsFareId > 0) {
                $premiumsFare['modified_by'] = $login_id;
                $resp = $this->CommonModel->updateUserPremiumFareDetail($premiumsFare);
                $msg = $resp['message'];
            } else {
                $premiumsFare['created_by'] = $login_id;
                $resp = $this->CommonModel->addUserPremiumFareDetail($premiumsFare);
                $msg = "Data Insert Successfully";
            }


            $peakStartTimeArr = array_values(array_filter($postdata['start_time']));
            $peakEndTime = array_values(array_filter($postdata['end_time']));
            $peakTimeValue = array_values(array_filter($postdata['peaktime_value']));

            if (!empty($peakStartTimeArr) && !empty($peakEndTime)) {
                if (count($peakStartTimeArr) > 0) {
                    for ($i = 0; $i < count($peakStartTimeArr); $i++) {
                        $peakTimeArr[] = [
                            'user_id' => $login_id,
                            'start_time' => $peakStartTimeArr[$i],
                            'end_time' => $peakEndTime[$i],
                            'peaktime_value' => $peakTimeValue[$i],
                            'peaktime_type' => '%',
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                        ];
                    }
                }
            }
            $peakTimeArr1['data'] = $peakTimeArr;
            $peakTimeArr1['user_id'] = $login_id;
            //echo '<pre>';print_r($peakTimeArr1);//die();
            $resp = $this->CommonModel->addUserPeakTimeChargeDetail($peakTimeArr1);


            $extra_value_1 = array_values(array_filter($postdata['extras_no_name1']));
            $extra_value_2 = array_values(array_filter($postdata['extras_no_name2']));
            //$extraValueType    = array_values(array_filter($postdata['extrasvaluetype']));

            if (!empty($extra_value_1) && !empty($extra_value_2)) {
                if (count($extra_value_1) > 0) {
                    for ($i = 0; $i < count($extra_value_1); $i++) {
                        $extrasArr[] = [
                            'user_id' => $login_id,
                            'extras_master_id' => $extra_value_1[$i],
                            'extra_value_type' => 'Rs',
                            'extra_value' => $extra_value_2[$i],
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                        ];
                    }
                }
            }
            $extrasArr1['data'] = $extrasArr;
            $extrasArr1['user_id'] = $login_id;
            // echo '<pre>';print_r($extrasArr1);die();
            $resp1 = $this->CommonModel->addUserExtraChargeDetail($extrasArr1);
            $this->redirect()->toRoute('setting', ['action' => 'add-price-fixed-routes']);
            }
            
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'premium', 'fareDetails' => $fareDetails, 'nightFareDetails' => $nightFareDetails,]);
        return $viewModel;
    }
    
    public function addPriceShareAction() {
        $share_fare = "";
        $shareFareDetails= "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        //$user_id = 6;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->cab;
        UserAddShareForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddShareForm();
        
        if(!empty($id)) {
            $share_fare = $this->CommonModel->getUserSharePrice($login_id, $id);
            //$share_fare = $share_fare[0];
        }
        $shareFareDetails = $this->CommonModel->getUserSharePrice($login_id, '');
        $fareDetails = [
            'share_fare' => $share_fare
        ];

        if ($request->isPost()) {
            $postdata = $request->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            $form->setData($postdata);
            $compShareId = $postdata['comp_share_id'];
            //$partnerShareId = $postdata['partner_share_id'];
            //$driverShareId = $postdata['driver_share_id'];
            $msg = "Share Details Insert Successfully";
            if ($compShareId > 0) {
                $msg = "Share Details Updated Successfully";
            }
            //Debug::dump($postdata); exit;

            if ($form->isValid()) {
                
                /* Comp Starts Here */                
                $share = [
                    'user_id' => $login_id,
                    'company_share_type' => $postdata['company_share_type'],
                    'company_share_value' => $postdata['company_share'],
                    'partner_share_type' => $postdata['partner_share_type'],
                    'partner_share_value' => $postdata['partner_share'],
                    'driver_share_type' => $postdata['driver_share_type'],
                    'driver_share_value' => $postdata['driver_share'],
                    'status' => 1,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'booking_type' => $postdata['booking_type'],
                    'auto_id' => $compShareId
                ];
                //echo '<pre>';print_r($share);die();
                
                if ($compShareId > 0) {
                    $share['modified_by'] = $login_id;
                    $resp = $this->CommonModel->updateUserShareDetail($share);
                } else {
                    $share['created_by'] = $login_id;
                    $msg = "Share Details Added Successfully";
                    $resp = $this->CommonModel->addUserShareDetail($share);
                }
               
                $this->redirect()->toRoute('setting', ['action' => 'add-price-share']);
                $this->flashMessenger()->addMessage(array('success' => $msg));
            }
        }
        $viewModel = new ViewModel(['form' => $form, 'tab' => 'share', 'fareDetails' => $fareDetails, 'shareFareDetails'=>$shareFareDetails]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : ADD THE CAB CANCEL FEES FARE
     * @param $data
     * @returns $responsedata
     */

    public function addFeesFareAction() {
        $cancellation_fare = "";
        $feesFareDetails = "";
        $bookingModule = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->cab;
        //UserAddCancellationFeesForm::$booking_module = $this->CommonModel->getBookingModuleList();
        UserAddCancellationFeesForm::$cancellation_type = $this->CommonModel->getCancellationTypeList();
        UserAddCancellationFeesForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddCancellationFeesForm();
        
        if(!empty($id)){
            $cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id, $masterBookType, $id);
            $bookingModule = $this->fetchBookingModule($cancellation_fare[0]['booking_type']);
            
            $stateList = $this->getPackageListArray($bookingModule);
            if (!empty($stateList['data'])) {
                foreach ($stateList['data'] as $val) {
                    $list[$val['id']] = $val['name'];
                }
                $form->get('booking_type')->setValueOptions($list);
                $form->get('booking_type')->setValue($cancellation_fare[0]['booking_type']);
            }
        }
        
        $feesFareDetails = $this->CommonModel->getUserCancellationFare($login_id, $masterBookType, '');        
        //$cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id);
        $fareDetails = [
            'cancellation_fare' => $cancellation_fare,
        ];
        //$user_id = 6;
        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            //$cancellation_fees_autoid = $postdata['cancellation_fees_id'];          

            $cancellation_master_id = array_values(array_filter($postdata['cancellation_master_id']));
            $cancellation_type = array_values(array_filter($postdata['cancellation_type']));
            $cancellation_fees = array_values(array_filter($postdata['cancellation_fees']));
            
            if (!empty($cancellation_master_id) && !empty($cancellation_type)) {
                if (count($cancellation_master_id) > 0) {
                    for ($i = 0; $i < count($cancellation_master_id); $i++) {
                        $cancelFeesArr[] = [
                            'user_id' => $login_id,
                            'cancellation_master_id' => $cancellation_master_id[$i],
                            'cancellation_type' => $cancellation_type[$i],
                            'cancellation_value' => $cancellation_fees[$i],
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                            'master_booking_type_id' => $masterBookType
                        ];
                    }
                }
            }
            $cancelFeesArr1['cancelfaredata'] = $cancelFeesArr;
            $cancelFeesArr1['user_id'] = $login_id;
            $cancelFeesArr1['booking_type'] = $postdata['booking_type'];
            $cancelFeesArr1['master_booking_type_id'] = $masterBookType;

            //echo '<pre>';print_r($cancelFeesArr1);die();
            $resp = $this->CommonModel->addUserCancellationFareDetail($cancelFeesArr1);
            
            //$this->redirect()->toRoute('setting', ['action' => 'add-waiting-fees-fare']);
            $this->redirect()->toRoute('setting', ['action' => 'add-fees-fare']);
            $msg = "Data Updated Successfully";
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'cancel_fees', 'fareDetails' => $fareDetails , 'feesFareDetails'=>$feesFareDetails, 'bookingModule'=>$bookingModule]);
        return $viewModel;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : ADD THE CAB CANCEL FEES FARE
     * @param $data
     * @returns $responsedata
     */

    public function addDriverFeesFareAction() {
        $cancellation_fare = "";
        $feesFareDetails = "";
        $bookingModule = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->cab;
        //UserAddCancellationFeesForm::$booking_module = $this->CommonModel->getBookingModuleList();
        UserAddCancellationFeesForm::$cancellation_type = $this->CommonModel->getCancellationTypeList();
        UserAddCancellationFeesForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddCancellationFeesForm();
        
        if(!empty($id)){
            $cancellation_fare = $this->CommonModel->getDriverCancellationFare($login_id, $masterBookType, $id);
            $bookingModule = $this->fetchBookingModule($cancellation_fare[0]['booking_type']);
            
            $stateList = $this->getPackageListArray($bookingModule);
            if (!empty($stateList['data'])) {
                foreach ($stateList['data'] as $val) {
                    $list[$val['id']] = $val['name'];
                }
                $form->get('booking_type')->setValueOptions($list);
                $form->get('booking_type')->setValue($cancellation_fare[0]['booking_type']);
            }
        }
        
        $feesFareDetails = $this->CommonModel->getDriverCancellationFare($login_id, $masterBookType, '');        
        //$cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id);
        $fareDetails = [
            'cancellation_fare' => $cancellation_fare,
        ];
        //$user_id = 6;
        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            //$cancellation_fees_autoid = $postdata['cancellation_fees_id'];          

            $cancellation_master_id = array_values(array_filter($postdata['cancellation_master_id']));
            $cancellation_type = array_values(array_filter($postdata['cancellation_type']));
            $cancellation_fees = array_values(array_filter($postdata['cancellation_fees']));
            
            if (!empty($cancellation_master_id) && !empty($cancellation_type)) {
                if (count($cancellation_master_id) > 0) {
                    for ($i = 0; $i < count($cancellation_master_id); $i++) {
                        $cancelFeesArr[] = [
                            'user_id' => $login_id,
                            'cancellation_master_id' => $cancellation_master_id[$i],
                            'cancellation_type' => $cancellation_type[$i],
                            'cancellation_value' => $cancellation_fees[$i],
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                            'master_booking_type_id' => $masterBookType
                        ];
                    }
                }
            }
            $cancelFeesArr1['cancelfaredata'] = $cancelFeesArr;
            $cancelFeesArr1['user_id'] = $login_id;
            $cancelFeesArr1['booking_type'] = $postdata['booking_type'];
            $cancelFeesArr1['master_booking_type_id'] = $masterBookType;

            //echo '<pre>';print_r($cancelFeesArr1);die();
            $resp = $this->CommonModel->addDriverCancellationFareDetail($cancelFeesArr1);
            
            //$this->redirect()->toRoute('setting', ['action' => 'add-waiting-fees-fare']);
            $this->redirect()->toRoute('setting', ['action' => 'add-driver-fees-fare']);
            $msg = "Data Updated Successfully";
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'cancel_fees', 'fareDetails' => $fareDetails , 'feesFareDetails'=>$feesFareDetails, 'bookingModule'=>$bookingModule]);
        return $viewModel;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : ADD THE PACKAGE CANCEL FEES FARE
     * @param $data
     * @returns $responsedata
     */
    
    public function addPackageFeesAction() {
        $cancellation_fare = "";
        $feesFareDetails = "";
        $bookingModule = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->package;
        //UserAddCancellationFeesForm::$booking_module = $this->CommonModel->getBookingModuleList();
        UserAddCancellationFeesForm::$cancellation_type = $this->CommonModel->getCancellationTypeList();
        UserAddCancellationFeesForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddCancellationFeesForm();
        
        if(!empty($id)){
            $cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id, $masterBookType, $id);
            $bookingModule = $this->fetchBookingModule($cancellation_fare[0]['booking_type']);
            
            $stateList = $this->getPackageListArray($bookingModule);
            if (!empty($stateList['data'])) {
                foreach ($stateList['data'] as $val) {
                    $list[$val['id']] = $val['name'];
                }
                $form->get('booking_type')->setValueOptions($list);
                $form->get('booking_type')->setValue($cancellation_fare[0]['booking_type']);
            }
        }
        
        $feesFareDetails = $this->CommonModel->getUserCancellationFare($login_id, $masterBookType, '');        
        //$cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id);
        $fareDetails = [
            'cancellation_fare' => $cancellation_fare,
        ];
        //$user_id = 6;
        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            //$cancellation_fees_autoid = $postdata['cancellation_fees_id'];          

            $cancellation_master_id = array_values(array_filter($postdata['cancellation_master_id']));
            $cancellation_type = array_values(array_filter($postdata['cancellation_type']));
            $cancellation_fees = array_values(array_filter($postdata['cancellation_fees']));
            
            if (!empty($cancellation_master_id) && !empty($cancellation_type)) {
                if (count($cancellation_master_id) > 0) {
                    for ($i = 0; $i < count($cancellation_master_id); $i++) {
                        $cancelFeesArr[] = [
                            'user_id' => $login_id,
                            'cancellation_master_id' => $cancellation_master_id[$i],
                            'cancellation_type' => $cancellation_type[$i],
                            'cancellation_value' => $cancellation_fees[$i],
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                            'master_booking_type_id' => $masterBookType
                        ];
                    }
                }
            }
            $cancelFeesArr1['cancelfaredata'] = $cancelFeesArr;
            $cancelFeesArr1['user_id'] = $login_id;
            $cancelFeesArr1['booking_type'] = $postdata['booking_type'];
            $cancelFeesArr1['master_booking_type_id'] = $masterBookType;

            //echo '<pre>';print_r($cancelFeesArr1);die();
            $resp = $this->CommonModel->addUserCancellationFareDetail($cancelFeesArr1);
            
            //$this->redirect()->toRoute('setting', ['action' => 'add-waiting-fees-fare']);
            $this->redirect()->toRoute('setting', ['action' => 'add-package-fees']);
            $msg = "Data Updated Successfully";
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'cancel_fees', 'fareDetails' => $fareDetails , 'feesFareDetails'=>$feesFareDetails, 'bookingModule'=>$bookingModule]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : ADD THE HOTEL CANCEL FEES FARE
     * @param $data
     * @returns $responsedata
     */
    
    public function addHotelFeesAction() {
        $cancellation_fare = "";
        $feesFareDetails = "";
        $bookingModule = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->hotel;
        //UserAddCancellationFeesForm::$booking_module = $this->CommonModel->getBookingModuleList();
        UserAddCancellationFeesForm::$cancellation_type = $this->CommonModel->getCancellationTypeList();
        UserAddCancellationFeesForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddCancellationFeesForm();
        
        if(!empty($id)){
            $cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id, $masterBookType, $id);
            $bookingModule = $this->fetchBookingModule($cancellation_fare[0]['booking_type']);
            
            $stateList = $this->getPackageListArray($bookingModule);
            if (!empty($stateList['data'])) {
                foreach ($stateList['data'] as $val) {
                    $list[$val['id']] = $val['name'];
                }
                $form->get('booking_type')->setValueOptions($list);
                $form->get('booking_type')->setValue($cancellation_fare[0]['booking_type']);
            }
        }
        
        $feesFareDetails = $this->CommonModel->getUserCancellationFare($login_id, $masterBookType, '');        
        //$cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id);
        $fareDetails = [
            'cancellation_fare' => $cancellation_fare,
        ];
        //$user_id = 6;
        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            //$cancellation_fees_autoid = $postdata['cancellation_fees_id'];          

            $cancellation_master_id = array_values(array_filter($postdata['cancellation_master_id']));
            $cancellation_type = array_values(array_filter($postdata['cancellation_type']));
            $cancellation_fees = array_values(array_filter($postdata['cancellation_fees']));
            
            if (!empty($cancellation_master_id) && !empty($cancellation_type)) {
                if (count($cancellation_master_id) > 0) {
                    for ($i = 0; $i < count($cancellation_master_id); $i++) {
                        $cancelFeesArr[] = [
                            'user_id' => $login_id,
                            'cancellation_master_id' => $cancellation_master_id[$i],
                            'cancellation_type' => $cancellation_type[$i],
                            'cancellation_value' => $cancellation_fees[$i],
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                            'master_booking_type_id' => $masterBookType
                        ];
                    }
                }
            }
            $cancelFeesArr1['cancelfaredata'] = $cancelFeesArr;
            $cancelFeesArr1['user_id'] = $login_id;
            $cancelFeesArr1['booking_type'] = $postdata['booking_type'];
            $cancelFeesArr1['master_booking_type_id'] = $masterBookType;

            //echo '<pre>';print_r($cancelFeesArr1);die();
            $resp = $this->CommonModel->addUserCancellationFareDetail($cancelFeesArr1);
            
            //$this->redirect()->toRoute('setting', ['action' => 'add-waiting-fees-fare']);
            $this->redirect()->toRoute('setting', ['action' => 'add-hotel-fees']);
            $msg = "Data Updated Successfully";
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'cancel_fees', 'fareDetails' => $fareDetails , 'feesFareDetails'=>$feesFareDetails, 'bookingModule'=>$bookingModule]);
        return $viewModel;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : ADD THE CRUISE CANCEL FEES FARE
     * @param $data
     * @returns $responsedata
     */
    
    public function addCruiseFeesAction() {
        $cancellation_fare = "";
        $feesFareDetails = "";
        $bookingModule = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->cruise;
        //UserAddCancellationFeesForm::$booking_module = $this->CommonModel->getBookingModuleList();
        UserAddCancellationFeesForm::$cancellation_type = $this->CommonModel->getCancellationTypeList();
        UserAddCancellationFeesForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddCancellationFeesForm();
        
        if(!empty($id)){
            $cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id, $masterBookType, $id);
            $bookingModule = $this->fetchBookingModule($cancellation_fare[0]['booking_type']);
            
            $stateList = $this->getPackageListArray($bookingModule);
            if (!empty($stateList['data'])) {
                foreach ($stateList['data'] as $val) {
                    $list[$val['id']] = $val['name'];
                }
                $form->get('booking_type')->setValueOptions($list);
                $form->get('booking_type')->setValue($cancellation_fare[0]['booking_type']);
            }
        }
        
        $feesFareDetails = $this->CommonModel->getUserCancellationFare($login_id, $masterBookType, '');        
        //$cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id);
        $fareDetails = [
            'cancellation_fare' => $cancellation_fare,
        ];
        //$user_id = 6;
        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            //$cancellation_fees_autoid = $postdata['cancellation_fees_id'];          

            $cancellation_master_id = array_values(array_filter($postdata['cancellation_master_id']));
            $cancellation_type = array_values(array_filter($postdata['cancellation_type']));
            $cancellation_fees = array_values(array_filter($postdata['cancellation_fees']));
            
            if (!empty($cancellation_master_id) && !empty($cancellation_type)) {
                if (count($cancellation_master_id) > 0) {
                    for ($i = 0; $i < count($cancellation_master_id); $i++) {
                        $cancelFeesArr[] = [
                            'user_id' => $login_id,
                            'cancellation_master_id' => $cancellation_master_id[$i],
                            'cancellation_type' => $cancellation_type[$i],
                            'cancellation_value' => $cancellation_fees[$i],
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                            'master_booking_type_id' => $masterBookType
                        ];
                    }
                }
            }
            $cancelFeesArr1['cancelfaredata'] = $cancelFeesArr;
            $cancelFeesArr1['user_id'] = $login_id;
            $cancelFeesArr1['booking_type'] = $postdata['booking_type'];
            $cancelFeesArr1['master_booking_type_id'] = $masterBookType;

            //echo '<pre>';print_r($cancelFeesArr1);die();
            $resp = $this->CommonModel->addUserCancellationFareDetail($cancelFeesArr1);
            
            //$this->redirect()->toRoute('setting', ['action' => 'add-waiting-fees-fare']);
            $this->redirect()->toRoute('setting', ['action' => 'add-cruise-fees']);
            $msg = "Data Updated Successfully";
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'cancel_fees', 'fareDetails' => $fareDetails , 'feesFareDetails'=>$feesFareDetails, 'bookingModule'=>$bookingModule]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : ADD THE FLIGHT CANCEL FEES FARE
     * @param $data
     * @returns $responsedata
     */
    
    public function addFlightFeesAction() {
        $cancellation_fare = "";
        $feesFareDetails = "";
        $bookingModule = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->flight;
        //UserAddCancellationFeesForm::$booking_module = $this->CommonModel->getBookingModuleList();
        UserAddCancellationFeesForm::$cancellation_type = $this->CommonModel->getCancellationTypeList();
        UserAddCancellationFeesForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddCancellationFeesForm();
        
        if(!empty($id)){
            $cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id, $masterBookType, $id);
            $bookingModule = $this->fetchBookingModule($cancellation_fare[0]['booking_type']);
            
            $stateList = $this->getPackageListArray($bookingModule);
            if (!empty($stateList['data'])) {
                foreach ($stateList['data'] as $val) {
                    $list[$val['id']] = $val['name'];
                }
                $form->get('booking_type')->setValueOptions($list);
                $form->get('booking_type')->setValue($cancellation_fare[0]['booking_type']);
            }
        }
        
        $feesFareDetails = $this->CommonModel->getUserCancellationFare($login_id, $masterBookType, '');        
        //$cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id);
        $fareDetails = [
            'cancellation_fare' => $cancellation_fare,
        ];
        //$user_id = 6;
        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            //$cancellation_fees_autoid = $postdata['cancellation_fees_id'];          

            $cancellation_master_id = array_values(array_filter($postdata['cancellation_master_id']));
            $cancellation_type = array_values(array_filter($postdata['cancellation_type']));
            $cancellation_fees = array_values(array_filter($postdata['cancellation_fees']));
            
            if (!empty($cancellation_master_id) && !empty($cancellation_type)) {
                if (count($cancellation_master_id) > 0) {
                    for ($i = 0; $i < count($cancellation_master_id); $i++) {
                        $cancelFeesArr[] = [
                            'user_id' => $login_id,
                            'cancellation_master_id' => $cancellation_master_id[$i],
                            'cancellation_type' => $cancellation_type[$i],
                            'cancellation_value' => $cancellation_fees[$i],
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                            'master_booking_type_id' => $masterBookType
                        ];
                    }
                }
            }
            $cancelFeesArr1['cancelfaredata'] = $cancelFeesArr;
            $cancelFeesArr1['user_id'] = $login_id;
            $cancelFeesArr1['booking_type'] = $postdata['booking_type'];
            $cancelFeesArr1['master_booking_type_id'] = $masterBookType;

            //echo '<pre>';print_r($cancelFeesArr1);die();
            $resp = $this->CommonModel->addUserCancellationFareDetail($cancelFeesArr1);
            
            //$this->redirect()->toRoute('setting', ['action' => 'add-waiting-fees-fare']);
            $this->redirect()->toRoute('setting', ['action' => 'add-flight-fees']);
            $msg = "Data Updated Successfully";
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'cancel_fees', 'fareDetails' => $fareDetails , 'feesFareDetails'=>$feesFareDetails, 'bookingModule'=>$bookingModule]);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : ADD THE BUS CANCEL FEES FARE
     * @param $data
     * @returns $responsedata
     */
    
    public function addBusFeesAction() {
        $cancellation_fare = "";
        $feesFareDetails = "";
        $bookingModule = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->bus;
        //UserAddCancellationFeesForm::$booking_module = $this->CommonModel->getBookingModuleList();
        UserAddCancellationFeesForm::$cancellation_type = $this->CommonModel->getCancellationTypeList();
        UserAddCancellationFeesForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddCancellationFeesForm();
        
        if(!empty($id)){
            $cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id, $masterBookType, $id);
            $bookingModule = $this->fetchBookingModule($cancellation_fare[0]['booking_type']);
            
            $stateList = $this->getPackageListArray($bookingModule);
            if (!empty($stateList['data'])) {
                foreach ($stateList['data'] as $val) {
                    $list[$val['id']] = $val['name'];
                }
                $form->get('booking_type')->setValueOptions($list);
                $form->get('booking_type')->setValue($cancellation_fare[0]['booking_type']);
            }
        }
        
        $feesFareDetails = $this->CommonModel->getUserCancellationFare($login_id, $masterBookType, '');        
        //$cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id);
        $fareDetails = [
            'cancellation_fare' => $cancellation_fare,
        ];
        //$user_id = 6;
        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            //$cancellation_fees_autoid = $postdata['cancellation_fees_id'];          

            $cancellation_master_id = array_values(array_filter($postdata['cancellation_master_id']));
            $cancellation_type = array_values(array_filter($postdata['cancellation_type']));
            $cancellation_fees = array_values(array_filter($postdata['cancellation_fees']));
            
            if (!empty($cancellation_master_id) && !empty($cancellation_type)) {
                if (count($cancellation_master_id) > 0) {
                    for ($i = 0; $i < count($cancellation_master_id); $i++) {
                        $cancelFeesArr[] = [
                            'user_id' => $login_id,
                            'cancellation_master_id' => $cancellation_master_id[$i],
                            'cancellation_type' => $cancellation_type[$i],
                            'cancellation_value' => $cancellation_fees[$i],
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                            'master_booking_type_id' => $masterBookType
                        ];
                    }
                }
            }
            $cancelFeesArr1['cancelfaredata'] = $cancelFeesArr;
            $cancelFeesArr1['user_id'] = $login_id;
            $cancelFeesArr1['booking_type'] = $postdata['booking_type'];
            $cancelFeesArr1['master_booking_type_id'] = $masterBookType;

            //echo '<pre>';print_r($cancelFeesArr1);die();
            $resp = $this->CommonModel->addUserCancellationFareDetail($cancelFeesArr1);
            
            //$this->redirect()->toRoute('setting', ['action' => 'add-waiting-fees-fare']);
            $this->redirect()->toRoute('setting', ['action' => 'add-bus-fees']);
            $msg = "Data Updated Successfully";
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'cancel_fees', 'fareDetails' => $fareDetails , 'feesFareDetails'=>$feesFareDetails, 'bookingModule'=>$bookingModule]);
        return $viewModel;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : ADD THE ATTRACTION CANCEL FEES FARE
     * @param $data
     * @returns $responsedata
     */
    
    public function addAttractionFeesAction() {
        $cancellation_fare = "";
        $feesFareDetails = "";
        $bookingModule = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->attractions;
        //UserAddCancellationFeesForm::$booking_module = $this->CommonModel->getBookingModuleList();
        UserAddCancellationFeesForm::$cancellation_type = $this->CommonModel->getCancellationTypeList();
        UserAddCancellationFeesForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddCancellationFeesForm();
        
        if(!empty($id)){
            $cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id, $masterBookType, $id);
            $bookingModule = $this->fetchBookingModule($cancellation_fare[0]['booking_type']);
            
            $stateList = $this->getPackageListArray($bookingModule);
            if (!empty($stateList['data'])) {
                foreach ($stateList['data'] as $val) {
                    $list[$val['id']] = $val['name'];
                }
                $form->get('booking_type')->setValueOptions($list);
                $form->get('booking_type')->setValue($cancellation_fare[0]['booking_type']);
            }
        }
        
        $feesFareDetails = $this->CommonModel->getUserCancellationFare($login_id, $masterBookType, '');        
        //$cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id);
        $fareDetails = [
            'cancellation_fare' => $cancellation_fare,
        ];
        //$user_id = 6;
        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            //$cancellation_fees_autoid = $postdata['cancellation_fees_id'];          

            $cancellation_master_id = array_values(array_filter($postdata['cancellation_master_id']));
            $cancellation_type = array_values(array_filter($postdata['cancellation_type']));
            $cancellation_fees = array_values(array_filter($postdata['cancellation_fees']));
            
            if (!empty($cancellation_master_id) && !empty($cancellation_type)) {
                if (count($cancellation_master_id) > 0) {
                    for ($i = 0; $i < count($cancellation_master_id); $i++) {
                        $cancelFeesArr[] = [
                            'user_id' => $login_id,
                            'cancellation_master_id' => $cancellation_master_id[$i],
                            'cancellation_type' => $cancellation_type[$i],
                            'cancellation_value' => $cancellation_fees[$i],
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                            'master_booking_type_id' => $masterBookType
                        ];
                    }
                }
            }
            $cancelFeesArr1['cancelfaredata'] = $cancelFeesArr;
            $cancelFeesArr1['user_id'] = $login_id;
            $cancelFeesArr1['booking_type'] = $postdata['booking_type'];
            $cancelFeesArr1['master_booking_type_id'] = $masterBookType;

            //echo '<pre>';print_r($cancelFeesArr1);die();
            $resp = $this->CommonModel->addUserCancellationFareDetail($cancelFeesArr1);
            
            //$this->redirect()->toRoute('setting', ['action' => 'add-waiting-fees-fare']);
            $this->redirect()->toRoute('setting', ['action' => 'add-attraction-fees']);
            $msg = "Data Updated Successfully";
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'cancel_fees', 'fareDetails' => $fareDetails , 'feesFareDetails'=>$feesFareDetails, 'bookingModule'=>$bookingModule]);
        return $viewModel;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : ADD THE GUIDE CANCEL FEES FARE
     * @param $data
     * @returns $responsedata
     */
    
    public function addGuideFeesAction() {
        $cancellation_fare = "";
        $feesFareDetails = "";
        $bookingModule = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->guide;
        //UserAddCancellationFeesForm::$booking_module = $this->CommonModel->getBookingModuleList();
        UserAddCancellationFeesForm::$cancellation_type = $this->CommonModel->getCancellationTypeList();
        UserAddCancellationFeesForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddCancellationFeesForm();
        
        if(!empty($id)){
            $cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id, $masterBookType, $id);
            $bookingModule = $this->fetchBookingModule($cancellation_fare[0]['booking_type']);
            
            $stateList = $this->getPackageListArray($bookingModule);
            if (!empty($stateList['data'])) {
                foreach ($stateList['data'] as $val) {
                    $list[$val['id']] = $val['name'];
                }
                $form->get('booking_type')->setValueOptions($list);
                $form->get('booking_type')->setValue($cancellation_fare[0]['booking_type']);
            }
        }
        
        $feesFareDetails = $this->CommonModel->getUserCancellationFare($login_id, $masterBookType, '');        
        //$cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id);
        $fareDetails = [
            'cancellation_fare' => $cancellation_fare,
        ];
        //$user_id = 6;
        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            //$cancellation_fees_autoid = $postdata['cancellation_fees_id'];          

            $cancellation_master_id = array_values(array_filter($postdata['cancellation_master_id']));
            $cancellation_type = array_values(array_filter($postdata['cancellation_type']));
            $cancellation_fees = array_values(array_filter($postdata['cancellation_fees']));
            
            if (!empty($cancellation_master_id) && !empty($cancellation_type)) {
                if (count($cancellation_master_id) > 0) {
                    for ($i = 0; $i < count($cancellation_master_id); $i++) {
                        $cancelFeesArr[] = [
                            'user_id' => $login_id,
                            'cancellation_master_id' => $cancellation_master_id[$i],
                            'cancellation_type' => $cancellation_type[$i],
                            'cancellation_value' => $cancellation_fees[$i],
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                            'master_booking_type_id' => $masterBookType
                        ];
                    }
                }
            }
            $cancelFeesArr1['cancelfaredata'] = $cancelFeesArr;
            $cancelFeesArr1['user_id'] = $login_id;
            $cancelFeesArr1['booking_type'] = $postdata['booking_type'];
            $cancelFeesArr1['master_booking_type_id'] = $masterBookType;

            //echo '<pre>';print_r($cancelFeesArr1);die();
            $resp = $this->CommonModel->addUserCancellationFareDetail($cancelFeesArr1);
            
            //$this->redirect()->toRoute('setting', ['action' => 'add-waiting-fees-fare']);
            $this->redirect()->toRoute('setting', ['action' => 'add-guide-fees']);
            $msg = "Data Updated Successfully";
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'cancel_fees', 'fareDetails' => $fareDetails , 'feesFareDetails'=>$feesFareDetails, 'bookingModule'=>$bookingModule]);
        return $viewModel;
    }
    
    public function addWaitingFeesFareAction() {
        $waiting_fare = "";
        $feesFareDetails = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->cab;
        UserAddCancellationFeesForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddCancellationFeesForm();
        
        if(!empty($id)){
            $waiting_fare = $this->CommonModel->getUserWaitingCharge($login_id, $id);
        }
        
        $feesFareDetails = $this->CommonModel->getUserWaitingCharge($login_id, '');        
        //$waiting_fare = $this->CommonModel->getUserWaitingCharge($login_id);
        $fareDetails = [
            'waiting_fare' => $waiting_fare,
        ];
        //$user_id = 6;
        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            
            /* Add Waiting Fees */

            $waiting_time_min_upto = array_values(array_filter($postdata['waiting_time_minutes_upto']));
            $waiting_time_fees = array_values(array_filter($postdata['waiting_time_fees']));

            if (!empty($waiting_time_min_upto) && !empty($waiting_time_fees)) {
                if (count($waiting_time_min_upto) > 0) {
                    for ($i = 0; $i < count($waiting_time_min_upto); $i++) {
                        $waitingFeesArr[] = [
                            'user_id' => $login_id,
                            'waiting_minute_upto' => $waiting_time_min_upto[$i],
                            'waiting_fees' => $waiting_time_fees[$i],
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type']
                        ];
                    }
                }
            }
            $waitingFeesArr1['waitingfaredata'] = $waitingFeesArr;
            $waitingFeesArr1['user_id'] = $login_id;
            $waitingFeesArr1['booking_type'] = $postdata['booking_type'];
            //echo '<pre>';print_r($waitingFeesArr1);die();
            $resp = $this->CommonModel->addUserWaitingChargeDetail($waitingFeesArr1);            
            $this->redirect()->toRoute('setting', ['action' => 'add-prewaiting-fees-fare']);
            $msg = "Data Updated Successfully";
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'waiting_fees', 'fareDetails' => $fareDetails, 'feesFareDetails'=>$feesFareDetails]);
        return $viewModel;
    }
    
    
    public function addPrewaitingFeesFareAction() {
        $pre_waiting_fare = "";
        $feesFareDetails = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->cab;
        UserAddCancellationFeesForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddCancellationFeesForm();
        
        if(!empty($id)){
            $pre_waiting_fare = $this->CommonModel->getUserPreWaitingCharge($login_id, $id);
        }
        
        $feesFareDetails = $this->CommonModel->getUserPreWaitingCharge($login_id, '');        
        $fareDetails = [
            'pre_waiting_fare' => $pre_waiting_fare,
        ];
        
        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();          

            /* Add Pre Waiting Fees */
            $pre_waiting_time_min_upto = array_values(array_filter($postdata['pre_waiting_minutes_upto']));
            $pre_waiting_time_fees = array_values(array_filter($postdata['pre_waiting_fee']));

            if (!empty($pre_waiting_time_min_upto) && !empty($pre_waiting_time_fees)) {
                if (count($pre_waiting_time_min_upto) > 0) {
                    for ($i = 0; $i < count($pre_waiting_time_min_upto); $i++) {
                        $prewaitingFeesArr[] = [
                            'user_id' => $login_id,
                            'pre_waiting_upto_minutes' => $pre_waiting_time_min_upto[$i],
                            'pre_waiting_fees' => $pre_waiting_time_fees[$i],
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type']
                        ];
                    }
                }
            }
            $prewaitingFeesArr1['prewaitingfaredata'] = $prewaitingFeesArr;
            $prewaitingFeesArr1['user_id'] = $login_id;
            $prewaitingFeesArr1['booking_type'] = $postdata['booking_type'];
            //\echo '<pre>';print_r($prewaitingFeesArr1);//die();
            $resp = $this->CommonModel->addUserPreWaitingChargeDetail($prewaitingFeesArr1);


            $this->redirect()->toRoute('setting', ['action' => 'add-price-premium']);
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'pre_waiting_fees', 'fareDetails' => $fareDetails, 'feesFareDetails'=>$feesFareDetails]);
        return $viewModel;
    }

   

    public function addPriceFixedRoutesAction() {
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        //$user_id = 6;

        $request = $this->getRequest();
        UserAddPriceFixedRoutesForm::$booking_type = $this->CommonModel->getPackageTypeList();
        $form = new UserAddPriceFixedRoutesForm();

        $fix_route = $this->CommonModel->getUserFixRoute($login_id);
        $postal_fare = $this->CommonModel->getUserPostalCode($login_id);
        $fareDetails = [
            'fix_route' => $fix_route,
            'postal_fare' => $postal_fare,
        ];

        if ($request->isPost()) {
            $postdata = $request->getPost()->toArray();
            $form->setData($postdata);
            $fix_route_autoid = $postdata['fix_route_id'];

            /// Fixed Route STARTS HERE ///////////

            $addFixedRoute = [
                'user_id' => $login_id,
                'frequent_location' => $postdata['frequent_location'],
                'booking_type' => $postdata['booking_type'],
                'ip' => $_SERVER['REMOTE_ADDR'],
                'status' => 1,
                'auto_id' => $fix_route_autoid
            ];

            //echo '<pre>';print_r($addFixedRoute);die();

            if ($fix_route_autoid > 0) {
                $addFixedRoute['modified_by'] = $login_id;
                $resp = $this->CommonModel->updateUserFixRouteDetail($addFixedRoute);
                $msg = $resp['message'];
            } else {
                $addFixedRoute['created_by'] = $login_id;
                $resp = $this->CommonModel->addUserFixRouteDetail($addFixedRoute);
                $msg = "Data Insert Successfully";
            }

            $pickup_postcode = array_values(array_filter($postdata['pickup_postcode']));
            $drop_off_postcode = array_values(array_filter($postdata['drop_off_postcode']));
            $value = array_values(array_filter($postdata['value']));

            if (!empty($pickup_postcode) && !empty($drop_off_postcode)) {
                if (count($pickup_postcode) > 0) {
                    for ($i = 0; $i < count($pickup_postcode); $i++) {
                        $postalFareArr[] = [
                            'user_id' => $login_id,
                            'pickup_postcode' => $pickup_postcode[$i],
                            'drop_postcode' => $drop_off_postcode[$i],
                            'price' => $value[$i],
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                        ];
                    }
                    //echo '<pre>';print_r($postalFareArr);//die();
                }
            }

            $postalFareArr1['postalcodedata'] = $postalFareArr;
            $postalFareArr1['user_id'] = $login_id;
            $resp = $this->CommonModel->addUserPostalCodeDetail($postalFareArr1);

            $this->redirect()->toRoute('setting', ['action' => 'add-price-share']);
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }


        $viewModel = new ViewModel(['form' => $form, 'tab' => 'fixed-routes', 'fareDetails' => $fareDetails]);
        return $viewModel;
    }   

    public function bookingTypeMappingAction() {
        $data = "";
        $status = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;

        BookingMappingForm::$booking_type = $this->CommonModel->getPackageTypeList();
        $form = new BookingMappingForm();
        $data = ['user_id' => $login_id];
        $mvehicleList = $this->CommonModel->getUserBookingTypeMappingDetail($data);
        $viewModel = new ViewModel(['form' => $form, 'mvehicleList' => $mvehicleList, 'status' => $status]);
        return $viewModel;
    }

    public function searchBookingMappingAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $val = $this->getRequest()->getPost();
        $data = [
            'booking_type' => $val['booking_type'],
            'user_id' => $user_id,
        ];
        //Call API...
        $mvehicleList = $this->CommonModel->getUserBookingTypeMappingDetail($data);
        $viewModel = new ViewModel(['mvehicleList' => $mvehicleList]);
        $viewModel->setTemplate('/dashboard/setting/mapping-type-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    /** Function to change VEHICLE TYPE STATUS */
    public function bookingTypeMappingStatusAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        //print_r($data); die;
        $id = implode(',', $data['selected']);
        $booking_type_status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'mapping_status' => $booking_type_status];
        $this->CommonModel->updateBookingTypeMappingStatus($data);
        $val = ['user_id' => $user_id];
        $mvehicleList = $this->CommonModel->getUserBookingTypeMappingDetail($val);
        $viewModel = new ViewModel(['mvehicleList' => $mvehicleList]);
        $viewModel->setTemplate('/dashboard/setting/mapping-type-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function addBookingTypeMappingAction() {
        $data = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        BookingMappingForm::$booking_type = $this->CommonModel->getPackageTypeList();
        BookingMappingForm::$booking_mode_type = $this->CommonModel->getPackageModeList();
        $form = new BookingMappingForm();
        $request = $this->getRequest();
        if ($request->isPost()) {
            $post = $request->getPost()->toArray();
            $form->setData($post);
            if ($form->isValid()) {
                //echo '<pre>';print_r($post);die();
                $data = [
                    'booking_type' => $post['booking_type'],
                    'booking_type_mode' => $post['booking_mode_type'],
                    'status' => $post['status'],
                    'user_id' => $user_id,
                    'created_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                //echo '<pre>';print_r($data);die();
                $insertStatus = $this->CommonModel->addUserMappingDetail($data);
                //echo '<pre>';print_r($insertStatus);die();
                if ($insertStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Mapping Details added successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'No Duplicate Entry Please....'));
                }
                $this->redirect()->toRoute('setting', ['action' => 'booking-type-mapping']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function editBookingTypeMappingAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        BookingMappingForm::$booking_type = $this->CommonModel->getPackageTypeList();
        BookingMappingForm::$booking_mode_type = $this->CommonModel->getPackageModeList();
        $form = new BookingMappingForm();
        $id = $this->params()->fromQuery('id');
        $data = [
            'auto_id' => $id,
            'user_id' => $user_id
        ];

        $vehicleData = $this->CommonModel->getUserBookingTypeMappingDetail($data);
        $vehicleData = $vehicleData[0];
        //Debug::dump($vehicleData); exit;
        $bookingType = isset($vehicleData['master_package_id']) ? $vehicleData['master_package_id'] : '';
        $bookingModeType = isset($vehicleData['master_package_mode_id']) ? $vehicleData['master_package_mode_id'] : '';
        $vehicleTypeStatus = $vehicleData['status'];
        $form->get('booking_type')->setValue($bookingType);
        $form->get('booking_mode_type')->setValue($bookingModeType);
        $form->get('vehicle_type_id')->setValue($vehicleData['id']);
        $form->setData($vehicleData);
        $request = $this->getRequest();
        if ($request->isPost()) {
            $post = $request->getPost()->toArray();
            $form->setData($post);
            if ($form->isValid()) {
                $data = [
                    'auto_id' => $post['vehicle_type_id'],
                    'booking_type' => $post['booking_type'],
                    'booking_type_mode' => $post['booking_mode_type'],
                    'status' => $post['status'],
                    'modified_by' => $user_id,
                    'user_id' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                //echo '<pre>';print_r($data);die();
                $insertStatus = $this->CommonModel->updateUserMappingDetail($data);
                if ($insertStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Mapping Details updated successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'No Duplicate Entry Please....'));
                }
                $this->redirect()->toRoute('setting', ['action' => 'booking-type-mapping']);
            }
        }


        $viewModel = new ViewModel(['form' => $form, 'vehicle_type_id' => $id, 'status' => $vehicleTypeStatus]);
        return $viewModel;
    }

    public function pointConversionAction() {
        $data = "";
        $status = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;

        PointConversionForm::$booking_type = $this->CommonModel->getPackageTypeList();
        PointConversionForm::$user_type = $this->CommonModel->getUserTypeList();
        PointConversionForm::$user_grade = $this->CommonModel->getUserTypeGradeList();
        $form = new PointConversionForm();
        $data = ['user_id' => $login_id];
        $mvehicleList = $this->CommonModel->getPointConversionDetail($data);
        $viewModel = new ViewModel(['form' => $form, 'mvehicleList' => $mvehicleList, 'status' => $status]);
        return $viewModel;
    }

    public function searchPointConversionAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $val = $this->getRequest()->getPost();
        $data = [
            'booking_type' => $val['booking_type'],
            'user_type' => $val['user_type'],
            'user_grade' => $val['user_grade'],
            'user_id' => $user_id,
            'status' => $val['status']
        ];
        //Call API...
        $mvehicleList = $this->CommonModel->getPointConversionDetail($data);
        $viewModel = new ViewModel(['mvehicleList' => $mvehicleList]);
        $viewModel->setTemplate('/dashboard/setting/point-conversion-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    /** Function to change VEHICLE TYPE STATUS */
    public function pointConversionStatusAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        //print_r($data); die;
        $id = implode(',', $data['selected']);
        $point_status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'status' => $point_status];
        $this->CommonModel->updatePointConversionStatus($data);
        $val = ['user_id' => $user_id];
        $mvehicleList = $this->CommonModel->getPointConversionDetail($val);
        $viewModel = new ViewModel(['mvehicleList' => $mvehicleList]);
        $viewModel->setTemplate('/dashboard/setting/point-conversion-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function addPointConversionAction() {
        $data = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        PointConversionForm::$booking_type = $this->CommonModel->getPackageTypeList();
        PointConversionForm::$user_type = $this->CommonModel->getUserTypeList();
        PointConversionForm::$user_grade = $this->CommonModel->getUserTypeGradeList();
        $form = new PointConversionForm();
        $request = $this->getRequest();
        if ($request->isPost()) {
            $post = $request->getPost()->toArray();
            $form->setData($post);
            if ($form->isValid()) {
                //echo '<pre>';print_r($post);die();
                $data = [
                    'booking_type' => $post['booking_type'],
                    'user_type' => $post['user_type'],
                    'user_grade' => $post['user_grade'],
                    'points' => $post['points'],
                    'conversion_rate' => $post['conversion_rate'],
                    'status' => $post['status'],
                    'created_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                //echo '<pre>';print_r($data);die();
                $insertStatus = $this->CommonModel->addpointconversiondetail($data);
                //echo '<pre>';print_r($insertStatus);die();
                if ($insertStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Details added successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'No Duplicate Entry Please....'));
                }
                $this->redirect()->toRoute('setting', ['action' => 'point-conversion']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function editPointConversionAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        PointConversionForm::$booking_type = $this->CommonModel->getPackageTypeList();
        PointConversionForm::$user_type = $this->CommonModel->getUserTypeList();
        PointConversionForm::$user_grade = $this->CommonModel->getUserTypeGradeList();
        $form = new PointConversionForm();
        $id = $this->params()->fromQuery('id');
        $data = [
            'auto_id' => $id
        ];

        $vehicleData = $this->CommonModel->getPointConversionDetail($data);
        $vehicleData = $vehicleData[0];
        //Debug::dump($vehicleData); exit;
        $bookingType = isset($vehicleData['master_package_id']) ? $vehicleData['master_package_id'] : '';
        $userType = isset($vehicleData['user_type_id']) ? $vehicleData['user_type_id'] : '';
        $userGrade = isset($vehicleData['user_grade_id']) ? $vehicleData['user_grade_id'] : '';
        $vehicleTypeStatus = $vehicleData['status'];
        $form->setData($vehicleData);
        $form->get('booking_type')->setValue($bookingType);
        $form->get('user_type')->setValue($userType);
        $form->get('user_grade')->setValue($userGrade);
        $form->get('vehicle_type_id')->setValue($vehicleData['id']);

        $request = $this->getRequest();
        if ($request->isPost()) {
            $post = $request->getPost()->toArray();
            $form->setData($post);
            if ($form->isValid()) {
                $data = [
                    'auto_id' => $post['vehicle_type_id'],
                    'booking_type' => $post['booking_type'],
                    'user_type' => $post['user_type'],
                    'user_grade' => $post['user_grade'],
                    'points' => $post['points'],
                    'conversion_rate' => $post['conversion_rate'],
                    'status' => $post['status'],
                    'modified_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                //echo '<pre>';print_r($data);die();
                $insertStatus = $this->CommonModel->updatepointconversiondetail($data);
                if ($insertStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Conversion Details updated successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'No Duplicate Entry Please....'));
                }
                $this->redirect()->toRoute('setting', ['action' => 'point-conversion']);
            }
        }


        $viewModel = new ViewModel(['form' => $form, 'vehicle_type_id' => $id, 'status' => $vehicleTypeStatus]);
        return $viewModel;
    }

    /**
     * Company Detail...
     * @return ViewModel
     */
    public function officeAction() {
        $msg = "";
        $msg_color = "";
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;

        $form = new ProfileCompanyDetailForm();
        $request = $this->getRequest();

        $url = $this->apiUrl() . "/company/companydetails?user_id=" . $userId;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);
        if ($JsonData['responsedata']['status'] == true) {
            $userDetails = $JsonData['responsedata'];
            $form->get('state_value')->setValue($userDetails['state']);
            $form->get('city_value')->setValue($userDetails['city']);
            $form->setData($userDetails);
        }

        if ($request->isPost()) {
            $postData = $this->getRequest()->getPost()->toArray();
            $form->setData($postData);
            if ($form->isValid()) {
                $finalData = [];
                $finalData = [
                    'company_name' => $postData['company_name'],
                    'company_address' => $postData['company_address'],
                    'state' => $postData['state_value'],
                    'city' => $postData['city_value'],
                    'service_tax_gst' => $postData['service_tax_gst'],
                    'pancard_no' => $postData['pancard_no'],
                    'contact_person_name' => $postData['contact_person_name'],
                    'landline_no' => $postData['landline_no'],
                    'mobile_no' => $postData['mobile_no'],
                    'email' => $postData['email'],
                    'website_url' => $postData['website_url'],
                    //'logo' => $postData['logo'],
                    'user_id' => $userId,
                    'country' => 101,
                    'pincode' => $postData['pincode'],
                    'id' => $userDetails['id']
                ];
                //print_r($finalData); exit;

                $url = $this->apiUrl() . "/company";
                $val = $this->put($url, $finalData);
                $JsonData = $val->getBody();
                $JsonData = Json::decode($JsonData, true);
                //print_r($JsonData); exit;

                if ((!empty($JsonData))) {
                    $msg = "Office Details Updated Successfully";
                    $msg_color = "green";
                } else {
                    $msg = "Office Details Not Updated";
                    $msg_color = "red";
                }
            }
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'company-details', 'msg' => $msg, 'msg_color' => $msg_color]);
        return $viewModel;
    }

    public function deleteTaxDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserTaxDetailStatus($data);
        $this->redirect()->toRoute('setting', ['action' => 'index']);
    }

    public function changeTaxDetailRecordStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateUserTaxDetailStatus($data);
        }
        $masterBookType= $this->config()->getConfig()->masterBookType->cab;
        $taxFareDetails = $this->CommonModel->getUserTaxDetail($user_id, $masterBookType, '');
        $viewModel = new ViewModel(['taxFareDetails' => $taxFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/basic-tax-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function deleteNightFareDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserNightFareDetailStatus($data);
        $msg = "Status Updated Successfully";
        $this->flashMessenger()->addMessage(array('success' => $msg));
        $this->redirect()->toRoute('setting', ['action' => 'add-price-premium']);
    }
    
    public function changeNightPremiumRecordStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateUserNightFareDetailStatus($data);
        }
        $nightFareDetails = $this->CommonModel->getUserNightFare($user_id, '');
        $viewModel = new ViewModel(['nightFareDetails' => $nightFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/night-fare-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function deleteCancelFeesDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserCancelFeesStatus($data);
        $msg = "Status Updated Successfully";
        $this->flashMessenger()->addMessage(array('success' => $msg));
        $this->redirect()->toRoute('setting', ['action' => 'add-fees-fare']);
    }
    
    public function deleteDriverCancelFeesDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateDriverCancelFeesStatus($data);
        $msg = "Status Updated Successfully";
        $this->flashMessenger()->addMessage(array('success' => $msg));
        $this->redirect()->toRoute('setting', ['action' => 'add-driver-fees-fare']);
    }
    
    public function changeCancelfeesStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateUserCancelFeesStatus($data);
        }
        $masterBookType= $this->config()->getConfig()->masterBookType->cab;
        $feesFareDetails = $this->CommonModel->getUserCancellationFare($user_id, $masterBookType, '');
        $viewModel = new ViewModel(['feesFareDetails' => $feesFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/fees-fare-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function changeDriverCancelfeesStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateDriverCancelFeesStatus($data);
        }
        $masterBookType= $this->config()->getConfig()->masterBookType->cab;
        $feesFareDetails = $this->CommonModel->getDriverCancellationFare($user_id, $masterBookType, '');
        $viewModel = new ViewModel(['feesFareDetails' => $feesFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/driver-fees-fare-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function deleteWaitingFeesDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserWaitingFeesStatus($data);
        $msg = "Status Updated Successfully";
        $this->flashMessenger()->addMessage(array('success' => $msg));
        $this->redirect()->toRoute('setting', ['action' => 'add-waiting-fees-fare']);
    }
    
    public function changeWaitingfeesStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateUserWaitingFeesStatus($data);
        }
        $feesFareDetails = $this->CommonModel->getUserWaitingCharge($user_id, '');
        $viewModel = new ViewModel(['feesFareDetails' => $feesFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/waiting-fees-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function deletePrewaitingFeesDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserPreWaitingFeesStatus($data);
        $msg = "Status Updated Successfully";
        $this->flashMessenger()->addMessage(array('success' => $msg));
        $this->redirect()->toRoute('setting', ['action' => 'add-prewaiting-fees-fare']);
    }
    
    public function changePrewaitingfeesStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateUserPreWaitingFeesStatus($data);
        }
        $feesFareDetails = $this->CommonModel->getUserPreWaitingCharge($user_id, '');
        $viewModel = new ViewModel(['feesFareDetails' => $feesFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/prewaiting-fees-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function changeShareRecordStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateUserShareDetailStatus($data);
        }
        $shareFareDetails = $this->CommonModel->getUserSharePrice($user_id, '');
        $viewModel = new ViewModel(['shareFareDetails' => $shareFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/share-fare-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function deleteShareDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserShareDetailStatus($data);
        $msg = "Status Updated Successfully";
        $this->flashMessenger()->addMessage(array('success' => $msg));
        $this->redirect()->toRoute('setting', ['action' => 'add-price-share']);
    }
    
    
    public function addCancelFareAction() {
        $cancellation_fare = "";
        $feesFareDetails = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        UserAddCancellationFeesForm::$cancellation_type = $this->CommonModel->getCancellationTypeList();
        UserAddCancellationFeesForm::$booking_type = $this->CommonModel->getPackageTypeList();
        $form = new UserAddCancellationFeesForm();
        
        if(!empty($id)){
            $cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id, $id);
        }
        
        $feesFareDetails = $this->CommonModel->getUserCancellationFare($login_id, '');        
        //$cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id);
        $fareDetails = [
            'cancellation_fare' => $cancellation_fare,
        ];
        //$user_id = 6;
        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            //$cancellation_fees_autoid = $postdata['cancellation_fees_id'];          

            $cancellation_master_id = array_values(array_filter($postdata['cancellation_master_id']));
            $cancellation_type = array_values(array_filter($postdata['cancellation_type']));
            $cancellation_fees = array_values(array_filter($postdata['cancellation_fees']));
            
            if (!empty($cancellation_master_id) && !empty($cancellation_type)) {
                if (count($cancellation_master_id) > 0) {
                    for ($i = 0; $i < count($cancellation_master_id); $i++) {
                        $cancelFeesArr[] = [
                            'user_id' => $login_id,
                            'cancellation_master_id' => $cancellation_master_id[$i],
                            'cancellation_type' => $cancellation_type[$i],
                            'cancellation_value' => $cancellation_fees[$i],
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                        ];
                    }
                }
            }
            $cancelFeesArr1['cancelfaredata'] = $cancelFeesArr;
            $cancelFeesArr1['user_id'] = $login_id;
            $cancelFeesArr1['booking_type'] = $postdata['booking_type'];

            //echo '<pre>';print_r($cancelFeesArr1);die();
            $resp = $this->CommonModel->addUserCancellationFareDetail($cancelFeesArr1);
            
            $this->redirect()->toRoute('setting', ['action' => 'add-waiting-fees-fare']);
            $msg = "Data Updated Successfully";
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'cancel_fees', 'fareDetails' => $fareDetails , 'feesFareDetails'=>$feesFareDetails]);
        return $viewModel;
    }
    
    
    /**
     * Get State List
     * @return JSON
     */
    public function getPackageListAction() {
        $data = [];
        $postData = $this->getRequest()->getPost();
        $booking_module_id = $postData['booking_module_id'];
        $val = '{"where": {"booking_type_id": "' . $booking_module_id . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/package?&filter=" . $val;
        $resp = $this->get($url);
        $stateJsonData = Json::decode($resp->getBody(), true);
        if ($stateJsonData['status']=="success") {
            foreach ($stateJsonData['data'] as $value) {
                $data[] = ["id" => $value['id'], "name" => $value['name']];
            }
            $response = ["status" => true, "data" => $data];
        } else {
            $response = ["status" => false];
        }
        $view = new JsonModel($response);
        return $view;
    }
    
    public function getPackageListArray($booking_module_id) {
        $val = '{"where": {"booking_type_id": "' . $booking_module_id . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/package?&filter=" . $val;
        $resp = $this->get($url);
        $stateJsonData = Json::decode($resp->getBody(), true);
        if ($stateJsonData['status']=="success") {
            foreach ($stateJsonData['data'] as $value) {
                $data[] = ["id" => $value['id'], "name" => $value['name']];
            }
            $response = ["status" => true, "data" => $data];
        } else {
            $response = ["status" => false];
        }
        return $response;
    }
    
    public function fetchBookingModule($id) {
        $url = $this->apiUrl() . "/package/getBookingModule?package_id=" . $id;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        if (!empty($data['responsedata'])) {
            $val = $data['responsedata'][0]['booking_type_id'];
        } else {
            $val = "NA";
        }
        return $val;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : CHANGE THE PACKAGE TAX DETAILS STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function changeHotelTaxDetailRecordStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateUserTaxDetailStatus($data);
        }
        $masterBookType= $this->config()->getConfig()->masterBookType->hotel;
        $taxFareDetails = $this->CommonModel->getUserTaxDetail($user_id, $masterBookType, '');
        $viewModel = new ViewModel(['taxFareDetails' => $taxFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/hotel-tax-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : DELETE THE HOTEL TAX  DETAILS
     * @param $data
     * @returns $responsedata
     */
    
    public function deleteHotelTaxDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserTaxDetailStatus($data);
        $this->redirect()->toRoute('setting', ['action' => 'hoteltax']);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : CHANGE THE PACKAGE TAX DETAILS STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function changePackageTaxDetailRecordStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateUserTaxDetailStatus($data);
        }
        $masterBookType= $this->config()->getConfig()->masterBookType->package;
        $taxFareDetails = $this->CommonModel->getUserTaxDetail($user_id, $masterBookType, '');
        $viewModel = new ViewModel(['taxFareDetails' => $taxFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/package-tax-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : DELETE THE PACKAGE TAX  DETAILS
     * @param $data
     * @returns $responsedata
     */
    
    public function deletePackageTaxDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserTaxDetailStatus($data);
        $this->redirect()->toRoute('setting', ['action' => 'packagetax']);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : CHANGE THE CRUISE TAX DETAILS STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function changeCruiseTaxDetailRecordStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateUserTaxDetailStatus($data);
        }
        $masterBookType= $this->config()->getConfig()->masterBookType->cruise;
        $taxFareDetails = $this->CommonModel->getUserTaxDetail($user_id, $masterBookType, '');
        $viewModel = new ViewModel(['taxFareDetails' => $taxFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/cruise-tax-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : DELETE THE CRUISE TAX  DETAILS
     * @param $data
     * @returns $responsedata
     */
    
    public function deleteCruiseTaxDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserTaxDetailStatus($data);
        $this->redirect()->toRoute('setting', ['action' => 'cruisetax']);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : CHANGE THE FLIGHT TAX DETAILS STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function changeFlightTaxDetailRecordStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateUserTaxDetailStatus($data);
        }
        $masterBookType= $this->config()->getConfig()->masterBookType->flight;
        $taxFareDetails = $this->CommonModel->getUserTaxDetail($user_id, $masterBookType, '');
        $viewModel = new ViewModel(['taxFareDetails' => $taxFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/flight-tax-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : DELETE THE FLIGHT TAX  DETAILS
     * @param $data
     * @returns $responsedata
     */
    
    public function deleteFlightTaxDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserTaxDetailStatus($data);
        $this->redirect()->toRoute('setting', ['action' => 'flighttax']);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : CHANGE THE BUS TAX DETAILS STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function changeBusTaxDetailRecordStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateUserTaxDetailStatus($data);
        }
        $masterBookType= $this->config()->getConfig()->masterBookType->bus;
        $taxFareDetails = $this->CommonModel->getUserTaxDetail($user_id, $masterBookType, '');
        $viewModel = new ViewModel(['taxFareDetails' => $taxFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/bus-tax-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : DELETE THE BUS TAX  DETAILS
     * @param $data
     * @returns $responsedata
     */
    
    public function deleteBusTaxDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserTaxDetailStatus($data);
        $this->redirect()->toRoute('setting', ['action' => 'bustax']);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : CHANGE THE ATTRACTION TAX DETAILS STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function changeAttractionTaxDetailRecordStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateUserTaxDetailStatus($data);
        }
        $masterBookType= $this->config()->getConfig()->masterBookType->attractions;
        $taxFareDetails = $this->CommonModel->getUserTaxDetail($user_id, $masterBookType, '');
        $viewModel = new ViewModel(['taxFareDetails' => $taxFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/attraction-tax-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : DELETE THE ATTRACTION TAX  DETAILS
     * @param $data
     * @returns $responsedata
     */
    
    public function deleteAttractionTaxDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserTaxDetailStatus($data);
        $this->redirect()->toRoute('setting', ['action' => 'attractiontax']);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : CHANGE THE GUIDE TAX DETAILS STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function changeGuideTaxDetailRecordStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateUserTaxDetailStatus($data);
        }
        $masterBookType= $this->config()->getConfig()->masterBookType->guide;
        $taxFareDetails = $this->CommonModel->getUserTaxDetail($user_id, $masterBookType, '');
        $viewModel = new ViewModel(['taxFareDetails' => $taxFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/guide-tax-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : DELETE THE GUIDE TAX  DETAILS
     * @param $data
     * @returns $responsedata
     */
    
    
    public function deleteGuideTaxDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserTaxDetailStatus($data);
        $this->redirect()->toRoute('setting', ['action' => 'guidetax']);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : CHANGE THE PACKAGE CANCEL FEES STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function changePackageCancelfeesStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateUserCancelFeesStatus($data);
        }
        $masterBookType= $this->config()->getConfig()->masterBookType->package;
        $feesFareDetails = $this->CommonModel->getUserCancellationFare($user_id, $masterBookType, '');
        $viewModel = new ViewModel(['feesFareDetails' => $feesFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/package-fees-fare-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : DELETE THE PACKAGE CANCEL FEES
     * @param $data
     * @returns $responsedata
     */
    
    public function deletePackageCancelFeesDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserCancelFeesStatus($data);
        $msg = "Status Updated Successfully";
        $this->flashMessenger()->addMessage(array('success' => $msg));
        $this->redirect()->toRoute('setting', ['action' => 'add-package-fees']);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : CHANGE THE HOTEL CANCEL FEES STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function changeHotelCancelfeesStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateUserCancelFeesStatus($data);
        }
        $masterBookType= $this->config()->getConfig()->masterBookType->hotel;
        $feesFareDetails = $this->CommonModel->getUserCancellationFare($user_id, $masterBookType, '');
        $viewModel = new ViewModel(['feesFareDetails' => $feesFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/hotel-fees-fare-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : DELETE THE HOTEL CANCEL FEES
     * @param $data
     * @returns $responsedata
     */
    
    public function deleteHotelCancelFeesDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserCancelFeesStatus($data);
        $msg = "Status Updated Successfully";
        $this->flashMessenger()->addMessage(array('success' => $msg));
        $this->redirect()->toRoute('setting', ['action' => 'add-hotel-fees']);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : CHANGE THE CRUISE CANCEL FEES STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function changeCruiseCancelfeesStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateUserCancelFeesStatus($data);
        }
        $masterBookType= $this->config()->getConfig()->masterBookType->cruise;
        $feesFareDetails = $this->CommonModel->getUserCancellationFare($user_id, $masterBookType, '');
        $viewModel = new ViewModel(['feesFareDetails' => $feesFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/cruise-fees-fare-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : DELETE THE CRUISE CANCEL FEES
     * @param $data
     * @returns $responsedata
     */
    
    public function deleteCruiseCancelFeesDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserCancelFeesStatus($data);
        $msg = "Status Updated Successfully";
        $this->flashMessenger()->addMessage(array('success' => $msg));
        $this->redirect()->toRoute('setting', ['action' => 'add-cruise-fees']);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : CHANGE THE FLIGHT CANCEL FEES STATUS
     * @param $data
     * @returns $responsedata
     */
    
    
    public function changeFlightCancelfeesStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            //echo "<pre>";print_r($data); die;
            $this->userModel->updateUserCancelFeesStatus($data);
        }
        $masterBookType= $this->config()->getConfig()->masterBookType->flight;
        $feesFareDetails = $this->CommonModel->getUserCancellationFare($user_id, $masterBookType, '');
        $viewModel = new ViewModel(['feesFareDetails' => $feesFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/flight-fees-fare-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : DELETE THE FLIGHT CANCEL FEES
     * @param $data
     * @returns $responsedata
     */
    
    public function deleteFlightCancelFeesDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserCancelFeesStatus($data);
        $msg = "Status Updated Successfully";
        $this->flashMessenger()->addMessage(array('success' => $msg));
        $this->redirect()->toRoute('setting', ['action' => 'add-flight-fees']);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : CHANGE THE BUS CANCEL FEES STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function changeBusCancelfeesStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateUserCancelFeesStatus($data);
        }
        $masterBookType= $this->config()->getConfig()->masterBookType->bus;
        $feesFareDetails = $this->CommonModel->getUserCancellationFare($user_id, $masterBookType, '');
        $viewModel = new ViewModel(['feesFareDetails' => $feesFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/bus-fees-fare-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : DELETE THE BUS CANCEL FEES
     * @param $data
     * @returns $responsedata
     */
    
    public function deleteBusCancelFeesDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserCancelFeesStatus($data);
        $msg = "Status Updated Successfully";
        $this->flashMessenger()->addMessage(array('success' => $msg));
        $this->redirect()->toRoute('setting', ['action' => 'add-bus-fees']);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : CHANGE THE ATTRACTION CANCEL FEES STATUS
     * @param $data
     * @returns $responsedata
     */
    
    
    public function changeAttractionCancelfeesStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateUserCancelFeesStatus($data);
        }
        $masterBookType= $this->config()->getConfig()->masterBookType->attractions;
        $feesFareDetails = $this->CommonModel->getUserCancellationFare($user_id, $masterBookType, '');
        $viewModel = new ViewModel(['feesFareDetails' => $feesFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/attraction-fees-fare-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : DELETE THE ATTRACTION CANCEL FEES
     * @param $data
     * @returns $responsedata
     */
    
    public function deleteAttractionCancelFeesDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserCancelFeesStatus($data);
        $msg = "Status Updated Successfully";
        $this->flashMessenger()->addMessage(array('success' => $msg));
        $this->redirect()->toRoute('setting', ['action' => 'add-attraction-fees']);
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : CHANGE THE GUIDE CANCEL FEES STATUS
     * @param $data
     * @returns $responsedata
     */
    
     public function changeGuideCancelfeesStatusAction() {
        $status = 0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status']==0 || $postData['status']==2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->userModel->updateUserCancelFeesStatus($data);
        }
        $masterBookType= $this->config()->getConfig()->masterBookType->guide;
        $feesFareDetails = $this->CommonModel->getUserCancellationFare($user_id, $masterBookType, '');
        $viewModel = new ViewModel(['feesFareDetails' => $feesFareDetails]);
        $viewModel->setTemplate('/dashboard/setting/guide-fees-fare-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : DELETE THE GUIDE CANCEL FEES
     * @param $data
     * @returns $responsedata
     */
    
    public function deleteGuideCancelFeesDetailAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->userModel->updateUserCancelFeesStatus($data);
        $msg = "Status Updated Successfully";
        $this->flashMessenger()->addMessage(array('success' => $msg));
        $this->redirect()->toRoute('setting', ['action' => 'add-guide-fees']);
    }
    
    
    
    
    
    
    
    
    
     /*** @CreatedBy : Mohit Jain
     * @createdDate : 22-April-2022
     * @description : ADD THE FLIGHT CANCEL FEES FARE
     * @param $data
     * @returns $responsedata
     */

    public function addFlightFeesFareAction() {
        $cancellation_fare = "";
        $feesFareDetails = "";
        $bookingModule = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        $id = $this->params()->fromQuery('id');
        $request = $this->getRequest();
        $masterBookType= $this->config()->getConfig()->masterBookType->flight;
        //UserAddCancellationFeesForm::$booking_module = $this->CommonModel->getBookingModuleList();
        UserAddCancellationFeesForm::$cancellation_type = $this->CommonModel->getCancellationTypeList();
        UserAddCancellationFeesForm::$booking_type = $this->CommonModel->getPackageListAction($masterBookType);
        $form = new UserAddCancellationFeesForm();
        
        if(!empty($id)){
            $cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id, $masterBookType, $id);
            $bookingModule = $this->fetchBookingModule($cancellation_fare[0]['booking_type']);
            
            $stateList = $this->getPackageListArray($bookingModule);
            if (!empty($stateList['data'])) {
                foreach ($stateList['data'] as $val) {
                    $list[$val['id']] = $val['name'];
                }
                $form->get('booking_type')->setValueOptions($list);
                $form->get('booking_type')->setValue($cancellation_fare[0]['booking_type']);
            }
        }
        
        $feesFareDetails = $this->CommonModel->getUserCancellationFare($login_id, $masterBookType, '');        
        //$cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id);
        $fareDetails = [
            'cancellation_fare' => $cancellation_fare,
        ];
        //$user_id = 6;
        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            //$cancellation_fees_autoid = $postdata['cancellation_fees_id'];          

            $cancellation_master_id = array_values(array_filter($postdata['cancellation_master_id']));
            $cancellation_type = array_values(array_filter($postdata['cancellation_type']));
            $cancellation_fees = array_values(array_filter($postdata['cancellation_fees']));
            
            if (!empty($cancellation_master_id) && !empty($cancellation_type)) {
                if (count($cancellation_master_id) > 0) {
                    for ($i = 0; $i < count($cancellation_master_id); $i++) {
                        $cancelFeesArr[] = [
                            'user_id' => $login_id,
                            'cancellation_master_id' => $cancellation_master_id[$i],
                            'cancellation_type' => $cancellation_type[$i],
                            'cancellation_value' => $cancellation_fees[$i],
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                            'master_booking_type_id' => $masterBookType
                        ];
                    }
                }
            }
            $cancelFeesArr1['cancelfaredata'] = $cancelFeesArr;
            $cancelFeesArr1['user_id'] = $login_id;
            $cancelFeesArr1['booking_type'] = $postdata['booking_type'];
            $cancelFeesArr1['master_booking_type_id'] = $masterBookType;

            //echo '<pre>';print_r($cancelFeesArr1);die();
            $resp = $this->CommonModel->addUserCancellationFareDetail($cancelFeesArr1);
            
            //$this->redirect()->toRoute('setting', ['action' => 'add-waiting-fees-fare']);
            $this->redirect()->toRoute('setting', ['action' => 'add-flight-fees-fare']);
            $msg = "Data Updated Successfully";
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'cancel_fees', 'fareDetails' => $fareDetails , 'feesFareDetails'=>$feesFareDetails, 'bookingModule'=>$bookingModule]);
        return $viewModel;
    }

}
