<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Dashboard\Form\{
    ProfilePersonalForm,
    ProfileCompanyDetailForm,
    ProfileChangePasswordForm,
    ProfileBankDetailForm,
    ProfileCreditRequestForm,
    ProfilePaymentDetailForm,
    ProfileLicenseDetailForm,
    ProfileOtherDetailForm
};
use Zend\View\Model\ViewModel;
use Zend\View\Model\JsonModel;
use Zend\Session\Container;
use Application\Controller\RestAPIClientController;
use Zend\Json\Json;
use Zend\Validator\File\Size;
use Zend\Validator\StringLength;
use Zend\Debug\Debug;

class ProfileController extends RestAPIClientController {

    /**
     * Index...
     * @return ViewModel
     */
    public function indexAction() {

        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $request = $this->getRequest();
        $form = new ProfilePersonalForm();

        $url = $this->apiAdminUrl() . "users/userinfodetail?id=" . $userId;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);

        if (!empty($JsonData[data][0])) {
            $userDetails = $JsonData[data][0];

            $form->get('first_name')->setValue($userDetails['first_name']);
            $form->get('last_name')->setValue($userDetails['last_name']);
            $form->get('email')->setValue($userDetails['email']);
            $form->get('mobile')->setValue($userDetails['mobile']);

            $form->get('email')->setAttribute('readonly', 'true');
            $form->get('mobile')->setAttribute('readonly', 'true');

            $request = $this->getRequest();
            if ($request->isPost()) {
                $mergeData = array_merge_recursive(
                        $this->getRequest()->getPost()->toArray()
                );

                $form->setData($mergeData);
                $postData = $mergeData;

                $finalData = [];
                $finalData = [
                    'first_name' => $postData['first_name'],
                    'last_name' => $postData['last_name'],
                    'email' => $postData['email'],
                    'mobile' => $postData['mobile_number'],
                    'id' => $userId
                ];


                $jsonData = json_encode($finalData);
                $url = $this->apiAdminUrl() . "users/updateById";
                $val = $this->post($url, $finalData);
                $JsonData = $val->getBody();
                $JsonData = Json::decode($JsonData, true);
                if ((!empty($JsonData)) && (!$JsonData['error'])) {
                    echo "saved successfully";
                } else {
                    echo "error";
                    die;
                }
            }
        }




        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    /**
     * Personal Detail...
     * @return ViewModel
     */
    public function personalDetailAction() {

        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;

        //echo "userid "; echo $userId;die;
        $request = $this->getRequest();
        $form = new ProfilePersonalForm();

        $finalData = ['id' => $userId];
        $url = $this->apiAdminUrl() . "users/userinfodetail/?&id=" . $userId;
        $val = $this->get($url, $finalData);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);

        if (($request->isXmlHttpRequest())) {

            if (!empty($JsonData[data][0])) {
                $userDetails = $JsonData[data][0];
                $form->setData($userDetails);

//            $form->get('first_name')->setValue($userDetails['first_name']);
//           $form->get('last_name')->setValue($userDetails['last_name']);
//           $form->get('email')->setValue($userDetails['email']);
//           $form->get('mobile')->setValue($userDetails['mobile']);

                $form->get('email')->setAttribute('readonly', 'true');
                $form->get('mobile')->setAttribute('readonly', 'true');
            }
        } else {

            if ($request->isPost()) {
                $postData = $this->getRequest()->getPost()->toArray();
                $form->setData($mergeData);

                $finalData = [];
                $finalData = [
                    'first_name' => $postData['first_name'],
                    'last_name' => $postData['last_name'],
                    'email' => $postData['email'],
                    'mobile' => $postData['mobile_number'],
                    'id' => $userId
                ];


                $jsonData = json_encode($finalData);
                $url = $this->apiAdminUrl() . "users/updateById";
                $val = $this->post($url, $finalData);
                $JsonData = $val->getBody();
                $JsonData = Json::decode($JsonData, true);
                if ((!empty($JsonData)) && (!$JsonData['error'])) {
                    //echo "saved successfully";
                } else {
                    echo "error";
                    die;
                }
            }
        }


        $viewModel = new ViewModel(['form' => $form]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    /**
     * Company Detail...
     * @return ViewModel
     */
    public function companyDetailAction() {

        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        //$userId = $sessionContainer->user_id;
        $userId = 10;

        $form = new ProfileCompanyDetailForm();
        $request = $this->getRequest();

        $typeSelect = 'select';
        $typeSubmit = 'submit';

        $url = $this->apiAdminUrl() . "user/company/?&user_id=" . $userId;
        $val = $this->get($url, $finalData);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);


        if (($request->isXmlHttpRequest())) {
            //ajax request

            if (!empty($JsonData[result][0])) {
                $userDetails = $JsonData[result][0];
                $form->setData($userDetails);
            }
            $viewModel = new ViewModel(['form' => $form]);

        } else {

            if ($request->isPost()) {
                // echo "post";die;
                $postData = $this->getRequest()->getPost()->toArray();

                $form->setData($postData);


                $finalData = [];
                $finalData = [
                    'company_name' => $postData['company_name'],
                    'company_address' => $postData['company_address'],
                    'state' => $postData['state_name'],
                    'city' => $postData['city_name'],
                    'service_tax_gst' => $postData['service_tax_gst'],
                    'pancard_no' => $postData['pancard_no'],
                    'contact_person_name' => $postData['contact_person_name'],
                    'landline_no' => $postData['landline_no'],
                    'mobile_no' => $postData['mobile_number'],
                    'email' => $postData['email'],
                    'website_url' => $postData['website_url'],
                    'logo' => $postData['logo'],
                    'user_id' => $userId,
                    'country' => 101,
                    'pincode' => $postData['pincode']
                ];


                $url = $this->apiAdminUrl() . "user/updatecompany";
                $val = $this->post($url, $finalData);
                $JsonData = $val->getBody();
                $JsonData = Json::decode($JsonData, true);
                // echo '<pre>';print_r($JsonData);die();
                if ((!empty($JsonData)) && (!$JsonData['error'])) {
                    $this->redirect()->toRoute('profile', ['action' => 'index']);
                } else {
                    echo "error";
                    die;
                }
            }

        }


        $viewModel->setTerminal(true);
        return $viewModel;
    }

    /**
     * Change Password...
     * @return ViewModel
     */
    public function changePasswordAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;

        //$userId = 10;

        $form = new ProfileChangePasswordForm();
        $request = $this->getRequest();

        //echo ($request->isXmlHttpRequest());die;

        if (($request->isXmlHttpRequest())) {

            $success="";
            $viewModel = new ViewModel(['form' => $form,'msg_value' => $success]);
            $viewModel->setTerminal(true);

        } else {


            if ($request->isPost()) {
                $postData = $this->getRequest()->getPost()->toArray();
                $form->setData($postData);

                if ($form->isValid()) {

                    $finalData = [];
                    $finalData = [
                        'oldpassword' => md5($postData['old_password']),
                        'newpassword' => md5($postData['new_password']),
                        'confirmpassword' => md5($postData['confirm_password']),
                        'id' => $userId
                    ];


                   // echo '<pre>';print_r($finalData);die();
                    $url = $this->apiAdminUrl() . "user/passwordupdate";
                    $val = $this->put($url, $finalData);
                    $JsonData = $val->getBody();
                    $JsonData = Json::decode($JsonData, true);
                    //echo '<pre>';print_r($JsonData);die;
                    $success=$JsonData['success'];
                    $code =$JsonData['code'];

                    if ((!empty($JsonData)) && (!$JsonData['error']) && ($code==200)) {


                       $viewModel = new ViewModel(['form' => $form,'msg_value' => $success]);
                       //$viewModel->setTerminal(true);

                       $this->redirect()->toRoute('profile', ['action' => 'index']);
                    } else {
                        $success=$JsonData['success'];

                    }
//
                }

                $viewModel = new ViewModel(['form' => $form,'msg_value' => $success]);
             //$viewModel->setTerminal(true);

            }



        }


        return $viewModel;
    }

    /**
     * Bank Detail...
     * @return ViewModel
     */
    public function bankDetailAction() {
         $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $userId = 3;

        $form = new ProfileBankDetailForm();
        $request = $this->getRequest();

        $url = $this->apiAdminUrl() . "user/showbankdetail/?&user_id=" . $userId;
        $val = $this->get($url, $finalData);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);


        if (($request->isXmlHttpRequest())) {


            if (!empty($JsonData[result][0])) {


                $userDetails = $JsonData[result][0];
                $form->setData($userDetails);
            }

            $viewModel = new ViewModel(['form' => $form]);
            $viewModel->setTerminal(true);

        } else {


            if ($request->isPost()) {
                $postData = $this->getRequest()->getPost()->toArray();
                $form->setData($postData);

                if ($form->isValid()) {

                    $finalData = [];
                    $finalData = [
                        'bankname' => $postData['name'],
                        'account_name' => $postData['ac_holder_name'],
                        'account_number' => $postData['ac_no'],
                        'ifsc_code' => $postData['ifsc_code'],
                        'address' => $postData['address'],
                        'ip' => $_SERVER['SERVER_ADDR'],
                        'user_id' => $userId
                    ];

                    //echo '<pre>';print_r($finalData);die();
                    $url = $this->apiAdminUrl() . "users/bankdetail";
                    $val = $this->put($url, $finalData);
                    $JsonData = $val->getBody();
                    $JsonData = Json::decode($JsonData, true);


                    if ((!empty($JsonData)) && (!$JsonData['error'])) {


                       $viewModel = new ViewModel(['form' => $form]);


                       $this->redirect()->toRoute('profile', ['action' => 'index']);
                    } else {

                        echo "some error";die;
                    }
//
                }
                $viewModel = new ViewModel(['form' => $form]);
            }


        }
        return $viewModel;

    }

    /**
     * Credit Request...
     * @return ViewModel
     */
    public function creditRequestAction() {
        $request = $this->getRequest();
        $form = new ProfileCreditRequestForm();
        $typeSelect = 'select';
        $typeSubmit = 'submit';

        //Call API here...
        $creditData = [
            'deposit_date' => '02-06-2017',
            'payment_mode' => 'cash',
            'partner_bank_accounts' => 'icici',
            'amount' => '48220',
            'deposited_bank' => 'hdfc',
            'deposited_branch' => 'karol bagh',
            'remark_request' => 'xyz'
        ];

        if (($request->isXmlHttpRequest() && $typeSubmit == $request->getPost()['submit_type'])) {
            //echo 'submit';die;

            $postData = [
                'deposit_date' => $request->getPost()['deposit_date'],
                'payment_mode' => $request->getPost()['payment_mode'],
                'partner_bank_accounts' => $request->getPost()['partner_bank_accounts'],
                'amount' => $request->getPost()['amount'],
                'deposited_bank' => $request->getPost()['deposited_bank'],
                'deposited_branch' => $request->getPost()['deposited_branch'],
                'remark_request' => $request->getPost()['remark_request']
            ];
            //$jsonData = json_encode($postData);
            //print_r($jsonData);die;
            //save data here...
            //Call API here...

            $msg = 'Successfully Saved';
            $form->setData($postData);
            $viewModel = new ViewModel(['form' => $form, 'msg' => $msg]);
            $viewModel->setTemplate('/profile/credit-request');
            $viewModel->setTerminal(true);
            return $viewModel;
            exit;
        } elseif (($request->isXmlHttpRequest() && $typeSelect == $request->getPost()['type'])) {
            //echo 'select';die;
            $form->setData($creditData);
        }

        $viewModel = new ViewModel(['form' => $form]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    /**
     * Payment Detail...
     * @return ViewModel
     */
    public function paymentDetailAction() {
        $request = $this->getRequest();
        $form = new ProfilePaymentDetailForm();
        $typeSelect = 'select';
        $typeSubmit = 'submit';

        //Call API here...
        $paymentData = [
            'local' => '1',
            'point_to_point' => '0',
            'airport_rail_bus' => '1',
            'outstation' => '1',
            'oneway' => '1',
            'all' => '0',
            'cash' => '1',
            'credit' => '0',
            'both' => '0'
        ];

        if (($request->isXmlHttpRequest() && $typeSubmit == $request->getPost()['submit_type'])) {
            //echo 'submit';die;

            $postData = [
                'local' => $request->getPost()['local'],
                'point_to_point' => $request->getPost()['point_to_point'],
                'airport_rail_bus' => $request->getPost()['airport_rail_bus'],
                'outstation' => $request->getPost()['outstation'],
                'oneway' => $request->getPost()['oneway'],
                'all' => $request->getPost()['all'],
                'cash' => $request->getPost()['cash'],
                'credit' => $request->getPost()['credit'],
                'both' => $request->getPost()['both']
            ];
            //$jsonData = json_encode($postData);
            //print_r($jsonData);die;
            //save data here...
            //Call API here...

            $msg = 'Successfully Saved';
            $form->setData($postData);
            $viewModel = new ViewModel(['form' => $form, 'msg' => $msg]);
            $viewModel->setTemplate('/profile/payment-detail');
            $viewModel->setTerminal(true);
            return $viewModel;
            exit;
        } elseif (($request->isXmlHttpRequest() && $typeSelect == $request->getPost()['type'])) {
            //echo 'select';die;
            $form->setData($paymentData);
        }

        $viewModel = new ViewModel(['form' => $form]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    /**
     * Licence Detail...
     * @return ViewModel
     */
    public function licenseDetailAction() {


         $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $userId = 14;

        $form = new ProfileLicenseDetailForm();
        $request = $this->getRequest();

        $url = $this->apiAdminUrl() . "user/showlicencedetail/?&user_id=" . $userId;
        $val = $this->get($url, $finalData);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);


        if (($request->isXmlHttpRequest())) {


            if (!empty($JsonData[result][0])) {


                $userDetails = $JsonData[result][0];
                $form->setData($userDetails);
            }

            $viewModel = new ViewModel(['form' => $form]);
            $viewModel->setTerminal(true);

        } else {


            if ($request->isPost()) {

                $postData=array_merge_recursive(

                    $this->getRequest()->getPost()->toArray(),
                    $this->getRequest()->getFiles()->toArray()

            );
                $form->setData($postData);


                if ($form->isValid()) {

                    $fileNameLicensecProof = $postData['license_proof']['name'];
                $fileTmpNameLicenseProof = $postData['license_proof']['tmp_name'];
                $licenseProofImageName = date("d-m-Y") . "-" . time() . $$fileNameLicensecProof;
                $targetPath = "public/upload/license/licenseproof/" . $licenseProofImageName;
                move_uploaded_file($fileTmpNameLicenseProof, $targetPath);

                $fileNamePancardProof = $postData['pancard_proof']['name'];
                $fileTmpNamePancardProof = $postData['pancard_proof']['tmp_name'];
                $pancardProofImageName = date("d-m-Y") . "-" . time() . $fileNamePancardProof;
                $targetPath = "public/upload/driver/pancardproof/" . $pancardProofImageName;
                move_uploaded_file($fileTmpNamePancardProof, $targetPath);

                $fileNamepoliceProof = $postData['police_proof']['name'];
                $fileTmpNamePoliceProof = $postData['pancard_proof']['tmp_name'];
                $policeProofImageName = date("d-m-Y") . "-" . time() . $fileNamepoliceProof;
                $targetPath = "public/upload/license/policeproof/" . $policeProofImageName;
                move_uploaded_file($fileTmpNamePoliceProof, $targetPath);


                $fileNameauditProof = $postData['audit_proof']['name'];
                $fileTmpNameAuditProof = $postData['pancard_proof']['tmp_name'];
                $auditProofImageName = date("d-m-Y") . "-" . time() . $fileNameauditProof;
                $targetPath = "public/upload/license/auditproof/" . $auditProofImageName;
                move_uploaded_file($fileTmpNameAuditProof, $targetPath);

                    $finalData = [];
                    $finalData = [
                        'license_state' => $postData['license_state'],
                        'license_no' => $postData['driving_license_no'],
                        'license_proof' => $licenseProofImageName,
                        'license_validity' => $postData['license_validity'],
                        'gps_device_no' => $postData['gps'],
                        'pancard' => $postData['pancard_no'],
                        'pancard_proof' => $pancardProofImageName,
                        'police_report' => $policeProofImageName,
                        'audit_report' => $auditProofImageName,
                        'user_id' => $userId
                    ];

                    //echo '<pre>';print_r($finalData);die();
                    $url = $this->apiAdminUrl() . "user/updatelicencedetail";
                    $val = $this->post($url, $finalData);
                    $JsonData = $val->getBody();
                    $JsonData = Json::decode($JsonData, true);
                    echo '<pre>';print_r($JsonData);die();

                    if ((!empty($JsonData)) && (!$JsonData['error'])) {


                       $viewModel = new ViewModel(['form' => $form]);


                       $this->redirect()->toRoute('profile', ['action' => 'index']);
                    } else {

                        echo "some error";die;
                    }
//
                }else{
                    echo "php";
                   Debug::dump($postData); exit;

                }
                $viewModel = new ViewModel(['form' => $form]);
            }


        }
        return $viewModel;
























        $request = $this->getRequest();
        $form = new ProfileLicenseDetailForm();
        $typeSelect = 'select';
        $typeSubmit = 'submit';

        //Call API here...
        $licenseData = [
            'license_state' => 'haryana',
            'badge_license_number' => 'df456',
            'license_proof' => 'license.jpg',
            'license_validity' => '12 months',
            'insurance_validity' => 'one year',
            'gps_device_number' => '1234567',
            'pancard' => '123456789',
            'pancard_proof' => 'pan.jpg',
            'police_report' => 'p-report',
            'audit_report' => 'audit.jpg'
        ];

        if (($request->isXmlHttpRequest() && $typeSubmit == $request->getPost()['submit_type'])) {
            //echo 'submit';die;
            //file start...
            $postFile = $this->getRequest()->getFiles()->toArray();
            $fileNameLicenseProof = $postFile['license_proof']['name'];
            $fileTmpNameLicenseProof = $postFile['license_proof']['tmp_name'];
            $licenseProofImageName = date("d-m-Y") . "-" . time() . $fileNameLicenseProof;
            //$targetpath = EMAIL_IMAGE_PATH.$filename;
            $targetPath = "public/upload/profile/licenseproof/" . $licenseProofImageName;
            move_uploaded_file($fileTmpNameLicenseProof, $targetPath);

            $fileNamePancardProof = $postFile['pancard_proof']['name'];
            $fileTmpNamePancardProof = $postFile['pancard_proof']['tmp_name'];
            $pancardProofImageName = date("d-m-Y") . "-" . time() . $fileNamePancardProof;
            //$targetpath = EMAIL_IMAGE_PATH.$filename;
            $targetPath = "public/upload/profile/pancardproof/" . $pancardProofImageName;
            move_uploaded_file($fileTmpNamePancardProof, $targetPath);

            $fileNameAuditReport = $postFile['audit_report']['name'];
            $fileTmpNameAuditReport = $postFile['audit_report']['tmp_name'];
            $auditReportProofImageName = date("d-m-Y") . "-" . time() . $fileNameAuditReport;
            //$targetpath = EMAIL_IMAGE_PATH.$filename;
            $targetPath = "public/upload/profile/auditreport/" . $auditReportProofImageName;
            move_uploaded_file($fileTmpNameAuditReport, $targetPath);
            //file end...

            $postData = [
                'license_state' => $request->getPost()['license_state'],
                'badge_license_number' => $request->getPost()['badge_license_number'],
                'license_proof' => $licenseProofImageName,
                'license_validity' => $request->getPost()['license_validity'],
                'insurance_validity' => $request->getPost()['insurance_validity'],
                'gps_device_number' => $request->getPost()['gps_device_number'],
                'pancard' => $request->getPost()['pancard'],
                'pancard_proof' => $pancardProofImageName,
                'police_report' => $request->getPost()['police_report'],
                'audit_report' => $auditReportProofImageName
            ];
            //$jsonData = json_encode($postData);
            //print_r($jsonData);die;
            //save data here...
            //Call API here...

            $msg = 'Successfully Saved';
            $form->setData($postData);
            $viewModel = new ViewModel(['form' => $form, 'msg' => $msg]);
            $viewModel->setTemplate('/profile/license-detail');
            $viewModel->setTerminal(true);
            return $viewModel;
            exit;
        } elseif (($request->isXmlHttpRequest() && $typeSelect == $request->getPost()['type'])) {
            //echo 'select';die;
            $form->setData($licenseData);
        }

        $viewModel = new ViewModel(['form' => $form]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    /**
     * Other Detail...
     * @return ViewModel
     */
    public function otherDetailAction() {
        $request = $this->getRequest();
        $form = new ProfileOtherDetailForm();
        $typeSelect = 'select';
        $typeSubmit = 'submit';

        //Call API here...
        $otherData = [
            'pref_city_to_drive_cab' => 'new delhi',
            'route_knowledge' => '1',
            'ac_non_ac' => '1',
            'pref_location_zone' => '3',
            'week_off' => '0'
        ];

        if (($request->isXmlHttpRequest() && $typeSubmit == $request->getPost()['submit_type'])) {
            //echo 'submit';die;

            $postData = [
                'pref_city_to_drive_cab' => $request->getPost()['pref_city_to_drive_cab'],
                'route_knowledge' => $request->getPost()['route_knowledge'],
                'ac_non_ac' => $request->getPost()['ac_non_ac'],
                'pref_location_zone' => $request->getPost()['pref_location_zone'],
                'week_off' => $request->getPost()['week_off']
            ];
            //$jsonData = json_encode($postData);
            //print_r($jsonData);die;
            //save data here...
            //Call API here...

            $msg = 'Successfully Saved';
            $form->setData($postData);
            $viewModel = new ViewModel(['form' => $form, 'msg' => $msg]);
            $viewModel->setTemplate('/profile/other-detail');
            $viewModel->setTerminal(true);
            return $viewModel;
            exit;
        } elseif (($request->isXmlHttpRequest() && $typeSelect == $request->getPost()['type'])) {
            //echo 'select';die;
            $form->setData($otherData);
        }

        $viewModel = new ViewModel(['form' => $form]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    /**
     * State List...
     * @return ViewModel
     */
    public function stateListAction() {
        //echo 'hello';die;
        $request = $this->getRequest();
        $postdata = $request->getPost();
        $postdata = $postdata['term'];

        //call API here...

        $data[] = [
            "label" => 'Delhi',
            "value" => '1',
        ];

        $view = new JsonModel($data);
        return $view;
    }

    /**
     * City List...
     * @return ViewModel
     */
    public function cityListAction() {

        $request = $this->getRequest();
        $postdata = $request->getPost();
        $postdata = $postdata['term'];
        //echo $postdata;die();
        //call API here...
        // $jsonData=[];
        //$id=1;
        //$jsonResponse = $this->get($this->apiUrl()."/airport-railway?filter[where][airport_railway_name]=T1 Airport");
        //$jsonResponse = $this->get($this->apiUrl()."/airport-railway");
        //print_r($jsonResponse);die;
        //foreach($jsonResponse as $list){
        //$jsonData[$list['id']] = $list['airport_railway_name'];
        //}

        $data[] = [
            "label" => 'New Delhi',
            "value" => '1'
        ];

        $view = new JsonModel($data);
        return $view;
    }

    /**
     * Check Already Exist Password...
     * @return ViewModel
     */
    public function checkAlreadyExistPasswordAction() {
        $request = $this->getRequest();
        if ($request->isPost()) {
            $fieldName = $request->getPost("id");
            $value = $request->getPost("value");
            //call API here...
            $size = 0;
        }

        if ($size == 0) {
            return new JsonModel(["id" => $fieldName, "message" => "<p style='color:green;'>Available</p>"]);
        } else {
            return new JsonModel(["id" => $fieldName, "message" => "<p style='color:red;'>Not Matched</p>"]);
        }

        exit();
    }

}
