<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Application\Controller\RestAPIClientController;
use Dashboard\Form\PaymentStructureForm;
use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Zend\Json\Json;
use Zend\Session\Container;
use Zend\Debug\Debug;
use Dashboard\Model\CommonModel;
use Dashboard\Model\User;

class PaymentStructureController extends RestAPIClientController {

    public function __construct() {
        $this->CommonModel = new CommonModel();
        $this->userModel = new User();
    }

    /**
     * Index
     * @return ViewModel
     */
    public function indexAction() {
        $form = new PaymentStructureForm();
        $data = [];
        $pStrtuctureList = $this->CommonModel->getPaymentStructureDetails($data);
        $viewModel = new ViewModel(['pStrtuctureList' => $pStrtuctureList]);
        return $viewModel;
    }

    public function addPaymentStructureAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        PaymentStructureForm::$country = $this->userModel->getCountryList();
        PaymentStructureForm::$booking_type = $this->CommonModel->getTourTypeList();
        $form = new PaymentStructureForm();
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();
                $data = [
                    'country_id' => $post['country_id'],
                    'booking_type' => $post['booking_type'],
                    'title' => $post['title'],
                    'description' => $post['description'],
                    'status' => 1,
                    'created_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                $insertStatus = $this->CommonModel->addPaymentStructureDetails($data);
                if ($insertStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Details added successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'Somet thing Went Wrong'));
                }
                $this->redirect()->toRoute('payment-structure', ['action' => 'index']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function editPaymentStructureAction() {
        $sessionUser = new Container('userlogin');
        $user_id = $sessionUser->userData['user_id'];

        PaymentStructureForm::$country = $this->userModel->getCountryList();
        PaymentStructureForm::$booking_type = $this->CommonModel->getTourTypeList();
        $form = new PaymentStructureForm();
        $id = $this->params()->fromQuery('id');
        $data = [
            'auto_id' => $id
        ];
        $vehicleData = $this->CommonModel->getPaymentStructureDetails($data);
        $vehicleData = $vehicleData[0];
        $form->setData($vehicleData);
        $form->get('id')->setValue($vehicleData['id']);
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();
                $data = [
                    'country_id' => $post['country_id'],
                    'booking_type' => $post['booking_type'],
                    'title' => $post['title'],
                    'description' => $post['description'],
                    'modified_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'auto_id' => $post['id']
                ];
                $updateStatus = $this->CommonModel->updatePaymentStructureDetails($data);
                if($updateStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Details Updated successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'Somet thing Went Wrong'));
                }
                $this->redirect()->toRoute('payment-structure', ['action' => 'index']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }
    
      /** Function to change PAYMENT STRUCTURE STATUS */
    public function paymentStructureStatusAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        $id = implode(',', $data['selected']);
        $status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'status' => $status];
        $this->CommonModel->updatePaymentStructureStatus($data);
        $val = [];
        $pStrtuctureList = $this->CommonModel->getPaymentStructureDetails($data);
        $viewModel = new ViewModel(['pStrtuctureList' => $pStrtuctureList]);
        $viewModel->setTemplate('/dashboard/payment-structure/payment-structure-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function changeRecordStatusAction() {
        $status=0;
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if($postData['status']==0 || $postData['status']==2){
                $status=1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->CommonModel->updatePaymentStructureStatus($data);
        }
        $val = [];
        $pStrtuctureList = $this->CommonModel->getPaymentStructureDetails($val);
        $viewModel = new ViewModel(['pStrtuctureList' => $pStrtuctureList]);
        $viewModel->setTemplate('/dashboard/payment-structure/payment-structure-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function deletePaymentStructureAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id'=>$userId, 'status'=>2];
        $this->CommonModel->updatePaymentStructureStatus($data);
        $this->redirect()->toRoute('payment-structure', ['action' => 'index']);
        $this->flashMessenger()->addMessage(array('success' => 'Details Delete Successfully'));
    }

}
