<?php

namespace Dashboard\Controller;

use Application\Controller\RestAPIClientController;
use Dashboard\Form\{
    MenuGroupForm,
    MenuForm,
    CmsPageForm
};
use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Zend\Session\Container;
use Zend\Json\Json;
use Zend\Debug\Debug;

class MenuController extends RestAPIClientController {

    private $existPage = 1;
    private $newPage = 2;

    /**
     * Index
     * @return ViewModel
     */
    public function indexAction() {
        //write code here...
        $menuGroupListing = $this->getMenuGroupList();
        $viewModel = new ViewModel(['menuGroupListing' => $menuGroupListing['data']]);
        return $viewModel;
    }

    public function addMenuGroupAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        MenuGroupForm::$groupposition = $this->getPositionList();
        MenuGroupForm::$menusno = $this->getNumberList();
        $form = new MenuGroupForm();
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $this->getRequest()->getPost()->toArray();
            $form->setData($postData);
            if ($form->isValid()) {
                $finalData = [];
                $finalData = [
                    'company_setup_id' => $this->config()->getConfig()->company->companyId,
                    'group_name' => $postData['group_name'],
                    'group_position' => $postData['group_position'],
                    'no_of_menus' => $postData['no_of_menus'],
                    'created_date' => date('Y-m-d H:i:s'),
                    'created_by' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                $url = $this->apiUrl() . "/menu-group";
                $val = $this->put($url, $finalData);
                $JsonData = $val->getBody();
                $JsonData = Json::decode($JsonData, true);

                if ((!empty($JsonData)) && (!$JsonData['error'])) {
                    $this->flashMessenger()->addMessage(array('success' => 'Menu Group create Successfully.'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'Menu Group not create Successfully.'));
                }
                $this->redirect()->toRoute('menu', ['action' => 'index']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function editMenuGroupAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        MenuGroupForm::$groupposition = $this->getPositionList();
        MenuGroupForm::$menusno = $this->getNumberList();
        $form = new MenuGroupForm();
        $group_id = $this->params()->fromQuery('id');
        $url = $this->apiUrl() . "/menu-group/" . $group_id;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        $form->setData($data);
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $this->getRequest()->getPost()->toArray();
            $form->setData($postData);
            if ($form->isValid()) {
                $finalData = [];
                $finalData = [
                    'company_setup_id' => $this->config()->getConfig()->company->companyId,
                    'group_name' => $postData['group_name'],
                    'group_position' => $postData['group_position'],
                    'no_of_menus' => $postData['no_of_menus'],
                    'modified_by' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                $val = '{"group_id": "' . $postData['group_id'] . '"}';
                $val = rawurlencode($val);
                $url = $this->apiUrl() . "/menu-group/upsertWithWhere?where=" . $val;
                $val = $this->post($url, $finalData);
                $JsonData = $val->getBody();
                $JsonData = Json::decode($JsonData, true);
                if ((!empty($JsonData)) && (!$JsonData['error'])) {
                    $this->flashMessenger()->addMessage(array('success' => 'Menu Group Updated Successfully.'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'Menu Group not Updated.'));
                }
                $this->redirect()->toRoute('menu', ['action' => 'index']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    /**
     * Index
     * @return ViewModel
     */
    public function cmsPagesAction() {
        $pageListing    =   $this->getCmsPagesList();
        $viewModel = new ViewModel(['pageListing' => $pageListing['data']]);
        return $viewModel;
    }

    public function addPageActionOld() {

        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        CmsPageForm::$menuGroup = $this->getMenuGroupListData();
        CmsPageForm::$pageOrder = $this->getNumberList();
        CmsPageForm::$pageList = $this->getPagesList();
        $form = new CmsPageForm();
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $this->getRequest()->getPost()->toArray();
            $form->setData($postData);
            if ($form->isValid()) {
                $finalData = [];
                $finalData = [
                    'company_setup_id' => $this->config()->getConfig()->company->companyId,
                    'menu_group_id' => $postData['menu_group_id'],
                    'page_type' => $postData['page_type'],
                    'page_title' => $postData['page_title'],
                    'page_desc' => $postData['page_desc'],
                    'meta_title' => $postData['meta_title'],
                    'meta_keywords' => $postData['meta_keywords'],
                    'meta_desc' => $postData['meta_desc'],
                    'show_after_login' => $postData['show_after_login'],
                    'page_target' => $postData['page_target'],
                    'icon_class' => $postData['icon_class'],
                    'page_url' => $postData['page_url'],
                    'page_order' => $postData['page_order'],
                    'created_date' => date('Y-m-d H:i:s'),
                    'created_by' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                //echo '<pre>';print_r($finalData);die();
                $url = $this->apiUrl() . "/cms-pages";
                $val = $this->put($url, $finalData);
                $JsonData = $val->getBody();
                $JsonData = Json::decode($JsonData, true);

                if ((!empty($JsonData)) && (!$JsonData['error'])) {
                    $this->flashMessenger()->addMessage(array('success' => 'Page create Successfully.'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'Page not created'));
                }
                $this->redirect()->toRoute('menu', ['action' => 'cms-pages']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function addPageAction() {

        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        CmsPageForm::$menuGroup = $this->getMenuGroupListData();
        CmsPageForm::$pageOrder = $this->getNumberList();
        CmsPageForm::$pageList = $this->getPagesList();
        $form = new CmsPageForm();
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $this->getRequest()->getPost()->toArray();
            $form->setData($postData);
            //echo $this->newPage;
            if ($postData['existing_page'] == $this->newPage) {
                $form->getInputFilter()->get('page_name')->setRequired(false);
                $form->getInputFilter()->get('page_type')->setRequired(true);
                $form->getInputFilter()->get('page_title')->setRequired(true);
                $form->getInputFilter()->get('page_url')->setRequired(true);
                $form->getInputFilter()->get('page_order')->setRequired(true);
                $form->getInputFilter()->get('page_desc')->setRequired(true);
                $form->getInputFilter()->get('show_after_login')->setRequired(true);
                $form->getInputFilter()->get('page_target')->setRequired(true);
                $form->getInputFilter()->get('icon_class')->setRequired(true);
                $form->getInputFilter()->get('meta_title')->setRequired(true);
                $form->getInputFilter()->get('meta_keywords')->setRequired(true);
                $form->getInputFilter()->get('meta_desc')->setRequired(true);
                $form->get('new_selected')->setValue(1);
            }
            //pickup-now value=2
            if ($postData['existing_page'] == $this->existPage) {
                $form->getInputFilter()->get('page_name')->setRequired(true);
                $form->getInputFilter()->get('page_order')->setRequired(false);
                $form->getInputFilter()->get('page_type')->setRequired(false);
                $form->getInputFilter()->get('page_title')->setRequired(false);
                $form->getInputFilter()->get('page_url')->setRequired(false);
                $form->getInputFilter()->get('page_desc')->setRequired(false);
                $form->getInputFilter()->get('show_after_login')->setRequired(false);
                $form->getInputFilter()->get('page_target')->setRequired(false);
                $form->getInputFilter()->get('icon_class')->setRequired(false);
                $form->getInputFilter()->get('meta_title')->setRequired(false);
                $form->getInputFilter()->get('meta_keywords')->setRequired(false);
                $form->getInputFilter()->get('meta_desc')->setRequired(false);
                $form->get('existing_selected')->setValue(0);
            }
            //die;
            if ($form->isValid()) {
                $finalData = [];
                if (isset($_FILES['page_image']['name']) && $_FILES['page_image']['name'] != '') {
                    $file = $_FILES['page_image']['tmp_name'];
                    $file    = file_get_contents($file);
                    $base64string    = base64_encode($file);
                }else{
                    $base64string = "";
                }
                $finalData = [
                    'company_setup_id' => $this->config()->getConfig()->company->companyId,
                    'menu_group_id' => $postData['menu_group_id'],
                    'menu_name'=>$postData['menu_name'],
                    'menu_order' => $postData['menu_order'],
                    'existing_page'=>$postData['existing_page'],
                    'cms_page_id'=>$postData['page_name'],
                    'page_type' => $postData['page_type'],
                    'page_title' => $postData['page_title'],
                    'page_desc' => $postData['page_desc'],
                    'meta_title' => $postData['meta_title'],
                    'meta_keywords' => $postData['meta_keywords'],
                    'meta_desc' => $postData['meta_desc'],
                    'show_after_login' => $postData['show_after_login'],
                    'page_target' => $postData['page_target'],
                    'icon_class' => $postData['icon_class'],
                    'page_url' => $postData['page_url'],
                    'page_order' => $postData['page_order'],
                    'page_image' => $base64string,
                    'created_date' => date('Y-m-d H:i:s'),
                    'created_by' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
               // echo '<pre>';print_r($finalData);die();
                $url = $this->apiUrl() . "/cms-pages/cmsMenuPages";
                $val = $this->post($url, $finalData);
                $JsonData = $val->getBody();
                $JsonData = Json::decode($JsonData, true);
               // echo '<pre>';print_r($JsonData);die();
                if ((!empty($JsonData)) && (!$JsonData['error'])) {
                    $this->flashMessenger()->addMessage(array('success' => 'Page create Successfully.'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'Page not created'));
                }
                $this->redirect()->toRoute('menu', ['action' => 'cms-pages']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

        public function editPageAction() {

        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        CmsPageForm::$menuGroup = $this->getMenuGroupListData();
        CmsPageForm::$pageOrder = $this->getNumberList();
        CmsPageForm::$pageList = $this->getPagesList();
        $form = new CmsPageForm();
        $id = $this->params()->fromQuery('id');
        $url = $this->apiUrl() . "/cms-menu/" . $id;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        $form->setData($data);
        $form->get('menu_id')->setValue($data['menu_id']);
        $form->get('page_name')->setValue($data['cms_page_id']);
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $this->getRequest()->getPost()->toArray();
            $form->setData($postData);
            //echo $this->newPage;
            if ($postData['existing_page'] == $this->newPage) {
                $form->getInputFilter()->get('page_name')->setRequired(false);
                $form->getInputFilter()->get('page_type')->setRequired(true);
                $form->getInputFilter()->get('page_title')->setRequired(true);
                $form->getInputFilter()->get('page_url')->setRequired(true);
                $form->getInputFilter()->get('page_order')->setRequired(true);
                $form->getInputFilter()->get('page_desc')->setRequired(true);
                $form->getInputFilter()->get('show_after_login')->setRequired(true);
                $form->getInputFilter()->get('page_target')->setRequired(true);
                $form->getInputFilter()->get('icon_class')->setRequired(true);
                $form->getInputFilter()->get('meta_title')->setRequired(true);
                $form->getInputFilter()->get('meta_keywords')->setRequired(true);
                $form->getInputFilter()->get('meta_desc')->setRequired(true);
                $form->get('new_selected')->setValue(1);
            }
            //pickup-now value=2
            if ($postData['existing_page'] == $this->existPage) {
                $form->getInputFilter()->get('page_name')->setRequired(true);
                $form->getInputFilter()->get('page_type')->setRequired(false);
                $form->getInputFilter()->get('page_title')->setRequired(false);
                $form->getInputFilter()->get('page_url')->setRequired(false);
                $form->getInputFilter()->get('page_order')->setRequired(false);
                $form->getInputFilter()->get('page_desc')->setRequired(false);
                $form->getInputFilter()->get('show_after_login')->setRequired(false);
                $form->getInputFilter()->get('page_target')->setRequired(false);
                $form->getInputFilter()->get('icon_class')->setRequired(false);
                $form->getInputFilter()->get('meta_title')->setRequired(false);
                $form->getInputFilter()->get('meta_keywords')->setRequired(false);
                $form->getInputFilter()->get('meta_desc')->setRequired(false);
                $form->get('existing_selected')->setValue(0);
            }
            //die;
            if ($form->isValid()) {
                $finalData = [];
                if (isset($_FILES['page_image']['name']) && $_FILES['page_image']['name'] != '') {
                    $file = $_FILES['page_image']['tmp_name'];
                    $file    = file_get_contents($file);
                    $base64string    = base64_encode($file);
                }else{
                    $base64string = "";
                }

                $finalData = [
                    'company_setup_id' => $this->config()->getConfig()->company->companyId,
                    'menu_group_id' => $postData['menu_group_id'],
                    'menu_name'=>$postData['menu_name'],
                    'menu_order' => $postData['menu_order'],
                    'existing_page'=>$postData['existing_page'],
                    'cms_page_id'=>$postData['page_name'],
                    'page_type' => $postData['page_type'],
                    'page_title' => $postData['page_title'],
                    'page_desc' => $postData['page_desc'],
                    'meta_title' => $postData['meta_title'],
                    'meta_keywords' => $postData['meta_keywords'],
                    'meta_desc' => $postData['meta_desc'],
                    'show_after_login' => $postData['show_after_login'],
                    'page_target' => $postData['page_target'],
                    'icon_class' => $postData['icon_class'],
                    'page_url' => $postData['page_url'],
                    'page_order' => $postData['page_order'],
                    'page_image' => $base64string,
                    'created_date' => date('Y-m-d H:i:s'),
                    'created_by' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'menu_id' => $postData['menu_id'],
                ];
                //echo '<pre>';print_r($finalData);die();
                $url = $this->apiUrl() . "/cms-pages/cmsMenuPages";
                $val = $this->post($url, $finalData);
                $JsonData = $val->getBody();
                $JsonData = Json::decode($JsonData, true);

                if ((!empty($JsonData)) && (!$JsonData['error'])) {
                    $this->flashMessenger()->addMessage(array('success' => 'Page create Successfully.'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'Page not created'));
                }
                $this->redirect()->toRoute('menu', ['action' => 'index']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function editCmsPageAction() {
        $getview='';
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        CmsPageForm::$menuGroup = $this->getMenuGroupListData();
        CmsPageForm::$pageOrder = $this->getNumberList();

        $form = new CmsPageForm();
        $getview = $this->params()->fromQuery('data');
        $id = $this->params()->fromQuery('id');
        if($getview !=''){ $id=$getview;}
        $url = $this->apiUrl() . "/cms-pages/" . $id;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        $form->setData($data);
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $this->getRequest()->getPost()->toArray();
            $form->setData($postData);
            $form->getInputFilter()->get('menu_group_id')->setRequired(false);
            $form->getInputFilter()->get('page_name')->setRequired(false);
            $form->getInputFilter()->get('menu_name')->setRequired(false);
            $form->getInputFilter()->get('menu_order')->setRequired(false);
            if ($form->isValid()) {
                $finalData = [];
                if (isset($_FILES['page_image']['name']) && $_FILES['page_image']['name'] != '') {
                    $file = $_FILES['page_image']['tmp_name'];
                    $file    = file_get_contents($file);
                    $base64string    = base64_encode($file);
                    $uploaddir = $_SERVER['DOCUMENT_ROOT'];
                    $file = '/upload/cms_image/';
                    $fileName= 'cms_pages'.date('Y-m-d_h-i-s');
                    $filepath = $uploaddir . $file . $fileName;
                    $data1['base64image']= $base64string;
                    $data1['filepath']= $filepath;
                    $this->uploadimageapi($data1);
                }else{
                    $base64string = "";
                }
                //echo $filepath; die;


                $finalData = [
                    'company_setup_id' => $this->config()->getConfig()->company->companyId,
                    'page_type' => $postData['page_type'],
                    'page_title' => $postData['page_title'],
                    'page_desc' => $postData['page_desc'],
                    'meta_title' => $postData['meta_title'],
                    'meta_keywords' => $postData['meta_keywords'],
                    'meta_desc' => $postData['meta_desc'],
                    'show_after_login' => $postData['show_after_login'],
                    'page_target' => $postData['page_target'],
                    'icon_class' => $postData['icon_class'],
                    'page_url' => $postData['page_url'],
                    'page_order' => $postData['page_order'],
                    'page_image'=> $fileName,
                    'modified_by' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'id' => $postData['id']
                ];

                $val = '{"id": "' . $postData['id'] . '"}';
                $val = rawurlencode($val);
                $url = $this->apiUrl() . "/cms-pages/upsertWithWhere?where=" . $val;
                $val = $this->post($url, $finalData);
                $JsonData = $val->getBody();
                $JsonData = Json::decode($JsonData, true);
                if ((!empty($JsonData)) && (!$JsonData['error'])) {
                    $this->flashMessenger()->addMessage(array('success' => 'Page Updated Successfully.'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'Page not Updated.'));
                }
                $this->redirect()->toRoute('menu', ['action' => 'cms-pages']);
            }else{
                //echo '<pre>';print_r($form->getMessages());die();
            }
        }
        $viewModel = new ViewModel(['form' => $form, 'view'=>$getview]);
        return $viewModel;
    }


    /**
     * Get Numbers List
     * @return JSON
     */
    public function getPositionList() {
        $data = [];
        $data = [
            'Footer-link' => 'Footer-link',
            'Header-link' => 'Header-link',
            'Any other link' => 'Any other link'
        ];
        return $data;
    }

    /**
     * Get Numbers List
     * @return JSON
     */
    public function getNumberList() {
        $data = [];
        $data = [
            '1' => '1',
            '2' => '2',
            '3' => '3',
            '4' => '4',
            '5' => '5',
            '6' => '6',
            '7' => '7',
            '8' => '8',
            '9' => '9',
            '10' => '10'
        ];
        return $data;
    }

    /**
     * Get Menu Group Listing
     * @return JSON
     */
    public function getMenuGroupList() {
        $company_setup_id = $this->config()->getConfig()->company->companyId;

        $val = '{"where":{"and": [{"company_setup_id": "' . $company_setup_id . '"},{"status": {"neq": 2}}]}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/menu-group?&filter=" . $val;
        $resp = $this->get($url);
        $menuGroupList = Json::decode($resp->getBody(), true);
        //echo '<pre>';print_r($menuGroupList);die();
        if ($menuGroupList != "") {
            $val = ["status" => true, "data" => Json::decode($resp->getBody(), true)];
        } else {
            $val = ["status" => false, "data" => Json::decode($resp->getBody(), true)];
        }
        return $val;
    }

    /** Function to change MENU GROUP STATUS */
    public function menuGroupStatusAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        //print_r($data); die;
        $id = implode(',', $data['selected']);
        $menu_group_status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'status' => $menu_group_status];
        $this->updateMenuGroupStatus($data);
        $menuGroupListing = $this->getMenuGroupList();
        //echo '<pre>';print_r($menuGroupListing['data']);die();
        $viewModel = new ViewModel(['menuGroupListing' => $menuGroupListing['data']]);
        $viewModel->setTemplate('dashboard/menu/menu-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    /** Function to change VEHICLE TYPE STATUS */
    public function pageStatusAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        //print_r($data); die;
        $id = implode(',', $data['selected']);
        $page_status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'status' => $page_status];

        $this->updatePageStatus($data);
        $pageListing    =   $this->getCmsPagesList();
        $viewModel = new ViewModel(['pageListing' => $pageListing['data']]);
        $viewModel->setTemplate('dashboard/menu/page-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }



    /** Function to Delete Cms Page */
    public function deleteCmsPageAction() {

        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $id = $this->params()->fromQuery('id');

        $data = ['user_id' => $user_id, 'id' => $id, 'status' => 2];
        $response=$this->updatePageStatus($data);

        if($response){
         $this->redirect()->toRoute('menu', ['action' => 'cms-pages']);
            $this->flashMessenger()->addMessage(array('success' => $msg));
        } else {
            $msg = "Record Could Not Delete..!";
            $this->redirect()->toRoute('menu', ['action' => 'cms-pages']);
            $this->flashMessenger()->addMessage(array('danger' => $msg));
        }


    }

    /** Function to Update MENU GROUP STATUS */
    public function updateMenuGroupStatus($data) {
        $url = $this->apiUrl() . "/menu-group/menuGroupStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        //echo '<pre>';print_r($data);die();
        return $data;
    }

    /** Function to Update CMS PAGE STATUS */
    public function updatePageStatus($data) {
        //echo '<pre>';print_r($data);die();
        $url = $this->apiUrl() . "/cms-pages/pageStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        //echo '<pre>';print_r($data);die();
        return $data;
    }

    /** Function to show SUB MENU */
    public function showSubMenuAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        $group_id = $data['group_id'];
        $pageListing = $this->getSubMenuGroupList($group_id);
        //echo '<pre>';print_r($pageListing['data']);die();
        $viewModel = new ViewModel(['pageListing' => $pageListing['data']]);
        $viewModel->setTemplate('dashboard/menu/sub-menu-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function getMenuGroupListData() {
        $menuGroupJsonDataArray = [];
        $company_setup_id = $this->config()->getConfig()->company->companyId;
        $val = '{"where": {"company_setup_id": "' . $company_setup_id . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/menu-group?&filter=" . $val;
        $resp = $this->get($url);
        $menuGroupJsonData = Json::decode($resp->getBody(), true);
        foreach ($menuGroupJsonData as $res) {
            $menuGroupJsonDataArray[$res['group_id']] = $res['group_name'];
        }
        return $menuGroupJsonDataArray;
    }

    public function getPagesList() {
        $menuGroupJsonDataArray = [];
        $company_setup_id = $this->config()->getConfig()->company->companyId;
        $val = '{"where": {"company_setup_id": "' . $company_setup_id . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/cms-pages?&filter=" . $val;
        $resp = $this->get($url);
        $menuGroupJsonData = Json::decode($resp->getBody(), true);
        foreach ($menuGroupJsonData as $res) {
            $menuGroupJsonDataArray[$res['id']] = $res['page_title'];
        }
        return $menuGroupJsonDataArray;
    }


    /**
     * Get Menu Group Listing
     * @return JSON
     */
    public function getCmsPagesList() {
        $company_setup_id = $this->config()->getConfig()->company->companyId;
        $val = '{"where":{"and": [{"company_setup_id": "'.$company_setup_id.'"},{"status": {"neq": "2"}}]}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/cms-pages?&filter=" . $val;
        $resp = $this->get($url);
        $cmsPagesList = Json::decode($resp->getBody(), true);
        //echo '<pre>';print_r($cmsPagesList);die();
        if ($cmsPagesList != "") {
            $val = ["status" => true, "data" => Json::decode($resp->getBody(), true)];
        } else {
            $val = ["status" => false, "data" => Json::decode($resp->getBody(), true)];
        }
        return $val;
    }

    /**
     * Get Menu Group Page Listing
     * @return JSON
     */
    public function getSubMenuGroupList($group_id) {
        $val = '{"where": {"menu_group_id": "' . $group_id . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/cms-menu?&filter=" . $val;
        $resp = $this->get($url);
        $cmsPagesList = Json::decode($resp->getBody(), true);
        //echo '<pre>';print_r($cmsPagesList);die();
        if ($cmsPagesList != "") {
            $val = ["status" => true, "data" => Json::decode($resp->getBody(), true)];
        } else {
            $val = ["status" => false, "data" => Json::decode($resp->getBody(), true)];
        }
        return $val;
    }

    public function uploadimageapi($arrval = array()) {
        $url = $this->apiUrl() . "/user/uploadImg";
        $val = $this->post($url, $arrval);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);
    }

}
