<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Dashboard\Form\{
    MemberShipPackageAddNewForm,
    MembershipFeatureForm
};

use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Zend\Json\Json;
use Zend\Session\Container;
use Zend\Debug\Debug;
use Dashboard\Model\CommonModel;

class MemberShipPackageController extends AbstractActionController {
    
    public function __construct() {
        $this->CommonModel = new CommonModel();
    }
    
    public function indexAction(){
        
       
        $membershipListing = [
            '0'=>[
                'id'=>'1',
                'package_name'=>'Silver',
                'cost'=>'India',
                'validity'=>'Delhi',
                'images'=>'',
                'data1'=>'',
                'data2'=>'',
            ],
            '1'=>[
                 'id'=>'2',
                'package_name'=>'Gold',
                'cost'=>'India',
                'validity'=>'Delhi',
                'images'=>'',
                'data1'=>'',
                'data2'=>'',
            ],
            '2'=>[
                 'id'=>'3',
                'package_name'=>'Silver',
                'cost'=>'India',
                'validity'=>'Delhi',
                'images'=>'',
                'data1'=>'',
                'data2'=>'',
            ],
            '3'=>[
                 'id'=>'4',
                'package_name'=>'Gold',
                'cost'=>'India',
                'validity'=>'Delhi',
                'images'=>'',
                'data1'=>'',
                'data2'=>'',
            ]
            
        ];
        // print_r($membershipListing); die;
       // \Zend\Debug\Debug::dump($membershipListing); 
        $viewModel = new ViewModel(['membershipListing'=>$membershipListing]);
        return $viewModel;
    }
    
    public function featuresAction(){
        $data = "";
        $status = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        $data = [];
        $featureListing = $this->CommonModel->getMembershipFeatures($data);
        $viewModel = new ViewModel(['featureListing'=>$featureListing]);
        return $viewModel;
    }
    
    
     /** Function to change VEHICLE TYPE STATUS */
    public function featuresStatusAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        //print_r($data); die;
        $id = implode(',', $data['selected']);
        $feature_status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'status' => $feature_status];
        $this->CommonModel->updateFeaturesStatus($data);
        $data = [];
        $featureListing = $this->CommonModel->getMembershipFeatures($data);
        $viewModel = new ViewModel(['featureListing'=>$featureListing]);
        $viewModel->setTemplate('/dashboard/member-ship-package/features-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function deleteFeatureAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id'=>$userId, 'status'=>2];
        $this->CommonModel->updateFeaturesStatus($data);
        $this->redirect()->toRoute('membership-package', ['action' => 'features']);
        $this->flashMessenger()->addMessage(array('success' => 'Feature Delete Successfully'));
    }
    
    public function addNewAction(){
        
        $form = new MemberShipPackageAddNewForm();
        $viewModel = new ViewModel(['form'=>$form]);
        //$viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function addFeatureAction(){
        $data = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;        
        $form = new MembershipFeatureForm();
        $request = $this->getRequest();
        if ($request->isPost()) {
            $post = $request->getPost()->toArray();
            $form->setData($post);
            if ($form->isValid()) {
                //echo '<pre>';print_r($post);die();
                $data = [];
                if (isset($_FILES['feature_image']['name']) && $_FILES['feature_image']['name'] != '') {
                    $file = $_FILES['feature_image']['tmp_name'];
                    $file    = file_get_contents($file);
                    $base64string    = base64_encode($file);
                    $uploaddir = $_SERVER['DOCUMENT_ROOT'];
                    $file = '/upload/feature_image/';
                    $fileName= time() .'-'. $_FILES['feature_image']['name'];
                    $filepath = $uploaddir . $file . $fileName;
                    $data1['base64image']= $base64string;
                    $data1['filepath']= $filepath;
                    $this->CommonModel->uploadimageapi($data1);
                }else{
                    $base64string = "";
                }
                $data = [
                    'company_id' => $this->config()->getConfig()->company->companyId,
                    'feature_name' => $post['feature_name'],
                    'feature_desc' => $post['feature_desc'],
                    'image_path' => $fileName,
                    'status' => $post['status'],
                    'created_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                //echo '<pre>';print_r($data);die();
                $insertStatus = $this->CommonModel->addMembershipFeature($data);
                //echo '<pre>';print_r($insertStatus);die();
                if ($insertStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Details added successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'Details not added..'));
                }
                $this->redirect()->toRoute('membership-package', ['action' => 'features']);
            }
        }
        $viewModel = new ViewModel(['form'=>$form]);
        //$viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function editFeatureAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $form = new MembershipFeatureForm();
        $id = $this->params()->fromQuery('id');
        $data=[
            'auto_id'=>$id
        ];

        $vehicleData = $this->CommonModel->getMembershipFeatures($data);
        $vehicleData = $vehicleData[0];
        //Debug::dump($vehicleData); exit;
        $vehicleTypeStatus = $vehicleData['status'];
        $form->setData($vehicleData);
        $form->get('feature_id')->setValue($vehicleData['id']);
        
        $request = $this->getRequest();
        if ($request->isPost()) {
            $post = $request->getPost()->toArray();
            $form->setData($post);
            if ($form->isValid()) {
                $data1=[
                'auto_id'=>$post['feature_id']
                ];
                //echo '<pre>';print_r($data1);//die();
                $vehicleData1 = $this->CommonModel->getMembershipFeatures($data1);
                $vehicleData1 = $vehicleData1[0];
                //echo '<pre>';print_r($vehicleData1);die();
                $data = [];
                if (isset($_FILES['feature_image']['name']) && $_FILES['feature_image']['name'] != '') {
                    $file = $_FILES['feature_image']['tmp_name'];
                    $file    = file_get_contents($file);
                    $base64string    = base64_encode($file);
                    $uploaddir = $_SERVER['DOCUMENT_ROOT'];
                    $file = '/upload/feature_image/';
                    $fileName= time() .'-'. $_FILES['feature_image']['name'];
                    $filepath = $uploaddir . $file . $fileName;
                    $data1['base64image']= $base64string;
                    $data1['filepath']= $filepath;
                    $this->CommonModel->uploadimageapi($data1);
                }else{
                    $base64string = "";
                    $fileName = $vehicleData1['image_path'];
                }
                
                $data = [
                    'auto_id' => $post['feature_id'],
                    'company_id' => $this->config()->getConfig()->company->companyId,
                    'feature_name' => $post['feature_name'],
                    'feature_desc' => $post['feature_desc'],
                    'image_path' => $fileName,
                    'status' => $post['status'],
                    'modified_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                //echo '<pre>';print_r($data);die();
                $insertStatus = $this->CommonModel->updateMembershipFeature($data);
                if ($insertStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Details updated successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'Details not updated..'));
                }
                $this->redirect()->toRoute('membership-package', ['action' => 'features']);
            }
        }


        $viewModel = new ViewModel(['form' => $form,  'vehicle_type_id' => $id, 'status' => $vehicleTypeStatus]);
        return $viewModel;
    }
    
    public function changeRecordStatusAction() {
        $status=0;
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if($postData['status']==0 || $postData['status']==2){
                $status=1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->CommonModel->updateFeaturesStatus($data);
        }
        $data = [];
        $featureListing = $this->CommonModel->getMembershipFeatures($data);
        $viewModel = new ViewModel(['featureListing'=>$featureListing]);
        $viewModel->setTemplate('/dashboard/member-ship-package/features-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
}

