<?php

namespace Dashboard\Controller;

//use Zend\Mvc\Controller\AbstractActionController;
use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Dashboard\Form\MarkupForm;
use Dashboard\Form\MarkupAddUserForm;
use Application\Controller\RestAPIClientController;
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\Debug\Debug;
use Dashboard\Model\User;
use Zend\Json\Json;
use Zend\Session\Container;
use Dashboard\Model\CommonModel;


class MarkupController extends RestAPIClientController {

    public function __construct() {
        $this->userModel = new User();
        $this->commonModel = new CommonModel();
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 03-May-2022
     * @description : SHOW ALL THE MARKUPS RESPECTIVE TO BOOKING TYPE
     * @param $data
     * @returns $responsedata
     */
    public function indexAction() {
        $type = $this->params()->fromRoute('type');
        $masterBookType= $this->config()->getConfig()->masterBookType->$type;
        MarkupAddUserForm::$country = $this->userModel->getCountryList();
        MarkupAddUserForm:: $booking_type = $this->commonModel->getPackageListAction($masterBookType);
        MarkupAddUserForm:: $user_grade_type = $this->getUserTypeGradeList();

        $form = new MarkupAddUserForm();
        $markupListing = [];

        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $userTypeId = $loginData['user_type_id'];
        if ($userTypeId == 10) {
            $userId = "";
        }


        $companyId = $this->config()->getConfig()->company->companyId;
        $url = $this->apiUrl() . "/markup/getCompanyMarkup?company_id=" . $companyId . "&created_by=" . $userId ."&master_booking_type_id=" .$masterBookType;

        $val = $this->get($url);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);

        if ((!empty($JsonData) && $JsonData['responsedata']['status'] == 'success')) {
            $markupListing = $JsonData['responsedata']['data'];
        }
        $viewModel = new ViewModel(['form' => $form, 'markupListing' => $markupListing, 'type'=>$type]);
        return $viewModel;
    }
    

    /**
     * Add Markup Booking
     * @return ViewModel
     */
    public function addMarkupBookingAction() {

        MarkupAddUserForm:: $booking_type = $this->getPackageTypeList();

        $markup_type = [
            '1' => 'Fixed',
            '2' => 'percentage',
            '3' => 'Any',
        ];
        MarkupAddUserForm::$markup_type = $markup_type;

        $form = new MarkupAddUserForm();
        $request = $this->getRequest();

        if ($request->isPost()) {
            $post = $request->getPost()->toArray();


            //\Zend\Debug\Debug::dump($post);

            $form->setData($request->getPost());

            if ($form->isValid()) {
                //echo 'niharika';die;
                return $this->redirect()->toRoute('markup', ['action' => 'index']);
            } else {

                //echo 'aggarwal';die;
                //$msg=$form->getMessages();
                //Debug::dump($msg);
                //die;
            }
        }


        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    /**
     * Add Markup City
     * @return ViewModel
     */
    public function addMarkupCityAction() {
        //write code here...

        $viewModel = new ViewModel();
        return $viewModel;
    }

    /**
     * Add Markup Country
     * @return ViewModel
     */
    public function addMarkupCountryAction() {
        //write code here...

        $viewModel = new ViewModel();
        return $viewModel;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO ADD THE NEW MARKUP
     * @param $data
     * @returns $responsedata
     */
    public function addMarkupUserAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $type = $this->params()->fromRoute('type');
        $companyId = $this->config()->getConfig()->company->companyId;
        $masterBookType= $this->config()->getConfig()->masterBookType->$type;

        MarkupAddUserForm::$country = $this->userModel->getCountryList();
        MarkupAddUserForm:: $booking_type = $this->commonModel->getPackageListAction($masterBookType);
        MarkupAddUserForm:: $user_grade_type = $this->getUserTypeGradeList();
        MarkupAddUserForm::$currency = $this->getCurrencyList();

        $form = new MarkupAddUserForm();
        $request = $this->getRequest();


        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            $finalData = [];
            $finalData = [
                'user_grade' => $postData['user_grade_type'],
                'company_id' => $companyId,
                'markup_amt_type' => $postData['addmarkupType'],
                'country_id' => $postData['country_id'],
                'state_id' => $postData['state_id'],
                'currency' => $postData['currency'],
                'markup_category' => $postData['markup'],
                'city_id' => $postData['city_id'],
                'markup_amount' => $postData['markup_amount'],
                'markup_amt_base' => $postData['addmarkupAmountT'],
                'extra_km' => $postData['extra_km'],
                'extra_min' => $postData['extra_min'],
                'master_package_id' => $postData['booking_type'],
                'user_id' => $postData['driver_value'],
                'ip' => $_SERVER['REMOTE_ADDR'],
                'created_by' => $userId,
                'master_booking_type_id'=>$postData['master_booking_type_id'],
            ];
            //echo'<pre>';print_r($finalData);die();

            $url = $this->apiUrl() . "/markup/addCompanyMarkup";
            $val = $this->post($url, $finalData);
            $JsonData = $val->getBody();
            $JsonData = Json::decode($JsonData, true);

            if ((!empty($JsonData)) && !isset($JsonData['error'])) {
                $masterBookTypeId= $this->config()->getConfig()->masterBookTypeId[$postData['master_booking_type_id']];
                $msg = "Markup Details Updated Successfully..";
                $url =    'index/'.$masterBookTypeId;
                $this->redirect()->toUrl($url);
                //$this->redirect()->toRoute('markup', ['action' => 'index']);
                $this->flashMessenger()->addMessage(array('success' => $msg));
            } else {
                $msg = "Markup Details Could Not Added Successfully..";
                $this->redirect()->toRoute('markup', ['action' => 'add-markup-user']);
                $this->flashMessenger()->addMessage(array('danger' => $msg));
            }
            $form->setData($request->getPost());
        }

        $viewModel = new ViewModel(['form' => $form, 'masterBookType'=>$masterBookType, 'type'=>$type]);

        return $viewModel;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE THE MARKUP
     * @param $data
     * @returns $responsedata
     */
    public function editMarkupUserAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $markupdata = [];

        $markupId = $this->params()->fromQuery('id');
        $companyId = $this->params()->fromQuery('company_id');
        $type = $this->params()->fromQuery('type');
        $masterBookType= $this->config()->getConfig()->masterBookType->$type;

        MarkupAddUserForm::$country = $this->userModel->getCountryList();
        MarkupAddUserForm:: $booking_type = $this->commonModel->getPackageListAction($masterBookType);
        MarkupAddUserForm:: $user_grade_type = $this->getUserTypeGradeList();
        MarkupAddUserForm::$currency = $this->getCurrencyList();

        $form = new MarkupAddUserForm();
        $request = $this->getRequest();

        if ($markupId != '' && $companyId != '') {
            $url = $this->apiUrl() . "/markup/getCompanyMarkup?company_id=" . $companyId . "&markup_id=" . $markupId;
            $val = $this->get($url);
            $JsonData = $val->getBody();
            $JsonData = Json::decode($JsonData, true);

            if ((!empty($JsonData['responsedata']) && isset($JsonData['responsedata']['data'][0]))) {
                $markupdata = $JsonData['responsedata']['data'][0];
                if ($markupdata['markup_category'] == 4 || $markupdata['markup_category']==5) {
                    if($markupdata['markup_category'] == 4) {
                    $urlStateCity = $this->apiUrl() . "/city/stateCountry?city_id=" . $markupdata['city_id'];
                    $val1 = $this->get($urlStateCity);
                    $JsonData1 = $val1->getBody();
                    $JsonData1 = Json::decode($JsonData1, true);
                    $JsonData1 = $JsonData1['response'][0];
                    
                    $stateList = $this->getStateList($JsonData1['country_id']);
                    //echo "<pre>"; print_r($stateList); die;
                    if (!empty($stateList['data'])) {
                        foreach ($stateList['data'] as $val) {
                            $list[$val['id']] = $val['name'];
                        }
                        $form->get('state_id')->setValueOptions($list);
                        $form->get('state_id')->setValue($JsonData1['state_id']);
                    }

                    $cityList = $this->getCityList($JsonData1['state_id']);
                    if (!empty($cityList['data'])) {
                        foreach ($cityList['data'] as $val) {
                            $list1[$val['id']] = $val['name'];
                        }
                        $form->get('city_id')->setValueOptions($list1);
                        $form->get('city_id')->setValue($markupdata['city_id']);
                    }
                    }
                    
                     if($markupdata['markup_category'] == 5) {
                            $stateList = $this->getStateList($markupdata['country_id']);
                            //echo "<pre>"; print_r($stateList); die;
                            if (!empty($stateList['data'])) {
                            foreach ($stateList['data'] as $val) {
                               $list[$val['id']] = $val['name'];
                            }
                            $form->get('state_id')->setValueOptions($list);
                            $form->get('state_id')->setValue($JsonData1['state_id']);
                            }
                        
                     }
                }
            }
        }


        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            
             if($postData['addmarkupType']=='%'){
                $currencyId = 0;
            }else{
                $currencyId = $postData['currency'];
            }

            $finalData = [];
            $finalData = [
                'markup_id' => $postData['markup_id'],
                'user_grade' => $postData['user_grade_type'],
                'company_id' => $postData['company_id'],
                'markup_amt_type' => $postData['addmarkupType'],
                'country_id' => $postData['country_id'],
                'state_id' => $postData['state_id'],
                'currency' => $currencyId,
                'markup_category' => $postData['markup'],
                'city_id' => $postData['city_id'],
                'markup_amount' => $postData['markup_amount'],
                'markup_amt_base' => $postData['addmarkupAmountT'],
                'extra_km' => $postData['extra_km'],
                'extra_min' => $postData['extra_min'],
                'master_package_id' => $postData['booking_type'],
                'user_id' => $postData['driver_value'],
                'modified_by' => $userId,
                'ip' => $_SERVER['REMOTE_ADDR'],
                'master_booking_type_id' => $postData['master_booking_type_id']
            ];
            
            //echo "<pre>";            print_r($finalData); die;

            $url = $this->apiUrl() . "/markup/updatemarkup";
            $val = $this->post($url, $finalData);
            $JsonData = $val->getBody();
            $JsonData = Json::decode($JsonData, true);

            if ((!empty($JsonData)) && !isset($JsonData['error'])) {
                $masterBookTypeId= $this->config()->getConfig()->masterBookTypeId[$postData['master_booking_type_id']];
                $msg = "Markup Details Updated Successfully..";
                $url =    'index/'.$masterBookTypeId;
                $this->redirect()->toUrl($url);
                //$this->redirect()->toRoute('markup', ['action' => $action ]);
                $this->flashMessenger()->addMessage(array('success' => $msg));
            } else {
                $msg = "Markup Details Could Not Updated Successfully..";
                $this->redirect()->toRoute('markup', ['action' => 'edit-markup-user']);
                $this->flashMessenger()->addMessage(array('danger' => $msg));
            }
            $form->setData($request->getPost());
        }

        $viewModel = new ViewModel(['form' => $form, 'markupdata' => $markupdata, 'type'=> $type]);
        return $viewModel;
    }

    /**
     * Markup Middle Links
     * @return ViewModel
     */
    public function markupMiddleLinksAction() {
        //write code here...

        $viewModel = new ViewModel();
        return $viewModel;
    }

    /**
     * Markup Search Booking
     * @return ViewModel
     */
    public function markupSearchBookingAction() {
        //write code here...

        $viewModel = new ViewModel();
        return $viewModel;
    }

    /**
     * Markup Search Country
     * @return ViewModel
     */
    public function markupSearchCountryAction() {
        //write code here...

        $viewModel = new ViewModel();
        return $viewModel;
    }

    /**
     * Markup Search User
     * @return ViewModel
     */
    public function markupSearchUserAction() {
        //write code here...

        $viewModel = new ViewModel();
        return $viewModel;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FILTER THE MARKUP DATA
     * @param $data
     * @returns $responsedata
     */
    public function filterMarkupDataAction() {
        $companyId = $this->config()->getConfig()->company->companyId;
        $markupListing = [];
        $postData = $this->getRequest()->getPost()->toArray();

        $markup = isset($postData['markup']) ? $postData['markup'] : '';
        $driver_value = isset($postData['driver_value']) ? $postData['driver_value'] : '';
        $user_grade_type = isset($postData['user_grade_type']) ? $postData['user_grade_type'] : '';
        $country_id = isset($postData['country_id']) ? $postData['country_id'] : '';
        $city_id = isset($postData['city_id']) ? $postData['city_id'] : '';
        $booking_type = isset($postData['booking_type']) ? $postData['booking_type'] : '';
        $querystr = '';

        if ($companyId != '') {
            $querystr .= "company_id=" . $companyId;
        }
        if ($markup != '') {
            $querystr .= "&markp_type=" . $markup;
        }
        if ($country_id != 0) {
            $querystr .= "&country_id=" . $country_id;
        }
        if ($city_id != 0) {
            $querystr .= "&city_id=" . $city_id;
        }
        if ($booking_type != 0) {
            $querystr .= "&master_package_id=" . $booking_type;
        }
        if ($driver_value != '') {
            $querystr .= "&user_id=" . $driver_value;
        }
        if ($user_grade_type != '') {
            $querystr .= "&user_grade=" . $user_grade_type;
        }

        $url = $this->apiUrl() . "/markup/getCompanyMarkup?" . $querystr;
        $resp = $this->get($url);
        $JsonData = Json::decode($resp->getBody(), true);

        if ((!empty($JsonData) && $JsonData['responsedata']['status'] == 'success')) {
            $markupListing = $JsonData['responsedata']['data'];
        }
        $viewModel = new ViewModel(['markupListing' => $markupListing]);
        $viewModel->setTemplate('/dashboard/markup/markup-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET ALL THE DRIVER LIST DATA
     * @param $data
     * @returns $responsedata
     */

    public function getDriverListAction() {
        $request = $this->getRequest();
        $postdata = $request->getPost();
        $term = $postdata['term'];
        $post = [
            'first_name'=>$postdata['term'],
            'user_type_id'=>'6,7,9',
        ];
        //echo "<pre>";        print_r($post); die;
       /*$val = '{"where":{ "and" :[{"first_name":{"like": "' . $term . '%"}},{"user_type_id":{"like": "6,7,9%"}}]},"limit":10}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/user?filter=" . $val;
        $resp = $this->get($url);
        $driverJsonData = Json::decode($resp->getBody(), true);*/
        $url = $this->apiUrl() . "/user/getUserList";
        $resp = $this->post($url,$post);
        $driverJsonData = Json::decode($resp->getBody(), true);
        //echo "<pre>"; print_r($driverJsonData); die;
        if (!empty($driverJsonData['responsedata'])) {
            foreach ($driverJsonData['responsedata'] as $value) {
                $name= $value['first_name'].' '.$value['last_name'].' - '.$value['email'].' - '.$value['mobile'];
                $data[] = ["label" => $name, "value" => $value['id']];
            }
        } else {
            $data[] = ["label" => 'Not Exist'];
        }
        $view = new JsonModel($data);
        return $view;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET ALL THE PACKAGE TYPE DATA
     * @param $data
     * @returns $responsedata
     */

    public function getPackageTypeList() {
        $packageTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/package";
        $resp = $this->get($url);
        $packageTypeJsonData = Json::decode($resp->getBody(), true);
        foreach ($packageTypeJsonData['data'] as $res) {
            $packageTypeJsonDataArray[$res['id']] = $res['name'];
        }
        return $packageTypeJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH ALL THE USER GRADE LIST DATA
     * @param $data
     * @returns $responsedata
     */

    public function getUserTypeGradeList() {
        $gradeTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/user-grade";
        $resp = $this->get($url);
        $gradeTypeJsonData = Json::decode($resp->getBody(), true);

        foreach ($gradeTypeJsonData as $res) {
            $gradeTypeJsonDataArray[$res['id']] = $res['grade_name'];
        }

        return $gradeTypeJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO SOFT DELETE THE MARKUP DATA
     * @param $data
     * @returns $responsedata
     */

    public function deleteMarkupAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $type = $this->params()->fromQuery('type');
        $data = ['id' => $id, 'user_id'=>$userId,'markup_status'=>2];
        $this->userModel->updateMarkupStatus($data);
        $url =    'index/'.$type;
        $this->redirect()->toUrl($url);
    }

    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET THE STATE LIST
     * @param $data
     * @returns $responsedata
     */
    
    public function getStateList($country_id) {
        $val = '{"where": {"country_id": "' . $country_id . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/state?filter=" . $val;
        $resp = $this->get($url);
        $stateData = Json::decode($resp->getBody(), true);
        //echo '<pre>';print_r($stateData);die();
        if (!empty($stateData)) {
            foreach ($stateData as $value) {
                $data[] = ["id" => $value['id'], "name" => $value['name']];
            }
            $response = ["status" => true, "data" => $data];
        } else {
            $response = ["status" => false];
        }
        return $response;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO GET THE CITY LIST DATA
     * @param $data
     * @returns $responsedata
     */

    public function getCityList($state_id) {
        $val = '{"where": {"state_id": "' . $state_id . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/city?filter=" . $val;
        $resp = $this->get($url);
        $cityData = Json::decode($resp->getBody(), true);
        //echo '<pre>';print_r($stateData);die();
        if (!empty($cityData)) {
            foreach ($cityData as $value) {
                $data[] = ["id" => $value['id'], "name" => $value['name']];
            }
            $response = ["status" => true, "data" => $data];
        } else {
            $response = ["status" => false];
        }
        return $response;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE THE MARKUP STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function markupStatusAction() {
        $data1 = [];
        $data1['company_id'] = $this->config()->getConfig()->company->companyId;

        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $user_id = $loginData['user_id'];
        $userTypeId = $loginData['user_type_id'];
        if ($userTypeId == 10) {
            $userId = "";
        }

        $data = $this->getRequest()->getPost();
        $explodeData = explode('-',$data['selected'][0]);
        $values = "";
        foreach($data['selected'] as $val){
            $dataVal = explode('-',$val);
            $values != "" && $values .= ",";
            $values .= $dataVal[0];
        }
        $id = implode(',', $data['selected']);
        $markup_status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $values, 'markup_status' => $markup_status];
        $this->userModel->updateMarkupStatus($data);
        $companyId = $this->config()->getConfig()->company->companyId;
        $url = $this->apiUrl() . "/markup/getCompanyMarkup?company_id=" . $companyId . "&created_by=" . $userId . "&master_booking_type_id=" .$explodeData[1];
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);
        if ((!empty($JsonData) && $JsonData['responsedata']['status'] == 'success')) {
            $markupListing = $JsonData['responsedata']['data'];
        }
        $type= $this->config()->getConfig()->masterBookTypeId[$explodeData[1]];
        $viewModel = new ViewModel(['markupListing' => $markupListing,'type'=>$type]);
        $viewModel->setTemplate('/dashboard/markup/markup-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO FETCH THE MARKUP HISTORY LIST
     * @param $data
     * @returns $responsedata
     */
    
    public function markupHistoryAction() {        
        $companyId = $this->config()->getConfig()->company->companyId;
        $markupListing = [];
        $postData = $this->getRequest()->getPost()->toArray();
        $markup = isset($postData['markup']) ? $postData['markup'] : '';
        $driver_value = isset($postData['driver_value']) ? $postData['driver_value'] : '';
        $user_grade_type = isset($postData['user_grade_type']) ? $postData['user_grade_type'] : '';
        $country_id = isset($postData['country_id']) ? $postData['country_id'] : '';
        $city_id = isset($postData['city_id']) ? $postData['city_id'] : '';
        $booking_type = isset($postData['booking_type']) ? $postData['booking_type'] : '';
        $markup_id = isset($postData['markup_id']) ? $postData['markup_id'] : '';
        $querystr = '';

        if ($companyId != '') {
            $querystr .= "company_id=" . $companyId;
        }
        if ($markup != '') {
            $querystr .= "&markp_type=" . $markup;
        }
        if ($country_id != 0) {
            $querystr .= "&country_id=" . $country_id;
        }
        if ($city_id != 0) {
            $querystr .= "&city_id=" . $city_id;
        }
        if ($booking_type != 0) {
            $querystr .= "&master_package_id=" . $booking_type;
        }
        if ($driver_value != '') {
            $querystr .= "&user_id=" . $driver_value;
        }
        if ($user_grade_type != '') {
            $querystr .= "&user_grade=" . $user_grade_type;
        }
        if ($markup_id != '') {
            $querystr .= "&markup_id=" . $markup_id;
        }
        
        $url = $this->apiUrl() . "/markup/getCompanyMarkupLogs?" . $querystr;
        $resp = $this->get($url);
        $JsonData = Json::decode($resp->getBody(), true);

        if ((!empty($JsonData) && $JsonData['responsedata']['status'] == 'success')) {
            $markupListing = $JsonData['responsedata']['data'];
        }
        $viewModel = new ViewModel(['markupListing' => $markupListing]);
        $viewModel->setTemplate('/dashboard/markup/markup-history');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-May-2022
     * @description : FUNCTION TO UPDATE THE STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function changeRecordStatusAction() {
        $status=0;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $user_id = $loginData['user_id'];
        $userTypeId = $loginData['user_type_id'];
        if ($userTypeId == 10) {
            $userId = "";
        }
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            $explodeData = explode('-',$postData['id']);
            if($postData['status']==0 || $postData['status']==2){
                $status=1;
            }
            $data = ['user_id' => $user_id, 'id' => $explodeData[0], 'markup_status' => $status];
            $this->userModel->updateMarkupStatus($data);
        }
        $companyId = $this->config()->getConfig()->company->companyId;
        $url = $this->apiUrl() . "/markup/getCompanyMarkup?company_id=" . $companyId . "&created_by=" . $userId . "&master_booking_type_id=" .$explodeData[1];
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);
        if ((!empty($JsonData) && $JsonData['responsedata']['status'] == 'success')) {
            $markupListing = $JsonData['responsedata']['data'];
        }
        $type= $this->config()->getConfig()->masterBookTypeId[$explodeData[1]];
        $viewModel = new ViewModel(['markupListing' => $markupListing, 'type'=>$type]);
        $viewModel->setTemplate('/dashboard/markup/markup-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function getCurrencyList() {
        $currencyTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/master-currency";
        $resp = $this->get($url);
        $currencyTypeJsonData = Json::decode($resp->getBody(), true);
        foreach ($currencyTypeJsonData as $res) {
            $currencyTypeJsonDataArray[$res['id']] = $res['name'];
        }
        return $currencyTypeJsonDataArray;
    }
}
