<?php

namespace Dashboard\Controller;

use Application\Controller\RestAPIClientController;
use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Zend\Json\Json;
use Zend\Session\Container;
use Zend\Debug\Debug;
use Dashboard\Model\CommonModel;

class InventoryManagementController extends RestAPIClientController {

    public function __construct() {
        $this->CommonModel = new CommonModel();
    }

    public function transportAction() {
        $data=[];
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $userId = $userData['user_id'];
        if($userTypeId!='10'){
            $data['created_by']=$userId;
        }
        //echo '<pre>';print_r($data);die();
        $vehicleList = $this->getAllVehicleList($data);
        $hash = [];
        $vehicleTypeArray = [];
        foreach($vehicleList as $item) {
        $hash_key = $item['vehicle_type_id'].'|'.$item['vehicle_type_name'];
        if(!array_key_exists($hash_key, $hash)) {
            $hash[$hash_key] = sizeof($vehicleTypeArray);
            array_push($vehicleTypeArray, array(
                'id' => $item['vehicle_type_id'],
                'vehicle_type_name' => $item['vehicle_type_name'],
                'count' => 0,
            ));
        }
            $vehicleTypeArray[$hash[$hash_key]]['count'] += 1;
        }
        //echo '<pre>';print_r($vehicleTypeArray);//die();
        //$inventory  =   usort($vehicleTypeArray,function ($item1,$item2){
        //if ($item1['id'] == $item2['id']) return 0;
        //return ($item1['id'] < $item2['id']) ? 1 : -1;
        //});
        //echo '<pre>';print_r($inventory);die();
        //die;
        $viewModel = new ViewModel([
            'vehicleList'=>$vehicleList,
            'vehicleTypeArray'=>$vehicleTypeArray
        ]);
        return $viewModel;
    }
    
    public function packageAction() {
        $viewModel = new ViewModel();
        return $viewModel;
    }
    
    public function hotelAction() {
        $viewModel = new ViewModel();
        return $viewModel;
    }

    public function activityAction() {
        $data=[];
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $userId = $userData['user_id'];
        if($userTypeId!='10'){
            $data['created_by']=$userId;
        }
        $activityList = $this->getActivityList($data);
        //echo '<pre>';print_r($activityList);die();
        $hash = [];
        $activityListArray = [];
        foreach($activityList as $item) {
        $hash_key = $item['city_id'].'|'.$item['city_name'];
        if(!array_key_exists($hash_key, $hash)) {
            $hash[$hash_key] = sizeof($activityListArray);
            array_push($activityListArray, array(
                'id' => $item['city_id'],
                'city_name' => $item['city_name'],
                'count' => 0,
            ));
        }
            $activityListArray[$hash[$hash_key]]['count'] += 1;
        }
        $viewModel = new ViewModel([
            'activityListArray'=>$activityListArray
        ]);
        return $viewModel;
    }
    
    public function getVehicleListAction() {
        $data=[];
        $vehicleArray = [];
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $userId = $userData['user_id'];
        if($userTypeId!='10'){
            $data['created_by']=$userId;
        }
        $postData = $this->getRequest()->getPost();
        $vehicleList = $this->getAllVehicleList($data);
        //echo '<pre>';print_r($postData);die();
        $filter_id = $postData['id'];
        if($filter_id!='All'){
        $vehicleArray = array_filter($vehicleList, function ($var) use ($filter_id) {
            return ($var['vehicle_type_id'] == $filter_id);
        });
        }else{
        $vehicleArray = $vehicleList;
        }        
        //echo '<pre>';print_r($newArray);die();
        if(!empty($vehicleArray)) {
            foreach ($vehicleArray as $value) {
                if ($value['vehicle_model_name'] != null) {
                    $data[] = ["id" => $value['vehicle_master_id'], "vehicle_name" => $value['vehicle_model_name'].' ('.$value['vehicle_no'].')'];
                }
            }
            $response = ["status" => true, "data" => $data];
        } else {
            $response = ["status" => false];
        }
        $view = new JsonModel($response);
        return $view;
        
    }
    
    /**
     *
     * Vehicle List...
     * @return ViewModel
     */
    public function getAllVehicleList($data) {
        $url = $this->apiUrl() . "/vehicle-master/getallvehicle";
        $resp = $this->post($url, $data);
        $vehiclelistJsonData = Json::decode($resp->getBody(), true);
        $vehicleList = [];
        if($vehiclelistJsonData['responsedata']['status']=='success'){
            $vehicleList = $vehiclelistJsonData['responsedata']['data'];
        }
        return $vehicleList;
        
    }
    
    public function getTransportEventsAction() {
        $data = [];
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $userId = $userData['user_id'];
        $data = [
            'user_id'=>$userId
        ];
        $statusData = $this->CommonModel->getTransportEventsDetails($data);
        $view = new JsonModel($statusData);
        return $view;
    }
    
    public function deleteTransportEventsAction() {
        $data = [];
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $userId = $userData['user_id'];
        $postData = $this->getRequest()->getPost();
        //echo '<pre>';print_r($postData);die();
        if($postData['vendor_status']==1){
            $status = 0;
        }else{
            $status = 1;
        }
        $data = [
            'user_id'=>$userId,
            'status'=>$status,
            'id'=>$postData['id']
        ];
        //echo '<pre>';print_r($data);die();
        $statusData = $this->CommonModel->updateTransportEventsStatus($data);
        if($statusData['response']['affectedRows']>0){
            $result = ['status'=>1];
        }
        //echo '<pre>';print_r($statusData);die();
        $view = new JsonModel($result);
        return $view;
    }
    
    public function addTransportEventsAction() {
        $data = [];
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $userId = $userData['user_id'];
        $postData = $this->getRequest()->getPost();
        //echo '<pre>';print_r($postData);die();
        $data = [
            'user_id'=>$userId,
            'booking_id'=>$postData['title'],
            'start_date'=>$postData['start'],
            'end_date'=>$postData['end'],
            'status'=>1,
            'ip'=>$_SERVER['REMOTE_ADDR'],
            'created_by'=>$userId            
        ];
        //echo '<pre>';print_r($data);die();
        $statusData = $this->CommonModel->addTransportEventsDetails($data);
        //echo '<pre>';print_r($statusData);die();
        if($statusData['responsedata']['status']=="success"){
            $result = ['status'=>1];
        }
        $view = new JsonModel($result);
        return $view;
    }
    
    
    public function updateTransportEventsAction() {
        $data = [];
        $result = [];
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $userId = $userData['user_id'];
        $postData = $this->getRequest()->getPost();
        //echo '<pre>';print_r($postData);die();
        $data = [
            'user_id'=>$userId,
            //'booking_id'=>$postData['title'],
            'start_date'=>$postData['start'],
            'end_date'=>$postData['end'],
            'status'=>1,
            'ip'=>$_SERVER['REMOTE_ADDR'],
            'modified_by'=>$userId,
            'auto_id'=>$postData['id'],
            
        ];
        //echo '<pre>';print_r($data);die();
        $statusData = $this->CommonModel->updateTransportEventsDetails($data);
        if($statusData['responsedata']['status']=="success"){
            $result = ['status'=>1];
        }
        $view = new JsonModel($result);
        return $view;
    }
    
    public function getActivityList() {
        $sightData = [];
        $data = [];
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $userId = $userData['user_id'];
        if($userTypeId!='10'){
            $data['created_by']=$userId;
        }
        $data['master_package_type']=$this->config()->getConfig()->masterPackage->activity;
        $url = $this->apiUrl() . "/sightseeing/listsightseeing";
        $resp = $this->post($url, $data);
        $packageFareData = Json::decode($resp->getBody(), true);        
        if (!empty($packageFareData)) {
            if ($packageFareData['responsedata']['status'] == "success") {
                $sightData = $packageFareData['responsedata']['data'];                
            }
        }      
        
        return $sightData;
    }
    
    public function getActivityListDetailsAction() {
        $data=[];
        $activityArray = [];
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $userId = $userData['user_id'];
        if($userTypeId!='10'){
            $data['created_by']=$userId;
        }
        $postData = $this->getRequest()->getPost();
        //$vehicleList = $this->getAllVehicleList($data);
        $activityList = $this->getActivityList($data);
        //echo '<pre>';print_r($postData);die();
        $filter_id = $postData['id'];
        if($filter_id!='All'){
        $activityArray = array_filter($activityList, function ($var) use ($filter_id) {
            return ($var['city_id'] == $filter_id);
        });
        }else{
        $activityArray = $activityList;
        }        
        //echo '<pre>';print_r($newArray);die();
        if(!empty($activityArray)) {
            foreach ($activityArray as $value) {
                if ($value['sightseeing_name'] != null) {
                    $data[] = ["id" => $value['s_id'], "sightseeing_name" => $value['sightseeing_name']];
                }
            }
            $response = ["status" => true, "data" => $data];
        } else {
            $response = ["status" => false];
        }
        $view = new JsonModel($response);
        return $view;
        
    }

}
