<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Application\Controller\RestAPIClientController;
use Dashboard\Form\HotelAddForm;
use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Zend\Json\Json;
use Zend\Session\Container;
use Dashboard\Model\CommonModel;
use Dashboard\Model\User;

class HotelController extends RestAPIClientController {

    public function __construct() {
        $this->CommonModel = new CommonModel();
        $this->userModel = new User();
    }

    /**
     * Index
     * @return ViewModel
     */
    public function indexAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $data = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getHotelDetailsList($data);
        //echo '<pre>';print_r($packageListing);die();
        $viewModel = new ViewModel(['packageListing' => $packageListing]);
        return $viewModel;
    }

    public function addHotelAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        HotelAddForm::$property_type = $this->CommonModel->getPropertyTypeList();
        HotelAddForm::$hotel_category = $this->CommonModel->getHotelCategoryList();
        $form = new HotelAddForm();
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            //echo '<pre>';print_r($postData);die();
            $form->setData($postData);
            if ($form->isValid()) {
                $finalData = [];
                $finalData = [
                    'company_id' => $this->config()->getConfig()->company->companyId,
                    'code' => $postData['code'],
                    'name' => $postData['name'],
                    'property_type' => $postData['property_type'],
                    'hotel_category' => $postData['hotel_category'],
                    'url' => $postData['url'],
                    'city_id' => $postData['destination_city_id'],
                    'location' => $postData['location'],
                    'featured' => $postData['featured'],
                    'preferred' => $postData['preferred'],
                    'total_floor' => $postData['total_floor'],
                    'total_rooms_single' => $postData['total_rooms_single'],
                    'total_rooms_double' => $postData['total_rooms_double'],
                    'total_rooms_twin' => $postData['total_rooms_twin'],
                    'total_rooms_disabled' => $postData['total_rooms_disabled'],
                    'check_in_time' => $postData['check_in_time'],
                    'check_out_time' => $postData['check_out_time'],
                    'total_conference_halls' => $postData['total_conference_halls'],
                    'total_board_rooms' => $postData['total_board_rooms'],
                    'total_party_lawns' => $postData['total_party_lawns'],
                    'description' => $postData['description'],
                    'created_date' => date('Y-m-d H:i:s'),
                    'user_id' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                //$get=array_filter($finalData);
                // $p=json_encode($get);
                //echo'<pre>';print_r($finalData);die();

                $responseData = $this->CommonModel->insertHotelDetails($finalData);
                //echo '<pre>';print_r($responseData);die();           
                if ($responseData['response']['status'] == 'success') {
                    $msg = "Details Added Successfully!..";
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Details Could Not Added!..";
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
                $this->redirect()->toRoute('hotel', ['action' => 'index']);
            }
//            else {
//                $msg = $form->getMessages();
//                echo '<pre>';
//                print_r($msg);
//                die();
//            }
        }

        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function editHotelAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        HotelAddForm::$property_type = $this->CommonModel->getPropertyTypeList();
        HotelAddForm::$hotel_category = $this->CommonModel->getHotelCategoryList();
        $form = new HotelAddForm();
        $id = $this->params()->fromQuery('id');
        $data = [
            'auto_id' => $id
        ];
        $vehicleData = $this->CommonModel->getHotelDetailsList($data);
        $vehicleData = $vehicleData[0];
        $form->setData($vehicleData);
        $form->get('id')->setValue($vehicleData['id']);
        $form->get('destination_city_id')->setValue($vehicleData['city_id']);
        $form->get('hotel_city')->setValue($vehicleData['city_name']);
        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            //echo '<pre>';print_r($postData);die();
            $form->setData($postData);
            if ($form->isValid()) {
                $finalData = [];
                $finalData = [
                    'company_id' => $this->config()->getConfig()->company->companyId,
                    'code' => $postData['code'],
                    'name' => $postData['name'],
                    'property_type' => $postData['property_type'],
                    'hotel_category' => $postData['hotel_category'],
                    'url' => $postData['url'],
                    'city_id' => $postData['destination_city_id'],
                    'location' => $postData['location'],
                    'featured' => $postData['featured'],
                    'preferred' => $postData['preferred'],
                    'total_floor' => $postData['total_floor'],
                    'total_rooms_single' => $postData['total_rooms_single'],
                    'total_rooms_double' => $postData['total_rooms_double'],
                    'total_rooms_twin' => $postData['total_rooms_twin'],
                    'total_rooms_disabled' => $postData['total_rooms_disabled'],
                    'check_in_time' => $postData['check_in_time'],
                    'check_out_time' => $postData['check_out_time'],
                    'total_conference_halls' => $postData['total_conference_halls'],
                    'total_board_rooms' => $postData['total_board_rooms'],
                    'total_party_lawns' => $postData['total_party_lawns'],
                    'description' => $postData['description'],
                    'modified_by' => $userId,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'auto_id' => $postData['id']
                ];
                //$get=array_filter($finalData);
                // $p=json_encode($get);
                //echo'<pre>';print_r($finalData);die();
                $responseData = $this->CommonModel->updateHotelDetails($finalData);
                //echo '<pre>';print_r($responseData);die();           
                if ($responseData['response']['status'] == 'success') {
                    $msg = "Details Added Successfully!..";
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Details Could Not Added!..";
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
                $this->redirect()->toRoute('hotel', ['action' => 'index']);
            }
//            else {
//                $msg = $form->getMessages();
//                echo '<pre>';
//                print_r($msg);
//                die();
//            }
        }

        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    /** Function to change HOTEL DETAILS STATUS */
    public function hotelDetailStatusAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        $id = implode(',', $data['selected']);
        $status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'status' => $status];
        $this->CommonModel->updateHotelStatus($data);
        $val = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getHotelDetailsList($val);
        $viewModel = new ViewModel(['packageListing' => $packageListing]);
        $viewModel->setTemplate('/dashboard/hotel/hotel-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function changeRecordStatusAction() {
        $status = 0;
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $request = $this->getRequest();
        if ($request->isPost()) {
            $postData = $request->getPost()->toArray();
            if ($postData['status'] == 0 || $postData['status'] == 2) {
                $status = 1;
            }
            $data = ['user_id' => $user_id, 'id' => $postData['id'], 'status' => $status];
            $this->CommonModel->updateHotelStatus($data);
        }
        $val = ['company_id' => $this->config()->getConfig()->company->companyId];
        $packageListing = $this->CommonModel->getHotelDetailsList($val);
        $viewModel = new ViewModel(['packageListing' => $packageListing]);
        $viewModel->setTemplate('/dashboard/hotel/hotel-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function deleteHotelDetailsAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $userId = $loginData['user_id'];
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id, 'user_id' => $userId, 'status' => 2];
        $this->CommonModel->updateHotelStatus($data);
        $this->redirect()->toRoute('hotel', ['action' => 'index']);
        $this->flashMessenger()->addMessage(array('success' => 'Details Delete Successfully'));
    }

}
