<?php

namespace Dashboard\Controller;

use Application\Controller\RestAPIClientController;
use Dashboard\Form\{
    UserAddBasicForm,
    UserAddCancellationFeesForm,
    UserAddPricePremiumForm,
    UserAddPriceFixedRoutesForm,
    UserAddShareForm,
    BookingMappingForm,
    PointConversionForm,
    ProfileCompanyDetailForm
};
use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Zend\Json\Json;
use Zend\Session\Container;
use Zend\Debug\Debug;
use Dashboard\Model\CommonModel;

class FareSettingController extends RestAPIClientController {

    public function __construct() {
        $this->CommonModel = new CommonModel();
    }

    public function indexAction() {
        $taxFare="";
        $taxFareDetails="";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        //$user_id = 6;
        $id = $this->params()->fromQuery('id');        
        $request = $this->getRequest();
        UserAddBasicForm::$booking_type = $this->CommonModel->getPackageTypeList();
        $form = new UserAddBasicForm();
        //$login_id = '1111';
        if(!empty($id)){
        $taxFare = $this->CommonModel->getUserTaxDetail($login_id,$id);
        $taxFare = $taxFare[0];
        }
        $taxFareDetails = $this->CommonModel->getUserTaxDetail($login_id,'');
        //$taxFareDetails
        //echo '<pre>';print_r($taxFareDetails);die();
        //echo '<pre>';print_r($taxFare[0]);die();
        if (!empty($taxFare)) {
            $form->setData($taxFare);
            $taxFareId = $taxFare['id'];            
        } else {
            $taxFareId = 0;
        }

        $fareSetting = $this->CommonModel->getFareSettingDetail($login_id);
        //echo '<pre>';print_r($fareSetting);die();
        if (!empty($fareSetting)) {
            $fareSettingId = $fareSetting['id'];
        } else {
            $fareSettingId = 0;
        }

        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            $form->setData($postdata);
            if($postdata['tax_save']=='Save & Next'){
            $form->getInputFilter()->get('booking_type')->setRequired(false);
            $form->getInputFilter()->get('sgst')->setRequired(false);
            $form->getInputFilter()->get('cgst')->setRequired(false);
            $form->getInputFilter()->get('igst')->setRequired(false);
            $form->getInputFilter()->get('tax_date_from')->setRequired(false);
            $form->getInputFilter()->get('tax_date_to')->setRequired(false);
            }
            if ($form->isValid()) {
                
                if($postdata['tax_save']=='Save'){
                    $addBasicFare = [
                        'user_id' => $login_id,
                        'booking_type' => $postdata['booking_type'],
                        'from_date' => date('Y-m-d', strtotime($postdata['tax_date_from'])),
                        'to_date' => date('Y-m-d', strtotime($postdata['tax_date_to'])),
                        'tax_type' => '%',
                        'sgst' => $postdata['sgst'],
                        'cgst' => $postdata['cgst'],
                        'igst' => $postdata['igst'],
                        'ip' => $_SERVER['REMOTE_ADDR'],
                        'status' => 1,
                        //'auto_id' => $taxFareId
                        'auto_id' => $postdata['tax_fare_id']
                    ];
                //echo '<pre>';print_r($addBasicFare);die();

                    if ($postdata['tax_fare_id'] > 0) {
                        $addBasicFare['modified_by'] = $login_id;
                        $resp = $this->CommonModel->updatetUserTaxDetail($addBasicFare);
                        $msg = $resp['message'];
                    } else if(isset($postdata['tax_save']) && ($postdata['tax_save']=='Save')) {
                        $addBasicFare['created_by'] = $login_id;
                        $resp = $this->CommonModel->addUserTaxDetail($addBasicFare);
                        $msg = "Data Insert Successfully";
                    }
                } else {
                    
                $basicfareSettings = [
                    'user_id' => $login_id,
                    'rounding' => $postdata['rounding'],
                    'level' => $postdata['level'],
                    'direction' => $postdata['direction'],
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'status' => 1,
                    'auto_id' => $fareSettingId
                ];
                //echo '<pre>';print_r($basicfareSettings);die();
                if ($fareSettingId > 0) {
                    $basicfareSettings['modified_by'] = $login_id;
                    $resp = $this->CommonModel->updateUserFareSettingDetail($basicfareSettings);
                    $msg = $resp['message'];
                } else {
                    $basicfareSettings['created_by'] = $login_id;
                    $resp = $this->CommonModel->addUserFareSettingDetail($basicfareSettings);
                    $msg = "Data Insert Successfully";
                }
                }
                //echo '<pre>';print_r($resp);die();
                $this->redirect()->toRoute('fare-setting', ['action' => 'index']);
                $this->flashMessenger()->addMessage(array('success' => $msg));
            }else{
                //$sm = $form->getMessages();
                //echo '<pre>';print_r($sm);die();
            }
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'tax-detail', 'taxFare' => $taxFare, 'taxFareDetails'=>$taxFareDetails, 'fareSetting' => $fareSetting]);
        return $viewModel;
    }

    public function addFeesFareAction() {
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;

        $request = $this->getRequest();
        UserAddCancellationFeesForm::$cancellation_type = $this->CommonModel->getCancellationTypeList();
        UserAddCancellationFeesForm::$booking_type = $this->CommonModel->getPackageTypeList();
        $form = new UserAddCancellationFeesForm();
        $cancellation_fare = $this->CommonModel->getUserCancellationFare($login_id);
        $waiting_fare = $this->CommonModel->getUserWaitingCharge($login_id);
        $pre_waiting_fare = $this->CommonModel->getUserPreWaitingCharge($login_id);
        $fareDetails = [
            'cancellation_fare' => $cancellation_fare,
            'waiting_fare' => $waiting_fare,
            'pre_waiting_fare' => $pre_waiting_fare,
        ];
        //$user_id = 6;
        if ($request->isPost()) {
            $postdata = $this->getRequest()->getPost()->toArray();
            //echo '<pre>';print_r($postdata);die();
            //$cancellation_fees_autoid = $postdata['cancellation_fees_id'];
            $waiting_charge_autoid = $postdata['waiting_charge_id'];
            $pre_waiting_charge_autoid = $postdata['pre_waiting_charge_id'];

            $cancellation_master_id = array_values(array_filter($postdata['cancellation_master_id']));
            $cancellation_type = array_values(array_filter($postdata['cancellation_type']));
            $cancellation_fees = array_values(array_filter($postdata['cancellation_fees']));

            if (!empty($cancellation_master_id) && !empty($cancellation_type)) {
                if (count($cancellation_master_id) > 0) {
                    for ($i = 0; $i < count($cancellation_master_id); $i++) {
                        $cancelFeesArr[] = [
                            'user_id' => $login_id,
                            'cancellation_master_id' => $cancellation_master_id[$i],
                            'cancellation_type' => $cancellation_type[$i],
                            'cancellation_value' => $cancellation_fees[$i],
                            'from_date' => date('Y-m-d', strtotime($postdata['cancel_date_from'])),
                            'to_date' => date('Y-m-d', strtotime($postdata['cancel_date_to'])),
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                        ];
                    }
                }
            }
            $cancelFeesArr1['cancelfaredata'] = $cancelFeesArr;
            $cancelFeesArr1['user_id'] = $login_id;

            //echo '<pre>';print_r($cancelFeesArr1);die();
            $resp = $this->CommonModel->addUserCancellationFareDetail($cancelFeesArr1);

            /* Add Waiting Fees */

            $waiting_time_min_upto = array_values(array_filter($postdata['waiting_time_minutes_upto']));
            $waiting_time_fees = array_values(array_filter($postdata['waiting_time_fees']));

            if (!empty($waiting_time_min_upto) && !empty($waiting_time_fees)) {
                if (count($waiting_time_min_upto) > 0) {
                    for ($i = 0; $i < count($waiting_time_min_upto); $i++) {
                        $waitingFeesArr[] = [
                            'user_id' => $login_id,
                            'waiting_minute_upto' => $waiting_time_min_upto[$i],
                            'waiting_fees' => $waiting_time_fees[$i],
                            'from_date' => date('Y-m-d', strtotime($postdata['cancel_date_from'])),
                            'to_date' => date('Y-m-d', strtotime($postdata['cancel_date_to'])),
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                        ];
                    }
                }
            }
            $waitingFeesArr1['waitingfaredata'] = $waitingFeesArr;
            $waitingFeesArr1['user_id'] = $login_id;
            //echo '<pre>';print_r($waitingFeesArr1);//die();
            $resp = $this->CommonModel->addUserWaitingChargeDetail($waitingFeesArr1);

            /* Add Pre Waiting Fees */

            $pre_waiting_time_min_upto = array_values(array_filter($postdata['pre_waiting_minutes_upto']));
            $pre_waiting_time_fees = array_values(array_filter($postdata['pre_waiting_fee']));


            if (!empty($pre_waiting_time_min_upto) && !empty($pre_waiting_time_fees)) {
                if (count($pre_waiting_time_min_upto) > 0) {
                    for ($i = 0; $i < count($pre_waiting_time_min_upto); $i++) {
                        $prewaitingFeesArr[] = [
                            'user_id' => $login_id,
                            'pre_waiting_upto_minutes' => $pre_waiting_time_min_upto[$i],
                            'pre_waiting_fees' => $pre_waiting_time_fees[$i],
                            'from_date' => date('Y-m-d', strtotime($postdata['cancel_date_from'])),
                            'to_date' => date('Y-m-d', strtotime($postdata['cancel_date_to'])),
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                        ];
                    }
                }
            }
            $prewaitingFeesArr1['prewaitingfaredata'] = $prewaitingFeesArr;
            $prewaitingFeesArr1['user_id'] = $login_id;
            //\echo '<pre>';print_r($prewaitingFeesArr1);//die();
            $resp = $this->CommonModel->addUserPreWaitingChargeDetail($prewaitingFeesArr1);


            $this->redirect()->toRoute('fare-setting', ['action' => 'add-price-premium']);
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'fees', 'fareDetails' => $fareDetails]);
        return $viewModel;
    }

    public function addPricePremiumAction() {
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        //$user_id = 6;

        $request = $this->getRequest();
        UserAddPricePremiumForm::$booking_type = $this->CommonModel->getPackageTypeList();
        $form = new UserAddPricePremiumForm();

        $night_charge = $this->CommonModel->getUserNightFare($login_id);
        $premiums_charge = $this->CommonModel->getUserPremiumsFare($login_id);
        $peak_time_fare = $this->CommonModel->getUserPeakTimeCharge($login_id);
        $extras_fare = $this->CommonModel->getUserExtraCharge($login_id);
        $fareDetails = [
            'night_charge' => $night_charge,
            'premiums_charge' => $premiums_charge,
            'peak_time_fare' => $peak_time_fare,
            'extras_fare' => $extras_fare
        ];

        if ($request->isPost()) {
            $postdata = $request->getPost()->toArray();
            $form->setData($postdata);
            $nightFareId = $postdata['night_premium_id'];
            $premiumsFareId = $postdata['premiums_id'];

            /// Night Fare STARTS HERE ///////////

            $nightFare = [
                'user_id' => $login_id,
                'from_date' => date('Y-m-d', strtotime($postdata['night_fare_date_from'])),
                'to_date' => date('Y-m-d', strtotime($postdata['night_fare_date_to'])),
                'night_rate_begins' => $postdata['night_rate_begins'],
                'night_rate_ends' => $postdata['night_rate_ends'],
                'night_rate_type' => $postdata['night_rate_type'],
                'night_rate_value' => $postdata['night_rate_value'],
                'ip' => $_SERVER['REMOTE_ADDR'],
                'status' => 1,
                'auto_id' => $nightFareId,
                'booking_type' => $postdata['booking_type']
            ];

            if ($nightFareId > 0) {
                $nightFare['modified_by'] = $login_id;
                $resp = $this->CommonModel->updateUserNightFareDetail($nightFare);
                $msg = $resp['message'];
            } else {
                $nightFare['created_by'] = $login_id;
                $resp = $this->CommonModel->addUserNightFareDetail($nightFare);
                $msg = "Data Insert Successfully";
            }

            /// Premiums Fare STARTS HERE ///////////

            $premiumsFare = [
                'user_id' => $login_id,
                'from_date' => date('Y-m-d', strtotime($postdata['premium_fare_date_from'])),
                'to_date' => date('Y-m-d', strtotime($postdata['premium_fare_date_to'])),
                'premiums_type' => $postdata['premiums_type'],
                'premiums_value' => $postdata['premiums_value'],
                'ip' => $_SERVER['REMOTE_ADDR'],
                'status' => 1,
                'auto_id' => $premiumsFareId,
                'booking_type' => $postdata['booking_type']
            ];

            if ($premiumsFareId > 0) {
                $premiumsFare['modified_by'] = $login_id;
                $resp = $this->CommonModel->updateUserPremiumFareDetail($premiumsFare);
                $msg = $resp['message'];
            } else {
                $premiumsFare['created_by'] = $login_id;
                $resp = $this->CommonModel->addUserPremiumFareDetail($premiumsFare);
                $msg = "Data Insert Successfully";
            }


            $peakStartTimeArr = array_values(array_filter($postdata['start_time']));
            $peakEndTime = array_values(array_filter($postdata['end_time']));
            $peakTimeValue = array_values(array_filter($postdata['peaktime_value']));

            if (!empty($peakStartTimeArr) && !empty($peakEndTime)) {
                if (count($peakStartTimeArr) > 0) {
                    for ($i = 0; $i < count($peakStartTimeArr); $i++) {
                        $peakTimeArr[] = [
                            'user_id' => $login_id,
                            'start_time' => $peakStartTimeArr[$i],
                            'end_time' => $peakEndTime[$i],
                            'peaktime_value' => $peakTimeValue[$i],
                            'peaktime_type' => '%',
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                        ];
                    }
                }
            }
            $peakTimeArr1['data'] = $peakTimeArr;
            $peakTimeArr1['user_id'] = $login_id;
            //echo '<pre>';print_r($peakTimeArr1);//die();
            $resp = $this->CommonModel->addUserPeakTimeChargeDetail($peakTimeArr1);


            $extra_value_1 = array_values(array_filter($postdata['extras_no_name1']));
            $extra_value_2 = array_values(array_filter($postdata['extras_no_name2']));
            //$extraValueType    = array_values(array_filter($postdata['extrasvaluetype']));

            if (!empty($extra_value_1) && !empty($extra_value_2)) {
                if (count($extra_value_1) > 0) {
                    for ($i = 0; $i < count($extra_value_1); $i++) {
                        $extrasArr[] = [
                            'user_id' => $login_id,
                            'extras_master_id' => $extra_value_1[$i],
                            'extra_value_type' => 'Rs',
                            'extra_value' => $extra_value_2[$i],
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                        ];
                    }
                }
            }
            $extrasArr1['data'] = $extrasArr;
            $extrasArr1['user_id'] = $login_id;
            // echo '<pre>';print_r($extrasArr1);die();
            $resp1 = $this->CommonModel->addUserExtraChargeDetail($extrasArr1);

            $this->redirect()->toRoute('fare-setting', ['action' => 'add-price-fixed-routes']);
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'premium', 'fareDetails' => $fareDetails]);
        return $viewModel;
    }

    public function addPriceFixedRoutesAction() {
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        //$user_id = 6;

        $request = $this->getRequest();
        UserAddPriceFixedRoutesForm::$booking_type = $this->CommonModel->getPackageTypeList();
        $form = new UserAddPriceFixedRoutesForm();

        $fix_route = $this->CommonModel->getUserFixRoute($login_id);
        $postal_fare = $this->CommonModel->getUserPostalCode($login_id);
        $fareDetails = [
            'fix_route' => $fix_route,
            'postal_fare' => $postal_fare,
        ];

        if ($request->isPost()) {
            $postdata = $request->getPost()->toArray();
            $form->setData($postdata);
            $fix_route_autoid = $postdata['fix_route_id'];

            /// Fixed Route STARTS HERE ///////////

            $addFixedRoute = [
                'user_id' => $login_id,
                'frequent_location' => $postdata['frequent_location'],
                'booking_type' => $postdata['booking_type'],
                'ip' => $_SERVER['REMOTE_ADDR'],
                'status' => 1,
                'auto_id' => $fix_route_autoid
            ];

            //echo '<pre>';print_r($addFixedRoute);die();

            if ($fix_route_autoid > 0) {
                $addFixedRoute['modified_by'] = $login_id;
                $resp = $this->CommonModel->updateUserFixRouteDetail($addFixedRoute);
                $msg = $resp['message'];
            } else {
                $addFixedRoute['created_by'] = $login_id;
                $resp = $this->CommonModel->addUserFixRouteDetail($addFixedRoute);
                $msg = "Data Insert Successfully";
            }

            $pickup_postcode = array_values(array_filter($postdata['pickup_postcode']));
            $drop_off_postcode = array_values(array_filter($postdata['drop_off_postcode']));
            $value = array_values(array_filter($postdata['value']));

            if (!empty($pickup_postcode) && !empty($drop_off_postcode)) {
                if (count($pickup_postcode) > 0) {
                    for ($i = 0; $i < count($pickup_postcode); $i++) {
                        $postalFareArr[] = [
                            'user_id' => $login_id,
                            'pickup_postcode' => $pickup_postcode[$i],
                            'drop_postcode' => $drop_off_postcode[$i],
                            'price' => $value[$i],
                            'created_by' => $login_id,
                            'status' => 1,
                            'ip' => $_SERVER['REMOTE_ADDR'],
                            'booking_type' => $postdata['booking_type'],
                        ];
                    }
                    //echo '<pre>';print_r($postalFareArr);//die();
                }
            }

            $postalFareArr1['postalcodedata'] = $postalFareArr;
            $postalFareArr1['user_id'] = $login_id;
            $resp = $this->CommonModel->addUserPostalCodeDetail($postalFareArr1);

            $this->redirect()->toRoute('fare-setting', ['action' => 'add-price-share']);
            $this->flashMessenger()->addMessage(array('success' => $msg));
        }


        $viewModel = new ViewModel(['form' => $form, 'tab' => 'fixed-routes', 'fareDetails' => $fareDetails]);
        return $viewModel;
    }

    public function addPriceShareAction() {
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;
        //$user_id = 6;

        $request = $this->getRequest();
        UserAddShareForm::$booking_type = $this->CommonModel->getPackageTypeList();
        $form = new UserAddShareForm();

        $share_fare = $this->CommonModel->getUserSharePrice($login_id);
        $fareDetails = [
            'share_fare' => $share_fare
        ];

        if ($request->isPost()) {
            $postdata = $request->getPost()->toArray();
            $form->setData($postdata);
            $compShareId = $postdata['comp_share_id'];
            $partnerShareId = $postdata['partner_share_id'];
            $driverShareId = $postdata['driver_share_id'];
            $msg = "Share Details Insert Successfully";
            if ($compShareId > 0 || $partnerShareId > 0 || $driverShareId > 0) {
                $msg = "Share Details Updated Successfully";
            }
            //Debug::dump($postdata); exit;

            if ($form->isValid()) {

                /* Comp Starts Here */
                $compShare = [
                    'user_id' => $login_id,
                    'share_type_id' => $postdata['company_share_type_id'],
                    'share_value_type' => $postdata['company_share_type'],
                    'share_value' => $postdata['company_share'],
                    'status' => 1,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'booking_type' => $postdata['booking_type'],
                    'auto_id' => $compShareId
                ];

                if ($compShareId > 0) {
                    $compShare['modified_by'] = $login_id;
                    $resp = $this->CommonModel->updateUserShareDetail($compShare);
                } else {
                    $compShare['created_by'] = $login_id;
                    $msg = "Share Details Created Successfully";
                    $resp = $this->CommonModel->addUserShareDetail($compShare);
                }


                /* Partner Starts Here */
                $partnerShare = [
                    'user_id' => $login_id,
                    'share_type_id' => $postdata['partner_share_type_id'],
                    'share_value_type' => $postdata['partner_share_type'],
                    'share_value' => $postdata['partner_share'],
                    'status' => 1,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'booking_type' => $postdata['booking_type'],
                    'auto_id' => $partnerShareId
                ];

                if ($partnerShareId > 0) {
                    $partnerShare['modified_by'] = $login_id;
                    $resp = $this->CommonModel->updateUserShareDetail($partnerShare);
                } else {
                    $partnerShare['created_by'] = $login_id;
                    $msg = "Share Details Created Successfully";
                    $resp = $this->CommonModel->addUserShareDetail($partnerShare);
                }

                /* Driver Starts Here */
                $driverShare = [
                    'user_id' => $login_id,
                    'share_type_id' => $postdata['driver_share_type_id'],
                    'share_value_type' => $postdata['driver_share_type'],
                    'share_value' => $postdata['driver_share'],
                    'status' => 1,
                    'ip' => $_SERVER['REMOTE_ADDR'],
                    'booking_type' => $postdata['booking_type'],
                    'auto_id' => $driverShareId
                ];

                if ($driverShareId > 0) {
                    $driverShare['modified_by'] = $login_id;
                    $resp = $this->CommonModel->updateUserShareDetail($driverShare);
                } else {
                    $driverShare['created_by'] = $login_id;
                    $msg = "Share Details Created Successfully";
                    $resp = $this->CommonModel->addUserShareDetail($driverShare);
                }
                $this->redirect()->toRoute('fare-setting', ['action' => 'add-price-share']);
                $this->flashMessenger()->addMessage(array('success' => $msg));
            }
        }
        $viewModel = new ViewModel(['form' => $form, 'tab' => 'share', 'fareDetails' => $fareDetails]);
        return $viewModel;
    }

    public function bookingTypeMappingAction() {
        $data = "";
        $status = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;

        BookingMappingForm::$booking_type = $this->CommonModel->getPackageTypeList();
        $form = new BookingMappingForm();
        $data = ['user_id' => $login_id];
        $mvehicleList = $this->CommonModel->getUserBookingTypeMappingDetail($data);
        $viewModel = new ViewModel(['form' => $form, 'mvehicleList' => $mvehicleList, 'status' => $status]);
        return $viewModel;
    }

    public function searchBookingMappingAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $val = $this->getRequest()->getPost();
        $data = [
            'booking_type' => $val['booking_type'],
            'user_id' => $user_id,
        ];
        //Call API...
        $mvehicleList = $this->CommonModel->getUserBookingTypeMappingDetail($data);
        $viewModel = new ViewModel(['mvehicleList' => $mvehicleList]);
        $viewModel->setTemplate('/dashboard/fare-setting/mapping-type-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    /** Function to change VEHICLE TYPE STATUS */
    public function bookingTypeMappingStatusAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        //print_r($data); die;
        $id = implode(',', $data['selected']);
        $booking_type_status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'mapping_status' => $booking_type_status];
        $this->CommonModel->updateBookingTypeMappingStatus($data);
        $val = ['user_id' => $user_id];
        $mvehicleList = $this->CommonModel->getUserBookingTypeMappingDetail($val);
        $viewModel = new ViewModel(['mvehicleList' => $mvehicleList]);
        $viewModel->setTemplate('/dashboard/fare-setting/mapping-type-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function addBookingTypeMappingAction() {
        $data = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        BookingMappingForm::$booking_type = $this->CommonModel->getPackageTypeList();
        BookingMappingForm::$booking_mode_type = $this->CommonModel->getPackageModeList();
        $form = new BookingMappingForm();
        $request = $this->getRequest();
        if ($request->isPost()) {
            $post = $request->getPost()->toArray();
            $form->setData($post);
            if ($form->isValid()) {
                //echo '<pre>';print_r($post);die();
                $data = [
                    'booking_type' => $post['booking_type'],
                    'booking_type_mode' => $post['booking_mode_type'],
                    'status' => $post['status'],
                    'user_id' => $user_id,
                    'created_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                //echo '<pre>';print_r($data);die();
                $insertStatus = $this->CommonModel->addUserMappingDetail($data);
                //echo '<pre>';print_r($insertStatus);die();
                if ($insertStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Mapping Details added successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'No Duplicate Entry Please....'));
                }
                $this->redirect()->toRoute('fare-setting', ['action' => 'booking-type-mapping']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function editBookingTypeMappingAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        BookingMappingForm::$booking_type = $this->CommonModel->getPackageTypeList();
        BookingMappingForm::$booking_mode_type = $this->CommonModel->getPackageModeList();
        $form = new BookingMappingForm();
        $id = $this->params()->fromQuery('id');
        $data=[
            'auto_id'=>$id,
            'user_id'=>$user_id
        ];

        $vehicleData = $this->CommonModel->getUserBookingTypeMappingDetail($data);
        $vehicleData = $vehicleData[0];
        //Debug::dump($vehicleData); exit;
        $bookingType = isset($vehicleData['master_package_id'])?$vehicleData['master_package_id']:'';
        $bookingModeType = isset($vehicleData['master_package_mode_id'])?$vehicleData['master_package_mode_id']:'';
        $vehicleTypeStatus = $vehicleData['status'];
        $form->get('booking_type')->setValue($bookingType);
        $form->get('booking_mode_type')->setValue($bookingModeType);
        $form->get('vehicle_type_id')->setValue($vehicleData['id']);
        $form->setData($vehicleData);
        $request = $this->getRequest();
        if ($request->isPost()) {
            $post = $request->getPost()->toArray();
            $form->setData($post);
            if ($form->isValid()) {
                $data = [
                    'auto_id' => $post['vehicle_type_id'],
                    'booking_type' => $post['booking_type'],
                    'booking_type_mode' => $post['booking_mode_type'],
                    'status' => $post['status'],
                    'modified_by' => $user_id,
                    'user_id' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                //echo '<pre>';print_r($data);die();
                $insertStatus = $this->CommonModel->updateUserMappingDetail($data);
                if ($insertStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Mapping Details updated successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'No Duplicate Entry Please....'));
                }
                $this->redirect()->toRoute('fare-setting', ['action' => 'booking-type-mapping']);
            }
        }


        $viewModel = new ViewModel(['form' => $form,  'vehicle_type_id' => $id, 'status' => $vehicleTypeStatus]);
        return $viewModel;
    }
    
    public function pointConversionAction() {
        $data = "";
        $status = "";
        $sessionContainer = new Container('userlogin');
        $userData = $sessionContainer->userData;
        $userTypeId = $userData['user_type_id'];
        $login_id = $sessionContainer->user_id;

        PointConversionForm::$booking_type = $this->CommonModel->getPackageTypeList();
        PointConversionForm::$user_type = $this->CommonModel->getUserTypeList();
        PointConversionForm::$user_grade = $this->CommonModel->getUserTypeGradeList();
        $form = new PointConversionForm();
        $data = ['user_id' => $login_id];
        $mvehicleList = $this->CommonModel->getPointConversionDetail($data);
        $viewModel = new ViewModel(['form' => $form, 'mvehicleList' => $mvehicleList, 'status' => $status]);
        return $viewModel;
    }
    
    public function searchPointConversionAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $val = $this->getRequest()->getPost();
        $data = [
            'booking_type' => $val['booking_type'],
            'user_type' => $val['user_type'],
            'user_grade' => $val['user_grade'],
            'user_id' => $user_id,
            'status'=> $val['status']
        ];
        //Call API...
        $mvehicleList = $this->CommonModel->getPointConversionDetail($data);
        $viewModel = new ViewModel(['mvehicleList' => $mvehicleList]);
        $viewModel->setTemplate('/dashboard/fare-setting/point-conversion-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    /** Function to change VEHICLE TYPE STATUS */
    public function pointConversionStatusAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        //print_r($data); die;
        $id = implode(',', $data['selected']);
        $point_status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'status' => $point_status];
        $this->CommonModel->updatePointConversionStatus($data);
        $val = ['user_id' => $user_id];
        $mvehicleList = $this->CommonModel->getPointConversionDetail($val);
        $viewModel = new ViewModel(['mvehicleList' => $mvehicleList]);
        $viewModel->setTemplate('/dashboard/fare-setting/point-conversion-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function addPointConversionAction() {
        $data = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        PointConversionForm::$booking_type = $this->CommonModel->getPackageTypeList();
        PointConversionForm::$user_type = $this->CommonModel->getUserTypeList();
        PointConversionForm::$user_grade = $this->CommonModel->getUserTypeGradeList();
        $form = new PointConversionForm();
        $request = $this->getRequest();
        if ($request->isPost()) {
            $post = $request->getPost()->toArray();
            $form->setData($post);
            if ($form->isValid()) {
                //echo '<pre>';print_r($post);die();
                $data = [
                    'booking_type' => $post['booking_type'],
                    'user_type' => $post['user_type'],
                    'user_grade' => $post['user_grade'],
                    'points' => $post['points'],
                    'conversion_rate' => $post['conversion_rate'],
                    'status' => $post['status'],
                    'created_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                //echo '<pre>';print_r($data);die();
                $insertStatus = $this->CommonModel->addpointconversiondetail($data);
                //echo '<pre>';print_r($insertStatus);die();
                if ($insertStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Details added successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'No Duplicate Entry Please....'));
                }
                $this->redirect()->toRoute('fare-setting', ['action' => 'point-conversion']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }
    
    
    public function editPointConversionAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        PointConversionForm::$booking_type = $this->CommonModel->getPackageTypeList();
        PointConversionForm::$user_type = $this->CommonModel->getUserTypeList();
        PointConversionForm::$user_grade = $this->CommonModel->getUserTypeGradeList();
        $form = new PointConversionForm();
        $id = $this->params()->fromQuery('id');
        $data=[
            'auto_id'=>$id
        ];

        $vehicleData = $this->CommonModel->getPointConversionDetail($data);
        $vehicleData = $vehicleData[0];
        //Debug::dump($vehicleData); exit;
        $bookingType = isset($vehicleData['master_package_id'])?$vehicleData['master_package_id']:'';
        $userType = isset($vehicleData['user_type_id'])?$vehicleData['user_type_id']:'';
        $userGrade = isset($vehicleData['user_grade_id'])?$vehicleData['user_grade_id']:'';
        $vehicleTypeStatus = $vehicleData['status'];
        $form->setData($vehicleData);
        $form->get('booking_type')->setValue($bookingType);
        $form->get('user_type')->setValue($userType);
        $form->get('user_grade')->setValue($userGrade);
        $form->get('vehicle_type_id')->setValue($vehicleData['id']);
        
        $request = $this->getRequest();
        if ($request->isPost()) {
            $post = $request->getPost()->toArray();
            $form->setData($post);
            if ($form->isValid()) {
                $data = [
                    'auto_id' => $post['vehicle_type_id'],
                    'booking_type' => $post['booking_type'],
                    'user_type' => $post['user_type'],
                    'user_grade' => $post['user_grade'],
                    'points' => $post['points'],
                    'conversion_rate' => $post['conversion_rate'],
                    'status' => $post['status'],
                    'modified_by' => $user_id,
                    'ip' => $_SERVER['REMOTE_ADDR']
                ];
                //echo '<pre>';print_r($data);die();
                $insertStatus = $this->CommonModel->updatepointconversiondetail($data);
                if ($insertStatus['responsedata']['status'] == "success") {
                    $this->flashMessenger()->addMessage(array('success' => 'Conversion Details updated successfully...'));
                } else {
                    $this->flashMessenger()->addMessage(array('error' => 'No Duplicate Entry Please....'));
                }
                $this->redirect()->toRoute('fare-setting', ['action' => 'point-conversion']);
            }
        }


        $viewModel = new ViewModel(['form' => $form,  'vehicle_type_id' => $id, 'status' => $vehicleTypeStatus]);
        return $viewModel;
    }
    
    /**
     * Company Detail...
     * @return ViewModel
     */
    public function officeAction() {
        $msg = "";
        $msg_color = "";
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;

        $form = new ProfileCompanyDetailForm();
        $request = $this->getRequest();

        $url = $this->apiUrl() . "/company/companydetails?user_id=" . $userId;
        $val = $this->get($url);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);
        if ($JsonData['responsedata']['status'] == true) {
            $userDetails = $JsonData['responsedata'];
            $form->get('state_value')->setValue($userDetails['state']);
            $form->get('city_value')->setValue($userDetails['city']);
            $form->setData($userDetails);
        }

        if ($request->isPost()) {
            $postData = $this->getRequest()->getPost()->toArray();
            $form->setData($postData);
            if ($form->isValid()) {
                $finalData = [];
                $finalData = [
                    'company_name' => $postData['company_name'],
                    'company_address' => $postData['company_address'],
                    'state' => $postData['state_value'],
                    'city' => $postData['city_value'],
                    'service_tax_gst' => $postData['service_tax_gst'],
                    'pancard_no' => $postData['pancard_no'],
                    'contact_person_name' => $postData['contact_person_name'],
                    'landline_no' => $postData['landline_no'],
                    'mobile_no' => $postData['mobile_no'],
                    'email' => $postData['email'],
                    'website_url' => $postData['website_url'],
                    //'logo' => $postData['logo'],
                    'user_id' => $userId,
                    'country' => 101,
                    'pincode' => $postData['pincode'],
                    'id' => $userDetails['id']
                ];
                //print_r($finalData); exit;

                $url = $this->apiUrl() . "/company";
                $val = $this->put($url, $finalData);
                $JsonData = $val->getBody();
                $JsonData = Json::decode($JsonData, true);
                //print_r($JsonData); exit;

                if ((!empty($JsonData))) {
                    $msg = "Office Details Updated Successfully";
                    $msg_color = "green";
                } else {
                    $msg = "Office Details Not Updated";
                    $msg_color = "red";
                }
            }
        }

        $viewModel = new ViewModel(['form' => $form, 'tab' => 'company-details', 'msg' => $msg, 'msg_color' => $msg_color]);
        return $viewModel;
    }
    

}
