<?php

namespace Dashboard\Controller;

use Application\Controller\RestAPIClientController;
use Zend\View\Model\ViewModel;
use Zend\Session\Container;
use Zend\Json\Json;

class CompanyPriceController extends RestAPIClientController {

    private $localPackageType = 1;
    private $pointPackageType = 2;
    private $airportPackageType = 3;
    private $outstationPackageType = 4;
    private $onewayPackageType = 5;

    /**
     * Index
     * @return ViewModel
     */
    public function indexAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $userTypeId = $loginData['user_type_id'];
        $data = [];
        $data = [
            'company_id' => $this->config()->getConfig()->company->companyId,
            'package_id' => $this->localPackageType,
        ];

        $data['vendor_id'] = $user_id;

        $localListing = $this->getCompanyPriceList($data);
        $viewModel = new ViewModel(['localListing' => $localListing, 'tab' => 'local-booking']);
        return $viewModel;
    }

    /**
     * Point To Point
     * @return ViewModel
     */
    public function pointToPointAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $userTypeId = $loginData['user_type_id'];
        $data = [];
        $data = [
            'company_id' => $this->config()->getConfig()->company->companyId,
            'package_id' => $this->pointPackageType,
        ];

        $data['vendor_id'] = $user_id;

        $pointToPointListing = $this->getCompanyPriceList($data);
        $viewModel = new ViewModel(['pointToPointListing' => $pointToPointListing, 'tab' => 'poin-to-point']);
        return $viewModel;
    }

    /**
     * Airport Transfer
     * @return ViewModel
     */
    public function airportTransferAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $userTypeId = $loginData['user_type_id'];
        $data = [];
        $data = [
            'company_id' => $this->config()->getConfig()->company->companyId,
            'package_id' => $this->airportPackageType,
        ];

        $data['vendor_id'] = $user_id;

        $airportTransferListing = $this->getCompanyPriceList($data);
        $viewModel = new ViewModel(['airportTransferListing' => $airportTransferListing, 'tab' => 'airport-transfer']);
        return $viewModel;
    }

    /**
     * Outstation
     * @return ViewModel
     */
    public function outstationAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $userTypeId = $loginData['user_type_id'];
        $data = [];
        $data = [
            'company_id' => $this->config()->getConfig()->company->companyId,
            'package_id' => $this->outstationPackageType,
        ];

        $data['vendor_id'] = $user_id;

        $outstationListing = $this->getCompanyPriceList($data);
        $viewModel = new ViewModel(['outstationListing' => $outstationListing, 'tab' => 'outstation']);
        return $viewModel;
    }

    /**
     * One WayTaxi
     * @return ViewModel
     */
    public function oneWayTaxiAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $userTypeId = $loginData['user_type_id'];
        $data = [];
        $data = [
            'company_id' => $this->config()->getConfig()->company->companyId,
            'package_id' => $this->onewayPackageType,
        ];

        $data['vendor_id'] = $user_id;
        $oneWayTaxiListing = $this->getCompanyPriceList($data);
        $viewModel = new ViewModel(['oneWayTaxiListing' => $oneWayTaxiListing,'tab' => 'oneway']);
        return $viewModel;
    }

    /**
     *
     * Vehicle Type List...
     * @return ViewModel
     */
    public function getCompanyPriceList($data) {
        $val = '?company_id=' . $data['company_id'] . '&package_id=' . $data['package_id'] . '&vendor_id=' . $data['vendor_id'];
        $url = $this->apiUrl() . "/fare_management/companyPrice" . $val;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data['responsedata'];
    }

}
