<?php

namespace Dashboard\Controller;

use Application\Controller\RestAPIClientController;
use Zend\View\Model\{
    ViewModel,
    JsonModel
};
use Dashboard\Form\{
    BookingHistorySearchForm,
    BookingClientSearchForm,
    BookingDriverSearchForm,
    BookingGeneralSearchForm,
    BookingLocationSearchForm,
    BookingPaymentSearchForm,
    BookingStatusSearchForm,
    BookingVehicleSearchForm
};
use Zend\Json\Json;
use Zend\Session\Container;
use Zend\Debug\Debug;
use Dashboard\Model\Booking;
use Dashboard\Model\Vehicle;
use Dashboard\Model\User;

class BookingHistoryController extends RestAPIClientController {

    public function __construct() {
        $this->bookingModel = new Booking();
        $this->vehicleModel = new Vehicle();
        $this->userModel = new User();
    }

    public function indexAction() {
        $statusData = $this->getRequest()->getQuery()->toArray();
        //echo '<pre>';print_r($statusData);die();
        $data = [];
        $tab_type = "";
        BookingGeneralSearchForm:: $bookingType = $this->getPackageTypeList();
        $form = new BookingGeneralSearchForm();
        $request = $this->getRequest();
        if (!empty($statusData)) {
            /*if ($statusData['type'] == 'current') {
                $data = ['multi_status' => '222', 'booking_pickup_date' => date('Y-m-d')];
            }if ($statusData['type'] == 'future') {
                $data = ['multi_status' => '111', 'booking_pickup_date' => date('Y-m-d')];
            }if ($statusData['type'] == 'complete') {
                $data = ['status' => '11'];
            }if ($statusData['type'] == 'pending') {
                $data = ['status' => '1'];
            }if ($statusData['type'] == 'cancel') {
                $data = ['status' => '10,20'];
            }*/

            if($statusData['booking_id'] != '') {
                $data = ['booking_id' => $statusData['booking_id']];
            }
            $bookingHistory = $this->getBookingSearchData($data);
        } else {
            $bookingHistory = $this->getBookingHistoryData($data);
        }

        $bookingHistoryListing = $bookingHistory;
        //echo '<pre>';print_r($bookingHistoryListing);die();
        $viewModel = new ViewModel([
            'form' => $form,
            'bookingHistoryListing' => $bookingHistoryListing,
            'tab_type' => $tab_type,
            'google_map_url' => $this->config()->getConfig()->google_map->url,
            'google_map_key' => $this->config()->getConfig()->google_map->key,
        ]);
        return $viewModel;
    }

    /**
     * search
     * @return ViewModel
     */
    public function searchBookingHistoryAction() {
        $data = [];
        $postData = $this->getRequest()->getPost()->toArray();
        $data = array_filter($postData);
        $bookingHistory = $this->getBookingSearchData($data);
        //echo '<pre>';print_r($bookingHistory);die();
        $viewModel = new ViewModel(['bookingHistoryListing' => $bookingHistory]);
        $viewModel->setTemplate('/dashboard/booking-history/booking-history-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }


    public function bookingAutoListAction() {
        $data = [];
        $bookingHistory = $this->getBookingHistoryData($data);
        //echo '<pre>';print_r($bookingHistory);die();
        $viewModel = new ViewModel(['bookingHistoryListing' => $bookingHistory]);
        $viewModel->setTemplate('/dashboard/booking-history/booking-history-listing');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function clientTabAction() {

        $clientrating = [
            '1' => '*',
            '2' => '**',
            '3' => '***',
            '4' => '****',
            '5' => '*****'
        ];
        BookingClientSearchForm::$clientrating = $clientrating;
        $request = $this->getRequest();

        if ($request->isPost()) {

            $post = $request->getPost()->toArray();
            //echo'<pre>';print_r($post);die();
            $tab_type = (isset($post['tab_type'])) ? $post['tab_type'] : '';
        }

        $form = new BookingClientSearchForm();
        $viewModel = new ViewModel(['form' => $form, 'tab_type' => $tab_type]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    /**
     * dateTimeBookingType...
     * @return ViewModel
     */
    public function dateTimeBookingTypeAction() {
        //write code here...

        if ($request->isPost()) {

            $post = $request->getPost()->toArray();
            $tab_type = (isset($post['tab_type'])) ? $post['tab_type'] : '';
        }

        $form = new BookingClientSearchForm();
        $viewModel = new ViewModel(['form' => $form, 'tab_type' => $tab_type]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    /**
     * driverTab...
     * @return ViewModel
     */
    public function driverTabAction() {
        //write code here...

        $driverrating = [
            '1' => '*',
            '2' => '**',
            '3' => '***',
            '4' => '****',
            '5' => '*****'
        ];
        $request = $this->getRequest();
        if ($request->isPost()) {

            $post = $request->getPost()->toArray();
            $tab_type = (isset($post['tab_type'])) ? $post['tab_type'] : '';
        }
        BookingDriverSearchForm::$driverrating = $driverrating;
        $form = new BookingDriverSearchForm();
        $viewModel = new ViewModel(['form' => $form]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    /**
     * generalTab...
     * @return ViewModel
     */
    public function generalTabAction() {
        BookingGeneralSearchForm:: $bookingType = $this->getPackageTypeList();
        $form = new BookingGeneralSearchForm();
        //$form->setData($bookinggeneral);

        $viewModel = new ViewModel(['form' => $form]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    /**
     * listingOfBooking...
     * @return ViewModel
     */
    public function listingOfBookingAction() {
        //write code here...

        $viewModel = new ViewModel();
        return $viewModel;
    }

    /**
     * locationTab...
     * @return ViewModel
     */
    public function locationTabAction() {
        //write code here...
        BookingLocationSearchForm:: $stateList = $this->getStateList();
        $form = new BookingLocationSearchForm();
        $viewModel = new ViewModel(['form' => $form]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    /**
     * paymentTab...
     * @return ViewModel
     */
    public function paymentTabAction() {
        //write code here...

        $paymenttype = [
            '1' => 'Cash',
            '2' => 'Credit'
        ];
        BookingPaymentSearchForm::$paymenttype = $paymenttype;

        $ispaid = [
            '1' => 'Yes',
            '2' => 'No'
        ];
        BookingPaymentSearchForm::$ispaid = $ispaid;

        $form = new BookingPaymentSearchForm();
        $viewModel = new ViewModel(['form' => $form]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    /**
     * statusTab...
     * @return ViewModel
     */
    public function statusTabAction() {
        BookingStatusSearchForm:: $bookingstatus = $this->getCabStatusList();
        //BookingStatusSearchForm:: $ordertime = $this->userModel->getShiftLoginList();
        $form = new BookingStatusSearchForm();
        $viewModel = new ViewModel(['form' => $form]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    /**
     * vehicleTab...
     * @return ViewModel
     */
    public function vehicleTabAction() {
        BookingVehicleSearchForm:: $vehicletype = $this->vehicleModel->getVehicleTypeList();
        $form = new BookingVehicleSearchForm();
        $viewModel = new ViewModel(['form' => $form]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function getPackageTypeList() {
        $packageTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/package";
        $resp = $this->get($url);
        $packageTypeJsonData = Json::decode($resp->getBody(), true);
        foreach ($packageTypeJsonData['data'] as $res) {
            $packageTypeJsonDataArray[$res['id']] = $res['name'];
        }
        return $packageTypeJsonDataArray;
    }

    public function getBookingHistoryData($data) {

        $url = $this->apiUrl() . "/booking/bookingList";
        $resp = $this->post($url, $data);
        $bookingList = Json::decode($resp->getBody(), true);
        $result = [];
        if ($bookingList['responsedata']['status'] == 'success') {
            $result = $bookingList['responsedata']['data'];
        }
        return $result;
    }

    public function getBookingSearchData($data) {

        $url = $this->apiUrl() . "/booking/bookingListSearch";
        $resp = $this->post($url, $data);
        //echo'<pre>';print_r($resp);die();
        $bookingList = Json::decode($resp->getBody(), true);
        $result = [];
        if ($bookingList['responsedata']['status'] == 'success') {
            $result = $bookingList['responsedata']['data'];
        }
        return $result;
    }

    public function bookingListAction() {
        $data = [];
        $val = $this->getRequest()->getPost();
        $date = $val['date'];
        $hour = $val['hour'];
        $booking_type = $val['booking_type'];
        $data = ['pickup_date' => $date, 'pickup_time' => $hour, 'booking_type' => $booking_type];
        //echo '<pre>';print_r($data);die();
        $bookingHistory = $this->getBookingHistoryData($data);
        $bookingHistoryListing = $bookingHistory;
        $viewModel = new ViewModel(['bookingHistoryListing' => $bookingHistoryListing]);
        $viewModel->setTemplate('dashboard/booking-history/booking-history-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function daysWiseAction() {
        $data = [];
        $hour_list = [];
        $booking_type = [];
        $val = $this->getRequest()->getPost();
        $date = $val['date'];
        $hour = $val['hour'];
        $url = $this->apiUrl() . "/booking/daywisecount?date=" . $date . '&hour=' . $hour;
        $resp = $this->get($url);
        $val = Json::decode($resp->getBody(), true);

        $url1 = $this->apiUrl() . "/booking/packagewisecount?date=" . $date . '&hour=' . $hour;
        $resp1 = $this->get($url1);
        $val1 = Json::decode($resp1->getBody(), true);

        //echo '<pre>';print_r($val1['responsedata']);die();
        $data = ['pickup_date' => $date];
        $bookingHistory = $this->getBookingHistoryData($data);
        //$bookingHistoryListing = $bookingHistory['data']['responsedata'];
        $total_booking = count($bookingHistory);
        foreach ($val['responsedata'][0] as $row) {
            $hour_list["hour_" . $row['hour']] = $row['no_of'];
        }

        foreach ($val1['responsedata'][0] as $row1) {
            $booking_type[] = [
                'booking_type' => $row1['booking_type'],
                'no' => $row1['no']
            ];
        }
        //print_r($hour_list); exit;
        $data = [
            "hour" => $hour_list,
            'total_booking' => $total_booking,
            "booking_type" => $booking_type
        ];
        //return array('hour' => $hour_list, 'hour_wise' => $hour_wise_list, 'booking_type' => $booking_type);
        $view = new JsonModel($data);
        return $view;
    }

    /**
     * Get State List
     * @return JSON
     */
    public function getStateList() {
        $stateJsonDataArray = [];
        $country_id = 101;
        $val = '{"where": {"country_id": "' . $country_id . '%"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/state?&filter=" . $val;
        $resp = $this->get($url);
        $stateJsonData = Json::decode($resp->getBody(), true);
        foreach ($stateJsonData as $res) {
            $stateJsonDataArray[$res['id']] = $res['name'];
        }
        return $stateJsonDataArray;
    }

    public function getCabStatusList() {
        $statusJsonDataArray = [];
        $status_type = 'cab';
        $val = '{"where": {"type":"' . $status_type . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/cab-status?&filter=" . $val;
        $resp = $this->get($url);
        $statusJsonData = Json::decode($resp->getBody(), true);
        foreach ($statusJsonData as $res) {
            $statusJsonDataArray[$res['status_id']] = $res['status'];
        }
        return $statusJsonDataArray;
    }

    // Created By pt Start--

    public function tripDetailsListAction() {
        $getid = [];
        $data = [];
        $request = $this->getRequest();
        $getid = $request->getPost()->toArray();
        $url = $this->apiUrl() . "/outstation/getMulticityTripDetail?req=" . $getid['id'];
        $resp = $this->get($url);
        $statusJsonData = Json::decode($resp->getBody(), true);
        if (!empty($statusJsonData) && isset($statusJsonData['responsedata']['data'])) {
            $data = $statusJsonData['responsedata']['data'];
        }
        if (isset($getid['triplist']) && $getid['triplist'] == 'active') {
            $viewModel = new JsonModel($data);
        } else {
            $viewModel = new ViewModel(['data' => $data]);
            $viewModel->setTemplate('/dashboard/booking-history/trip-detail');
            $viewModel->setTerminal(true);
        }
        return $viewModel;
    }

    public function bookingStatusAction() {
        $data = [];
        $booking_id = $this->params()->fromQuery('booking_id');
        $url = $this->apiUrl() . "/Booking/Bookinglog?booking_id=" . $booking_id;
        $resp = $this->get($url);
        $statusJsonData = Json::decode($resp->getBody(), true);
        if ($statusJsonData['responsedata']['status'] == 'success') {
            $data = $statusJsonData['responsedata']['data'];
        }
        $viewModel = new ViewModel(['data' => $data]);
        $viewModel->setTemplate('/dashboard/booking-history/booking-status');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function bookingInfoAction() {
        $data = [];
        $booking_id = $this->params()->fromQuery('booking_id');
        $url = $this->apiUrl() . "/Booking/booking_info?booking_id=" . $booking_id;
        $resp = $this->get($url);
        $statusJsonData = Json::decode($resp->getBody(), true);
        if ($statusJsonData['responsedata']['status'] == 'success') {
            $data = $statusJsonData['responsedata'];
        }
        //echo '<pre>';print_r($data);die();
        $viewModel = new ViewModel(['data' => $data]);
        $viewModel->setTemplate('/dashboard/booking-history/booking-info');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function paymentDetailAction() {
        $booking_id = $this->params()->fromQuery('booking_id');
        $data = ['booking_id' => $booking_id];
        $paymentInfo = $this->getBookingSearchData($data);
        if (isset($paymentInfo[0])) {
            $paymentInfo = $paymentInfo[0];
        }
        //echo '<pre>';print_r($paymentInfo);die();
        $viewModel = new ViewModel(['data' => $paymentInfo]);
        $viewModel->setTemplate('/dashboard/booking-history/payment-detail');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function driverAllocationAction() {
        $data = [];
        $booking_id = $this->params()->fromQuery('booking_id');
        $url = $this->apiUrl() . "/driver/driver_alloc?booking_id=" . $booking_id;
        $resp = $this->get($url);
        $allocation = Json::decode($resp->getBody(), true);
        //echo '<pre>';print_r($allocation);die();
        if ($allocation['responsedata']['status'] == "success") {
            $data = $allocation['responsedata']['data'];
        }
        $viewModel = new ViewModel(['data' => $data]);
        $viewModel->setTemplate('/dashboard/booking-history/booking-allocation');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function bookingDetailAction() {
        $data = [];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $getdata = $request->getPost()->toArray();
            $data = ['booking_id' => $getdata['booking_id']];
            $bookingdetail = $this->getBookingSearchData($data);
            $bookingdetail = $bookingdetail[0];
        }
        $viewModel = new ViewModel(['bookingdetail' => $bookingdetail, 'booking_id' => $getdata['booking_id']]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function updateDateTimeAction() {
        //echo "Mohit"; die;
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];

        $request = $this->getRequest();
        $getdata = $request->getPost()->toArray();
        $data = [
            'booking_id'  => $getdata['bookingid'],
            'pickup_date' => $getdata['pickup_date'],
            'pickup_time' => $getdata['pickup_time'],
            'user_id'     => $user_id
        ];
        //var_dump($data); die;
        $url = $this->apiUrl() . "/booking/updatePickupDateTime";
        $resp = $this->post($url, $data);
        $respJsonData = Json::decode($resp->getBody(), true);
        //var_dump($respJsonData); die;
        if ($respJsonData['response']['affectedRows'] > 0) {
            $status = 'true';
        } else {
            $status = 'false';
        }
        $viewModel = new JsonModel(['status' => $status]);
        return $viewModel;
    }

    public function updateClientRatingAction() {
        $result = [];
        $request = $this->getRequest();
        if ($request->isPost()) {

            $getdata = $request->getPost()->toArray();
            $data = [
                'booking_id' => $getdata['booking_id'],
                'driver_id' => $getdata['driver_id'],
                'user_id' => $getdata['client_id'],
                'rating' => $getdata['rating_val']
            ];
            $url = $this->apiUrl() . "/user/userRating";
            $resp = $this->post($url, $data);
            $respJsonData = Json::decode($resp->getBody(), true);
            if (!empty($respJsonData['response'])) {
                $result = $respJsonData['response']['status'];
            }
        }
        $viewModel = new JsonModel(['status' => $result]);

        return $viewModel;
    }

    public function updateCancelReasonAction() {
        $getdata = [];
        $data = [];
        $request = $this->getRequest();
        $getdata = $request->getPost()->toArray();
        $data = ['booking_id' => $getdata['booking_id']];
        $bookingdetail = $this->getBookingSearchData($data);
        $bookingdetail = $bookingdetail[0];
        if (!empty($bookingdetail)) {
            $data2 = [
                'booking_id' => $bookingdetail['id'],
                'driver_id' => $bookingdetail['driver_id'],
                'status' => $getdata['exereason'],
                'updated_on' => date('Y-m-d h:i:s')
            ];

            $url = $this->apiUrl() . "/driver/cancelBookingDriver";
            $resp = $this->post($url, $data2);
            $respJsonData = Json::decode($resp->getBody(), true);
            $respJsonData = $respJsonData['responsedata'];
            //echo '<pre>';print_r($respJsonData);die();
        }
        $viewModel = new JsonModel($respJsonData);
        return $viewModel;
    }

    public function executeNoShowAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        $getdata = $request->getPost()->toArray();

        $data = ['booking_id' => $getdata['bookingid']];
        $bookingdetail = $this->getBookingSearchData($data);
        $bookingdetail = $bookingdetail[0];
        //$bookingdetail['status_id']=3;
        //echo '<pre>';print_r($bookingdetail);die();

        $data = [
                'booking_id'=> $bookingdetail['id'],
                'mobile_no' => $bookingdetail['client_mobile'],
                'driver_id' => $bookingdetail['driver_id'],
                'booking_ref' => $bookingdetail['ref'],
                'reason_text' => 'Client is  not traceable',
                'remark_text' => 'No Show Bookings',
                'user_id' => $user_id,
                'booking_status' => $bookingdetail['status_id']
        ];
        $resp   =   $this->bookingModel->getExecuteNoShow($data);
        $response = [
               'status' => $resp['status'],
               'message' => $resp['message']
        ];
        $viewModel = new JsonModel($response);
        return $viewModel;
    }

    public function redispatchAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $request = $this->getRequest();
        $getdata = $request->getPost()->toArray();

        $data = ['booking_id' => $getdata['bookingid']];
        $bookingdetail = $this->getBookingSearchData($data);
        $bookingdetail = $bookingdetail[0];
        $data = [
                'booking_id' => $bookingdetail['id'],
                'user_id' => $user_id,
                'mobile_no' => $bookingdetail['client_mobile'],
                'driver_id' => $bookingdetail['driver_id'],
                'booking_ref' => $bookingdetail['ref'],
                'reason_text' => 'Redispatched because of some Processing error',
                'remark_text' => 'Redispatched',
                'booking_status' => $bookingdetail['status_id'],
                'pick_lat' => $bookingdetail['pickup_latitude'],
                'pick_long' => $bookingdetail['pickup_longitude']
        ];
        //echo '<pre>';print_r($data);die();
        $resp    =   $this->bookingModel->getRedispatch($data);
        $response = [
               'status' => $resp['status'],
               'message' => $resp['message']
        ];
        $viewModel = new JsonModel($response);
        return $viewModel;
    }

    public function generalBookingDetailsAction() {

        $data = [];
        $request = $this->getRequest();
        if ($request->isPost()) {
            $getdata = $request->getPost()->toArray();
            // ());
            $param = [];
            $param = [
                'distance' => $getdata['distance'],
                'bookingId' => $getdata['billno'],
                'strtTime' => $this->userModel->changeDateFormat($getdata['ordertime']),
                'endTime' => $this->userModel->changeDateFormat($getdata['ordertime']),
                //'address'=>"karol bagh,India",
                //'lat'=>"28.6520483",
                //'lon'=>"77.19434",
                'delay_time' => $getdata['wait_time'],
                'currentTime' => $getdata['running_time'],
                'totalAmount' => $getdata['amount'],
                //'totalTime'=>$getdata['amount'],
                //'isMatching'=>"true",
                'pre_Waiting_time' => $getdata['pre_wait'],
                    //'road_tax'=>"",
                    //'toolTax'=>"",
                    //'other_tax'=> ""
            ];
            $url = $this->apiUrl() . "/Booking/updatePickupDateTime";
            $resp = $this->post($url, $param);
            $respJsonData = Json::decode($resp->getBody(), true);
        }
        $viewModel = new JsonModel($getdata);
        return $viewModel;
    }

    public function clientDetailsAction() {
        $data = [];
        $clientInfo = [];
        $post = $this->getRequest()->getPost();
        $data = ['booking_id' => $post['booking_id']];
        $clientInfo = $this->getBookingSearchData($data);
        if (isset($clientInfo[0])) {
            $clientInfo = $clientInfo[0];
        }
        //echo "<pre>"; print_r($clientInfo);die;
        $viewModel = new ViewModel(['data' => $clientInfo]);
        $viewModel->setTemplate('/dashboard/booking-history/client-details');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function driverDetailsAction() {
        $data = [];
        $driverInfo = [];
        $post = $this->getRequest()->getPost();
        $data = ['booking_id' => $post['booking_id']];
        $driverInfo = $this->getBookingSearchData($data);
        if (isset($driverInfo[0])) {
            $driverInfo = $driverInfo[0];
        }
        $viewModel = new ViewModel(['data' => $driverInfo]);
        $viewModel->setTemplate('/dashboard/booking-history/driver-details');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function waypointInfoAction() {
        $data = [];
        $booking_id = $this->params()->fromQuery('booking_id');
        $driver_id = $this->params()->fromQuery('driver_id');
        $url = $this->apiUrl() . "/driver/waypoint?booking_id=" . $booking_id . "&driver_id=" . $driver_id;
        $resp = $this->get($url);
        $statusJsonData = Json::decode($resp->getBody(), true);
        if ($statusJsonData['responsedata']['status'] == 'success') {
            $val = $statusJsonData['responsedata']['data'];
            $status = "true";
        } else {
            $val = "";
            $status = "false";
        }
        $data = [
            "status" => $status,
            'data' => $val,
            'start_lat' => $statusJsonData['responsedata']['start_lat'],
            'start_long' => $statusJsonData['responsedata']['start_long'],
            'end_lat' => $statusJsonData['responsedata']['end_lat'],
            'end_long' => $statusJsonData['responsedata']['end_long'],
            'pickup_lat' => $statusJsonData['responsedata']['pickup_lat'],
            'pickup_lng' => $statusJsonData['responsedata']['pickup_lng']
        ];
        $view = new JsonModel($data);
        return $view;
    }

    public function claimBookingAction() {
        $sessionUser = new Container('userlogin');
        $loginData = $sessionUser->userData;
        $user_id = $loginData['user_id'];
        $user_type_id = $loginData['user_type_id'];
        $userid = 0;
        if($user_type_id!='10'){
          $userid = $user_id;
        }
        $driverList = $this->bookingModel->getActiveDriverList($userid);
        $data = $this->getRequest()->getPost();
        $booking_id = $data['booking_id'];
        $vehicleList = $this->vehicleModel->getVehicleTypeClaimList();

        $viewModel = new ViewModel([
            'booking_id' => $booking_id,
            'vehicleList' => $vehicleList,
            'driverList' => $driverList
        ]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function generateBillAction() {
        $data = $this->getRequest()->getPost();
        $booking_id = $data['booking_id'];
        $driver_id = $data['driver_id'];
        $data = ['booking_id' => $booking_id];
        $bookingdetail = $this->getBookingSearchData($data);
        $bookingdetail = $bookingdetail[0];
        //echo '<pre>';print_r($bookingdetail);die();
        $viewModel = new ViewModel(['booking_id' => $booking_id, 'bookingdetail' => $bookingdetail]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function addExtraAction() {
        $viewModel = new ViewModel();
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function clientReceiptAction() {
        $post = $this->getRequest()->getPost();
        $booking_id = $post['booking_id'];
        $bookingId = $post['bookingId'];
        $client_id = $post['client_id'];
        $data = ['booking_id' => $post['booking_id']];
        $clientInfo = $this->getBookingSearchData($data);
        if (isset($clientInfo[0])) {
            $clientInfo = $clientInfo[0];
        }
        $viewModel = new ViewModel(['data' => $clientInfo, 'booking_id' => $booking_id]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function sendClientReceiptAction() {
        $post = $this->getRequest()->getPost();
        $booking_id = $post['booking_id'];
        $email = $post['email'];
        $data = [
            'booking_id' => $post['booking_id'],
            'email' => $post['email']
        ];

        /// Need to call API /////

        $viewModel = new JsonModel(['status' => 'true']);
        return $viewModel;
    }

    public function smsToClientAction() {
        $post = $this->getRequest()->getPost();
        $type = $post['type'];
        $data = ['booking_id' => $post['booking_id']];
        $clientInfo = $this->getBookingSearchData($data);
        if (isset($clientInfo[0])) {
            $clientInfo = $clientInfo[0];
        }
        //echo '<pre>';print_r($clientInfo);//die();
        if($type=="booking"){
        $data = [
            'template_name'=>'booking',
            'mobile'=>$clientInfo['client_mobile'],
            'user_name'=>$clientInfo['clientname'],
            'booking_ref_no'=>$post['booking_id'],
            'pickup_time'=>$clientInfo['ordertime'],
            'estimated_price'=>$clientInfo['estimated_final_price'],
            'otp'=>'1234'
        ];
        }else if($type=="driver"){
        $data = [
            'template_name'=>'booking',
            'mobile'=>$clientInfo['mobile'],
            'user_name'=>$clientInfo['driver_name'],
            'booking_ref_no'=>$post['booking_id'],
            'pickup_time'=>$clientInfo['ordertime'],
            'estimated_price'=>$clientInfo['estimated_final_price'],
            'otp'=>'1234'
        ];
        }
        //echo '<pre>';print_r($data);die();
        $this->sendSMS($data);
        /// Need to call API /////
        $viewModel = new JsonModel(['status' => 'true']);
        return $viewModel;
    }


    public function reserveBookingAction() {
        $post = $this->getRequest()->getPost();
        $booking_id = $post['booking_id'];
        $driver_id = $post['driver_id'];
        $data = [
            'booking_id' => $post['booking_id'],
            'driver_id' => $post['driver_id']
        ];
        $url = $this->apiUrl() . "/notification/claimNotification";
        $resp = $this->post($url,$data);
        $statusJsonData = Json::decode($resp->getBody(), true);
        //echo '<pre>';print_r($statusJsonData);die();
        if ($statusJsonData['responsedata']['status'] == 'success') {
            $status = "true";
        } else {
            $status = "false";
        }
        /// Need to call API /////
        $viewModel = new JsonModel(['status' => 'true']);
        return $viewModel;
    }

    public function liveBillGenAdminAction() {
        $post = $this->getRequest()->getPost();
        $data = [
            'distance' => $post['km'],
            'bookingId' => $post['booking_id'],
            'strtTime' => date('Y-m-d').' '.$post['start_time'],
            'endTime' => date('Y-m-d').' '.$post['end_time'],
            'address' => '',
            'lat' => '',
            'lon' => '',
            'delay_time' => $post['wait'],
            'currentTime' => date('Y-m-d H:i:s'),
            'totalAmount' => $post['total_amount'],
            'totalTime' => $post['total_time'],
            'isMatching' => "true",
            'pre_Waiting_time' => $post['pre_wait'],
            'road_tax' => $post['parking_charge'],
            'toolTax' => $post['toll_tax'],
            'other_tax' => $post['other_charge'],
       ];

       $resp   =   $this->bookingModel->generateBill($data);
       //echo '<pre>';print_r($resp);die();
       /// Need to call API /////
       $viewModel = new JsonModel(['status' => $resp['status']]);
       return $viewModel;
    }


    public function bookingTabsAction() {
        $post = $this->getRequest()->getPost();
        $viewModel = new ViewModel(['bookingtype' => $post['bookingtype']]);
        $viewModel->setTemplate('/dashboard/booking-history/booking-tabs');
        $viewModel->setTerminal(true);
        return $viewModel;
    }


}
