<?php

namespace User\Form;

use Zend\InputFilter\InputFilter;
use Zend\Validator\Digits;
use Zend\Validator\StringLength;
use Zend\Validator\NotEmpty;
use Zend\Validator\EmailAddress;
use Zend\Validator\Date;

class UserPersonalRegistrationFormFilter extends InputFilter {

   public function __construct() {

        /**
         * Name
         */
        $this->add([
            'name' => 'first_name',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter First Name'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);

        /**
         * Last Name
         */
        $this->add([
            'name' => 'last_name',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Last Name'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);

        /**
         * Mobile No
         */
        $this->add([
            'name' => 'contact_no',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ],
                [   'name' => 'Digits',
                    'options' => [
                        'messages' => [
                            Digits::NOT_DIGITS => 'Please enter Numeric value only',
                        ],
                    ],
                    'break_chain_on_failure' => true,
                ],
                [   'name' => 'StringLength',
                    'options' => [
                        'min' => 10,
                        'max' => 10,
                        'messages' => [
                            StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                            StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                        ],
                    ],
                    'break_chain_on_failure' => true
                ],
            ]
        ]);

        /**
         * Date Of Birth
         */
        $this->add([
            'name' => 'dob',
            'required' => TRUE,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Date Of Birth'
                        ]
                    ],

                ],
                [   'name' => 'Date',
                    'options' => [
                        'messages' => [
                            Date::INVALID_DATE => '',
                        ],
                    ],
                    'break_chain_on_failure' => true
                ],
            ]
        ]);

        /**
         * Residential Address
         */
        $this->add([
            'name' => 'residential_address',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Residential Address'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
        /**
         * Residential Proof
         */
        $this->add([
            'name' => 'residential_proof',
            'required' => false,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [                
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'File was not uploaded'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ], 
                ['name'    => 'FileUploadFile'],
                [
                    'name'    => 'FileMimeType',                        
                    'options' => [                       
                        'mimeType'  => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
                    ],
                    'break_chain_on_failure' => true
                ],
                ['name'    => 'FileIsImage'],
                [
                        'name'    => 'FileImageSize',                        
                        'options' => [                            
                            'minWidth'  => 128,
                            'minHeight' => 128,
                            'maxWidth'  => 4096,
                            'maxHeight' => 4096
                        ]
                ],     
            ]
        ]);
        
        /**
         * City
         */
        $this->add([
            'name' => 'city_id',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please Select City'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
        /**
         * Vehicle Code
         */
        $this->add([
            'name' => 'vehicle_code',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Vehicle Code'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
        /**
         * Vehicle No
         */
        $this->add([
            'name' => 'vehicle_number',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please enter Vehicle No'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
        /**
         * Upload Your RC Proof
         */
        $this->add([
            'name' => 'rc_proof',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [                
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'File was not uploaded'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ], 
                ['name'    => 'FileUploadFile'],
                [
                    'name'    => 'FileMimeType',                        
                    'options' => [                       
                        'mimeType'  => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
                    ],
                    'break_chain_on_failure' => true
                ],
                ['name'    => 'FileIsImage'],
                [
                        'name'    => 'FileImageSize',                        
                        'options' => [                            
                            'minWidth'  => 128,
                            'minHeight' => 128,
                            'maxWidth'  => 4096,
                            'maxHeight' => 4096
                        ]
                ],     
            ]
        ]);
        
        /**
         * License State
         */
        $this->add([
            'name' => 'license_state',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please select License State'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
        /**
         * License Proof
         */
        $this->add([
            'name' => 'license_proof',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [                
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'File was not uploaded'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ], 
                ['name'    => 'FileUploadFile'],
                [
                    'name'    => 'FileMimeType',                        
                    'options' => [                       
                        'mimeType'  => ['image/gif', 'image/png', 'image/jpg', 'image/jpeg']
                    ],
                    'break_chain_on_failure' => true
                ],
                ['name'    => 'FileIsImage'],
                [
                        'name'    => 'FileImageSize',                        
                        'options' => [                            
                            'minWidth'  => 128,
                            'minHeight' => 128,
                            'maxWidth'  => 4096,
                            'maxHeight' => 4096
                        ]
                ],     
            ]
        ]);
//        
//   $this->add($factory->createInput(array(
//                        'name' => 'agreeterms',
//                        'validators' => array(
//                            array(
//                                'name' => 'Digits',
//                                'break_chain_on_failure' => true,
//                                'options' => array(
//                                    'messages' => array(
//                                        Digits::NOT_DIGITS => 'You must agree to the terms of use.',
//                                    ),
//                                ),
//                            ),
//                        ),
//                    )));
   
   
   
    $this->add([
            'name' => 'agreeterms',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'Digits',
                    'options' => [
                        'messages' => [
                            Digits::NOT_DIGITS => 'You must agree to the terms of use.',
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
    }

}
