<?php

namespace User\Form;

use Zend\Form\Element;
use Zend\Form\Form;
use Zend\Form\Element\Select;
use Zend\Form\Element\Submit;
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class LoginForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {

        /**
         * Login Detail Form of Guide Registration
         */
        parent::__construct('login-form');
        $this->setAttribute('method', 'post');

        /**
         * user type
         */
        $this->add([
            'name' => 'user_type_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'user-type-id',
                'class' => 'form-control input-border',

            ],
            'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => 'Select User Type',
                'value_options' => [
                    '1' => 'Normal User',
                    '7' => 'Travel Agent',
                    '3' => 'Driver',
                    '4' => 'Vendor',
                    '5' => 'Guide',
                    '6' => 'Corporate User ',
                    '10' => 'Super Admin ',
                ],
            ],
        ]);


        /**
         * username
         */
        $this->add([
            'name' => 'username',
            'type' => 'text',
            'attributes' => [
                'id' => 'username_id',
                'class' => 'form-control input-border',
                'placeholder' => 'User Name'
            ],
            'options' => [
                'label' => 'User Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Password
         */
        $this->add([
            'name' => 'password',
            'type' => 'password',
            'attributes' => [
                'id' => 'password_id',
                'class' => 'form-control input-border',
                'placeholder' => 'Password'
            ],
            'options' => [
                'label' => 'Password<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



        /**
         * Registration Type
         */
        $this->add([
            'name' => 'registration_type',
            'type' => 'hidden',
            'attributes' => [
                'id' => 'registration-type',
                'class' => 'form-control'
            ]
        ]);

        /**
         * Continue
         */
        $this->add([
            'name' => 'login_form',
            'type' => 'Submit',
            'attributes' => [
                'value' => 'Login',
                'label' => 'Submit',
                'class' => 'btn btn-primary btn-lg btn-login'
            ]
        ]);

        /**
         * Continue
         */
        $this->add([
            'name' => 'login_dashboard',
            'type' => 'Submit',
            'attributes' => [
                'value' => 'Sign In',
                'label' => 'Submit',
                'class' => 'btn btn-primary btn-block btn-flat'
            ]
        ]);

        $this->add([
            'name' => 'login_search',
            'type' => 'Submit',
            'attributes' => [
                'value' => 'Sign In',
                'label' => 'Submit',
                'class' => 'publish_all btn btn-danger text-white'
            ]
        ]);

        $this->add([
            'name' => 'link_type',
            'type' => 'Hidden',
        ]);

        /**
         * Continue
         */
        $this->add([
            'name' => 'login_search_form',
            'type' => 'Submit',
            'attributes' => [
                'value' => 'Login',
                'label' => 'Submit',
                'class' => 'btn btn-primary btn-lg btn-search-login'
            ]
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'username' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Email / Mobile No.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'user_type_id' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select User Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'password' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Password '
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
