<?php

namespace User\Form;

use Zend\Form\Element;
use Zend\Form\Form;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Hidden;
use Zend\Form\Element\Text;
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class ConfirmLoginOtpForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {

        /**
         * Login Detail Form of Guide Registration
         */
        parent::__construct('confirm-form');
        $this->setAttribute('method', 'post');

        /**
         * username
         */
        $this->add([
            'name' => 'confirm_otp',
            'type' => 'text',
            'attributes' => [
                'id' => 'confirm-otp',
                'class' => 'form-control input-border',
                'onkeypress' => "return isNumber(event)",
            ],
            'options' => [
                'label' => 'OTP<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Continue
         */
        $this->add([
            'name' => 'confirm_btn',
            'type' => 'Submit',
            'attributes' => [
                'value' => 'Verify',
                'label' => 'Submit',
                'class' => 'btn btn-primary btn-lg confirm-btn'
            ]
        ]);
        /**
         * Continue
         */
        $this->add([
            'name' => 'redirect_confirm_btn',
            'type' => 'Submit',
            'attributes' => [
                'value' => 'Verify',
                'label' => 'Submit',
                'class' => 'btn btn-primary btn-lg confirm-redirect-btn'
            ]
        ]);

        /**
         * Continue
         */
        $this->add([
            'name' => 'resend_btn',
            'type' => 'Submit',
            'attributes' => [
                'value' => 'Resend',
                'label' => 'Submit',
                'class' => 'btn btn-primary btn-lg resend-otp-btn'
            ]
        ]);

        $this->add([
            'name' => 'resend_counter',
            'type' => Hidden::class,
            'attributes' => [
                'id'=>'resend-counter',
                'value' => '0',
            ]
        ]);

        $this->add([
            'name' => 'ticket_type',
            'type' => Hidden::class,
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'confirm_otp' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter OTP'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                     ['name' => 'Digits',
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please enter Numeric value only',
                            ],
                        ],
                        'break_chain_on_failure' => true,
                    ],
                ]
            ],
        ];
    }

}
