<?php

namespace User;

use Zend\Router\Http\Literal;
use Zend\Router\Http\Segment;
use Zend\ServiceManager\Factory\InvokableFactory;

return [
    'router' => [
        'routes' => [
            'login' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/login',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'login',
                    ],
                ],
            ],
            'guest-login' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/guest-login',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'guest-login',
                    ],
                ],
            ],
            'guest-auto-login' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/guest-auto-login',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'guest-auto-login',
                    ],
                ],
            ],
            'confirmLoginOtp' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/confirmLoginOtp',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'confirmLoginOtp',
                    ],
                ],
            ],
            'confirmRedirectLoginOtp' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/confirmRedirectLoginOtp',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'confirmRedirectLoginOtp',
                    ],
                ],
            ],
            'logout' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/logout',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'logout',
                    ],
                ],
            ],
            'user' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/signup[/:action][/:param]',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'param' => '[a-zA-Z0-9]*'
                    ],
                ],
            ],
            'user-login' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/login-redirect[/:action]',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'login-search',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'make-payment' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/make-payment[/:action]',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'make-payment',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'payment-response' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/payment-response[/:action][/:param]',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'payment-response',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'param' => '[a-zA-Z0-9]*'
                    ],
                ],
            ],
            'checkout' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/checkout[/:action]',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'checkout',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'affilate-registration' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/affilate-registration',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'affilate-registration',
                    ],
                ],
            ],
            'driver' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/driver[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*',
                        'slug' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'normal-user' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/normal-user[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'index',
                        //'action' => 'personal-info',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'corporate-user' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/corporate-user[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'index',
                        //'action' => 'personal-info',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'travel-agent' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/travel-agent[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'index',
                        //'action' => 'personal-info',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'hotel' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/hotel[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'vendor' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/vendor[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'guide' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/guide[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'refresh' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/refresh',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'refresh',
                    ],
                ],
            ],
            'verifyemail' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/user[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'index',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'newslettersubscription' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/user[/:action]',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'newslettersubscription',
                    ],
                    'constraints' => [
                        'action' => '[a-zA-Z][a-zA-Z0-9_-]*'
                    ],
                ],
            ],
            'subscribe-newsletter' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/subscribe-newsletter',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'subscribe-newsletter',
                    ]
                ],
            ],
            'upload-file' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/upload-file',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'uploadfile'
                    ],
                ],
            ],
            'get-user-data' => [
                'type' => Segment::class,
                'options' => [
                    'route' => '/get-user-data',
                    'defaults' => [
                        'controller' => Controller\RegistrationController::class,
                        'action' => 'userdata'
                    ],
                ],
            ]
            /*'dashboard-login' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/dashboard-login',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'dashboard-login',
                    ],
                ],
            ],
            'supplier' => [
                'type' => Literal::class,
                'options' => [
                    'route' => '/supplier',
                    'defaults' => [
                        'controller' => Controller\IndexController::class,
                        'action' => 'supplier',
                    ],
                ],
            ],*/
        ],
    ],
    'controllers' => [
        'factories' => [
            Controller\IndexController::class => InvokableFactory::class,
            Controller\DriverController::class => InvokableFactory::class,
            Controller\VendorController::class => InvokableFactory::class,
            Controller\NormalUserController::class => InvokableFactory::class,
            Controller\CorporateUserController::class => InvokableFactory::class,
            Controller\GuideController::class => InvokableFactory::class,
            Controller\RegistrationController::class => InvokableFactory::class,
        ],
    ],
    'view_manager' => [
        'display_not_found_reason' => true,
        'display_exceptions' => true,
        'doctype' => 'HTML5',
        'not_found_template' => 'error/404',
        'exception_template' => 'error/index',
        'template_map' => [
            'layout/layout' => __DIR__ . '/../view/layout/layout.phtml',
            'user/index/index' => __DIR__ . '/../view/user/index/index.phtml',
            'error/404' => __DIR__ . '/../view/error/404.phtml',
            'error/index' => __DIR__ . '/../view/error/index.phtml',
        ],
        'template_path_stack' => [
            __DIR__ . '/../view',
        ],
        'strategies' => [
            'ViewJsonStrategy',
        ],
    ],
    'moduleLayouts' => [
        'User' => 'layout/user.phtml'
    ],
];
