<?php

/** @CreatedBy : Mohit Jain
 *  @Description : Sightseeing Model Functions
 */

namespace SightSeeing\Model;

use Application\Controller\RestAPIClientController;
use Zend\Session\Container;
use Zend\Json\Json;

class Sightseeing extends RestAPIClientController {

    public function apiUrl() {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        return $config->api->url;
    }

    public function getFareData($base_vehicle_id, $modelType) {
        $val = '{"where":{"and": [{"base_vehicle_id": "' . $base_vehicle_id . '"},{"status": "1"}]}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/" . $modelType . "?&filter=" . $val;
        $resp = $this->get($url);
        return $data = Json::decode($resp->getBody(), true);
    }

    public function getMarkupGrade($gradeArray) {
        $grade="";
        if ($gradeArray['userTypeId'] == 1) {
            if (($gradeArray['userCity'] == $gradeArray['searchCity']) && ($gradeArray['userGender'] == 'Male')) {
                $grade = '1';
            } else if (($gradeArray['userCity'] == $gradeArray['searchCity']) && ($gradeArray['userGender'] == 'Female')) {
                $grade = '2';
            } else if (($gradeArray['userCity'] != $gradeArray['searchCity']) && ($gradeArray['userGender'] == 'Male')) {
                $grade = '3';
            } else if (($gradeArray['userCity'] != $gradeArray['searchCity']) && ($gradeArray['userGender'] == 'Female')) {
                $grade = '4';
            }
        } else if ($gradeArray['userTypeId'] == 7) {
            if (($gradeArray['userCity'] == $gradeArray['searchCity']) && ($gradeArray['userGender'] == 'Male')) {
                $grade = '1';
            } else if (($gradeArray['userCity'] == $gradeArray['searchCity']) && ($gradeArray['userGender'] == 'Female')) {
                $grade = '2';
            } else if (($gradeArray['userCity'] != $gradeArray['searchCity']) && ($gradeArray['userGender'] == 'Male')) {
                $grade = '3';
            } else if (($gradeArray['userCity'] != $gradeArray['searchCity']) && ($gradeArray['userGender'] == 'Female')) {
                $grade = '4';
            }
        }
        return $grade;
    }

    public function getCompanyMarkup($companyId, $cityId, $masterPackageType, $grade) {
        $markup_data = $this->apiUrl() . "/markup/getCompanyMarkup?company_id=" . $companyId . "&city_id=" . $cityId . "&master_package_id=" . $masterPackageType . "&user_grade=" . $grade;
        $markupValue = $this->get($markup_data);
        $markupData = Json::decode($markupValue->getBody(), true);
        if ($markupData['responsedata']['status'] == "failed") {
            $markup_data = $this->apiUrl() . "/markup/getCompanyMarkup?company_id=" . $companyId . "&city_id=" . $cityId . "&master_package_id=0&user_grade=" . $grade;
            $markupValue = $this->get($markup_data);
            $markupData = Json::decode($markupValue->getBody(), true);
        }else if($markupData['responsedata']['status'] == "failed"){
            $markup_data = $this->apiUrl() . "/markup/getCompanyMarkup?company_id=" . $companyId . "&user_grade=" . $grade;
            $markupValue = $this->get($markup_data);
            $markupData = Json::decode($markupValue->getBody(), true);
        }
        if ($markupData['responsedata']['status'] == "success") {
            $markupData = $markupData['responsedata']['data'][0];
        } else {
            $markupData = [];
        }
        //echo '<pre>';print_r($markupData);die();
        return $markupData;
    }

    public function getUserMarkup($companyId, $cityId, $masterPackageType,$user_id){
        echo $markup_data = $this->apiUrl() . "/markup/getCompanyMarkup?company_id=" . $companyId . "&city_id=" . $cityId . "&master_package_id=" . $masterPackageType . "&user_id=" . $user_id;
        $markupValue = $this->get($markup_data);
        $markupData = Json::decode($markupValue->getBody(), true);
        if ($markupData['responsedata']['status'] == "success") {
            $markupData = $markupData['responsedata']['data'][0];
        } else {
            $markupData = [];
        }
        //echo '<pre>';print_r($markupData);die();
        return $markupData;
    }

    public function getCurrencyDetails($currencyId){
        $val = '{"where": {"id": "' . $currencyId . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/master-currency?&filter=" . $val;
        $resp = $this->get($url);
        $val = Json::decode($resp->getBody(), true);
        $currData = isset($val[0]) ? $val[0] : 0;
        return $currData;
    }
    
    public function getSightseeingType() {
        $sightseeing_type = [];
        $data = ['status'=>1];
        $url = $this->apiUrl() . "/master-tour-theme/gettourTheme";
        $val = $this->post($url,$data);
        $jsonData = $val->getBody();
        $jsonResponse = Json::decode($jsonData, true);
        //echo '<pre>';print_r($jsonResponse);die();
        if ($jsonResponse['responsedata']['status']=="success") {
            foreach ($jsonResponse['responsedata']['data'] as $key => $value) {
                $sightseeing_type[$value['id']] = $value['theme_name'];
            }
        }
        return $sightseeing_type;
    }
    
    public function addSightSeeingData($data){
        $url = $this->apiUrl() . "/sightseeing/addsightseeingDetails";
        $resp = $this->post($url, $data);
        $resp = Json::decode($resp->getBody(), true);
        return $resp;
    }

}
