<?php

namespace SightSeeing\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden,
    Button
};
use Zend\Validator\{
    NotEmpty,
    Digits
};
use Zend\InputFilter\InputFilterProviderInterface;

class SightSeeingSearchForm extends Form implements InputFilterProviderInterface {

    //private $packageList = ['1' => '4 Hrs - 40 KM', '2' => '8 Hrs - 80 KM', '3' => '12 Hrs - 120 KM', '4' => '16 Hrs - 160 KM'];
    public static $sightTypeList = [];
    
    public function __construct($name = null) {

        parent::__construct('sight-search-form');
        $this->setAttribute('method', 'post');

        /**
         * Pickup City
         */
        $this->add([
            'name' => 'pickup_city',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-city',
                'class' => 'inputMaterial pickup-city',
            ],
            'options' => [
                'label' => 'City<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true
            ],
        ]);

        /**
         * Pickup Area
         */
        $this->add([
            'name' => 'pickup_area',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-area',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Pickup Location<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Pickup Address
         */
        $this->add([
            'name' => 'pickup_address',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-address',
                'class' => 'inputMaterial',
                'placeholder'=> ''
            ],
            'options' => [
                'label' => 'Pickup Address<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Pickup Date
         */
        $this->add([
            'name' => 'pickup_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-date',
                'placeholder' => 'Date',
                'class' => 'inputMaterial datepicker',
            ]
        ]);

        /**
         * Pickup Time
         */
        $this->add([
            'name' => 'pickup_time',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pickup-time',
                'placeholder' => 'Time',
                'class' => 'inputMaterial'
            ]
        ]);

        /**
         * Number of Adults
         */
        $this->add([
            'type' => Number::class,
            'name' => 'adults',
            'attributes' => [
                'id' => 'adults',
                'class' => 'inputMaterial',
                'min' => 0,
                'max' => 9,
                'step' => 1,
                'value' => 1
            ],
            'options' => [
                'label' => 'Adults',
            ],
        ]);

        /**
         * Number of Childs
         */
        $this->add([
            'type' => Number::class,
            'name' => 'childs',
            'attributes' => [
                'id' => 'childs',
                'class' => 'inputMaterial',
                'min' => 0,
                'max' => 9,
                'step' => 1,
                'value' => 0,
                'oninput' => "child_count(this.value)"
            ],
            'options' => [
                'label' => 'Childs',
            ],
        ]);

        /**
         * Accept the Terms and Conditions
         */
        $this->add([
            'name' => 'agree_terms',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'agree-terms',
            ],
            'options' => [
                'label' => 'Accept the Terms and Conditions',
                'checked_value' => '1',
                'unchecked_value' => 'no',
                'use_hidden_element' => true
            ],
        ]);

        /**
         * Search a Car
         */
        $this->add([
            'name' => 'search_btn_a_car',
            'type' => Button::class,
            'attributes' => [
                'id' => 'search-a-car',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);

        /**
         * Search a Car
         */
        $this->add([
            'name' => 'search_a_car',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search a Car',
                'id' => 'search-a-car',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);

        /**
         * Form Type
         */
        $this->add([
            'name' => 'form_type',
            'type' => Hidden::class,
            'attributes' => [
                'value' => 'car_search_form',
            ],
        ]);

        /**
         * Pickup Area Value
         */
        $this->add([
            'name' => 'pickup_area_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'pickup-area-value'
            ],
        ]);

        $this->add([
            'name' => 'master_package_type',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'master-package-type',
                'class' => 'inputMaterial'
            ]
        ]);

        $this->add([
            'name' => 'city_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-id',
                'class' => 'inputMaterial'
            ]
        ]);

         $this->add([
            'name' => 'vehicle_type_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'vehicle-type-id',
                'class' => 'inputMaterial'
            ]
        ]);

         $this->add([
            'name' => 'city_latitude',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-latitude',
                'class' => 'inputMaterial'
            ]
        ]);

         $this->add([
            'name' => 'city_longitude',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-longitude',
                'class' => 'inputMaterial'
            ]
        ]);


         ///////////////


         $this->add([
            'name' => 'city_northeast_latitude',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-northeast-latitude',
                'class' => 'inputMaterial'
            ]
        ]);

         $this->add([
            'name' => 'city_northeast_longitude',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-northeast-longitude',
                'class' => 'inputMaterial'
            ]
        ]);

        $this->add([
            'name' => 'city_southwest_latitude',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-southwest-latitude',
                'class' => 'inputMaterial'
            ]
        ]);

         $this->add([
            'name' => 'city_southwest_longitude',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'city-southwest-longitude',
                'class' => 'inputMaterial'
            ]
        ]);


        /**
         * Nationality
         */
        $this->add([
            'name' => 'nationality',
            'type' => Text::class,
            'attributes' => [
                'id' => 'nationality',
                'class' => 'inputMaterial country-class'
            ],
            'options' => [
                'label' => 'Nationality<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
            ],
        ]);
        
        /**
         * Airport
         */
        $this->add([
            'name' => 'sightseeing_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'sightseeing-type',
                'class' => 'inputMaterial ht44px'
            ],
            'options' => [
                'label' => 'Tour Type<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$sightTypeList,
                'disable_inarray_validator' => true,
                'empty_option' => '',
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'pickup_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'pickup_address' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Pickup Address'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'nationality' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Nationality'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'pickup_date' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [

                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Pickup Date'
                            ]
                        ],
                    ],
                    ['name' => 'Date',
                        'options' => [
                             'format'=>'d-m-Y',
                            'messages' => [
                                //Date::INVALID_DATE => '',
                                \Zend\Validator\Date::INVALID_DATE => 'Please enter Valid Date',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'pickup_time' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Pickup Time'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'sightseeing_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Tour Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'adults' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 1,
                            'max' => 9
                        ]
                    ],
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please select Number of Adult'
                            ]
                        ],
                    ],
                ]
            ],
            'childs' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 1,
                            'max' => 9
                        ]
                    ],
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please select Number of Child'
                            ]
                        ],
                    ],
                ]
            ],

            'agree_terms' => [
                'required' => false,
                'validators' => [
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please Accept the Terms and Conditions',
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }

}
