<?php

/** @CreatedBy : Mohit Jain
 *  @Description : Guide Model Functions
 */

namespace Guide\Model;

use Application\Controller\RestAPIClientController;
use Zend\Session\Container;
use Zend\Json\Json;

class Guide extends RestAPIClientController {

    public function apiUrl() {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        return $config->api->url;
    }

    public function getLanguageList() {
        $lngTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/master-language";
        $resp = $this->get($url);
        $lngTypeJsonData = Json::decode($resp->getBody(), true);
        foreach ($lngTypeJsonData['data'] as $res) {
            $lngTypeJsonDataArray[$res['language_id']] = $res['language_name'];
        }
        return $lngTypeJsonDataArray;
    }

    public function getTourTypeList() {
        $tourTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/master-tour-theme";
        $resp = $this->get($url);
        $tourTypeJsonData = Json::decode($resp->getBody(), true);
        foreach ($tourTypeJsonData as $res) {
            $tourTypeJsonDataArray[$res['id']] = $res['theme_name'];
        }
        return $tourTypeJsonDataArray;
    }

    public function getLanguageName($id) {
        $url = $this->apiUrl() . "/master-language/" . $id;
        $resp = $this->get($url);
        $languageName = Json::decode($resp->getBody(), true);
        $languageNameData = $languageName['language_name'];
        return $languageNameData;
    }

    public function getCurrencyList() {
        $currencyTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/master-currency";
        $resp = $this->get($url);
        $currencyTypeJsonData = Json::decode($resp->getBody(), true);
        foreach ($currencyTypeJsonData as $res) {
            $currencyTypeJsonDataArray[$res['id']] = $res['name'];
        }
        return $currencyTypeJsonDataArray;
    }

    public function getCurrencyDetails($currencyId){
        $val = '{"where": {"id": "' . $currencyId . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/master-currency?&filter=" . $val;
        $resp = $this->get($url);
        $val = Json::decode($resp->getBody(), true);
        $currData = isset($val[0]) ? $val[0] : 0;
        return $currData;
    }
}
