<?php

namespace Guide\Form;

use Zend\InputFilter\InputFilter;
use Zend\Validator\Digits;
use Zend\Validator;

class VehicleSearchFormFilter extends InputFilter {

    public function __construct() {
        
//    select city---- 
        
        $this->add([
            'name' => 'pickup_city',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [
                    'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            Validator\NotEmpty::IS_EMPTY => ' Please Select City'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]); 
         
        
        
        
        $this->add([
            'name' => 'pickup_date',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [
                    'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            Validator\NotEmpty::IS_EMPTY => 'Please Select Date'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
        
          $this->add([
            'name' => 'pickup_time',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [
                    'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            Validator\NotEmpty::IS_EMPTY => 'Please Select Time'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
          
        
        
        
        
        $this->add([
            'name' => 'pickup_country',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [
                    'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            Validator\NotEmpty::IS_EMPTY => 'Please Select Country'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
         $this->add([
            'name' => 'tour_type',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [
                    'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            Validator\NotEmpty::IS_EMPTY => 'Please Select Tour Type'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
         
         
         
        $this->add([
            'name' => 'guid_package',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [
                    'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            Validator\NotEmpty::IS_EMPTY => 'Please Select Package'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
        $this->add([
            'name' => 'guide_language',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [
                    'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            Validator\NotEmpty::IS_EMPTY => 'Please Select Guide Language'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
        $this->add([
            'name' => 'pickup_address',
            'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [
                    'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            Validator\NotEmpty::IS_EMPTY => 'Please Provide Pickup Address'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
        ]);
        
        $this->add([
            'name' => 'agreeterms',
            'required' => true,
            'validators' => [
                [
                    'name' => 'Digits',
                    'break_chain_on_failure' => true,
                    'options' => [
                        'messages' => [
                            Digits::NOT_DIGITS => 'Please Accept Terms and Conditions',
                        ],
                    ],
                ],
            ],
        ]);
        
    }

}
