<?php

/** @CreatedBy : Mohit Jain
 *  @Description : User Model Functions
 */

namespace Dashboard\Model;

use Application\Controller\RestAPIClientController;
use Zend\Session\Container;
use Zend\Json\Json;

class User extends RestAPIClientController {

    public function apiUrl() {
        $config = new \Zend\Config\Config(include BASE_PATH . '/config/autoload/global.php');
        return $config->api->url;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET KYC TYPE LIST
     * @param $data
     * @returns $responsedata
     */
    
    public function getKycTypeList() {
        $kycTypeJsonDataArray = [];
        $val = '{"where": {"type": "kycP"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/document-type?&filter=" . $val;
        $resp = $this->get($url);
        $kycTypeJsonData = Json::decode($resp->getBody(), true);
        foreach ($kycTypeJsonData as $res) {
            $kycTypeJsonDataArray[$res['doc_type_id']] = $res['document_name'];
        }
        return $kycTypeJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET PACKAGE TYPE LIST
     * @param $data
     * @returns $responsedata
     */

    public function getPackageTypeList() {
        $packageTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/package";
        $resp = $this->get($url);
        $packageTypeJsonData = Json::decode($resp->getBody(), true);
        if(count($packageTypeJsonData['data'])>0){
        foreach ($packageTypeJsonData['data'] as $res) {
            $packageTypeJsonDataArray[$res['id']] = $res['name'];
        }
        }
        return $packageTypeJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET PAYMENT TYPE LIST
     * @param $data
     * @returns $responsedata
     */

    public function getPaymentTypeList() {
        $paymentTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/payment-type";
        $resp = $this->get($url);
        $paymentTypeJsonData = Json::decode($resp->getBody(), true);
        if($paymentTypeJsonData['status']=="success"){
        foreach ($paymentTypeJsonData['data'] as $res) {
            $paymentTypeJsonDataArray[$res['payment_type_id']] = $res['pay_type_mode'];
        }
        }
        return $paymentTypeJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET WEEEK DAYS LIST
     * @param $data
     * @returns $responsedata
     */

    public function getWeekDaysList() {
        $weekDaysJsonDataArray = [];
        $url = $this->apiUrl() . "/week-days-list";
        $resp = $this->get($url);
        $weekDaysJsonData = Json::decode($resp->getBody(), true);
        foreach ($weekDaysJsonData as $res) {
            $weekDaysJsonDataArray[$res['id']] = $res['name'];
        }
        return $weekDaysJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET USER DUTY TYPE LIST
     * @param $data
     * @returns $responsedata
     */

    public function getUserDutyTypeList($userId) {
        $dutyTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/user/dutyTypeList?user_id=" . $userId;
        $resp = $this->get($url);
        $dutyTypeJsonData = Json::decode($resp->getBody(), true);
        foreach ($dutyTypeJsonData['responsedata'] as $res) {
            $dutyTypeJsonDataArray[$res['user_duty_id']] = $res['package_id'];
        }
        return $dutyTypeJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET USER PREF DRIVE CITY LIST
     * @param $data
     * @returns $responsedata
     */

    public function getUserprefDriveCityList($userId) {
        $prefDriveJsonDataArray = [];
        $url = $this->apiUrl() . "/user/prefDriveCityList?user_id=" . $userId;
        $resp = $this->get($url);
        $prefDriveJsonData = Json::decode($resp->getBody(), true);
        if(!isset($prefDriveJsonData['error'])){
        foreach ($prefDriveJsonData['responsedata'] as $res) {
            $prefDriveJsonDataArray[$res['user_drive_city_id']] = $res['city_id'];
        } }
        return $prefDriveJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET USER PAYMENT TYPE LIST
     * @param $data
     * @returns $responsedata
     */

    public function getUserpaymentTypeList($userId) {
        $paymentTypeJsonDataArray = [];
        $url = $this->apiUrl() . "/user/paymentList?user_id=" . $userId;
        $resp = $this->get($url);
        $paymentTypeJsonData = Json::decode($resp->getBody(), true);
        foreach ($paymentTypeJsonData['responsedata'] as $res) {
            $paymentTypeJsonDataArray[$res['user_payment_id']] = $res['payment_type_id'];
        }
        return $paymentTypeJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET USER SPEAK LANGUAGE LIST
     * @param $data
     * @returns $responsedata
     */

    public function getUserSpeakLanguageList($userId) {
        $speaklangJsonDataArray = [];
        $url = $this->apiUrl() . "/user/speakLangList?user_id=" . $userId;
        $resp = $this->get($url);
        $speaklangJsonData = Json::decode($resp->getBody(), true);
        foreach ($speaklangJsonData['responsedata'] as $res) {
            $speaklangJsonDataArray[$res['user_lang_id']] = $res['language_id'];
        }
        return $speaklangJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET USER WRITE LANGUAGE LIST
     * @param $data
     * @returns $responsedata
     */

    public function getUserWriteLanguageList($userId) {
        $writelangJsonDataArray = [];
        $url = $this->apiUrl() . "/user/writeLangList?user_id=" . $userId;
        $resp = $this->get($url);
        $writelangJsonData = Json::decode($resp->getBody(), true);
        foreach ($writelangJsonData['responsedata'] as $res) {
            $writelangJsonDataArray[$res['user_lang_id']] = $res['language_id'];
        }
        return $writelangJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET USER SHIFT LOGIN LIST
     * @param $data
     * @returns $responsedata
     */

    public function getUserShiftLoginList($userId) {
        $shiftLoginJsonDataArray = [];
        $url = $this->apiUrl() . "/user/shiftLoginList?user_id=" . $userId;
        $resp = $this->get($url);
        $shiftLopinJsonData = Json::decode($resp->getBody(), true);
        foreach ($shiftLopinJsonData['responsedata'] as $res) {
            $shiftLoginJsonDataArray[$res['user_workingshift_id']] = $res['working_shift_id'];
        }
        return $shiftLoginJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET USER WEEK DAYS LIST
     * @param $data
     * @returns $responsedata
     */

    public function getUserWeekDaysList($userId) {
        $shiftLoginJsonDataArray = [];
        $url = $this->apiUrl() . "/user/weekOffList?user_id=" . $userId;
        $resp = $this->get($url);
        $shiftLopinJsonData = Json::decode($resp->getBody(), true);
        foreach ($shiftLopinJsonData['responsedata'] as $res) {
            $shiftLoginJsonDataArray[$res['user_weekoff_id']] = $res['week_id'];
        }
        return $shiftLoginJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET LANGUAGE LIST
     * @param $data
     * @returns $responsedata
     */

    public function getLanguageList() {
        $languageJsonDataArray = [];
        $url = $this->apiUrl() . "/master-language";
        $resp = $this->get($url);
        $languageJsonData = Json::decode($resp->getBody(), true);
        if($languageJsonData['status']=="success"){
        foreach ($languageJsonData['data'] as $res) {
            $languageJsonDataArray[$res['language_id']] = $res['language_name'];
        }
        }
        return $languageJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET SHIFT LOGIN LIST
     * @param $data
     * @returns $responsedata
     */

    public function getShiftLoginList() {
        $shiftJsonDataArray = [];
        $url = $this->apiUrl() . "/master-working-shift";
        $resp = $this->get($url);
        $shiftJsonData = Json::decode($resp->getBody(), true);
        if($shiftJsonData['status']=="success"){
        foreach ($shiftJsonData['data'] as $res) {
            $shiftJsonDataArray[$res['working_shift_id']] = $res['shift'];
        }
        }
        return $shiftJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET PREF CITY LIST
     * @param $data
     * @returns $responsedata
     */

    public function getPrefCityList() {
        $cityJsonDataArray = [];
        $url = $this->apiUrl() . "/city";
        $resp = $this->get($url);
        $cityJsonData = Json::decode($resp->getBody(), true);
        foreach ($cityJsonData as $res) {
            $cityJsonDataArray[$res['id']] = $res['name'];
        }
        return $cityJsonDataArray;
    }


    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET ALL COUNTRY LIST
     * @param $data
     * @returns $responsedata
     */
    
    public function getCountryList() {
        $countryJsonDataArray = [];
        $url = $this->apiUrl() . "/country";
        $resp = $this->get($url);
        $countryJsonData = Json::decode($resp->getBody(), true);
        foreach ($countryJsonData as $res) {
            $countryJsonDataArray[$res['id']] = $res['name'];
        }
        return $countryJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET COUNTRY CODE PREFIX
     * @param $data
     * @returns $responsedata
     */
    
    public function getCountryCodePrefix() {
        $countryJsonDataArray = [];
        $url = $this->apiUrl() . "/country";
        $resp = $this->get($url);
        $countryJsonData = Json::decode($resp->getBody(), true);
        foreach ($countryJsonData as $res) {
            $countryJsonDataArray[$res['phone_code']] = '+'.$res['phone_code'].' ('.$res['code'].')';
        }
        return $countryJsonDataArray;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET USER TYPE LIST
     * @param $data
     * @returns $responsedata
     */
    public function getUserTypeList($roleType="") {
        $roleJsonDataArray = [];
        $role_type = "";
        if($roleType!=""){
            $role_type = $this->getUserRoleType($roleType);
        }
        $roleTypeData = [
            'role_type' =>$role_type
        ];
        $url = $this->apiUrl() . "/user/getUserRoleList";
        $resp = $this->post($url,$roleTypeData);
        $roleJsonData = Json::decode($resp->getBody(), true);
        if($roleJsonData['responsedata']['status']=="success"){
            foreach ($roleJsonData['responsedata']['data'] as $res) {
                $roleJsonDataArray[$res['Role_ID']] = $res['RoleName'];
            }
        }
        return $roleJsonDataArray;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 20-July-2022
     * @description : FUNCTION TO GET ROLE TYPE
     * @param $data
     * @returns $responsedata
     */
    public function getUserRoleType($roleType) {
        $val = "";
        $data = [
            'role_name'=>$roleType
        ];
        $url = $this->apiUrl() . "/user/getUserRoleType";
        $resp = $this->post($url,$data);
        $data = Json::decode($resp->getBody(), true);
        if($data['responsedata']['status']=="success"){
             foreach ($data['responsedata']['data'] as $res) {
                 $comma_string[] = $res['id'];
                //$ids = implode(',',$res['id']);
             }
            $val = implode(",", $comma_string);
        }
        return $val;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 20-July-2022
     * @description : FUNCTION TO GET ROLE TYPE
     * @param $data
     * @returns $responsedata
     */
    public function getAllUserRoleType($roleType) {
        $val = "";
        $roleTypeData = [
            'role_type' =>$roleType
        ];
        $url = $this->apiUrl() . "/user/getUserRoleList";
        $resp = $this->post($url,$roleTypeData);
        $roleJsonData = Json::decode($resp->getBody(), true);
        if($roleJsonData['responsedata']['status']=="success"){
             foreach ($roleJsonData['responsedata']['data'] as $res) {
                 $comma_string[] = $res['Role_ID'];
                //$ids = implode(',',$res['id']);
             }
            $val = implode(",", $comma_string);
        }
        return $val;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET ALL USER LIST
     * @param $data
     * @returns $responsedata
     */
    
    public function getUserList($data) {
        $url = $this->apiUrl() . "/user-management/users";
        $resp = $this->post($url, $data);
        $userList = Json::decode($resp->getBody(), true);
        if ($userList['responsedata'] != "") {
            $val = ["status" => true, "data" => Json::decode($resp->getBody(), true)];
        } else {
            $val = ["status" => false, "data" => Json::decode($resp->getBody(), true)];
        }
        return $val;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET DRIVER LIST
     * @param $data
     * @returns $responsedata
     */
    public function getDriverList($data) {
        $url = $this->apiUrl() . "/user-management/drivers";
        $resp = $this->post($url, $data);
        $userList = Json::decode($resp->getBody(), true);
        if ($userList['responsedata'] != "") {
            $val = ["status" => true, "data" => Json::decode($resp->getBody(), true)];
        } else {
            $val = ["status" => false, "data" => Json::decode($resp->getBody(), true)];
        }
        return $val;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET SMS HISTORY
     * @param $data
     * @returns $responsedata
     */
    public function getSmsHistory($user_id) {
        $val = '{"where": {"uid": "' . $user_id . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/sms-status?&filter=" . $val;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET EMAIL HISTORY
     * @param $data
     * @returns $responsedata
     */
    public function getEmailHistory($user_id) {
        $val = '{"where": {"uid": "' . $user_id . '"}}';
        $val = rawurlencode($val);
        $url = $this->apiUrl() . "/email-history?&filter=" . $val;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET STATUS HISTORY
     * @param $data
     * @returns $responsedata
     */
    
    public function getStatusHistory($user_id, $from_date, $to_date) {
        $url = $this->apiUrl() . "/user/statusHistory?user_id=" . $user_id . "&from_date=" . $from_date . "&to_date=" . $to_date;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET ALLOCATION HISTORY
     * @param $data
     * @returns $responsedata
     */
    
    public function getAllocationHistory($user_id, $from_date, $to_date) {
        $url = $this->apiUrl() . "/user/allocationHistory?user_id=" . $user_id . "&from_date=" . $from_date . "&to_date=" . $to_date;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET BOOKING HISTORY
     * @param $data
     * @returns $responsedata
     */
    public function getBookingHistory($data) {
        $url = $this->apiUrl() . "/booking/bookingList";
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        $result = [];
        if($data['responsedata']['status']=='success'){
           $result  = $data['responsedata']['data'];
        }
        return $result;
    }

     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET DRIVER LEDGER
     * @param $data
     * @returns $responsedata
     */
    
    public function getDriverLedger($user_id, $from_date, $to_date) {
        $url = $this->apiUrl() . "/user/driverLedger?user_id=" . $user_id . "&from_date=" . $from_date . "&to_date=" . $to_date;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }


    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET PAYMENT HISTORY
     * @param $data
     * @returns $responsedata
     */
    
    public function getPaymentHistory($user_id) {
        $url = $this->apiUrl() . "/user/paymentHistory?user_id=" . $user_id;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }


    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO UPDATE USER STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateUserStatus($data) {
        $url = $this->apiUrl() . "/user-management/userStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO UPDATE MARKUP STATUS
     * @param $data
     * @returns $responsedata
     */
    
    public function updateMarkupStatus($data) {
        $url = $this->apiUrl() . "/markup/markupStatus"; //die;
        $resp = $this->put($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO ADD NEW USER
     * @param $data
     * @returns $responsedata
     */
    
    public function addNewUser($data) {
        $url = $this->apiUrl() . "/user/adduser";
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO ADD NEW ROLE
     * @param $data
     * @returns $responsedata
     */
    
    public function addNewRole($data) {
        $url = $this->apiUrl() . "/user/adduser";
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET STATE ID
     * @param $data
     * @returns $responsedata
     */
    public function getStateId($id) {
        $url = $this->apiUrl() . "/state/".$id;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

     /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO ADD STAFF
     * @param $data
     * @returns $responsedata
     */
    
    public function addstaff($data) {
        $url = $this->apiUrl() . "/user/signup";
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO UPDATE STAFF
     * @param $data
     * @returns $responsedata
     */

    public function updatestaff($data){
        $url = $this->apiUrl() . "/user/updatestaff";
        $resp = $this->post($url, $data);
        $data = Json::decode($resp->getBody(), true);
        return $data;
    }

   /** @Desc     : Function to Get User Staff By user Id & user type id
    * @CreatedBy : Mohit Verma
    * @createdDate : 4-May-2019
    **/
    public function getUserStaff($data) {
        $result = [];
        $dataUser = [];
        $userId     = $data['user_id'];
        $userTypeId = $data['user_type_id'];
        $dataUser = [
            'user_id'=>$data['user_id'],
            'user_type_id'=>$data['user_type_id'],
        ];
        if($userId>0){
            $url = $this->apiUrl() . "/user/getuserstaff";
            $resp = $this->post($url,$dataUser);
            $result = Json::decode($resp->getBody(), true);
        }
        return $result;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO UPLOAD IMAGE
     * @param $data
     * @returns $responsedata
     */

    public function uploadImage(){
        $kycFile    =   $_FILES['kyc_upload']['name'];
        $kycFile    =   file_get_contents($_FILES['kyc_upload']['tmp_name']);
        $kycFile = base64_encode($kycFile);
        $finalData['base64image']= $kycFile;
        $url = $this->apiUrl() . "/user/uploadImg";
        $val = $this->post($url, $finalData);
        $JsonData = $val->getBody();
        $JsonData = Json::decode($JsonData, true);
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET USER TYPE
     * @param $data
     * @returns $responsedata
     */

    public function getUserType($id){
        $url = $this->apiUrl() . "/user/getusertype?user_id=".$id;
        $resp = $this->get($url);
        $data = Json::decode($resp->getBody(), true);
        $val = $data['responsedata']['data']['user_type_id'];
        return $val;
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO CHANGEE PASSWORD
     * @param $data
     * @returns $responsedata
     */

    public function changePassword($data){
        $url = $this->apiUrl() . "/user/changePassword";
        $resp = $this->post($url,$data);
        $data = Json::decode($resp->getBody(), true);
        return $data['response'];
    }
    
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO USER CHANGE PASSWORD
     * @param $data
     * @returns $responsedata
     */

    public function userChangePassword($data){
        $url = $this->apiUrl() . "/user/userChangePassword";
        $resp = $this->post($url,$data);
        $data = Json::decode($resp->getBody(), true);
        return $data['response'];
    }
    
    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO CHANGE DATE FORMAT
     * @param $data
     * @returns $responsedata
     */

    public function changeDateFormat($date) {
        if($date!=""){
        $data = date('Y-m-d',strtotime($date));
        }else{
        $data = "";
        }
        return $data;
     }

    /**
     * @CreatedBy : Mohit Jain
     * @createdDate : 02-August-2019
     * @description : FUNCTION TO GET USER DOCUMENT
     * @param $data
     * @returns $responsedata
     */
    public function getUserDocument($id,$filename)
    {
        $url = $this->apiUrl() . "/user-management/useruploaddocuments?user_id=".$id."&filename=".$filename;
        $resp = $this->get($url);
        $JsonData = $resp->getBody();
        $JsonData = Json::decode($JsonData, true);
        return $JsonData;
    }
}
