<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Email,
    Textarea,
    Number
};


class UserManagementSearchForm extends Form {

    public static $country = [];
    public static $state = [];
    public static $city = [];
    public static $usertype = [];
    public static $usertype_status = [];
    public function __construct($name = null) {

        parent::__construct('user-management-search-form');
        $this->setAttribute('method', 'post');

        /**
         *
         * Login ID
         */
        $this->add([
            'name' => 'user_id',
            'type' => Number::class,
            'attributes' => [
                'id' => 'user-id',
                'placeholder' => 'Login ID',
                'class' => 'form-control inputchange',
                'onkeypress'=>'return isNumber(event)'
            ],
            'options' => [
                'label' => 'Login ID<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Contact No
         */
        $this->add([
            'name' => 'mobile_number',
            'type' => Number::class,
            'attributes' => [
                'id' => 'mobile-number',
                'placeholder' => 'Mobile No',
                'class' => 'form-control inputchange',
                'onkeypress'=>'return isNumber(event)'
                
            ],
            'options' => [
                'label' => 'Mobile No<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



        /**
         *
         * country
         */
        $this->add([
            'name' => 'country_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'country-id',
                'placeholder' => '',
                'class' => 'form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Country',
                'value_options' => self::$country,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Country--',
            ],
        ]);


        /**
         *
         * country
         */
        $this->add([
            'name' => 'state_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'state-id',
                'placeholder' => '',
                'class' => 'form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'State',
                'value_options' => self::$state,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select State--',
            ],
        ]);


        /**
         *
         * country
         */
        $this->add([
            'name' => 'city_id',
            'type' => Select::class,
            'attributes' => [
                'id' => 'city-id',
                'placeholder' => '',
                'class' => 'form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'City',
                'value_options' => self::$city,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select City--',
            ],
        ]);

        /**
         * User Type
         */
        $this->add([
            'name' => 'user_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'user-type-id',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'User Type<span style="color: red"> *</span>',
                'value_options' => self::$usertype,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select User Type--',
            ]
        ]);

        /**
         * Name
         */
        $this->add([
            'name' => 'name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'name',
                'placeholder' => 'Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Email ID
         */
        $this->add([
            'name' => 'email',
            'type' => Email::class,
            'attributes' => [
                'id' => 'email',
                'class' => 'form-control inputchange',
                'placeholder' =>'Email Id'
            ],
            'options' => [
                'label' => 'Email ID<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         *
         * Status
         */
        $this->add([
            'name' => 'status',
            'type' => Radio::class,
            'attributes' => [
                'id' => 'status',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Status<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

         /**
         *
         * User Type Status
         */
       $this->add([
            'name' => 'user_type_status',
            'type' => Select::class,
            'attributes' => [
                'id' => 'user-type-status',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Status',
                'value_options' => self::$usertype_status,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Status--',
            ]
        ]);
        
        /**
         * Search
         */
        $this->add([
            'name' => 'search_user',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search',
                'id' => 'search-user',
                'class' => 'btn btn-red defaultbtnsearch btn-warning'
            ],
        ]);

        /**
         * Clear
         */
        $this->add([
            'name' => 'clear_button',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'clear-button-id',
                'placeholder' => 'Submit',
                'class' => 'btn btn-red btn-warning',
                'value' => 'Clear'
            ],
        ]);
    }

}
