<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Date,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden
};
use Zend\Validator\{
    NotEmpty
};
use Zend\InputFilter\InputFilterProviderInterface;

class ProfileOtherDetailForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {

        parent::__construct('profile-other-detail');
        $this->setAttribute('method', 'post');

        /**
         * Route Knowledge
         */
        $this->add([
            'name' => 'route_know',
            'type' => Select::class,
            'attributes' => [
                'id' => 'route-know',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Route Knowledge<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
                'empty_option' => 'Select',
                'value_options' => [
                    'No' => 'No',
                    'Yes' => 'Yes'
                ]
            ],
        ]);

        /**
         * Pref Location/Zone
         */
        $this->add([
            'name' => 'zone',
            'type' => Select::class,
            'attributes' => [
                'id' => 'zone',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Pref Location/Zone<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true,
                'empty_option' => 'Select',
                'value_options' => [
                    'Center' => 'Center',
                    'North' => 'North',
                    'South' => 'South',
                    'East' => 'East',
                    'West' => 'West'
                ]
            ],
        ]);

        /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'submit_type',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'submit-type',
                'class' => 'form-control',
                'value' => 'submit'
            ]
        ]);

        /**
         * Reset
         */
        $this->add([
            'name' => 'other_reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'other-reset',
                'placeholder' => 'Reset',
                'class' => 'reset_btn btn btn-success btn-new-vehile'
            ],
        ]);

        /**
         * Save
         */
        $this->add([
            'name' => 'other_save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'other-save',
                'value' => 'Save',
                'placeholder' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-new-vehile profile_save btn-warning'
            ],
        ]);

        /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'user_id',
            'type' => Text::class
        ]);

         /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'id',
            'type' => Text::class
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'route_know' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Route Knowledge'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'zone' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Zone'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
