<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Date,
    Radio,
    Submit,
    Password,
    Checkbox,
    Email,
    Hidden
};
use Zend\InputFilter\InputFilterProviderInterface;
use Zend\Validator\{
    NotEmpty,
    Digits,
    StringLength,
    EmailAddress,
    Identical
};
use Zend\Validator\File\Size;

class ProfileChangePasswordForm extends Form implements InputFilterProviderInterface {

    public function __construct($name = null) {

        parent::__construct('profile-change-password');
        $this->setAttribute('method', 'post');

        /**
         * Old Password
         */
        $this->add([
            'name' => 'old_password',
            'type' => Password::class,
            'attributes' => [
                'id' => 'old-password',
                'placeholder' => 'Old Password',
                'class' => 'form-control inputchange '
            ],
            'options' => [
                'label' => 'Old Password<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * New Password
         */
        $this->add([
            'name' => 'new_password',
            'type' => Password::class,
            'attributes' => [
                'id' => 'new-password',
                'placeholder' => 'New Password',
                'class' => 'form-control inputchange '
            ],
            'options' => [
                'label' => 'New Password<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Confirm Password
         */
        $this->add([
            'name' => 'confirm_password',
            'type' => Password::class,
            'attributes' => [
                'id' => 'confirm-password',
                'placeholder' => 'Confirm Password',
                'class' => 'form-control inputchange '
            ],
            'options' => [
                'label' => 'Confirm Password<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Reset
         */
        $this->add([
            'name' => 'profile_reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'profile-reset',
                'value' => 'Reset',
                'class' => 'reset_btn btn btn-success reset_btn'
            ],
        ]);

        /**
         * Submit
         */
        $this->add([
            'name' => 'profile_submit',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'profile-submit',
                'value' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-new-vehile profile_save btn-warning'
            ],
        ]);

        /**
         * Hidden Field...
         */
        $this->add([
            'name' => 'user_id',
            'type' => Text::class
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'old_password' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter old password.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'new_password' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter new password.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 6,
                            'messages' => [
                                StringLength::TOO_SHORT => 'Please enter greater than 5 Digits',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'confirm_password' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter confirm password.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 6,
                            'messages' => [
                                StringLength::TOO_SHORT => 'Please enter greater than 5 Digits',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Identical',
                        'options' => [
                            'token' => 'new_password',
                            'messages' => [
                                Identical::NOT_SAME => 'Please enter same password.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
        ];
    }

}
