<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;

use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Email;
class PaymentSearchForm extends Form {

    public function __construct($name = null) {

        parent::__construct('payment-search-form');
        
        /**
         * 
         * Gateway Name
         */
        $this->add([
            'name' => 'gateway_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'gateway-name',                
                'class' => 'form-control',
                'placeholder' =>'gateway name'
            ],
            'options' => [
                'label' => 'Gateway Name<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Status
         */
        $this->add([
            'name' => 'activestatus',
            'type' => radio::class,
            'attributes' => [
                'id' => 'activestatus_id',    
                'placeholder' => '',
                'class' => 'form-control',
            ],
            'options' => [
                
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        $this->add([
            'name' => 'deactivestatus',
            'type' => radio::class,
            'attributes' => [
                'id' => 'deactivestatus_id',    
                'placeholder' => '',
                'class' => 'form-control',
            ],
            'options' => [
               
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * User For
         */
        $this->add([
            'name' => 'user_for_website',
            'type' => Checkbox::class,
            'attributes' => [
                'value' => 'Submit',
                'id' => 'user-for',
                'class' => '',
            ],
        ]); 
        
        /**
         * 
         * User For
         */
        $this->add([
            'name' => 'user_for_mobile',
            'type' => Checkbox::class,
            'attributes' => [
               
                'id' => 'user-for',
                'class' => '',
            ],
        ]); 

        /**
         * 
         * Search
         */
        $this->add([
            'name' => 'search',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search',
                'id' => 'search',
                'class' => 'btn btn-primary btn-lg',
            ],
        ]);        
    }

}
