<?php

namespace Dashboard\Form;

use Zend\Form\Form;
//use Zend\Form\Element;
//use Zend\Form\Element\Select;
//use Zend\Form\Element\Text;
//use Zend\Form\Element\Textarea;
//use Zend\Form\Element\Submit;

use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden,
    Textarea,
    File
};
use Zend\Validator\{
    NotEmpty,
    Digits
};

use Zend\InputFilter\InputFilterProviderInterface;

class ManageDocumentationForm extends Form implements InputFilterProviderInterface {    
   

    public function __construct($name = null) {

        parent::__construct('manage-documentation');
        
         
        
        /**
         * 
         * Country ...
         */
         
            
        $this->add([
            'name' => 'country',
            'type' => Select::class,
            'attributes' => [
                'id' => 'country',
                'class' => 'selectpicker form-control',
                'data-show-subtext'=>true,
                'data-live-search'=>true,
                'style'=>'display: none'
            ],
            'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Country -- ',
                'value_options' => [
                    '1' => 'India',
                    '2' => 'China',
                    '3' => 'Rusia',
                    '4' => 'USA',
                    '5' => 'Jappan'
                    
                ],
            ],
        ]);
        
            /**
         * 
         * booking type ...
         */
           
        
         $this->add([
            'name' => 'booking_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking_type',
                'class' => 'selectpicker form-control',
                'data-show-subtext'=>true,
                'data-live-search'=>true,
                'style'=>'display: none'
            ],
            'options' => [
                'disable_inarray_validator' => true,
                'empty_option' => ' -- Select Booking Type -- ',
                'value_options' => [
                    '1' => 'Domestic FIT',
                    '2' => 'Domestic Group',
                    '3' => 'International Group',
                    '4' => 'International Fit',
                    '5' => 'Inbound Fit',
                    '6' => 'Inbound Group',
                    '7' => 'Domestic Hotel Booking',
                    '8' => 'International Hotel Booking',
                    
                ],
            ],
        ]);
        
        /**         
         * 
         * Inclusions Name...
         */
        $this->add([
            'name' => 'title',
             'type' => Text::class,
            'attributes' => [
                'id' => 'title',  
                'placeholder' => 'title',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'title<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**         
         * 
         * Thumb Image...
         */
        $this->add([
            'name' => 'thumb_image',
             'type' => File::class,
            'attributes' => [
                'id' => 'thumb-image',                  
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Thumb Image<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        
         
        /**
         * 
         * Description ...
         */
         
        
          $this->add([
            'name' => 'page_desc',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'page-desc',
                'placeholder' => 'Content',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Content<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
           
          
   
        
        
   
         
         
         
         /**
         * 
         * Save...
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => 'btn btn-red defaultbtnsearch btn-warning',
            ],
        ]);   
        
        
    }
  public function getInputFilterSpecification() {
        return [   
            
            
             
          'title' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Fill Title Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
             
//          'thumb_image' => [
//                'required' => true,
//                'filters' => [
//                    ['name' => 'StripTags'],
//                    ['name' => 'StringTrim']
//                ],
//                'validators' => [
//                    ['name' => 'NotEmpty',
//                        'options' => [
//                            'messages' => [
//                                NotEmpty::IS_EMPTY => 'Please Upload Thumb Image'
//                            ]
//                        ],
//                        'break_chain_on_failure' => true
//                    ]
//                ]
//            ],
          
          'page_desc' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Give Description'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
             'country' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Country'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            
            'booking_type' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Booking Type'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
             
            ];
    

}
}
