<?php

namespace Dashboard\Form;
use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    Date,
    Number,
    Checkbox,
    Text,
    Submit,
    Hidden,
    Textarea,
    File
};
use Zend\Validator\{
    NotEmpty,
    Digits
};

use Zend\InputFilter\InputFilterProviderInterface;

class MailForm extends Form implements InputFilterProviderInterface {    
   

    public function __construct($name = null) {

        parent::__construct('mail-template');
        
        /**         
         * 
         *  Id...
         */
         $this->add([
            'name' => 'id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'id',
                'class' => 'form-control'
            ],
        ]);
        
        /**         
         * 
         *  Name...
         */
         $this->add([
            'name' => 'name',
            'type' => text::class,
            'attributes' => [
                'id' => 'name',
                'class' => 'form-control'
            ],
        ]);
         
         /**         
         * 
         *  Type...
         */
         $this->add([
            'name' => 'type',
            'type' => text::class,
            'attributes' => [
                'id' => 'type',
                'class' => 'form-control'
            ],
        ]);
         
         /**
         * 
         * Upload Image...
         */
        $this->add([
            'name' => 'upload_img',
            'type' => File::class,
            'attributes' => [
                'id' => 'upload-img',
                'class' => 'form-control'
            ],
            'options' => [          
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);
         
         /**         
         * 
         *  Header Text...
         */
         $this->add([
            'name' => 'header_text',
            'type' => Text::class,
            'attributes' => [
                'class' => 'form-control',
                'id' => 'header-text'
            ],
        ]);
         
        /**         
         * 
         *  Header Text...
         */
         $this->add([
            'name' => 'footer_text',
            'type' => Text::class,
            'attributes' => [
                'class' => 'form-control',
                'id' => 'header-text'
            ],
        ]);
         
          /**         
         * 
         *  Description...
         */
         $this->add([
            'name' => 'description',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'description',
                'class' => 'form-control',
            ],
        ]);
        
       
 
         /**
         * 
         * Save...
         */
        $this->add([
            'name' => 'submit',
            'type' => Submit::class,
            'options' => [
            'label'   => '<i class="icon icon-foo"></i> Submit',
           // 'icon'    => '<i class="fa fa-save>',
            'disable_html_escape' => true,
    ],
            'attributes' => [
                'value' => 'Save',
                'id' => 'submit-button',
                'class' => ' btn-primary btn-warning',
            ],
           
            
        ]);   
        
        
        
    }
  public function getInputFilterSpecification() {
        return [   
            
            
             
            'name' => [
               'required' => true,
               'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
               ],
                'validators' => [
                    ['name' => 'NotEmpty',
                       'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => "Please Fill Email"
                            ]
                       ],
                        'break_chain_on_failure' => true
                    ]
                ]
           ],
            
            'type' => [
               'required' => true,
               'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
               ],
                'validators' => [
                    ['name' => 'NotEmpty',
                       'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Select Type'
                            ]
                       ],
                        'break_chain_on_failure' => true
                    ]
                ]
           ],
            'header_text' => [
               'required' => true,
               'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
               ],
                'validators' => [
                    ['name' => 'NotEmpty',
                       'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Hedaer Content'
                            ]
                       ],
                        'break_chain_on_failure' => true
                    ]
                ]
           ],
            'footer_text' => [
               'required' => true,
               'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
               ],
                'validators' => [
                    ['name' => 'NotEmpty',
                       'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Footer Content'
                            ]
                       ],
                        'break_chain_on_failure' => true
                    ]
                ]
           ],
            'description' => [
               'required' => true,
               'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
               ],
                'validators' => [
                    ['name' => 'NotEmpty',
                       'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Provide Description'
                            ]
                       ],
                        'break_chain_on_failure' => true
                    ]
                ]
           ],
           
            
            ];
    

}
}
