<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Submit,
    Textarea
};
use Zend\Validator\{
    NotEmpty,
    EmailAddress
};
use Zend\InputFilter\InputFilterProviderInterface;

class JavaScriptCodeForm extends Form {

    public function __construct($name = null) {
        parent::__construct('javascript-form');
        $this->setAttribute('method', 'post');


        /**
         *
         * Google Analytics
         */
        $this->add([
            'name' => 'analytics_code',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'analytics-code',
                'placeholder' => 'data',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Google Analytics : ',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * Additional Javascript
         */
        $this->add([
            'name' => 'additional_javascript',
            'type' => Textarea::class,
            'attributes' => [
                'id' => 'additional-javascript',
                'placeholder' => 'Data',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Additional Javascript : ',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         *
         * button System Backup
         */
        $this->add([
            'name' => 'system_backup',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'system-backup-id',
                'placeholder' => 'System Backup',
                'class' => 'btn btn-info',
            ],
        ]);

        /**
         *
         * button Restore
         */
        $this->add([
            'name' => 'restore',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'restore-id',
                'placeholder' => 'Restore',
                'class' => 'btn btn-danger',
            ],
        ]);

        /**
         *
         * button reset
         */
        $this->add([
            'name' => 'reset',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'reset-id',
                'placeholder' => 'reset',
                'class' => 'btn btn-success',
            ],
        ]);

        /**
         *
         * save
         */
        $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'javascript-code-save-btn',
                'placeholder' => 'Save',
                'class' => 'save_data_btn btn btn-primary btn-warning pull-right margin-L-1',
                'Value' => 'Save',
                'onclick' => "submitForm('#javascript-form', event);"
            ],
        ]);
    }

}
