<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden,
    Date
};
use Zend\Validator\{
    NotEmpty,
    Digits
};

use Zend\InputFilter\InputFilterProviderInterface;

class FareAddSearchForm extends Form implements InputFilterProviderInterface {

    public static $country = [];
    public static $state = [];
    public static $city = [];
    public static $booking_type = [];
    public static $booking_mode_type = [];
    public static $vehicle_type = [];
    public static $currency = [];
    public static $client = [];

    public function __construct($name = null) {

        parent::__construct('add-fare');

        $this->setAttribute('method', 'post');

        /**
         * Accept the Terms and Conditions
         */
        $this->add([
            'name' => 'market_place',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'market-place',
                'checked' => 'checked'
            ],
            'options' => [
                'label' => 'Market Place',
                'checked_value' => '1',
                'unchecked_value' => '0',
                'use_hidden_element' => true
            ],
        ]);

        /**
         * Accept the Terms and Conditions
         */
        $this->add([
            'name' => 'weekend[]',
            'type' => Checkbox::class,
            'attributes' => [
                'id' => 'weekend',
                'checked' => 'checked'
            ],
            'options' => [
                'label' => '',
                'checked_value' => '1',
                'unchecked_value' => 'no',
                'use_hidden_element' => false
            ],
        ]);


        /**
         *
         * country
         */
        /*$this->add([
            'name' => 'fare_country',
            'type' => Select::class,
            'attributes' => [
                'id' => 'fare-country-id',
                'placeholder' => '',
                'class' => 'form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Country',
                'value_options' => self::$country,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Country--',
            ],
        ]);*/


        /**
         *
         * country
         */
//        $this->add([
//            'name' => 'fare_state',
//            'type' => Select::class,
//            'attributes' => [
//                'id' => 'fare-state-id',
//                'placeholder' => '',
//                'class' => 'form-control',
//            ],
//            'options' => [
//                'label' => 'State',
//                'value_options' => self::$state,
//                'disable_inarray_validator' => true,
//                'empty_option' => '--Select State--',
//            ],
//        ]);


        /**
         *
         * city
         */
        /*$this->add([
            'name' => 'fare_city',
            'type' => Select::class,
            'attributes' => [
                'id' => 'fare-city-id',
                'placeholder' => '',
                'class' => 'form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true',
                //'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'City',
                'value_options' => self::$city,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select City--',
            ],
        ]);*/

        /**
         *
         * city
         */
        $this->add([
            'name' => 'fare_city',
            'type' => Text::class,
            'attributes' => [
                'id' => 'fare-city',
                'placeholder' => '',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'City'
            ],
        ]);

        $this->add([
            'name' => 'city_search',
            'type' => \Zend\Form\Element\Textarea::class,
            'attributes' => [
                'id' => 'city-search',
                //'placeholder' => '',
                'class' => 'form-control',
                'class' => 'demo-default selectized form-control',
                'multiple' => 'multiple',
            ],
            'options' => [
                'label' => 'City'
            ],
        ]);

        $this->add([
            'name' => 'fare_city_id',
            'type' => hidden::class,
            'attributes' => [
                'id' => 'fare-city-id',
            ],
        ]);

        $this->add([
            'name' => 'city_search_id',
            'type' => hidden::class,
            'attributes' => [
                'id' => 'city-search-id',
            ],
        ]);

        $this->add([
            'name' => 'fare_state',
            'type' => hidden::class,
            'attributes' => [
                'id' => 'fare-state-id',
            ],
             'options' => [
                'label' => 'State'
            ],
        ]);

        $this->add([
            'name' => 'fare_country',
            'type' => hidden::class,
            'attributes' => [
                'id' => 'fare-country-id',
            ],
             'options' => [
                'label' => 'Country'
            ],
        ]);


        /**
         *
         * state
         */
        /* $this->add([
          'name' => 'state[]',
          'type' => Select::class,
          'attributes' => [
          'id' => 'state-id',
          'placeholder' => '',
          'class' => 'demo-default select-state selectized selectized-state form-control',
          'mutiple' => 'mutiple',
          ],
          'options' => [
          'label' => 'State',
          'value_options' => self::$state,
          'empty_option' => '--Select State--',
          ],
          ]); */


        /**
         *
         * city
         */
        /* $this->add([
          'name' => 'city[]',
          'type' => Select::class,
          'attributes' => [
          'id' => 'state-id',
          'placeholder' => '',
          'class' => 'demo-default select-state selectized form-control',
          'mutiple' => 'mutiple',
          ],
          'options' => [
          'label' => 'City',
          'value_options' => self::$city,
          'empty_option' => '--Select City--',
          ],
          ]); */

        /**
         *
         * booking_type
         */
        $this->add([
            'name' => 'booking_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-type',
                'placeholder' => '',
                'class' => 'selectpicker form-control country-select',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Booking Type',
                'value_options' => self::$booking_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Booking Type--',
            ],
        ]);


        /**
         *
         * booking_mode_type
         */
        $this->add([
            'name' => 'booking_mode_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-mode-type',
                'placeholder' => '',
                'class' => 'selectpicker form-control country-select',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Booking Mode',
                'value_options' => self::$booking_mode_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Mode--',
            ],
        ]);




        /**
         *
         * cab Type
         */
        $this->add([
            'name' => 'vehicle_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vehicle-type',
                'placeholder' => '',
                'class' => 'selectpicker form-control country-select',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Vehicle Type',
                'value_options' => self::$vehicle_type,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Vehicle Type--',
            ],
        ]);


        /**
         *
         * Garage Own Address
         */
        $this->add([
            'name' => 'garage_own_address',
            'type' => Text::class,
            'attributes' => [
                'id' => 'garage-own-address',
                'placeholder' => 'Address',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => '',
            ],
        ]);


        /**
         *
         * Garage Own State
         */
        $this->add([
            'name' => 'garage_own_state',
            'type' => Select::class,
            'attributes' => [
                'id' => 'garage-own-state',
                'placeholder' => '',
                'class' => 'form-control fare-state',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => '',
                'value_options' => self::$state,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select State--',
            ],
        ]);

        /**
         *
         * Garage Own City
         */
        $this->add([
            'name' => 'garage_own_city',
            'type' => Select::class,
            'attributes' => [
                'id' => 'garage-own-city',
                'placeholder' => '',
                'class' => 'form-control fare-city',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => '',
                'value_options' => self::$city,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select City--',
            ],
        ]);

        /**
         *
         * Garage Own Pincode
         */
        $this->add([
            'name' => 'garage_own_pincode',
            'type' => Text::class,
            'attributes' => [
                'id' => 'garage-own-pincode',
                'placeholder' => 'Pin Code',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => '',
            ],
        ]);


        /**
         *
         * Garage Company Address
         */
        $this->add([
            'name' => 'garage_comp_address',
            'type' => Text::class,
            'attributes' => [
                'id' => 'garage-comp-address',
                'placeholder' => 'Company Address',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => '',
            ],
        ]);


        /**
         *
         * Garage Company State
         */
        $this->add([
            'name' => 'garage_comp_state',
            'type' => Select::class,
            'attributes' => [
                'id' => 'garage-comp-state',
                'placeholder' => '',
                'class' => 'form-control fare-state',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => '',
                'value_options' => self::$state,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select State--',
            ],
        ]);

        /**
         *
         * Garage Company City
         */
        $this->add([
            'name' => 'garage_comp_city',
            'type' => Select::class,
            'attributes' => [
                'id' => 'garage-comp-city',
                'placeholder' => '',
                'class' => 'form-control fare-city',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => '',
                'value_options' => self::$city,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select City--',
            ],
        ]);

        /**
         *
         * Garage Company Pincode
         */
        $this->add([
            'name' => 'garage_comp_pincode',
            'type' => Text::class,
            'attributes' => [
                'id' => 'garage-comp-pincode',
                'placeholder' => 'Company Pin Code',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => '',
            ],
        ]);


        /**
         *
         * client
         */
        /* $this->add([
          'name' => 'client[]',
          'type' => Select::class,
          'attributes' => [
          'id' => 'client-id',
          'placeholder' => '',
          'class' => 'demo-default select-state selectized form-control',
          'mutiple' => 'mutiple',
          ],
          'options' => [
          'label' => 'City',
          'value_options' => self::$client,
          'empty_option' => '--Select Client--',
          ],
          ]); */

        /**
         *
         * client
         */
        $this->add([
            'name' => 'client',
            'type' => Select::class,
            'attributes' => [
                'id' => 'client-id',
                'placeholder' => '',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Client Name',
                'value_options' => self::$client,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Client--',
            ],
        ]);


        /**
         * From Date
         */
        $this->add([
            'name' => 'fare_date_from',
            'type' => text::class,
            'attributes' => [
                'id' => 'fare-date-from',
                'placeholder' => 'From Date',
                'class' => 'form-control datepicker'
            ],
            'options' => [
                'label' => 'From Date',
            ],
        ]);


        /**
         * To Date
         */
        $this->add([
            'name' => 'fare_date_to',
            'type' => text::class,
            'attributes' => [
                'id' => 'fare-date-to',
                'placeholder' => 'To Date',
                'class' => 'form-control datepicker'
            ],
            'options' => [
                'label' => 'To Date',
            ],
        ]);


        /**
         *
         * Currency
         */
        $this->add([
            'name' => 'currency',
            'type' => Select::class,
            'attributes' => [
                'id' => 'currency',
                'placeholder' => '',
                'class' => 'selectpicker form-control',
                'data-show-subtext' => 'true',
                'data-live-search' => 'true'
            ],
            'options' => [
                'label' => 'Currency',
                'value_options' => self::$currency,
                'disable_inarray_validator' => true,
                'empty_option' => '--Select Currency--',
            ],
        ]);


        /**
         *
         * Garage Own Address
         */
        $this->add([
            'name' => 'commission_value',
            'type' => Text::class,
            'attributes' => [
                'id' => 'commission-value',
                'placeholder' => 'Enter Value',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => '',
            ],
        ]);




        /**
         *
         * Add price
         */
        $this->add([
            'name' => 'add_price_button',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'add-price-id',
                'placeholder' => 'Submit',
                'class' => 'publish_all btn btn-orange btn-unapublish',
            ],
        ]);


        /**
         * Public Fare Selected
         */
        $this->add([
            'name' => 'public_fare_selected',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'public-fare-selected',
                'class' => 'inputMaterial'
            ]
        ]);

        /**
         * Client fare Selected
         */
        $this->add([
            'name' => 'client_fare_selected',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'client-fare-selected',
                'class' => 'inputMaterial'
            ]
        ]);


        /**
         * Point Dispatch Selected
         */
        $this->add([
            'name' => 'point_dispatch_selected',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'point-dispatch-selected',
                'class' => 'inputMaterial'
            ]
        ]);

        /**
         * Garage Dispatch Selected
         */
        $this->add([
            'name' => 'garage_dispatch_selected',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'garage-dispatch-selected',
                'class' => 'inputMaterial'
            ]
        ]);



         /**
         * Own Garage Selected
         */
        $this->add([
            'name' => 'own_garage_selected',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'own-garage-selected',
                'class' => 'inputMaterial'
            ]
        ]);

        /**
         * Company Garage Selected
         */
        $this->add([
            'name' => 'comp_garage_selected',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'comp-garage-selected',
                'class' => 'inputMaterial'
            ]
        ]);



         /**
         * Net Rate Selected
         */
        $this->add([
            'name' => 'net_rate_selected',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'net-rate-selected',
                'class' => 'inputMaterial'
            ]
        ]);

        /**
         * Commission Rate Selected
         */
        $this->add([
            'name' => 'commission_rate_selected',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'commission-rate-selected',
                'class' => 'inputMaterial'
            ]
        ]);


        /**
         *
         * Add price
         */
        $this->add([
            'name' => 'add_fare',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'add-fare',
                'value' => 'Save',
                'class' => 'btn btn-info form-control widthpercent100',
                'onclick'=>"submitForm('#add-fare',event);",
            ],
        ]);


        /**
         *
         * Search price
         */
        $this->add([
            'name' => 'search_fare',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'search-fare',
                'value' => 'Search',
                'class' => 'publish_all btn btn-orange btn-warning',
            ],
        ]);


        $this->add([
            'name' => 'clear_button',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'clear-button-id',
                'placeholder' => 'Submit',
                'class' => 'btn btn-red btn-warning',
                'value' => 'Clear'
            ],
        ]);
    }


    public function getInputFilterSpecification() {
        return [
            'client' => [
                 'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please Select Client'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
            ],

            'fare_country' => [
                 'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please Select Country'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
            ],

            'fare_state' => [
                 'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please Select State'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
            ],

            'fare_city' => [
                 'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please Select City'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
            ],


            'booking_type' => [
                 'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please Select Booking Type'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
            ],

            'booking_mode_type' => [
                 'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please Select Booking Mode'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
            ],

            'vehicle_type' => [
                 'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please Select Vehicle Type'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
            ],


            'garage_own_address' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Address'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

            'garage_own_state' => [
                 'required' => false,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Select State'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
            ],

            'garage_own_city' => [
                 'required' => false,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Select City'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
            ],

            'garage_own_pincode' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Pincode'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],


            'garage_comp_address' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Address'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

            'garage_comp_state' => [
                 'required' => false,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Select State'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
            ],

            'garage_comp_city' => [
                 'required' => false,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Select City'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
            ],

            'garage_comp_pincode' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Pincode'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],


            'fare_date_from' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter From Date'
                            ]
                        ],
                    ],
//                    ['name' => 'Date',
//                        'options' => [
//                            'messages' => [
//                                \Zend\Validator\Date::INVALID_DATE => '',
//                            ],
//                        ],
//                        'break_chain_on_failure' => true
//                    ],
                ]
            ],


            'fare_date_to' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter To Date'
                            ]
                        ],
                    ],
//                    ['name' => 'Date',
//                        'options' => [
//                            'messages' => [
//                                \Zend\Validator\Date::INVALID_DATE => '',
//                            ],
//                        ],
//                        'break_chain_on_failure' => true
//                    ],
                ]
            ],


            'currency' => [
                 'required' => true,
            'filters' => [
                ['name' => 'StripTags'],
                ['name' => 'StringTrim']
            ],
            'validators' => [
                [   'name' => 'NotEmpty',
                    'options' => [
                        'messages' => [
                            NotEmpty::IS_EMPTY => 'Please Select Currency'
                        ]
                    ],
                    'break_chain_on_failure' => true
                ]
            ]
            ],

            'commission_value' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Enter Value'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

                        'weekend[]' => [
                'required' => false,
                'validators' => [
                    ['name' => 'Digits',
                        'break_chain_on_failure' => true,
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please Accept the Terms and Conditions',
                            ],
                        ],
                    ],
                ],
            ],

        ];
    }

}
