<?php

namespace Dashboard\Form;
use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Email;
use Zend\Form\Element\Hidden;


class FareAddPriceDistanceWaitingForm extends Form {

    public function __construct($name = null) {
           parent::__construct('distance-waiting');
          $this->setAttribute('method', 'post');
        
      
          
        $this->add([
            'name' => 'distance_waiting_fare_id',
            'type' => Hidden::class,
        ]);   
         
        /**
         * 
         * Rate per km
         */
        $this->add([
            'name' => 'rate_per_km',
            'type' => Text::class,
            'attributes' => [
                'id' => 'rate-per-km-id',  
                'placeholder' => '100',
                'class' => 'form-control',
                 'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'Rate Per Km',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         * Ignore First Km After
         */
        $this->add([
            'name' => 'ignore_first_km_after',
            'type' => Text::class,
            'attributes' => [
                'id' => 'ignore-first-km-after-id',  
                'placeholder' => '1',
                'class' => 'form-control',
                 'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'Ignore First Km After',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         * 
         * Minimum Fare
         */
          $this->add([
            'name' => 'minimum_fare',
            'type' => Text::class,
            'attributes' => [
                'id' => 'minimum-fare-id',  
                'placeholder' => '800',
                'class' => 'form-control',
                'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'Minimum Fare',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
              
        /**
         * 
         * Minutes Up To
         */
          $this->add([
            'name' => 'minutes_upto',
            'type' => Text::class,
            'attributes' => [
                'id' => 'minutes-upto-id',  
                'placeholder' => '5',
                'class' => 'form-control',
                 'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'Minutes Upto',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Fee
         */
          $this->add([
            'name' => 'fee',
            'type' => Text::class,
            'attributes' => [
                'id' => 'fee-id',  
                'placeholder' => '10',
                'class' => 'form-control',
                 'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'Fee',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
          
          
          /**
         * 
         * After That Fees Per Minute
         */
          $this->add([
            'name' => 'after_that_fees_per_minutes',
            'type' => Text::class,
            'attributes' => [
                'id' => 'after-that-fees-per-minutes-id',  
                'placeholder' => '20',
                'class' => 'form-control',
                 'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'After That Fees Per Minutes',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
          
        
          /**
         * 
         * update all rows
         */
            $this->add([
            'name' => 'update_all_rows',
                'type' => Checkbox::class,
            'attributes' => [
                'id' => 'update-all-rows-id',    
                'placeholder' => '',
                'class' => 'checkmark',
               
            ],
            'options' => [
                'label' => 'Update All Rows',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 

          
            /**
         * 
         * Package Name
         */
            $this->add([
            'name' => 'distance_waiting_package_name[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-name-id',  
                'placeholder' => '10km',
                'class' => 'form-control allowtext',
                
            ],
            'options' => [
                'label' => 'Package Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
         /**
         * 
         * Ignore KM
         */
            $this->add([
            'name' => 'distance_waiting_ignore_km[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'ignore-km-id',  
                'placeholder' => '10',
                'class' => 'form-control',
                'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'Ignore KM',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
            
         /**
         * 
         * Amount
         */
            $this->add([
            'name' => 'distance_waiting_amount[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'distWaitLCLpkgAmount_1',  
                'placeholder' => '100',
                'class' => 'form-control',
                 'maxlength'=>8,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'Amount',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
            
         /**
         * 
         * Add
         */
              $this->add([
            'name' => 'package_name_ignore_km_amount_add',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'package-name-ignore-km-amount-add-id',    
                'placeholder' => 'Add',
                'class' => 'col-sm-4 add_DistWaitLCLpkg no-padding',
            ],
            
        ]);
              
         /**
         * 
         * save
         */
              $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'distance-waiting-btn',    
                'placeholder' => 'Save',
                'class' => 'btn btn-info form-control ',
                'value' =>'Save',
                'onclick'=>"submitForm('#distance-waiting', event);"
                
            ],
            
        ]);
              
              
         /**
         * 
         * next
         */
               $this->add([
            'name' => 'next',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'next-id',    
                'placeholder' => 'Save',
                'class' => 'btn btn-info form-control margin-bottom10px',
                 'value' =>'Next'
            ],
            
        ]);
            
            
            
            
            
    }

}
