<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\File;
use Zend\Form\Element\Text;
use Zend\Form\Element\Radio;
use Zend\Form\Element\Submit;
use Zend\Form\Element\Checkbox;
use Zend\Form\Element\Email;
use Zend\Form\Element\Hidden;



class FareAddPriceDistanceHourForm extends Form {

    public function __construct($name = null) {

        parent::__construct('distance-hour');

        $this->setAttribute('method', 'post');
        
         
       /**
         * Public Fare Selected
         */
        $this->add([
            'name' => 'distancehourid',
            'type' => Hidden::class,
          ]);         
        /**
         * 
         * rate per km
         */
        $this->add([
            'name' => 'rate_per_km',
            'type' => Text::class,
            'attributes' => [
                'id' => 'rate-per-km-id',  
                'placeholder' => '10',
                'class' => 'form-control',
                 'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'Rate Per Km',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
         /**
         * 
         * Ignore First Km After
         */
        $this->add([
            'name' => 'ignore_first_km_after',
            'type' => Text::class,
            'attributes' => [
                'id' => 'ignore-first-km-after-id',  
                'placeholder' => '1',
                'class' => 'form-control',
                 'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'Ignore First Km After',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

         /**
         * 
         * Ignore First Hours
         */
        $this->add([
            'name' => 'ignore_first_hours',
            'type' => Text::class,
            'attributes' => [
                'id' => 'ignore-first-hours-id',  
                'placeholder' => '1',
                'class' => 'form-control',
                 'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'Ignore First Hours',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        
        /**
         * 
         * Minimum Fare
         */
          $this->add([
            'name' => 'minimum_fare',
            'type' => Text::class,
            'attributes' => [
                'id' => 'minimum-fare-id',  
                'placeholder' => '800',
                'class' => 'form-control',
                 'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'Minimum Fare',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
           
          
          /**
         * 
         * Rate Per Hour
         */
          $this->add([
            'name' => 'rate_per_hour',
            'type' => Text::class,
            'attributes' => [
                'id' => 'rate-per-hour-id',  
                'placeholder' => '100',
                'class' => 'form-control',
                 'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'rate Per Hour',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
          
           /**
         * 
         * update all rows
         */
            $this->add([
            'name' => 'update_all_rows',
                'type' => Checkbox::class,
            'attributes' => [
                'id' => 'update-all-rows-id',    
                'placeholder' => '',
                'class' => 'checkmark',
               
            ],
            'options' => [
                'label' => 'Update All Rows',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]); 

              /**
         * 
         * Package Name
         */
            $this->add([
            'name' => 'distance_hour_package_name[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'package-name-id',  
                'placeholder' => '4Hrs-40km',
                'class' => 'form-control allowtext',
                
            ],
            'options' => [
                'label' => 'Package Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
         
            
               /**
         * 
         * Ignore Hours
         */
            $this->add([
            'name' => 'distance_hour_ignore_hours[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'ignore-hours-id',  
                'placeholder' => '4',
                'class' => 'form-control',
                
            ],
            'options' => [
                'label' => 'Ignore Hours',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
            
              /**
         * 
         * Ignore KM
         */
            $this->add([
            'name' => 'distance_hour_ignore_km[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'ignore-km-id',  
                'placeholder' => '40',
                'class' => 'form-control',
                 'maxlength'=>5,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'Ignore Km',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
             
                /**
         * 
         * Amount
         */
            $this->add([
            'name' => 'distance_hour_amount[]',
            'type' => Text::class,
            'attributes' => [
                'id' => 'pkg_amount_Dist_Hourly_1',  
                'placeholder' => '800',
                'class' => 'form-control',
                'maxlength'=>8,
                'onkeypress'=>"return isNumber(event)"
                
            ],
            'options' => [
                'label' => 'Amount',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
            
                    /**
         * 
         * Add
         */
              $this->add([
            'name' => 'package_name_ignore_hours_ignore_km_amount_add',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'package-name-ignore-hours-ignore-km-amount-add-id',    
                'placeholder' => 'Add',
                'class' => 'btn btn-info form-control ',
            ],
            
        ]);
              
         /**
         * 
         * save
         */
              $this->add([
            'name' => 'save',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'distance-hour-btn',    
                'placeholder' => 'Save',
                'class' => 'btn btn-info form-control ',
                'Value'=>'Save',
                'onclick'=>"submitForm('#distance-hour', event);"
            ],
            
        ]);
              
              
         /**
         * 
         * next
         */
               $this->add([
            'name' => 'next',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'next-id',    
                'placeholder' => 'Save',
                'class' => 'btn btn-info form-control margin-bottom10px',
                'value' =>'Next'
            ],
            
        ]);
             
    }

}
