<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\Text;
use Zend\Form\Element\Submit;


class DriverManagementLoginForm extends Form {
    
    public function __construct($name = null) {

        parent::__construct('driver-management-login-form');
        $this->setAttribute('method', 'post');      
        
       
        /**
         * Login Id...
         */
        $this->add([
            'name' => 'login_id',
            'type' => Text::class,
            'attributes' => [
                'id' => 'login-id',
                'placeholder' => 'Login Id',
                'class' => 'form-control inputchange login-id'
            ],
            'options' => [            
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);

        /**
         *Password...
         */
        $this->add([
            'name' => 'password',
            'type' => Text::class,
            'attributes' => [
                'id' => 'new-password',
                'placeholder' => 'password',
                'class' => 'form-control inputchange pwd'
            ],
            'options' => [               
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);
        
        /**
         *Confirm Password...
         */
        $this->add([
            'name' => 'confirm_password',
            'type' => Text::class,
            'attributes' => [
                'id' => 'confirm-password',
                'placeholder' => 'Confirm password',
                'class' => 'form-control inputchange conf-password'
            ],
            'options' => [               
                'label_options' => ['disable_html_escape' => true]
            ]
        ]);
        
        /**
         * Save...
         */
        $this->add([
            'name' => 'save_login_detail',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'save-login-detail', 
                'value' => 'Save',                
                'class' => 'btn btn-primary avatar-save col-sm-2 pull-right'
            ],
            
        ]);  
        
    }

}
