<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Date,
    Radio,
    Submit,
    Password,
    Checkbox,
    Email,
    Hidden
};
use Zend\InputFilter\InputFilterProviderInterface;
use Zend\Validator\{
    NotEmpty,
    Digits,
    StringLength,
    EmailAddress
};
use Zend\Validator\File\Size;

class CreditRequestForm extends Form implements InputFilterProviderInterface {

    public static $paymentModeList = ['Cheque'=>'Cheque','Cash Deposit'=>'Cash Deposit','Online Transfer'=>'Online Transfer','Demand Draft'=>'Demand Draft'];

    public function __construct($name = null) {

        parent::__construct('credit-request-form');
        $this->setAttribute('method', 'post');

        /**
         * Payment Ref No
         */
        $this->add([
            'name' => 'payment_ref_no',
            'type' => Text::class,
            'attributes' => [
                'id' => 'payment-ref-no',
                'placeholder' => 'Ref No',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Ref. ID',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Driver Name
         */
        $this->add([
            'name' => 'user_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'user-name',
                'placeholder' => 'Name',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Name',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Deposit Amount
         */
        $this->add([
            'name' => 'deposit_amount',
            'type' => Text::class,
            'attributes' => [
                'id' => 'deposit-amount',
                'placeholder' => 'Amount',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Deposit Amount',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Deposit Date
         */
        $this->add([
            'name' => 'deposit_date',
            'type' => Date::class,
            'attributes' => [
                'id' => 'deposit-date',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Deposit Date<span style="color:red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        $this->add([
            'name' => 'payment_mode',
            'type' => Select::class,
            'attributes' => [
                'id' => 'payment-mode',
                'class' => 'form-control input'
            ],
            'options' => [
                'label' => 'Payment Mode',
                'label_options' => ['disable_html_escape' => true],
                'value_options' => self::$paymentModeList,
                'disable_inarray_validator' => true,
                'empty_option' => 'Select',
            ],
        ]);

        /**
         * partner bank Accounts
         */
        $this->add([
            'name' => 'partner_bank',
            'type' => Text::class,
            'attributes' => [
                'id' => 'partner-bank',
                'placeholder' => 'Partner bank accounts',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Partner Bank Accounts<span style="color:red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);



        /**
         * Deposited Bank
         */
        $this->add([
            'name' => 'deposit_bank',
            'type' => Text::class,
            'attributes' => [
                'id' => 'deposit-bank',
                'placeholder' => 'Deposit bank',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Deposit Bank<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Deposited Branch
         */
        $this->add([
            'name' => 'deposit_branch',
            'type' => Text::class,
            'attributes' => [
                'id' => 'deposit-branch',
                'placeholder' => 'Deposit Branch',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Deposit Branch<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Remark/Request
         */
        $this->add([
            'name' => 'remark',
            'type' => Text::class,
            'attributes' => [
                'id' => 'remark',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Remarks<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Credit Date
         */
        $this->add([
            'name' => 'credit_date',
            'type' => Date::class,
            'attributes' => [
                'id' => 'credit-date',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Credit Date<span style="color:red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

         /**
         * Credit Amount
         */
        $this->add([
            'name' => 'credit_amount',
            'type' => Text::class,
            'attributes' => [
                'id' => 'credit-amount',
                'placeholder' => 'Amount',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Credit Amount',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Admin Remarks
         */
        $this->add([
            'name' => 'admin_remarks',
            'type' => Text::class,
            'attributes' => [
                'id' => 'admin-remarks',
                'placeholder' => '',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Admin Remarks<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * Search
         */
        $this->add([
            'name' => 'id',
            'type' => Hidden::class,
        ]);

        /**
         * Search
         */
        $this->add([
            'name' => 'driver_id',
            'type' => Hidden::class,
        ]);

       /**
         *
         * save
         */
        $this->add([
            'name' => 'save_approved',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'approve-save-btn',
                'placeholder' => 'Save',
                'class' => 'btn btn-primary pull-right',
                'Value' => 'Approved',
                'onclick' => "submitForm('#credit-request-form', event);"
            ],
        ]);

        /**
         *
         * save
         */
        $this->add([
            'name' => 'save_audit',
            'type' => Submit::class,
            'attributes' => [
                'id' => 'audit-save-btn',
                'placeholder' => 'Save',
                'class' => 'btn btn-primary pull-right',
                'Value' => 'Audit',
                'onclick' => "submitForm('#credit-request-form', event);"
            ],
        ]);
    }

    public function getInputFilterSpecification() {
        return [
            'partner_bank' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Partner bank Account'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'deposit_amount' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Amount'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Digits',
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please enter Numeric value only',
                            ],
                        ],
                        'break_chain_on_failure' => true,
                    ],
                ]
            ],
            'deposit_bank' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Deposit Bank'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'deposit_branch' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Deposit Branch'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'remark' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Remarks'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

            'credit_date' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Credit Date'
                            ]
                        ],
                    ],
                    ['name' => 'Date',
                        'options' => [
                            'messages' => [
                                //Date::INVALID_DATE => '',
                                \Zend\Validator\Date::INVALID_DATE => '',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],

            'credit_amount' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Credit Amount'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],


            'admin_remarks' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Admin Remarks'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],


        ];
    }

}
