<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\Submit;

class BookingPaymentSearchForm extends Form {

    public static $paymenttype=[];
    public static $ispaid=[];

    public function __construct($name = null) {

        parent::__construct('booking-payment-search-form');
        $this->setAttribute('method', 'post');

        /**
         * Payment Tab start
         * Payment Type
         */
        $this->add([
            'name' => 'payment_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'payment-type',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Payment Type<span style="color: red"> *</span>',
                'value_options' => self::$paymenttype,
                'empty_option' => 'Select',
            ]
        ]);

        /**
         * Payment Tab end
         * Is Paid
         */
        $this->add([
            'name' => 'is_paid',
            'type' => Select::class,
            'attributes' => [
                'id' => 'is-paid',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Is Paid<span style="color: red"> *</span>',
                'value_options' => self::$ispaid,
                'empty_option' => 'Select',
            ]
        ]);

        /**
         * Search
         */
        $this->add([
            'name' => 'search',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search',
                'id' => 'search',
                'class' => 'btn btn-primary btn-lg booking-his'
            ]
        ]);

        /**
         * Clear
         */
        $this->add([
            'name' => 'clear',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Clear',
                'id' => 'clear',
                'class' => 'btn btn-primary btn-lg'
            ]
        ]);
    }

}
