<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element;
use Zend\Form\Element\Select;
use Zend\Form\Element\Text;
use Zend\Form\Element\Email;
use Zend\Form\Element\Submit;

class BookingGeneralSearchForm extends Form {
    public static $bookingType =[];

    public function __construct($name = null) {

        //echo "niharika";die;
        parent::__construct('booking-general-search-form');
        $this->setAttribute('method', 'post');

        /**
         * General Tab start
         * Booking ID
         */
        $this->add([
            'name' => 'booking_id',
            'type' => Text::class,
            'attributes' => [
                'id' => 'booking-id',
                'placeholder' => 'Booking Process Id',
                'class' => 'form-control inputchange'

            ],
            'options' => [
                'label' => 'ID<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Booking Type
         */
        $this->add([
            'name' => 'booking_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-type',
                'class' => 'col-sm-12 col-lg-12 inputfild name valid form-control'
            ],
            'options' => [
                'label' => 'Booking Type<span style="color: red"> *</span>',
                'value_options' => self::$bookingType,
                'empty_option' => 'Select',
            ],
        ]);

        /**
         * Initial Request Data Since
         */
        $this->add([
            'name' => 'from_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'from-date',
                'placeholder' => 'Since',
                'class' => 'form-control inputchange from'
            ],
            'options' => [
                'label' => 'Initial Request Data<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Initial Request Data To
         */
        $this->add([
            'name' => 'to_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'to-date',
                'placeholder' => 'To',
                'class' => 'form-control inputchange to'
            ]
        ]);

        /**
         * Vehicle Owner
         */
        $this->add([
            'name' => 'vehicle_owner',
            'type' => Text::class,
            'attributes' => [
                'id' => 'vehicle-owner',
                'placeholder' => 'Vehicle Owner',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Vehicle Owner<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Driver Name
         */
        $this->add([
            'name' => 'driver_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'driver-name',
                'placeholder' => 'Driver',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Driver<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * General Tab end
         * Partner Name
         */
        $this->add([
            'name' => 'partner_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'partner-name',
                'placeholder' => 'Partner',
                'class' => 'form-control inputchange'
            ],
            'options' => [
                'label' => 'Partner<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Search
         */
        $this->add([
            'name' => 'search',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search',
                'id' => 'search',
                'class' => 'btn btn-primary btn-lg booking-his'
            ],
        ]);

        /**
         * Clear
         */
        $this->add([
            'name' => 'clear',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Clear',
                'id' => 'clear',
                'class' => 'btn btn-primary btn-lg'
            ],
        ]);
    }

}
