<?php

namespace Dashboard\Form;

use Zend\Form\Form;
use Zend\Form\Element\{
    Select,
    File,
    Text,
    Date,
    Radio,
    Submit,
    Checkbox,
    Email,
    Hidden
};

class BidSearchForm extends Form {

     public static $bookingstatus =[];
     
    public function __construct($name = null) {

        parent::__construct('bid-search-form');
               /**
         * 
         * Source Station
         */
        $this->add([
            'name' => 'source_station',
             'type' => Text::class,
            'attributes' => [
                'id' => 'source-station',  
                'placeholder' => 'Source',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Source Station<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        /**
         * 
         * Destination Station
         */
        $this->add([
            'name' => 'destination_station',
            'type' => Text::class,
            'attributes' => [
                'id' => 'destination-station',  
                'placeholder' => 'Destination',
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Destination<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
         /**
         * Source Value
         */
        $this->add([
            'name' => 'source_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'source-value'
            ],
        ]);
        /**
         * Destination Value
         */
        $this->add([
            'name' => 'destination_value',
            'type' => Hidden::class,
            'attributes' => [
                'value' => '',
                'id' => 'destination-value'
            ],
        ]);
        
        /**
         * 
         * Journey Date
         */
        $this->add([
            'name' => 'journey_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'journey-date',   
                'placeholder' =>'DD/MM/YYYY',
                'class' => 'form-control text-uppercase datepicker'
            ],
            'options' => [
                'label' => 'Journey Date<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);
        
        
        /**
         * 
         * Booking Status
         */
        $this->add([
            'name' => 'booking_status',
            'type' => Select::class,
            'attributes' => [
                'id' => 'booking-status',                
                'class' => 'form-control'
            ],
            'options' => [
                'label' => 'Booking Status<span style="color: red"> *</span>',
                'value_options' => self::$bookingstatus
            ],
        ]);

        /**
         * 
         * Search
         */
        $this->add([
            'name' => 'search',
            'type' => Submit::class,
            'attributes' => [
                'value' => 'Search',
                'id' => 'search',
                'class' => 'btn btn-primary btn-lg',
            ],
        ]);        
    }

}
