<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Application\Controller\RestAPIClientController;
use Zend\View\Model\ViewModel;
use Zend\View\Model\JsonModel;
use Zend\Json\Json;
use Zend\Session\Container;
use Dashboard\Form\{
    VehicleTypeForm
};
use Zend\Debug\Debug;
use Dashboard\Model\Vehicle;

class VehicleTypeController extends RestAPIClientController {

    public function __construct() {
        $this->vehicleModel = new Vehicle();
    }

    /**
     * Index
     * @return ViewModel
     */
    public function indexAction() {
        $data = "";
        $status = "";
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        VehicleTypeForm::$vehicletype = $this->vehicleModel->getVehicleTypeList();
        $form = new VehicleTypeForm();
        $request = $this->getRequest();
        if ($request->isPost()) {
            $post = $request->getPost()->toArray();
            $status = (isset($post['status'])) ? $post['status'] : '';
            //Debug::dump($post); exit;
            $form->setData($request->getPost());
            if (!empty($post['search_vehicle_type'])) {
                if ($post['vehicle_type'] != "" && $post['status'] == "") {
                    $val = '{"where": {"id":' . $post['vehicle_type'] . '}}';
                    $data = rawurlencode($val);
                } else if ($post['vehicle_type'] != "" && $post['status'] != "") {
                    $val = '{"where":{"and": [{"id": "' . $post['vehicle_type'] . '"},{"status":' . $post['status'] . '}]}}';
                    $data = rawurlencode($val);
                } else if ($post['vehicle_type'] == "" && $post['status'] != "") {
                    $val = '{"where": {"status":' . $post['status'] . '}}';
                    $data = rawurlencode($val);
                }
                $this->flashMessenger()->addMessage(array('success' => 'Vehicle Type Listed successfully...'));
            } else {
                $created_date = date('Y-m-d H:i:s');
                $data = [];
                $data = [
                    'vehicle_type' => $post['vehicle_type_name'],
                    'status' => $post['status'],
                    'created_date' => $created_date,
                    'created_by' => $user_id
                ];
                $insertStatus = $this->vehicleModel->insertVehicleType($data);
                $data = "";
                $this->flashMessenger()->addMessage(array('success' => 'Vehicle Type added successfully...'));
            }
        }

        $mvehicleList = $this->vehicleModel->getVehicleTypeData($data);
        $mvehicleList = $mvehicleList['data'];
        $viewModel = new ViewModel(['form' => $form, 'mvehicleList' => $mvehicleList, 'vehicle_type_id' => '', 'status' => $status]);
        return $viewModel;
    }

    public function deleteAction() {
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id];
        $this->vehicleModel->deleteVehicleType($data);
        $this->redirect()->toRoute('vehicletype', ['action' => 'index']);
    }

    public function editAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $form = new VehicleTypeForm();
        $id = $this->params()->fromQuery('id');
        $url = $this->apiUrl() . "/vehicle-type/" . $id;
        $resp = $this->get($url);
        $vehicleData = Json::decode($resp->getBody(), true);
        //Debug::dump($vehicleData); exit;
        $vehicleType = $vehicleData['vehicle_type'];
        $vehicleTypeStatus = $vehicleData['status'];
        $form->get('vehicle_type_name')->setValue($vehicleType);
        $form->get('vehicle_type_id')->setValue($id);
        $request = $this->getRequest();
        if ($request->isPost()) {
            $post = $request->getPost()->toArray();
            $data = [];
            $data = ['id' => $post['vehicle_type_id'], 'vehicle_type' => $post['vehicle_type_name'], 'status' => $post['status'], 'modified_by' => $user_id];
            $insertStatus = $this->vehicleModel->updateVehicleType($data);
            $this->redirect()->toRoute('vehicletype', ['action' => 'index']);
        }
        $mvehicleList = $this->vehicleModel->getVehicleTypeData();
        $mvehicleList = $mvehicleList['data'];
        $viewModel = new ViewModel(['form' => $form, 'mvehicleList' => $mvehicleList, 'vehicle_type_id' => $id, 'status' => $vehicleTypeStatus]);
        $viewModel->setTemplate('/dashboard/vehicle-type/edit-vehicle-type');
        return $viewModel;
    }

    /** Function to change VEHICLE TYPE STATUS */
    public function vehicleTypeStatusAction() {
        $data1 = [];
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        //print_r($data); die;
        $id = implode(',', $data['selected']);
        $vehicle_type_status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'vehicle_type_status' => $vehicle_type_status];
        $this->vehicleModel->updateVehicleTypeStatus($data);
        $mvehicleList = $this->vehicleModel->getVehicleTypeData();
        $mvehicleList = $mvehicleList['data'];
        $viewModel = new ViewModel(['mvehicleList' => $mvehicleList]);
        $viewModel->setTemplate('/dashboard/vehicle-type/vehicle-type-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

}
