<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Application\Controller\RestAPIClientController;
use Zend\View\Model\ViewModel;
use Zend\View\Model\JsonModel;
use Zend\Json\Json;
use Zend\Session\Container;
use Zend\Debug\Debug;
use Dashboard\Form\{
    VehicleNameForm
};
use Dashboard\Model\Vehicle;

class VehicleNameController extends RestAPIClientController {

    public function __construct() {
        $this->vehicleModel = new Vehicle();
    }

    /**
     * Index
     * @return ViewModel
     */
    public function indexAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        VehicleNameForm:: $vehiclename = $this->vehicleModel->getVehicleNameList($data = null);
        VehicleNameForm:: $vehicletype = $this->vehicleModel->getVehicleTypeList($data = null);
        //Call API...
        $form = new VehicleNameForm();

        $request = $this->getRequest();
        if ($request->isPost()) {
            $post = $request->getPost()->toArray();
            //Debug::dump($post); //exit;
            $form->setData($request->getPost());
            if (!empty($post['search_vehicle_name'])) {
                if ($post['vehicle_type'] != "" && $post['vehicle_name'] != "") {
                    $val = '{"where":{"and": [{"vehicle_type_id": "' . $post['vehicle_type'] . '"},{"id": "' . $post['vehicle_name'] . '"},{"status":' . $post['status'] . '}]}}';
                    $data = rawurlencode($val);
                } else if ($post['vehicle_type'] != "") {
                    $val = '{"where":{"and": [{"vehicle_type_id": "' . $post['vehicle_type'] . '"},{"status":' . $post['status'] . '}]}}';
                    $data = rawurlencode($val);
                } else if ($post['vehicle_name'] != "") {
                    $val = '{"where":{"and": [{"id": "' . $post['vehicle_name'] . '"},{"status":' . $post['status'] . '}]}}';
                    $data = rawurlencode($val);
                } else if ($post['vehicle_type'] == "" && $post['vehicle_name'] == "") {
                    $val = '{"where":{"status":' . $post['status'] . '}}';
                    $data = rawurlencode($val);
                }
                //echo "Search";
            } else {
                $created_date = date('Y-m-d H:i:s');
                $data = [];
                $data = [
                    'name' => $post['vehicle_model_name'],
                    'vehicle_type_id' => $post['vehicle_type'],
                    'status' => $post['status'],
                    'created_date' => $created_date,
                    'created_by' => $user_id
                ];
                $insertStatus = $this->vehicleModel->insertVehicleName($data);
                $data = "";
            }
        }
        $vehiclenameListing = $this->vehicleModel->getVehicleNameData($data);
        $vehiclenameListing = $vehiclenameListing['data'];
        //Debug::dump($vehiclenameListing); exit;
        $viewModel = new ViewModel(['form' => $form, 'vehiclenamelisting' => $vehiclenameListing, 'vehicle_type_id' => '']);
        return $viewModel;
    }

    public function deleteAction() {
        $id = $this->params()->fromQuery('data');
        $data = ['id' => $id];
        $this->vehicleModel->deleteVehicleName($data);
        $this->redirect()->toRoute('vehiclename', ['action' => 'index']);
    }

    public function editAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        VehicleNameForm:: $vehicletype = $this->vehicleModel->getVehicleTypeList($data = null);
        $form = new VehicleNameForm();
        $id = $this->params()->fromQuery('id');
        $url = $this->apiUrl() . "/vehicle-model/" . $id;
        $resp = $this->get($url);
        $vehicleData = Json::decode($resp->getBody(), true);
        //Debug::dump($vehicleData);exit;
        $vehicleName = $vehicleData['name'];
        $vehicleTypeId = $vehicleData['vehicle_type_id'];
        $vehicleTypeStatus = $vehicleData['status'];
        $form->get('vehicle_model_name')->setValue($vehicleName);
        $form->get('vehicle_type')->setValue($vehicleTypeId);
        $form->get('vehicle_model_id')->setValue($id);
        $request = $this->getRequest();
        if ($request->isPost()) {
            $post = $request->getPost()->toArray();
            $data = ['id' => $post['vehicle_model_id'], 'vehicle_type_id' => $post['vehicle_type'], 'name' => $post['vehicle_model_name'], 'status' => $post['status'], 'modified_by' => $user_id];
            $insertStatus = $this->vehicleModel->updateVehicleName($data);
            $this->redirect()->toRoute('vehiclename', ['action' => 'index']);
        }
        $viewModel = new ViewModel(['form' => $form, 'vehicle_type_id' => $id]);
        $viewModel->setTemplate('/dashboard/vehicle-name/edit-vehicle-name');
        return $viewModel;
    }

    /** Function to change VEHICLE MODEL STATUS */
    public function vehicleModelStatusAction() {
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $user_id = $sessionContainer->user_id;
        $data = $this->getRequest()->getPost();
        $id = implode(',', $data['selected']);
        $vehicle_model_status = $data['status'];
        $data = ['user_id' => $user_id, 'id' => $id, 'vehicle_model_status' => $vehicle_model_status];
        $this->vehicleModel->updateVehicleModelStatus($data);
        $vehiclenameListing = $this->vehicleModel->getVehicleNameData();
        $vehiclenameListing = $vehiclenameListing['data'];
        $viewModel = new ViewModel(['vehiclenamelisting' => $vehiclenameListing]);
        $viewModel->setTemplate('dashboard/vehicle-name/vehicle-name-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

}
