<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Zend\View\Model\ViewModel;
use Dashboard\Form\TourInclusionAddForm;

class TourInclusionController extends AbstractActionController {

    /**
     * Index
     * @return ViewModel
     */
    public function indexAction() {


        //Call API...
        $tourInclusionListing = [
            '0' => [
                'thumb_image' => '',
                'tour_inclusion_name' => 'Tax Included',
                'status' => '1'
            ],
            '1' => [
                'thumb_image' => '',
                'tour_inclusion_name' => 'Boat Transfers Tax Included',
                'status' => '1'
            ],
            '2' => [
                'thumb_image' => '',
                'tour_inclusion_name' => 'Airport Transfers Tax Included',
                'status' => '1'
            ]
        ];

        $viewModel = new ViewModel(['tourInclusionListing' => $tourInclusionListing]);
        return $viewModel;
    }

    public function addTourInclusionAction() {

        $tourinclustiondata = [
            '0' => [
                'Sr_no' => '01',
                'country' => 'India',
                'booking_type' => 'Domestic fit',
                'inclusion_name' => 'Transfer',
                'thumb_image' => 'outstation.png',
                'inclusion_contant' => 'We have a variety of Products suiting the requirements of everyone.',
                'created_by' => 'Admin'
            ],
            '1' => [
                'Sr_no' => '02',
                'country' => 'USA',
                'booking_type' => 'Domestic fit',
                'inclusion_name' => 'Transfer',
                'thumb_image' => 'outstation.png',
                'inclusion_contant' => 'We have a variety of Products suiting the requirements of everyone.',
                'created_by' => 'Admin'
            ],
            '3' => [
                'Sr_no' => '03',
                'country' => 'China',
                'booking_type' => 'Domestic fit',
                'inclusion_name' => 'Transfer',
                'thumb_image' => 'outstation.png',
                'inclusion_contant' => 'We have a variety of Products suiting the requirements of everyone.',
                'created_by' => 'Admin'
            ]
        ];




        $form = new TourInclusionAddForm();


        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();

                return $this->redirect()->toRoute('tour-inclusion', ['action' => 'add-tour-inclusion']);
            }
        }
        $viewModel = new ViewModel(['form' => $form,
            'tourinclustiondata' => $tourinclustiondata]);
        return $viewModel;
    }

    public function editTourInclusionAction() {



       $form = new TourInclusionAddForm();


        $request = $this->getRequest();
        //if request will be post                
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();

                return $this->redirect()->toRoute('tour-inclusion', ['action' => 'edit-tour-inclusion']);
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

}
