<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Zend\View\Model\ViewModel;
use Dashboard\Form\TourExclusionAddForm;



class TourExclusionController extends AbstractActionController {

   
    public function indexAction(){
        
    
        //Call API...
        $tourExclusionListing = [
            '0'=>[
                'thumb_image'=>'',
                'tour_exclusion_name'=>'Tax Included',                
                'status'=>'1'
            ],
            '1'=>[
                'thumb_image'=>'',
                'tour_exclusion_name'=>'Boat Transfers Tax Included',                
                'status'=>'1'
            ],
            '2'=>[
                'thumb_image'=>'',
                'tour_exclusion_name'=>'Airport Transfers Tax Included',                
                'status'=>'1'
            ]            
        ];
        
        $viewModel = new ViewModel(['tourExclusionListing'=>$tourExclusionListing]);
        return $viewModel;
    }
     public function addTourExclusionAction(){
         
         $tourinclustiondata = [
            '0' => [
                'Sr_no' => '01',
                'country' => 'India',
                'booking_type' => 'Domestic fit',
                'exclusion_name' => 'Transfer',
                'thumb_image' => 'outstation.png',
                'inclusion_contant' => 'We have a variety of Products suiting the requirements of everyone.',
                'created_by' => 'Admin'
            ],
            '1' => [
                'Sr_no' => '02',
                'country' => 'USA',
                'booking_type' => 'Domestic fit',
                'exclusion_name' => 'Transfer',
                'thumb_image' => 'outstation.png',
                'inclusion_contant' => 'We have a variety of Products suiting the requirements of everyone.',
                'created_by' => 'Admin'
            ],
            '3' => [
                'Sr_no' => '03',
                'country' => 'China',
                'booking_type' => 'Domestic fit',
                'exclusion_name' => 'Transfer',
                'thumb_image' => 'outstation.png',
                'inclusion_contant' => 'We have a variety of Products suiting the requirements of everyone.',
                'created_by' => 'Admin'
            ]
        ];
         
        $form= new TourExclusionAddForm();
        
        $request = $this->getRequest();
                   
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();

                return $this->redirect()->toRoute('tour-exclusion', ['action' => 'add-tour-exclusion']);
            }
        }
        
        
        $viewModel = new ViewModel(['form' => $form,
            'tourinclustiondata' => $tourinclustiondata]);
        return $viewModel;
        
      
        
     }
     
      public function editTourExclusionAction(){
         
         
         
        $form= new TourExclusionAddForm();
        
        $request = $this->getRequest();
                   
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();

                return $this->redirect()->toRoute('tour-exclusion', ['action' => 'edit-tour-exclusion']);
            }
        }
        
        
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
        
     }
 
}
