<?php

namespace Dashboard\Controller;

use Zend\Mvc\Controller\AbstractActionController;
use Application\Controller\RestAPIClientController;
use Zend\View\Model\ViewModel;
use Dashboard\Model\Template;
use Dashboard\Form\TemplateSettingsForm;
use Dashboard\Form\MailForm;
use Dashboard\Form\SmsForm;
use Zend\Session\Container;
use Zend\Json\Json;
use Zend\Debug\Debug;

class TemplateSettingsController extends AbstractActionController {

    /**
     * 
     * @return ViewModel
     */
    public function __construct() {
        $this->temp = new Template();
    }

    public function indexAction() {
        //write code here...

        $form = new TemplateSettingsForm();
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    /* @Desc - Email Template Setting */

    public function mailTemplateAction() {
        $mailList = $this->temp->getMailList();
        $viewModel = new ViewModel(['mailList' => $mailList['data']]);
        return $viewModel;
    }

    public function AddMailAction() {
        $form = new MailForm();
        $mailinfo = $this->temp->addMailInfo();
        $request = $this->getRequest();

        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();
                $addMailDeatils = $this->temp->insertMailDetails($post);

                if ((!empty($addMailDeatils)) && (!isset($addMailDeatils['error']))) {

                    $msg = "Mail Details Added Successfully";
                    $this->redirect()->toRoute('templatesettings', ['action' => 'mail-template']);
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Mail Details Could Not Added Successfully";

                    $this->redirect()->toRoute('templatesettings', ['action' => 'add-mail']);
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
            }
        }
        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function EditMailAction() {
        $data = [];
        $is_active = '';
        $sessionContainer = new Container('userlogin');
        $userTypeId = $sessionContainer->userTypeId;
        $userId = $sessionContainer->user_id;
        $updateMailDeatils = '';
        $getid = $this->params()->fromQuery('id');
        $data['id'] = $getid;
        $content = $this->temp->getDesc($data);
        $form = new MailForm();

        if ((!empty($content['data']))) {
            $form->setData($content['data']);
            $status = $content['data']['is_active'];
        }
        $request = $this->getRequest();
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();
                $updateMailDeatils = $this->temp->editMailDetails($post);

                if ((!empty($updateMailDeatils)) && (!isset($updateMailDeatils['error']))) {

                    $msg = "Mail Details Updated Successfully";
                    $this->redirect()->toRoute('templatesettings', ['action' => 'mail-template']);
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Mail Details Could Not Updated Successfully";

                    $this->redirect()->toRoute('templatesettings', ['action' => 'edit-mail']);
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
            }
        }
        $viewModel = new ViewModel(['form' => $form, 'status' => $status]);
        return $viewModel;
    }
    
     public function MailStatusAction() {
        $data = $this->getRequest()->getPost();
        $id = implode(',', $data['selected']);
        $user_status = $data['status'];
        $data = ['id' => $id, 'email_status' => $user_status];
        $m=$this->temp->updateMailStatus($data); 
        $mailList = $this->temp->getMailList();
        $viewModel = new ViewModel(['mailList' => $mailList['data']]);
        $viewModel->setTemplate('dashboard/template-settings/mail-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

    public function descViewAction() {
        $desc = '';
        $data = $this->getRequest()->getPost();
        $content = $this->temp->getDesc($data);
        if (!empty($content)) {
            $desc = $content['data']['description'];
        }
        $viewModel = new ViewModel(['desc' => $desc]);
        $viewModel->setTerminal(true);
        return $viewModel;
    }
    
    public function SmsTemplateAction() {
        $smslist = $this->temp->getSmsList();
        $viewModel = new ViewModel(['smslist' => $smslist['data']]);
        return $viewModel;
    }

    public function AddSmsAction() {
        $form = new SmsForm();
        $request = $this->getRequest();

        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray();
                $insertdata=$this->temp->insertSmsDetails($post);
                
                if ((!empty($insertdata)) && (!isset($insertdata['error']))) {

                    $msg = "New Sms Details Created Successfully";
                    $this->redirect()->toRoute('templatesettings', ['action' => 'sms-template']);
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Sms Details Could Not create Successfully";

                    $this->redirect()->toRoute('templatesettings', ['action' => 'add-sms']);
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
                
                
            }
        }

        $viewModel = new ViewModel(['form' => $form]);
        return $viewModel;
    }

    public function EditSmsAction() {
        $form = new SmsForm();
        $is_active='';
        $request = $this->getRequest();
        $getid = $this->params()->fromQuery('id');
        
        if(!empty($getid)){
         $getdata=$this->temp->getsmsdetail($getid);
         $is_active=$getdata['data']['is_active'];
         //echo $is_active; die;
         $form->setData($getdata['data']);
        }
        if ($request->isPost()) {
            $form->setData($request->getPost());
            if ($form->isValid()) {
                $post = $request->getPost()->toArray(); 
                $getresult=$this->temp->editSmsDetails($post);
             
                if ((!empty($getresult)) && (!isset($getresult['error']))) {

                    $msg = "Sms Details Updated Successfully";
                    $this->redirect()->toRoute('templatesettings', ['action' => 'sms-template']);
                    $this->flashMessenger()->addMessage(array('success' => $msg));
                } else {
                    $msg = "Sms Details Could Not Update Successfully";
                    $this->flashMessenger()->addMessage(array('danger' => $msg));
                }
                
            }
        }

        $viewModel = new ViewModel(['form' => $form,'is_active'=>$is_active]);
        return $viewModel;
    }
    
    public function SmsStatusAction() {
        $data = $this->getRequest()->getPost();
        $id = implode(',', $data['selected']);
        $user_status = $data['status'];
        $data = ['id' => $id, 'sms_status' => $user_status];
        $this->temp->updateSmsStatus($data);    
        $smslist = $this->temp->getSmsList();
        $viewModel = new ViewModel(['smslist' => $smslist['data']]);
        $viewModel->setTemplate('dashboard/template-settings/sms-listing.phtml');
        $viewModel->setTerminal(true);
        return $viewModel;
    }

}
