<?php

namespace Application\Form;

use Zend\Form\Form;
use Zend\Form\Element\{Checkbox, Text, Submit, Hidden, Textarea,Select,Number};
use Zend\Validator\{Digits, EmailAddress, NotEmpty, StringLength};
use Zend\InputFilter\InputFilterProviderInterface;

class EnquiryForm extends Form implements InputFilterProviderInterface {

     public static $packages= [];
     public static $budget= [];
     public static $vehicleType= [];
    public function __construct($name = null) {

        parent::__construct('enquiry-form');

        /**
         * Name
         */
        $this->add([
            'name' => 'customer_name',
            'type' => Text::class,
            'attributes' => [
                'id' => 'customer-name',
                'class' => 'inputMaterial',
                'onkeypress' => "return isAlphaNumber(event)",
                'maxlength' => 35
            ],
            'options' => [
                'label' => 'Name <span style="color: red">*</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Email ID
         */
        $this->add([
            'name' => 'customer_email',
            'type' => Text::class,
            'attributes' => [
                'id' => 'customer-email',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'Email ID<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);


        /**
         * Mobile No
         */
        $this->add([
            'name' => 'customer_mobile',
            'type' => Text::class,
            'attributes' => [
                'id' => 'customer-mobile',
                'class' => 'inputMaterial',
                'onkeypress' => "return isNumber(event)",
                'maxlength' => 10
            ],
            'options' => [
                'label' => 'Mobile No<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true]
            ],
        ]);

        /**
         * Pickup City
         */
        $this->add([
            'name' => 'origin_city',
            'type' => Text::class,
            'attributes' => [
                'id' => 'origin-city',
                'class' => 'inputMaterial',
            ],
            'options' => [
                'label' => 'City<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true
            ],
        ]);

         /**
         *  start-id
         */

        $this->add([
            'name' => 'origin_city_id',
            'type' => Hidden::class,
            'attributes' => [
                'id' => 'origin-city-id',
                'class' => 'inputMaterial',
            ],
        ]);



        /**
         * Start Date
         */
        $this->add([
            'name' => 'start_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'start-date',
                //'placeholder' => 'Date',
                'class' => 'inputMaterial pickupdate',
            ],
            'options' => [
                'label' => 'Start date<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true
            ],
        ]);

        /**
         * Start Time
         */
        $this->add([
            'name' => 'start_time',
            'type' => Text::class,
            'attributes' => [
                'id' => 'start-time',
                //'placeholder' => 'Time',
                'class' => 'inputMaterial'
            ],
             'options' => [
                'label' => 'Start Time<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true
            ],
        ]);

        /**
         * End Date
         */
        $this->add([
            'name' => 'end_date',
            'type' => Text::class,
            'attributes' => [
                'id' => 'end-date',
               // 'placeholder' => 'Date',
                'class' => 'inputMaterial pickupdate',
            ],
            'options' => [
                'label' => 'End Date<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true
            ],
        ]);

        /**
         * End Time
         */
        $this->add([
            'name' => 'end_time',
            'type' => Text::class,
            'attributes' => [
                'id' => 'end-time',
               // 'placeholder' => 'Time',
                'class' => 'inputMaterial'
            ],
            'options' => [
                'label' => 'End Time<span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                'disable_inarray_validator' => true
            ],
        ]);


        $this->add([
            'name' => 'enquiry_type',
            'type' => Hidden::class,
        ]);

         /**
         * Package Name
         */
        $this->add([
            'name' => 'package_name',
            'type' => Select::class,
            'attributes' => [
                'id' => 'package-name',
                'placeholder' => 'Package name',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Package Name <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                //'empty_option' => '--Select Package--',
                'value_options' =>self::$packages,
                'disable_inarray_validator' => true,
                //'empty_option' => '',
            ],
        ]);
         /**
         * Vehicle Type Name
         */
        $this->add([
            'name' => 'vehicle_type',
            'type' => Select::class,
            'attributes' => [
                'id' => 'vehicle-type',
                'placeholder' => 'Vehicle type',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Vehicle type <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                //'empty_option' => '--Select Vehicle--',
                 'value_options' =>self::$vehicleType,
                 'disable_inarray_validator' => true,
                //'empty_option' => '',
            ],
        ]);

         /**
         * Budget
         */
        $this->add([
            'name' => 'budget',
            'type' => Select::class,
            'attributes' => [
                'id' => 'budget',
                'placeholder' => 'Budget',
                'class' => 'form-control',
            ],
            'options' => [
                'label' => 'Budget <span style="color: red"> *</span>',
                'label_options' => ['disable_html_escape' => true],
                //'empty_option' => '--Select Package--',
                'value_options'=>self::$budget,
                 'disable_inarray_validator' => true,
                //'empty_option' => '',
            ],
        ]);


        /**
         * Number of Adults
         */
        $this->add([
            'type' => Number::class,
            'name' => 'adults',
            'attributes' => [
                'id' => 'adults',
                'class' => 'inputMaterial',
                'min' => 0,
                'max' => 9,
                'step' => 1,
                'value' => 1
            ],
            'options' => [
                'label' => 'Adults',
            ],
        ]);

        /**
         * Number of Childs
         */
        $this->add([
            'type' => Number::class,
            'name' => 'childs',
            'attributes' => [
                'id' => 'childs',
                'class' => 'inputMaterial',
                'min' => 0,
                'max' => 9,
                'step' => 1,
                'value' => 0
            ],
            'options' => [
                'label' => 'Childs',
            ],
        ]);

        /**
         * Number of Luggages
         */
        $this->add([
            'type' => Number::class,
            'name' => 'luggages',
            'attributes' => [
                'id' => 'luggages',
                'class' => 'inputMaterial',
                'min' => 0,
                'max' => 9,
                'step' => 1,
                'value' => 0
            ],
            'options' => [
                'label' => 'Luggages',
            ],
        ]);

        /**
         * Number of Vehicles
         */
        $this->add([
            'type' => Number::class,
            'name' => 'no_of_vehicles',
            'attributes' => [
                'id' => 'no-of-vehicles',
                'class' => 'inputMaterial',
                'min' => 1,
                'max' => 9,
                'step' => 1,
                'value' => 1
            ],
            'options' => [
                'label' => 'Vehicles',
            ],
        ]);

        /**
         * Submit
         */
        $this->add([
            'name' => 'enquiry_submit',
            'type' => Submit::class,
            'attributes' => [
            'value' => 'submit',
                'id' => 'enquiry-submit',
                'class' => 'btn btn-primary',
                'onclick' => "submitForm('#enquiry-form', event);"
            ],
        ]);

    }

    public function getInputFilterSpecification() {
        return [
            'customer_name' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Name'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'customer_mobile' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Mobile No.'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'Digits',
                        'options' => [
                            'messages' => [
                                Digits::NOT_DIGITS => 'Please enter Numeric value only',
                            ],
                        ],
                        'break_chain_on_failure' => true,
                    ],
                    ['name' => 'StringLength',
                        'options' => [
                            'min' => 10,
                            'max' => 10,
                            'messages' => [
                                StringLength::TOO_LONG => 'Please enter Less than 10 Digits',
                                StringLength::TOO_SHORT => 'Please enter greater than 9 Digits',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],

            'customer_email' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ],
                    ['name' => 'EmailAddress',
                        'options' => [
                            'messages' => [
                                EmailAddress::INVALID => 'Please enter Valid Email Id',
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

            'origin_city' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please Enter Origin City'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],


            'start_date' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [

                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Start Date'
                            ]
                        ],
                    ],
                    ['name' => 'Date',
                        'options' => [
                             'format'=>'Y-m-d',
                            'messages' => [
                                //Date::INVALID_DATE => '',
                                \Zend\Validator\Date::INVALID_DATE => 'Please enter Valid Date',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'start_time' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Start Time'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

            'end_date' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [

                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter End Date'
                            ]
                        ],
                    ],
                    ['name' => 'Date',
                        'options' => [
                             'format'=>'Y-m-d',
                            'messages' => [
                                //Date::INVALID_DATE => '',
                                \Zend\Validator\Date::INVALID_DATE => 'Please enter Valid Date',
                            ],
                        ],
                        'break_chain_on_failure' => true
                    ],
                ]
            ],
            'end_time' => [
                'required' => true,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please enter Enter Time'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

            'package_name' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select package'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],

            'budget' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Budget'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
            'vehicle_type' => [
                'required' => false,
                'filters' => [
                    ['name' => 'StripTags'],
                    ['name' => 'StringTrim']
                ],
                'validators' => [
                    ['name' => 'NotEmpty',
                        'options' => [
                            'messages' => [
                                NotEmpty::IS_EMPTY => 'Please select Budget'
                            ]
                        ],
                        'break_chain_on_failure' => true
                    ]
                ]
            ],
        ];
    }

}
